#pragma once

#include "KingSystem/Resource/GeneralParamList/resGParamListObject.h"

namespace ksys::res {

template <GParamListObjType>
struct GParamListObjTypeTraits;

#define KSYS_DECLARE_GPARAM_TRAIT_(NAME)                                                           \
    template <>                                                                                    \
    struct GParamListObjTypeTraits<GParamListObjType::NAME> {                                      \
        using type = class GParamListObject##NAME;                                                 \
        static inline constexpr auto enum_value = GParamListObjType::NAME;                         \
        static inline constexpr auto index = static_cast<s32>(enum_value);                         \
    };

KSYS_DECLARE_GPARAM_TRAIT_(System)
KSYS_DECLARE_GPARAM_TRAIT_(General)
KSYS_DECLARE_GPARAM_TRAIT_(Enemy)
KSYS_DECLARE_GPARAM_TRAIT_(EnemyLevel)
KSYS_DECLARE_GPARAM_TRAIT_(EnemyRace)
KSYS_DECLARE_GPARAM_TRAIT_(AttackInterval)
KSYS_DECLARE_GPARAM_TRAIT_(EnemyShown)
KSYS_DECLARE_GPARAM_TRAIT_(BindBone)
KSYS_DECLARE_GPARAM_TRAIT_(Attack)
KSYS_DECLARE_GPARAM_TRAIT_(WeaponCommon)
KSYS_DECLARE_GPARAM_TRAIT_(WeaponThrow)
KSYS_DECLARE_GPARAM_TRAIT_(Sandworm)
KSYS_DECLARE_GPARAM_TRAIT_(SmallSword)
KSYS_DECLARE_GPARAM_TRAIT_(Rod)
KSYS_DECLARE_GPARAM_TRAIT_(LargeSword)
KSYS_DECLARE_GPARAM_TRAIT_(Spear)
KSYS_DECLARE_GPARAM_TRAIT_(Shield)
KSYS_DECLARE_GPARAM_TRAIT_(Bow)
KSYS_DECLARE_GPARAM_TRAIT_(WeaponOption)
KSYS_DECLARE_GPARAM_TRAIT_(MasterSword)
KSYS_DECLARE_GPARAM_TRAIT_(GuardianMiniWeapon)
KSYS_DECLARE_GPARAM_TRAIT_(Player)
KSYS_DECLARE_GPARAM_TRAIT_(Camera)
KSYS_DECLARE_GPARAM_TRAIT_(Grab)
KSYS_DECLARE_GPARAM_TRAIT_(Armor)
KSYS_DECLARE_GPARAM_TRAIT_(ArmorEffect)
KSYS_DECLARE_GPARAM_TRAIT_(ArmorHead)
KSYS_DECLARE_GPARAM_TRAIT_(ArmorUpper)
KSYS_DECLARE_GPARAM_TRAIT_(ShiekerStone)
KSYS_DECLARE_GPARAM_TRAIT_(SeriesArmor)
KSYS_DECLARE_GPARAM_TRAIT_(Liftable)
KSYS_DECLARE_GPARAM_TRAIT_(Item)
KSYS_DECLARE_GPARAM_TRAIT_(Rupee)
KSYS_DECLARE_GPARAM_TRAIT_(Arrow)
KSYS_DECLARE_GPARAM_TRAIT_(Bullet)
KSYS_DECLARE_GPARAM_TRAIT_(CureItem)
KSYS_DECLARE_GPARAM_TRAIT_(CookSpice)
KSYS_DECLARE_GPARAM_TRAIT_(LumberjackTree)
KSYS_DECLARE_GPARAM_TRAIT_(Npc)
KSYS_DECLARE_GPARAM_TRAIT_(NpcEquipment)
KSYS_DECLARE_GPARAM_TRAIT_(Zora)
KSYS_DECLARE_GPARAM_TRAIT_(Traveler)
KSYS_DECLARE_GPARAM_TRAIT_(Prey)
KSYS_DECLARE_GPARAM_TRAIT_(AnimalFollowOffset)
KSYS_DECLARE_GPARAM_TRAIT_(ExtendedEntity)
KSYS_DECLARE_GPARAM_TRAIT_(BindActor)
KSYS_DECLARE_GPARAM_TRAIT_(EatTarget)
KSYS_DECLARE_GPARAM_TRAIT_(AnimalUnit)
KSYS_DECLARE_GPARAM_TRAIT_(Insect)
KSYS_DECLARE_GPARAM_TRAIT_(Fish)
KSYS_DECLARE_GPARAM_TRAIT_(Rope)
KSYS_DECLARE_GPARAM_TRAIT_(Horse)
KSYS_DECLARE_GPARAM_TRAIT_(HorseUnit)
KSYS_DECLARE_GPARAM_TRAIT_(HorseObject)
KSYS_DECLARE_GPARAM_TRAIT_(HorseRider)
KSYS_DECLARE_GPARAM_TRAIT_(HorseCreator)
KSYS_DECLARE_GPARAM_TRAIT_(GiantArmorSlot)
KSYS_DECLARE_GPARAM_TRAIT_(GiantArmor)
KSYS_DECLARE_GPARAM_TRAIT_(Guardian)
KSYS_DECLARE_GPARAM_TRAIT_(MonsterShop)
KSYS_DECLARE_GPARAM_TRAIT_(Swarm)
KSYS_DECLARE_GPARAM_TRAIT_(GelEnemy)
KSYS_DECLARE_GPARAM_TRAIT_(Nest)
KSYS_DECLARE_GPARAM_TRAIT_(Wizzrobe)
KSYS_DECLARE_GPARAM_TRAIT_(StalEnemy)
KSYS_DECLARE_GPARAM_TRAIT_(GuardianMini)
KSYS_DECLARE_GPARAM_TRAIT_(ClothReaction)
KSYS_DECLARE_GPARAM_TRAIT_(Global)
KSYS_DECLARE_GPARAM_TRAIT_(Beam)
KSYS_DECLARE_GPARAM_TRAIT_(AutoGen)
KSYS_DECLARE_GPARAM_TRAIT_(ChemicalType)
KSYS_DECLARE_GPARAM_TRAIT_(Golem)
KSYS_DECLARE_GPARAM_TRAIT_(HorseTargetedInfo)
KSYS_DECLARE_GPARAM_TRAIT_(WolfLink)
KSYS_DECLARE_GPARAM_TRAIT_(Event)
KSYS_DECLARE_GPARAM_TRAIT_(GolemIK)
KSYS_DECLARE_GPARAM_TRAIT_(PictureBook)
KSYS_DECLARE_GPARAM_TRAIT_(AirWall)
KSYS_DECLARE_GPARAM_TRAIT_(Motorcycle)

#undef KSYS_DECLARE_GPARAM_TRAIT_

}  // namespace ksys::res
