#include <Havok/Common/Base/Reflection/hkClass.h>
#include <Havok/Common/Base/Reflection/hkClassMember.h>
#include <Havok/Common/Base/Reflection/hkTypeInfo.h>
#include <array>
#include "KingSystem/Physics/StaticCompound/physStaticCompoundInfo.h"

namespace ksys::phys {

// Reflection data is normally autogenerated with a Havok script and type parser,
// but considering we only have 3 classes it's easier to just write the data manually.

// ShapeInfo

static constexpr hkClassMember ShapeInfo_Members[] = {
    {"ActorInfoIndex", nullptr, nullptr, hkClassMember::Type::TYPE_INT32,
     hkClassMember::Type::TYPE_VOID, 0, 0, 0, nullptr},
    {"InstanceId", nullptr, nullptr, hkClassMember::Type::TYPE_INT32,
     hkClassMember::Type::TYPE_VOID, 0, 0, 4, nullptr},
    {"BodyGroup", nullptr, nullptr, hkClassMember::Type::TYPE_INT8, hkClassMember::Type::TYPE_VOID,
     0, 0, 8, nullptr},
    {"BodyLayerType", nullptr, nullptr, hkClassMember::Type::TYPE_UINT8,
     hkClassMember::Type::TYPE_VOID, 0, 0, 9, nullptr},
};

const hkClass ShapeInfo_Class{
    "ShapeInfo",
    nullptr,
    sizeof(ShapeInfo),
    nullptr,
    0,
    nullptr,
    0,
    ShapeInfo_Members,
    std::size(ShapeInfo_Members),
};

const hkClass& ShapeInfo::staticClass() {
    return ShapeInfo_Class;
}

const hkTypeInfo ShapeInfo_TypeInfo = hkTypeInfo::make<ShapeInfo>("ShapeInfo", "!ShapeInfo");

// ActorInfo

static constexpr hkClassMember ActorInfo_Members[] = {
    {"HashId", nullptr, nullptr, hkClassMember::Type::TYPE_UINT32, hkClassMember::Type::TYPE_VOID,
     0, 0, 0, nullptr},
    {"SRTHash", nullptr, nullptr, hkClassMember::Type::TYPE_INT32, hkClassMember::Type::TYPE_VOID,
     0, 0, 4, nullptr},
    {"ShapeInfoStart", nullptr, nullptr, hkClassMember::Type::TYPE_INT32,
     hkClassMember::Type::TYPE_VOID, 0, 0, 8, nullptr},
    {"ShapeInfoEnd", nullptr, nullptr, hkClassMember::Type::TYPE_INT32,
     hkClassMember::Type::TYPE_VOID, 0, 0, 0xc, nullptr},
};

const hkClass ActorInfo_Class{
    "ActorInfo",
    nullptr,
    sizeof(ActorInfo),
    nullptr,
    0,
    nullptr,
    0,
    ActorInfo_Members,
    std::size(ActorInfo_Members),
};

const hkClass& ActorInfo::staticClass() {
    return ActorInfo_Class;
}

const hkTypeInfo ActorInfo_TypeInfo = hkTypeInfo::make<ActorInfo>("ActorInfo", "!ActorInfo");

// StaticCompoundInfo

static constexpr hkClassMember StaticCompoundInfo_Members[] = {
    {"Offset", nullptr, nullptr, hkClassMember::Type::TYPE_UINT32, hkClassMember::Type::TYPE_VOID,
     0, 0, 0, nullptr},
    {"ActorInfo", &ActorInfo_Class, nullptr, hkClassMember::Type::TYPE_ARRAY,
     hkClassMember::Type::TYPE_STRUCT, 0, 0, 8, nullptr},
    {"ShapeInfo", &ShapeInfo_Class, nullptr, hkClassMember::Type::TYPE_ARRAY,
     hkClassMember::Type::TYPE_STRUCT, 0, 0, 0x18, nullptr},
};

const hkClass StaticCompoundInfo_Class{
    "StaticCompoundInfo",
    nullptr,
    sizeof(StaticCompoundInfo),
    nullptr,
    0,
    nullptr,
    0,
    StaticCompoundInfo_Members,
    std::size(StaticCompoundInfo_Members),
};

const hkClass& StaticCompoundInfo::staticClass() {
    return StaticCompoundInfo_Class;
}

const hkTypeInfo StaticCompoundInfo_TypeInfo =
    hkTypeInfo::make<StaticCompoundInfo>("StaticCompoundInfo", "!StaticCompoundInfo");

}  // namespace ksys::phys
