#pragma once

#include "KingSystem/ActorSystem/actAiAi.h"

namespace uking::ai {

class FlyMoveToTarget : public ksys::act::ai::Ai {
    SEAD_RTTI_OVERRIDE(FlyMoveToTarget, ksys::act::ai::Ai)
public:
    explicit FlyMoveToTarget(const InitArg& arg);
    ~FlyMoveToTarget() override;

    bool init_(sead::Heap* heap) override;
    void enter_(ksys::act::ai::InlineParamPack* params) override;
    void leave_() override;
    void loadParams_() override;

protected:
    // static_param at offset 0x38
    const int* mMoveFailCount_s{};
    // static_param at offset 0x40
    const float* mFarDist_s{};
    // static_param at offset 0x48
    const float* mOutDist_s{};
    // static_param at offset 0x50
    const float* mOffsetHeight_s{};
    // dynamic_param at offset 0x58
    sead::Vector3f* mTargetPos_d{};
};

}  // namespace uking::ai
