#pragma once

#include <cfloat>

#define HK_INT32_MIN (-2147483647 - 1)
#define HK_INT32_MAX 2147483647

#define HK_FLOAT_PI 3.14159265358979f
#define HK_FLOAT_DEG_TO_RAD (HK_FLOAT_PI / 180.0f)
#define HK_FLOAT_RAD_TO_DEG (180.0f / HK_FLOAT_PI)
#define HK_FLOAT_EPSILON FLT_EPSILON
#define HK_FLOAT_MIN FLT_MIN
#define HK_FLOAT_MAX 3.40282e+38f
#define HK_FLOAT_HIGH 1.8446726e+019f

#if defined(HK_REAL_IS_DOUBLE)
#define HK_REAL_PI HK_DOUBLE_PI
#define HK_REAL_DEG_TO_RAD HK_DOUBLE_DEG_TO_RAD
#define HK_REAL_RAD_TO_DEG HK_DOUBLE_RAD_TO_DEG
#define HK_REAL_EPSILON HK_DOUBLE_EPSILON
#define HK_REAL_MIN HK_DOUBLE_MIN
#define HK_REAL_MAX HK_DOUBLE_MAX
#define HK_REAL_HIGH HK_DOUBLE_HIGH
#else
#define HK_REAL_PI HK_FLOAT_PI
#define HK_REAL_DEG_TO_RAD HK_FLOAT_DEG_TO_RAD
#define HK_REAL_RAD_TO_DEG HK_FLOAT_RAD_TO_DEG
#define HK_REAL_EPSILON HK_FLOAT_EPSILON
#define HK_REAL_MIN HK_FLOAT_MIN
#define HK_REAL_MAX HK_FLOAT_MAX
#define HK_REAL_HIGH HK_FLOAT_HIGH
#endif

enum hkVectorConstant {
    HK_QUADREAL_BEGIN,

    HK_QUADREAL_MINUS1,
    HK_QUADREAL_0,
    HK_QUADREAL_1,
    HK_QUADREAL_2,
    HK_QUADREAL_3,
    HK_QUADREAL_4,
    HK_QUADREAL_5,
    HK_QUADREAL_6,
    HK_QUADREAL_7,
    HK_QUADREAL_8,
    HK_QUADREAL_15,
    HK_QUADREAL_16,
    HK_QUADREAL_255,
    HK_QUADREAL_256,
    HK_QUADREAL_2_POW_23,

    HK_QUADREAL_INV_0,
    HK_QUADREAL_INV_1,
    HK_QUADREAL_INV_2,
    HK_QUADREAL_INV_3,
    HK_QUADREAL_INV_4,
    HK_QUADREAL_INV_5,
    HK_QUADREAL_INV_6,
    HK_QUADREAL_INV_7,
    HK_QUADREAL_INV_8,
    HK_QUADREAL_INV_15,
    HK_QUADREAL_INV_127,
    HK_QUADREAL_INV_226,
    HK_QUADREAL_INV_255,
    HK_QUADREAL_1000,
    HK_QUADREAL_0100,
    HK_QUADREAL_0010,
    HK_QUADREAL_0001,
    HK_QUADREAL_MAX,
    HK_QUADREAL_HIGH,
    /// Epsilon.
    HK_QUADREAL_EPS,
    /// Epsilon squared.
    HK_QUADREAL_EPS_SQRD,
    HK_QUADREAL_MIN,
    HK_QUADREAL_MINUS_MAX,
    HK_QUADREAL_MINUS_MIN,
    HK_QUADREAL_m11m11,
    HK_QUADREAL_1m11m1,
    HK_QUADREAL_1010,
    HK_QUADREAL_1100,
    HK_QUADREAL_0011,
    HK_QUADREAL_1248,
    HK_QUADREAL_8421,
    HK_QUADREAL_PACK_HALF,
    HK_QUADREAL_PACK16_UNIT_VEC,
    HK_QUADREAL_UNPACK16_UNIT_VEC,
    HK_QUADREAL_PI,
    HK_QUADREAL_PI_HALF,
    HK_QUADREAL_PI_QUARTER,
    HK_QUADREAL_FOUR_PI_THIRD,
    HK_QUADREAL_TWO_PI,
    HK_QUADREAL_FOUR_PI,
    HK_QUADREAL_DEG2RAD,
    HK_QUADREAL_RAD2DEG,

    HK_QUADREAL_END
};

#define hkSimdReal_1 (hkSimdReal::getConstant<HK_QUADREAL_1>())

extern const m128 g_vectorfConstants[HK_QUADREAL_END];
