// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package engine

import (
	"context"
	"github.com/zebox/registry-admin/app/store"
	"sync"
)

// Ensure, that InterfaceMock does implement Interface.
// If this is not the case, regenerate this file with moq.
var _ Interface = &InterfaceMock{}

// InterfaceMock is a mock implementation of Interface.
//
//	func TestSomethingThatUsesInterface(t *testing.T) {
//
//		// make and configure a mocked Interface
//		mockedInterface := &InterfaceMock{
//			AccessGarbageCollectorFunc: func(ctx context.Context) error {
//				panic("mock out the AccessGarbageCollector method")
//			},
//			CloseFunc: func(ctx context.Context) error {
//				panic("mock out the Close method")
//			},
//			CreateAccessFunc: func(ctx context.Context, access *store.Access) error {
//				panic("mock out the CreateAccess method")
//			},
//			CreateGroupFunc: func(ctx context.Context, group *store.Group) error {
//				panic("mock out the CreateGroup method")
//			},
//			CreateRepositoryFunc: func(ctx context.Context, entry *store.RegistryEntry) error {
//				panic("mock out the CreateRepository method")
//			},
//			CreateUserFunc: func(ctx context.Context, user *store.User) error {
//				panic("mock out the CreateUser method")
//			},
//			DeleteAccessFunc: func(ctx context.Context, key string, id interface{}) error {
//				panic("mock out the DeleteAccess method")
//			},
//			DeleteGroupFunc: func(ctx context.Context, id int64) error {
//				panic("mock out the DeleteGroup method")
//			},
//			DeleteRepositoryFunc: func(ctx context.Context, repositoryName string, digest string) error {
//				panic("mock out the DeleteRepository method")
//			},
//			DeleteUserFunc: func(ctx context.Context, id int64) error {
//				panic("mock out the DeleteUser method")
//			},
//			FindAccessesFunc: func(ctx context.Context, filter QueryFilter) (ListResponse, error) {
//				panic("mock out the FindAccesses method")
//			},
//			FindGroupsFunc: func(ctx context.Context, filter QueryFilter) (ListResponse, error) {
//				panic("mock out the FindGroups method")
//			},
//			FindRepositoriesFunc: func(ctx context.Context, filter QueryFilter) (ListResponse, error) {
//				panic("mock out the FindRepositories method")
//			},
//			FindUsersFunc: func(ctx context.Context, filter QueryFilter, withPassword bool) (ListResponse, error) {
//				panic("mock out the FindUsers method")
//			},
//			GetAccessFunc: func(ctx context.Context, id int64) (store.Access, error) {
//				panic("mock out the GetAccess method")
//			},
//			GetGroupFunc: func(ctx context.Context, id int64) (store.Group, error) {
//				panic("mock out the GetGroup method")
//			},
//			GetRepositoryFunc: func(ctx context.Context, entryID int64) (store.RegistryEntry, error) {
//				panic("mock out the GetRepository method")
//			},
//			GetUserFunc: func(ctx context.Context, id interface{}) (store.User, error) {
//				panic("mock out the GetUser method")
//			},
//			RepositoryGarbageCollectorFunc: func(ctx context.Context, syncDate int64) error {
//				panic("mock out the RepositoryGarbageCollector method")
//			},
//			UpdateAccessFunc: func(ctx context.Context, access store.Access) error {
//				panic("mock out the UpdateAccess method")
//			},
//			UpdateGroupFunc: func(ctx context.Context, group store.Group) error {
//				panic("mock out the UpdateGroup method")
//			},
//			UpdateRepositoryFunc: func(ctx context.Context, conditionClause map[string]interface{}, data map[string]interface{}) error {
//				panic("mock out the UpdateRepository method")
//			},
//			UpdateUserFunc: func(ctx context.Context, user store.User) error {
//				panic("mock out the UpdateUser method")
//			},
//		}
//
//		// use mockedInterface in code that requires Interface
//		// and then make assertions.
//
//	}
type InterfaceMock struct {
	// AccessGarbageCollectorFunc mocks the AccessGarbageCollector method.
	AccessGarbageCollectorFunc func(ctx context.Context) error

	// CloseFunc mocks the Close method.
	CloseFunc func(ctx context.Context) error

	// CreateAccessFunc mocks the CreateAccess method.
	CreateAccessFunc func(ctx context.Context, access *store.Access) error

	// CreateGroupFunc mocks the CreateGroup method.
	CreateGroupFunc func(ctx context.Context, group *store.Group) error

	// CreateRepositoryFunc mocks the CreateRepository method.
	CreateRepositoryFunc func(ctx context.Context, entry *store.RegistryEntry) error

	// CreateUserFunc mocks the CreateUser method.
	CreateUserFunc func(ctx context.Context, user *store.User) error

	// DeleteAccessFunc mocks the DeleteAccess method.
	DeleteAccessFunc func(ctx context.Context, key string, id interface{}) error

	// DeleteGroupFunc mocks the DeleteGroup method.
	DeleteGroupFunc func(ctx context.Context, id int64) error

	// DeleteRepositoryFunc mocks the DeleteRepository method.
	DeleteRepositoryFunc func(ctx context.Context, repositoryName string, digest string) error

	// DeleteUserFunc mocks the DeleteUser method.
	DeleteUserFunc func(ctx context.Context, id int64) error

	// FindAccessesFunc mocks the FindAccesses method.
	FindAccessesFunc func(ctx context.Context, filter QueryFilter) (ListResponse, error)

	// FindGroupsFunc mocks the FindGroups method.
	FindGroupsFunc func(ctx context.Context, filter QueryFilter) (ListResponse, error)

	// FindRepositoriesFunc mocks the FindRepositories method.
	FindRepositoriesFunc func(ctx context.Context, filter QueryFilter) (ListResponse, error)

	// FindUsersFunc mocks the FindUsers method.
	FindUsersFunc func(ctx context.Context, filter QueryFilter, withPassword bool) (ListResponse, error)

	// GetAccessFunc mocks the GetAccess method.
	GetAccessFunc func(ctx context.Context, id int64) (store.Access, error)

	// GetGroupFunc mocks the GetGroup method.
	GetGroupFunc func(ctx context.Context, id int64) (store.Group, error)

	// GetRepositoryFunc mocks the GetRepository method.
	GetRepositoryFunc func(ctx context.Context, entryID int64) (store.RegistryEntry, error)

	// GetUserFunc mocks the GetUser method.
	GetUserFunc func(ctx context.Context, id interface{}) (store.User, error)

	// RepositoryGarbageCollectorFunc mocks the RepositoryGarbageCollector method.
	RepositoryGarbageCollectorFunc func(ctx context.Context, syncDate int64) error

	// UpdateAccessFunc mocks the UpdateAccess method.
	UpdateAccessFunc func(ctx context.Context, access store.Access) error

	// UpdateGroupFunc mocks the UpdateGroup method.
	UpdateGroupFunc func(ctx context.Context, group store.Group) error

	// UpdateRepositoryFunc mocks the UpdateRepository method.
	UpdateRepositoryFunc func(ctx context.Context, conditionClause map[string]interface{}, data map[string]interface{}) error

	// UpdateUserFunc mocks the UpdateUser method.
	UpdateUserFunc func(ctx context.Context, user store.User) error

	// calls tracks calls to the methods.
	calls struct {
		// AccessGarbageCollector holds details about calls to the AccessGarbageCollector method.
		AccessGarbageCollector []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
		}
		// Close holds details about calls to the Close method.
		Close []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
		}
		// CreateAccess holds details about calls to the CreateAccess method.
		CreateAccess []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Access is the access argument value.
			Access *store.Access
		}
		// CreateGroup holds details about calls to the CreateGroup method.
		CreateGroup []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Group is the group argument value.
			Group *store.Group
		}
		// CreateRepository holds details about calls to the CreateRepository method.
		CreateRepository []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Entry is the entry argument value.
			Entry *store.RegistryEntry
		}
		// CreateUser holds details about calls to the CreateUser method.
		CreateUser []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// User is the user argument value.
			User *store.User
		}
		// DeleteAccess holds details about calls to the DeleteAccess method.
		DeleteAccess []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Key is the key argument value.
			Key string
			// ID is the id argument value.
			ID interface{}
		}
		// DeleteGroup holds details about calls to the DeleteGroup method.
		DeleteGroup []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// ID is the id argument value.
			ID int64
		}
		// DeleteRepository holds details about calls to the DeleteRepository method.
		DeleteRepository []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// RepositoryName is the repositoryName argument value.
			RepositoryName string
			// Digest is the digest argument value.
			Digest string
		}
		// DeleteUser holds details about calls to the DeleteUser method.
		DeleteUser []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// ID is the id argument value.
			ID int64
		}
		// FindAccesses holds details about calls to the FindAccesses method.
		FindAccesses []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Filter is the filter argument value.
			Filter QueryFilter
		}
		// FindGroups holds details about calls to the FindGroups method.
		FindGroups []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Filter is the filter argument value.
			Filter QueryFilter
		}
		// FindRepositories holds details about calls to the FindRepositories method.
		FindRepositories []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Filter is the filter argument value.
			Filter QueryFilter
		}
		// FindUsers holds details about calls to the FindUsers method.
		FindUsers []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Filter is the filter argument value.
			Filter QueryFilter
			// WithPassword is the withPassword argument value.
			WithPassword bool
		}
		// GetAccess holds details about calls to the GetAccess method.
		GetAccess []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// ID is the id argument value.
			ID int64
		}
		// GetGroup holds details about calls to the GetGroup method.
		GetGroup []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// ID is the id argument value.
			ID int64
		}
		// GetRepository holds details about calls to the GetRepository method.
		GetRepository []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// EntryID is the entryID argument value.
			EntryID int64
		}
		// GetUser holds details about calls to the GetUser method.
		GetUser []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// ID is the id argument value.
			ID interface{}
		}
		// RepositoryGarbageCollector holds details about calls to the RepositoryGarbageCollector method.
		RepositoryGarbageCollector []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// SyncDate is the syncDate argument value.
			SyncDate int64
		}
		// UpdateAccess holds details about calls to the UpdateAccess method.
		UpdateAccess []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Access is the access argument value.
			Access store.Access
		}
		// UpdateGroup holds details about calls to the UpdateGroup method.
		UpdateGroup []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Group is the group argument value.
			Group store.Group
		}
		// UpdateRepository holds details about calls to the UpdateRepository method.
		UpdateRepository []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// ConditionClause is the conditionClause argument value.
			ConditionClause map[string]interface{}
			// Data is the data argument value.
			Data map[string]interface{}
		}
		// UpdateUser holds details about calls to the UpdateUser method.
		UpdateUser []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// User is the user argument value.
			User store.User
		}
	}
	lockAccessGarbageCollector     sync.RWMutex
	lockClose                      sync.RWMutex
	lockCreateAccess               sync.RWMutex
	lockCreateGroup                sync.RWMutex
	lockCreateRepository           sync.RWMutex
	lockCreateUser                 sync.RWMutex
	lockDeleteAccess               sync.RWMutex
	lockDeleteGroup                sync.RWMutex
	lockDeleteRepository           sync.RWMutex
	lockDeleteUser                 sync.RWMutex
	lockFindAccesses               sync.RWMutex
	lockFindGroups                 sync.RWMutex
	lockFindRepositories           sync.RWMutex
	lockFindUsers                  sync.RWMutex
	lockGetAccess                  sync.RWMutex
	lockGetGroup                   sync.RWMutex
	lockGetRepository              sync.RWMutex
	lockGetUser                    sync.RWMutex
	lockRepositoryGarbageCollector sync.RWMutex
	lockUpdateAccess               sync.RWMutex
	lockUpdateGroup                sync.RWMutex
	lockUpdateRepository           sync.RWMutex
	lockUpdateUser                 sync.RWMutex
}

// AccessGarbageCollector calls AccessGarbageCollectorFunc.
func (mock *InterfaceMock) AccessGarbageCollector(ctx context.Context) error {
	if mock.AccessGarbageCollectorFunc == nil {
		panic("InterfaceMock.AccessGarbageCollectorFunc: method is nil but Interface.AccessGarbageCollector was just called")
	}
	callInfo := struct {
		Ctx context.Context
	}{
		Ctx: ctx,
	}
	mock.lockAccessGarbageCollector.Lock()
	mock.calls.AccessGarbageCollector = append(mock.calls.AccessGarbageCollector, callInfo)
	mock.lockAccessGarbageCollector.Unlock()
	return mock.AccessGarbageCollectorFunc(ctx)
}

// AccessGarbageCollectorCalls gets all the calls that were made to AccessGarbageCollector.
// Check the length with:
//
//	len(mockedInterface.AccessGarbageCollectorCalls())
func (mock *InterfaceMock) AccessGarbageCollectorCalls() []struct {
	Ctx context.Context
} {
	var calls []struct {
		Ctx context.Context
	}
	mock.lockAccessGarbageCollector.RLock()
	calls = mock.calls.AccessGarbageCollector
	mock.lockAccessGarbageCollector.RUnlock()
	return calls
}

// Close calls CloseFunc.
func (mock *InterfaceMock) Close(ctx context.Context) error {
	if mock.CloseFunc == nil {
		panic("InterfaceMock.CloseFunc: method is nil but Interface.Close was just called")
	}
	callInfo := struct {
		Ctx context.Context
	}{
		Ctx: ctx,
	}
	mock.lockClose.Lock()
	mock.calls.Close = append(mock.calls.Close, callInfo)
	mock.lockClose.Unlock()
	return mock.CloseFunc(ctx)
}

// CloseCalls gets all the calls that were made to Close.
// Check the length with:
//
//	len(mockedInterface.CloseCalls())
func (mock *InterfaceMock) CloseCalls() []struct {
	Ctx context.Context
} {
	var calls []struct {
		Ctx context.Context
	}
	mock.lockClose.RLock()
	calls = mock.calls.Close
	mock.lockClose.RUnlock()
	return calls
}

// CreateAccess calls CreateAccessFunc.
func (mock *InterfaceMock) CreateAccess(ctx context.Context, access *store.Access) error {
	if mock.CreateAccessFunc == nil {
		panic("InterfaceMock.CreateAccessFunc: method is nil but Interface.CreateAccess was just called")
	}
	callInfo := struct {
		Ctx    context.Context
		Access *store.Access
	}{
		Ctx:    ctx,
		Access: access,
	}
	mock.lockCreateAccess.Lock()
	mock.calls.CreateAccess = append(mock.calls.CreateAccess, callInfo)
	mock.lockCreateAccess.Unlock()
	return mock.CreateAccessFunc(ctx, access)
}

// CreateAccessCalls gets all the calls that were made to CreateAccess.
// Check the length with:
//
//	len(mockedInterface.CreateAccessCalls())
func (mock *InterfaceMock) CreateAccessCalls() []struct {
	Ctx    context.Context
	Access *store.Access
} {
	var calls []struct {
		Ctx    context.Context
		Access *store.Access
	}
	mock.lockCreateAccess.RLock()
	calls = mock.calls.CreateAccess
	mock.lockCreateAccess.RUnlock()
	return calls
}

// CreateGroup calls CreateGroupFunc.
func (mock *InterfaceMock) CreateGroup(ctx context.Context, group *store.Group) error {
	if mock.CreateGroupFunc == nil {
		panic("InterfaceMock.CreateGroupFunc: method is nil but Interface.CreateGroup was just called")
	}
	callInfo := struct {
		Ctx   context.Context
		Group *store.Group
	}{
		Ctx:   ctx,
		Group: group,
	}
	mock.lockCreateGroup.Lock()
	mock.calls.CreateGroup = append(mock.calls.CreateGroup, callInfo)
	mock.lockCreateGroup.Unlock()
	return mock.CreateGroupFunc(ctx, group)
}

// CreateGroupCalls gets all the calls that were made to CreateGroup.
// Check the length with:
//
//	len(mockedInterface.CreateGroupCalls())
func (mock *InterfaceMock) CreateGroupCalls() []struct {
	Ctx   context.Context
	Group *store.Group
} {
	var calls []struct {
		Ctx   context.Context
		Group *store.Group
	}
	mock.lockCreateGroup.RLock()
	calls = mock.calls.CreateGroup
	mock.lockCreateGroup.RUnlock()
	return calls
}

// CreateRepository calls CreateRepositoryFunc.
func (mock *InterfaceMock) CreateRepository(ctx context.Context, entry *store.RegistryEntry) error {
	if mock.CreateRepositoryFunc == nil {
		panic("InterfaceMock.CreateRepositoryFunc: method is nil but Interface.CreateRepository was just called")
	}
	callInfo := struct {
		Ctx   context.Context
		Entry *store.RegistryEntry
	}{
		Ctx:   ctx,
		Entry: entry,
	}
	mock.lockCreateRepository.Lock()
	mock.calls.CreateRepository = append(mock.calls.CreateRepository, callInfo)
	mock.lockCreateRepository.Unlock()
	return mock.CreateRepositoryFunc(ctx, entry)
}

// CreateRepositoryCalls gets all the calls that were made to CreateRepository.
// Check the length with:
//
//	len(mockedInterface.CreateRepositoryCalls())
func (mock *InterfaceMock) CreateRepositoryCalls() []struct {
	Ctx   context.Context
	Entry *store.RegistryEntry
} {
	var calls []struct {
		Ctx   context.Context
		Entry *store.RegistryEntry
	}
	mock.lockCreateRepository.RLock()
	calls = mock.calls.CreateRepository
	mock.lockCreateRepository.RUnlock()
	return calls
}

// CreateUser calls CreateUserFunc.
func (mock *InterfaceMock) CreateUser(ctx context.Context, user *store.User) error {
	if mock.CreateUserFunc == nil {
		panic("InterfaceMock.CreateUserFunc: method is nil but Interface.CreateUser was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		User *store.User
	}{
		Ctx:  ctx,
		User: user,
	}
	mock.lockCreateUser.Lock()
	mock.calls.CreateUser = append(mock.calls.CreateUser, callInfo)
	mock.lockCreateUser.Unlock()
	return mock.CreateUserFunc(ctx, user)
}

// CreateUserCalls gets all the calls that were made to CreateUser.
// Check the length with:
//
//	len(mockedInterface.CreateUserCalls())
func (mock *InterfaceMock) CreateUserCalls() []struct {
	Ctx  context.Context
	User *store.User
} {
	var calls []struct {
		Ctx  context.Context
		User *store.User
	}
	mock.lockCreateUser.RLock()
	calls = mock.calls.CreateUser
	mock.lockCreateUser.RUnlock()
	return calls
}

// DeleteAccess calls DeleteAccessFunc.
func (mock *InterfaceMock) DeleteAccess(ctx context.Context, key string, id interface{}) error {
	if mock.DeleteAccessFunc == nil {
		panic("InterfaceMock.DeleteAccessFunc: method is nil but Interface.DeleteAccess was just called")
	}
	callInfo := struct {
		Ctx context.Context
		Key string
		ID  interface{}
	}{
		Ctx: ctx,
		Key: key,
		ID:  id,
	}
	mock.lockDeleteAccess.Lock()
	mock.calls.DeleteAccess = append(mock.calls.DeleteAccess, callInfo)
	mock.lockDeleteAccess.Unlock()
	return mock.DeleteAccessFunc(ctx, key, id)
}

// DeleteAccessCalls gets all the calls that were made to DeleteAccess.
// Check the length with:
//
//	len(mockedInterface.DeleteAccessCalls())
func (mock *InterfaceMock) DeleteAccessCalls() []struct {
	Ctx context.Context
	Key string
	ID  interface{}
} {
	var calls []struct {
		Ctx context.Context
		Key string
		ID  interface{}
	}
	mock.lockDeleteAccess.RLock()
	calls = mock.calls.DeleteAccess
	mock.lockDeleteAccess.RUnlock()
	return calls
}

// DeleteGroup calls DeleteGroupFunc.
func (mock *InterfaceMock) DeleteGroup(ctx context.Context, id int64) error {
	if mock.DeleteGroupFunc == nil {
		panic("InterfaceMock.DeleteGroupFunc: method is nil but Interface.DeleteGroup was just called")
	}
	callInfo := struct {
		Ctx context.Context
		ID  int64
	}{
		Ctx: ctx,
		ID:  id,
	}
	mock.lockDeleteGroup.Lock()
	mock.calls.DeleteGroup = append(mock.calls.DeleteGroup, callInfo)
	mock.lockDeleteGroup.Unlock()
	return mock.DeleteGroupFunc(ctx, id)
}

// DeleteGroupCalls gets all the calls that were made to DeleteGroup.
// Check the length with:
//
//	len(mockedInterface.DeleteGroupCalls())
func (mock *InterfaceMock) DeleteGroupCalls() []struct {
	Ctx context.Context
	ID  int64
} {
	var calls []struct {
		Ctx context.Context
		ID  int64
	}
	mock.lockDeleteGroup.RLock()
	calls = mock.calls.DeleteGroup
	mock.lockDeleteGroup.RUnlock()
	return calls
}

// DeleteRepository calls DeleteRepositoryFunc.
func (mock *InterfaceMock) DeleteRepository(ctx context.Context, repositoryName string, digest string) error {
	if mock.DeleteRepositoryFunc == nil {
		panic("InterfaceMock.DeleteRepositoryFunc: method is nil but Interface.DeleteRepository was just called")
	}
	callInfo := struct {
		Ctx            context.Context
		RepositoryName string
		Digest         string
	}{
		Ctx:            ctx,
		RepositoryName: repositoryName,
		Digest:         digest,
	}
	mock.lockDeleteRepository.Lock()
	mock.calls.DeleteRepository = append(mock.calls.DeleteRepository, callInfo)
	mock.lockDeleteRepository.Unlock()
	return mock.DeleteRepositoryFunc(ctx, repositoryName, digest)
}

// DeleteRepositoryCalls gets all the calls that were made to DeleteRepository.
// Check the length with:
//
//	len(mockedInterface.DeleteRepositoryCalls())
func (mock *InterfaceMock) DeleteRepositoryCalls() []struct {
	Ctx            context.Context
	RepositoryName string
	Digest         string
} {
	var calls []struct {
		Ctx            context.Context
		RepositoryName string
		Digest         string
	}
	mock.lockDeleteRepository.RLock()
	calls = mock.calls.DeleteRepository
	mock.lockDeleteRepository.RUnlock()
	return calls
}

// DeleteUser calls DeleteUserFunc.
func (mock *InterfaceMock) DeleteUser(ctx context.Context, id int64) error {
	if mock.DeleteUserFunc == nil {
		panic("InterfaceMock.DeleteUserFunc: method is nil but Interface.DeleteUser was just called")
	}
	callInfo := struct {
		Ctx context.Context
		ID  int64
	}{
		Ctx: ctx,
		ID:  id,
	}
	mock.lockDeleteUser.Lock()
	mock.calls.DeleteUser = append(mock.calls.DeleteUser, callInfo)
	mock.lockDeleteUser.Unlock()
	return mock.DeleteUserFunc(ctx, id)
}

// DeleteUserCalls gets all the calls that were made to DeleteUser.
// Check the length with:
//
//	len(mockedInterface.DeleteUserCalls())
func (mock *InterfaceMock) DeleteUserCalls() []struct {
	Ctx context.Context
	ID  int64
} {
	var calls []struct {
		Ctx context.Context
		ID  int64
	}
	mock.lockDeleteUser.RLock()
	calls = mock.calls.DeleteUser
	mock.lockDeleteUser.RUnlock()
	return calls
}

// FindAccesses calls FindAccessesFunc.
func (mock *InterfaceMock) FindAccesses(ctx context.Context, filter QueryFilter) (ListResponse, error) {
	if mock.FindAccessesFunc == nil {
		panic("InterfaceMock.FindAccessesFunc: method is nil but Interface.FindAccesses was just called")
	}
	callInfo := struct {
		Ctx    context.Context
		Filter QueryFilter
	}{
		Ctx:    ctx,
		Filter: filter,
	}
	mock.lockFindAccesses.Lock()
	mock.calls.FindAccesses = append(mock.calls.FindAccesses, callInfo)
	mock.lockFindAccesses.Unlock()
	return mock.FindAccessesFunc(ctx, filter)
}

// FindAccessesCalls gets all the calls that were made to FindAccesses.
// Check the length with:
//
//	len(mockedInterface.FindAccessesCalls())
func (mock *InterfaceMock) FindAccessesCalls() []struct {
	Ctx    context.Context
	Filter QueryFilter
} {
	var calls []struct {
		Ctx    context.Context
		Filter QueryFilter
	}
	mock.lockFindAccesses.RLock()
	calls = mock.calls.FindAccesses
	mock.lockFindAccesses.RUnlock()
	return calls
}

// FindGroups calls FindGroupsFunc.
func (mock *InterfaceMock) FindGroups(ctx context.Context, filter QueryFilter) (ListResponse, error) {
	if mock.FindGroupsFunc == nil {
		panic("InterfaceMock.FindGroupsFunc: method is nil but Interface.FindGroups was just called")
	}
	callInfo := struct {
		Ctx    context.Context
		Filter QueryFilter
	}{
		Ctx:    ctx,
		Filter: filter,
	}
	mock.lockFindGroups.Lock()
	mock.calls.FindGroups = append(mock.calls.FindGroups, callInfo)
	mock.lockFindGroups.Unlock()
	return mock.FindGroupsFunc(ctx, filter)
}

// FindGroupsCalls gets all the calls that were made to FindGroups.
// Check the length with:
//
//	len(mockedInterface.FindGroupsCalls())
func (mock *InterfaceMock) FindGroupsCalls() []struct {
	Ctx    context.Context
	Filter QueryFilter
} {
	var calls []struct {
		Ctx    context.Context
		Filter QueryFilter
	}
	mock.lockFindGroups.RLock()
	calls = mock.calls.FindGroups
	mock.lockFindGroups.RUnlock()
	return calls
}

// FindRepositories calls FindRepositoriesFunc.
func (mock *InterfaceMock) FindRepositories(ctx context.Context, filter QueryFilter) (ListResponse, error) {
	if mock.FindRepositoriesFunc == nil {
		panic("InterfaceMock.FindRepositoriesFunc: method is nil but Interface.FindRepositories was just called")
	}
	callInfo := struct {
		Ctx    context.Context
		Filter QueryFilter
	}{
		Ctx:    ctx,
		Filter: filter,
	}
	mock.lockFindRepositories.Lock()
	mock.calls.FindRepositories = append(mock.calls.FindRepositories, callInfo)
	mock.lockFindRepositories.Unlock()
	return mock.FindRepositoriesFunc(ctx, filter)
}

// FindRepositoriesCalls gets all the calls that were made to FindRepositories.
// Check the length with:
//
//	len(mockedInterface.FindRepositoriesCalls())
func (mock *InterfaceMock) FindRepositoriesCalls() []struct {
	Ctx    context.Context
	Filter QueryFilter
} {
	var calls []struct {
		Ctx    context.Context
		Filter QueryFilter
	}
	mock.lockFindRepositories.RLock()
	calls = mock.calls.FindRepositories
	mock.lockFindRepositories.RUnlock()
	return calls
}

// FindUsers calls FindUsersFunc.
func (mock *InterfaceMock) FindUsers(ctx context.Context, filter QueryFilter, withPassword bool) (ListResponse, error) {
	if mock.FindUsersFunc == nil {
		panic("InterfaceMock.FindUsersFunc: method is nil but Interface.FindUsers was just called")
	}
	callInfo := struct {
		Ctx          context.Context
		Filter       QueryFilter
		WithPassword bool
	}{
		Ctx:          ctx,
		Filter:       filter,
		WithPassword: withPassword,
	}
	mock.lockFindUsers.Lock()
	mock.calls.FindUsers = append(mock.calls.FindUsers, callInfo)
	mock.lockFindUsers.Unlock()
	return mock.FindUsersFunc(ctx, filter, withPassword)
}

// FindUsersCalls gets all the calls that were made to FindUsers.
// Check the length with:
//
//	len(mockedInterface.FindUsersCalls())
func (mock *InterfaceMock) FindUsersCalls() []struct {
	Ctx          context.Context
	Filter       QueryFilter
	WithPassword bool
} {
	var calls []struct {
		Ctx          context.Context
		Filter       QueryFilter
		WithPassword bool
	}
	mock.lockFindUsers.RLock()
	calls = mock.calls.FindUsers
	mock.lockFindUsers.RUnlock()
	return calls
}

// GetAccess calls GetAccessFunc.
func (mock *InterfaceMock) GetAccess(ctx context.Context, id int64) (store.Access, error) {
	if mock.GetAccessFunc == nil {
		panic("InterfaceMock.GetAccessFunc: method is nil but Interface.GetAccess was just called")
	}
	callInfo := struct {
		Ctx context.Context
		ID  int64
	}{
		Ctx: ctx,
		ID:  id,
	}
	mock.lockGetAccess.Lock()
	mock.calls.GetAccess = append(mock.calls.GetAccess, callInfo)
	mock.lockGetAccess.Unlock()
	return mock.GetAccessFunc(ctx, id)
}

// GetAccessCalls gets all the calls that were made to GetAccess.
// Check the length with:
//
//	len(mockedInterface.GetAccessCalls())
func (mock *InterfaceMock) GetAccessCalls() []struct {
	Ctx context.Context
	ID  int64
} {
	var calls []struct {
		Ctx context.Context
		ID  int64
	}
	mock.lockGetAccess.RLock()
	calls = mock.calls.GetAccess
	mock.lockGetAccess.RUnlock()
	return calls
}

// GetGroup calls GetGroupFunc.
func (mock *InterfaceMock) GetGroup(ctx context.Context, id int64) (store.Group, error) {
	if mock.GetGroupFunc == nil {
		panic("InterfaceMock.GetGroupFunc: method is nil but Interface.GetGroup was just called")
	}
	callInfo := struct {
		Ctx context.Context
		ID  int64
	}{
		Ctx: ctx,
		ID:  id,
	}
	mock.lockGetGroup.Lock()
	mock.calls.GetGroup = append(mock.calls.GetGroup, callInfo)
	mock.lockGetGroup.Unlock()
	return mock.GetGroupFunc(ctx, id)
}

// GetGroupCalls gets all the calls that were made to GetGroup.
// Check the length with:
//
//	len(mockedInterface.GetGroupCalls())
func (mock *InterfaceMock) GetGroupCalls() []struct {
	Ctx context.Context
	ID  int64
} {
	var calls []struct {
		Ctx context.Context
		ID  int64
	}
	mock.lockGetGroup.RLock()
	calls = mock.calls.GetGroup
	mock.lockGetGroup.RUnlock()
	return calls
}

// GetRepository calls GetRepositoryFunc.
func (mock *InterfaceMock) GetRepository(ctx context.Context, entryID int64) (store.RegistryEntry, error) {
	if mock.GetRepositoryFunc == nil {
		panic("InterfaceMock.GetRepositoryFunc: method is nil but Interface.GetRepository was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		EntryID int64
	}{
		Ctx:     ctx,
		EntryID: entryID,
	}
	mock.lockGetRepository.Lock()
	mock.calls.GetRepository = append(mock.calls.GetRepository, callInfo)
	mock.lockGetRepository.Unlock()
	return mock.GetRepositoryFunc(ctx, entryID)
}

// GetRepositoryCalls gets all the calls that were made to GetRepository.
// Check the length with:
//
//	len(mockedInterface.GetRepositoryCalls())
func (mock *InterfaceMock) GetRepositoryCalls() []struct {
	Ctx     context.Context
	EntryID int64
} {
	var calls []struct {
		Ctx     context.Context
		EntryID int64
	}
	mock.lockGetRepository.RLock()
	calls = mock.calls.GetRepository
	mock.lockGetRepository.RUnlock()
	return calls
}

// GetUser calls GetUserFunc.
func (mock *InterfaceMock) GetUser(ctx context.Context, id interface{}) (store.User, error) {
	if mock.GetUserFunc == nil {
		panic("InterfaceMock.GetUserFunc: method is nil but Interface.GetUser was just called")
	}
	callInfo := struct {
		Ctx context.Context
		ID  interface{}
	}{
		Ctx: ctx,
		ID:  id,
	}
	mock.lockGetUser.Lock()
	mock.calls.GetUser = append(mock.calls.GetUser, callInfo)
	mock.lockGetUser.Unlock()
	return mock.GetUserFunc(ctx, id)
}

// GetUserCalls gets all the calls that were made to GetUser.
// Check the length with:
//
//	len(mockedInterface.GetUserCalls())
func (mock *InterfaceMock) GetUserCalls() []struct {
	Ctx context.Context
	ID  interface{}
} {
	var calls []struct {
		Ctx context.Context
		ID  interface{}
	}
	mock.lockGetUser.RLock()
	calls = mock.calls.GetUser
	mock.lockGetUser.RUnlock()
	return calls
}

// RepositoryGarbageCollector calls RepositoryGarbageCollectorFunc.
func (mock *InterfaceMock) RepositoryGarbageCollector(ctx context.Context, syncDate int64) error {
	if mock.RepositoryGarbageCollectorFunc == nil {
		panic("InterfaceMock.RepositoryGarbageCollectorFunc: method is nil but Interface.RepositoryGarbageCollector was just called")
	}
	callInfo := struct {
		Ctx      context.Context
		SyncDate int64
	}{
		Ctx:      ctx,
		SyncDate: syncDate,
	}
	mock.lockRepositoryGarbageCollector.Lock()
	mock.calls.RepositoryGarbageCollector = append(mock.calls.RepositoryGarbageCollector, callInfo)
	mock.lockRepositoryGarbageCollector.Unlock()
	return mock.RepositoryGarbageCollectorFunc(ctx, syncDate)
}

// RepositoryGarbageCollectorCalls gets all the calls that were made to RepositoryGarbageCollector.
// Check the length with:
//
//	len(mockedInterface.RepositoryGarbageCollectorCalls())
func (mock *InterfaceMock) RepositoryGarbageCollectorCalls() []struct {
	Ctx      context.Context
	SyncDate int64
} {
	var calls []struct {
		Ctx      context.Context
		SyncDate int64
	}
	mock.lockRepositoryGarbageCollector.RLock()
	calls = mock.calls.RepositoryGarbageCollector
	mock.lockRepositoryGarbageCollector.RUnlock()
	return calls
}

// UpdateAccess calls UpdateAccessFunc.
func (mock *InterfaceMock) UpdateAccess(ctx context.Context, access store.Access) error {
	if mock.UpdateAccessFunc == nil {
		panic("InterfaceMock.UpdateAccessFunc: method is nil but Interface.UpdateAccess was just called")
	}
	callInfo := struct {
		Ctx    context.Context
		Access store.Access
	}{
		Ctx:    ctx,
		Access: access,
	}
	mock.lockUpdateAccess.Lock()
	mock.calls.UpdateAccess = append(mock.calls.UpdateAccess, callInfo)
	mock.lockUpdateAccess.Unlock()
	return mock.UpdateAccessFunc(ctx, access)
}

// UpdateAccessCalls gets all the calls that were made to UpdateAccess.
// Check the length with:
//
//	len(mockedInterface.UpdateAccessCalls())
func (mock *InterfaceMock) UpdateAccessCalls() []struct {
	Ctx    context.Context
	Access store.Access
} {
	var calls []struct {
		Ctx    context.Context
		Access store.Access
	}
	mock.lockUpdateAccess.RLock()
	calls = mock.calls.UpdateAccess
	mock.lockUpdateAccess.RUnlock()
	return calls
}

// UpdateGroup calls UpdateGroupFunc.
func (mock *InterfaceMock) UpdateGroup(ctx context.Context, group store.Group) error {
	if mock.UpdateGroupFunc == nil {
		panic("InterfaceMock.UpdateGroupFunc: method is nil but Interface.UpdateGroup was just called")
	}
	callInfo := struct {
		Ctx   context.Context
		Group store.Group
	}{
		Ctx:   ctx,
		Group: group,
	}
	mock.lockUpdateGroup.Lock()
	mock.calls.UpdateGroup = append(mock.calls.UpdateGroup, callInfo)
	mock.lockUpdateGroup.Unlock()
	return mock.UpdateGroupFunc(ctx, group)
}

// UpdateGroupCalls gets all the calls that were made to UpdateGroup.
// Check the length with:
//
//	len(mockedInterface.UpdateGroupCalls())
func (mock *InterfaceMock) UpdateGroupCalls() []struct {
	Ctx   context.Context
	Group store.Group
} {
	var calls []struct {
		Ctx   context.Context
		Group store.Group
	}
	mock.lockUpdateGroup.RLock()
	calls = mock.calls.UpdateGroup
	mock.lockUpdateGroup.RUnlock()
	return calls
}

// UpdateRepository calls UpdateRepositoryFunc.
func (mock *InterfaceMock) UpdateRepository(ctx context.Context, conditionClause map[string]interface{}, data map[string]interface{}) error {
	if mock.UpdateRepositoryFunc == nil {
		panic("InterfaceMock.UpdateRepositoryFunc: method is nil but Interface.UpdateRepository was just called")
	}
	callInfo := struct {
		Ctx             context.Context
		ConditionClause map[string]interface{}
		Data            map[string]interface{}
	}{
		Ctx:             ctx,
		ConditionClause: conditionClause,
		Data:            data,
	}
	mock.lockUpdateRepository.Lock()
	mock.calls.UpdateRepository = append(mock.calls.UpdateRepository, callInfo)
	mock.lockUpdateRepository.Unlock()
	return mock.UpdateRepositoryFunc(ctx, conditionClause, data)
}

// UpdateRepositoryCalls gets all the calls that were made to UpdateRepository.
// Check the length with:
//
//	len(mockedInterface.UpdateRepositoryCalls())
func (mock *InterfaceMock) UpdateRepositoryCalls() []struct {
	Ctx             context.Context
	ConditionClause map[string]interface{}
	Data            map[string]interface{}
} {
	var calls []struct {
		Ctx             context.Context
		ConditionClause map[string]interface{}
		Data            map[string]interface{}
	}
	mock.lockUpdateRepository.RLock()
	calls = mock.calls.UpdateRepository
	mock.lockUpdateRepository.RUnlock()
	return calls
}

// UpdateUser calls UpdateUserFunc.
func (mock *InterfaceMock) UpdateUser(ctx context.Context, user store.User) error {
	if mock.UpdateUserFunc == nil {
		panic("InterfaceMock.UpdateUserFunc: method is nil but Interface.UpdateUser was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		User store.User
	}{
		Ctx:  ctx,
		User: user,
	}
	mock.lockUpdateUser.Lock()
	mock.calls.UpdateUser = append(mock.calls.UpdateUser, callInfo)
	mock.lockUpdateUser.Unlock()
	return mock.UpdateUserFunc(ctx, user)
}

// UpdateUserCalls gets all the calls that were made to UpdateUser.
// Check the length with:
//
//	len(mockedInterface.UpdateUserCalls())
func (mock *InterfaceMock) UpdateUserCalls() []struct {
	Ctx  context.Context
	User store.User
} {
	var calls []struct {
		Ctx  context.Context
		User store.User
	}
	mock.lockUpdateUser.RLock()
	calls = mock.calls.UpdateUser
	mock.lockUpdateUser.RUnlock()
	return calls
}
