// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package server

import (
	"context"
	"github.com/docker/distribution/notifications"
	"sync"
)

// Ensure, that dataServiceInterfaceMock does implement dataServiceInterface.
// If this is not the case, regenerate this file with moq.
var _ dataServiceInterface = &dataServiceInterfaceMock{}

// dataServiceInterfaceMock is a mock implementation of dataServiceInterface.
//
// 	func TestSomethingThatUsesdataServiceInterface(t *testing.T) {
//
// 		// make and configure a mocked dataServiceInterface
// 		mockeddataServiceInterface := &dataServiceInterfaceMock{
// 			RepositoriesMaintenanceFunc: func(ctx context.Context, timeout int64)  {
// 				panic("mock out the RepositoriesMaintenance method")
// 			},
// 			RepositoryEventsProcessingFunc: func(ctx context.Context, envelope notifications.Envelope) error {
// 				panic("mock out the RepositoryEventsProcessing method")
// 			},
// 			SyncExistedRepositoriesFunc: func(ctx context.Context) error {
// 				panic("mock out the SyncExistedRepositories method")
// 			},
// 		}
//
// 		// use mockeddataServiceInterface in code that requires dataServiceInterface
// 		// and then make assertions.
//
// 	}
type dataServiceInterfaceMock struct {
	// RepositoriesMaintenanceFunc mocks the RepositoriesMaintenance method.
	RepositoriesMaintenanceFunc func(ctx context.Context, timeout int64)

	// RepositoryEventsProcessingFunc mocks the RepositoryEventsProcessing method.
	RepositoryEventsProcessingFunc func(ctx context.Context, envelope notifications.Envelope) error

	// SyncExistedRepositoriesFunc mocks the SyncExistedRepositories method.
	SyncExistedRepositoriesFunc func(ctx context.Context) error

	// calls tracks calls to the methods.
	calls struct {
		// RepositoriesMaintenance holds details about calls to the RepositoriesMaintenance method.
		RepositoriesMaintenance []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Timeout is the timeout argument value.
			Timeout int64
		}
		// RepositoryEventsProcessing holds details about calls to the RepositoryEventsProcessing method.
		RepositoryEventsProcessing []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Envelope is the envelope argument value.
			Envelope notifications.Envelope
		}
		// SyncExistedRepositories holds details about calls to the SyncExistedRepositories method.
		SyncExistedRepositories []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
		}
	}
	lockRepositoriesMaintenance    sync.RWMutex
	lockRepositoryEventsProcessing sync.RWMutex
	lockSyncExistedRepositories    sync.RWMutex
}

// RepositoriesMaintenance calls RepositoriesMaintenanceFunc.
func (mock *dataServiceInterfaceMock) RepositoriesMaintenance(ctx context.Context, timeout int64) {
	if mock.RepositoriesMaintenanceFunc == nil {
		panic("dataServiceInterfaceMock.RepositoriesMaintenanceFunc: method is nil but dataServiceInterface.RepositoriesMaintenance was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Timeout int64
	}{
		Ctx:     ctx,
		Timeout: timeout,
	}
	mock.lockRepositoriesMaintenance.Lock()
	mock.calls.RepositoriesMaintenance = append(mock.calls.RepositoriesMaintenance, callInfo)
	mock.lockRepositoriesMaintenance.Unlock()
	mock.RepositoriesMaintenanceFunc(ctx, timeout)
}

// RepositoriesMaintenanceCalls gets all the calls that were made to RepositoriesMaintenance.
// Check the length with:
//     len(mockeddataServiceInterface.RepositoriesMaintenanceCalls())
func (mock *dataServiceInterfaceMock) RepositoriesMaintenanceCalls() []struct {
	Ctx     context.Context
	Timeout int64
} {
	var calls []struct {
		Ctx     context.Context
		Timeout int64
	}
	mock.lockRepositoriesMaintenance.RLock()
	calls = mock.calls.RepositoriesMaintenance
	mock.lockRepositoriesMaintenance.RUnlock()
	return calls
}

// RepositoryEventsProcessing calls RepositoryEventsProcessingFunc.
func (mock *dataServiceInterfaceMock) RepositoryEventsProcessing(ctx context.Context, envelope notifications.Envelope) error {
	if mock.RepositoryEventsProcessingFunc == nil {
		panic("dataServiceInterfaceMock.RepositoryEventsProcessingFunc: method is nil but dataServiceInterface.RepositoryEventsProcessing was just called")
	}
	callInfo := struct {
		Ctx      context.Context
		Envelope notifications.Envelope
	}{
		Ctx:      ctx,
		Envelope: envelope,
	}
	mock.lockRepositoryEventsProcessing.Lock()
	mock.calls.RepositoryEventsProcessing = append(mock.calls.RepositoryEventsProcessing, callInfo)
	mock.lockRepositoryEventsProcessing.Unlock()
	return mock.RepositoryEventsProcessingFunc(ctx, envelope)
}

// RepositoryEventsProcessingCalls gets all the calls that were made to RepositoryEventsProcessing.
// Check the length with:
//     len(mockeddataServiceInterface.RepositoryEventsProcessingCalls())
func (mock *dataServiceInterfaceMock) RepositoryEventsProcessingCalls() []struct {
	Ctx      context.Context
	Envelope notifications.Envelope
} {
	var calls []struct {
		Ctx      context.Context
		Envelope notifications.Envelope
	}
	mock.lockRepositoryEventsProcessing.RLock()
	calls = mock.calls.RepositoryEventsProcessing
	mock.lockRepositoryEventsProcessing.RUnlock()
	return calls
}

// SyncExistedRepositories calls SyncExistedRepositoriesFunc.
func (mock *dataServiceInterfaceMock) SyncExistedRepositories(ctx context.Context) error {
	if mock.SyncExistedRepositoriesFunc == nil {
		panic("dataServiceInterfaceMock.SyncExistedRepositoriesFunc: method is nil but dataServiceInterface.SyncExistedRepositories was just called")
	}
	callInfo := struct {
		Ctx context.Context
	}{
		Ctx: ctx,
	}
	mock.lockSyncExistedRepositories.Lock()
	mock.calls.SyncExistedRepositories = append(mock.calls.SyncExistedRepositories, callInfo)
	mock.lockSyncExistedRepositories.Unlock()
	return mock.SyncExistedRepositoriesFunc(ctx)
}

// SyncExistedRepositoriesCalls gets all the calls that were made to SyncExistedRepositories.
// Check the length with:
//     len(mockeddataServiceInterface.SyncExistedRepositoriesCalls())
func (mock *dataServiceInterfaceMock) SyncExistedRepositoriesCalls() []struct {
	Ctx context.Context
} {
	var calls []struct {
		Ctx context.Context
	}
	mock.lockSyncExistedRepositories.RLock()
	calls = mock.calls.SyncExistedRepositories
	mock.lockSyncExistedRepositories.RUnlock()
	return calls
}
