/*
 * Copyright (c) 2023 by David Gerber - https://zapek.com
 *
 * This file is part of Xeres.
 *
 * Xeres is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Xeres is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Xeres.  If not, see <http://www.gnu.org/licenses/>.
 */

package io.xeres.ui.support.contentline;

import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;

public class ContentCode implements Content
{
	private static final String STYLE = "-fx-font-family: \"monospace\"";

	private Text node;

	public ContentCode(String text)
	{
		node = new Text(text);
		node.setFill(Color.LIMEGREEN);
		node.setStyle(STYLE);
	}

	@Override
	public Node getNode()
	{
		return node;
	}

	@Override
	public void stripTrailingLn()
	{
		var text = node.getText();
		if (text.endsWith("\n"))
		{
			node = new Text(text.substring(0, text.length() - 1));
			node.setFill(Color.LIMEGREEN);
			node.setStyle(STYLE);
		}
	}
}
