# How to contribute

Contributions are welcome! Please read the following in order to make it easier.

## Reporting a bug

* use the [issue tracker](https://github.com/zapek/Xeres/issues)
* make sure the bug is not already in the list, to avoid duplicates (a simple search should do)
* if in doubt, feel free to [discuss it](https://github.com/zapek/Xeres/discussions) first

## Making a feature request

* use the [issue tracker](https://github.com/zapek/Xeres/issues)
* make sure the feature request is not already in the list, to avoid duplicates (a simple search should do)
* if in doubt, feel free to [discuss it](https://github.com/zapek/Xeres/discussions) first

## Submitting changes

* make sure you use the same formatting and style (there's an .editorconfig file that does it automatically)
* create a branch using either `feature`/name if it's for adding a feature or `bugfix`/name for **simple** bugfixes (otherwise use `feature`). Use a meaningful name like `25-add-multiple-locations` (the first number being the number of the corresponding issue, if any)
* write a meaningful commit message, [this link](https://chris.beams.io/posts/git-commit/) contains useful information on how to do it
* create a [pull request](https://github.com/zapek/Xeres/pulls)
* if in doubt, feel free to [discuss it](https://github.com/zapek/Xeres/discussions) first

Thank you!