--
-- Add chat backlog
--
CREATE TABLE chat_backlog
(
	id              BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,
	location_id     BIGINT NOT NULL,
	created         TIMESTAMP(9) NOT NULL,
	own             BOOLEAN NOT NULL,
	message         VARCHAR(199000)
);
CREATE INDEX idx_location_created ON chat_backlog (location_id, created);

CREATE TABLE chat_room_backlog
(
	id              BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,
	room_id         BIGINT NOT NULL,
	created         TIMESTAMP(9) NOT NULL,
	gxs_id          BINARY(16) DEFAULT NULL,
	nickname        VARCHAR(512) NOT NULL,
	message         VARCHAR(199000)
);
CREATE INDEX idx_room_created ON chat_room_backlog (room_id, created);
