[![Main site](docs/logo.png)](https://xeres.io)

[![GitHub release](https://img.shields.io/github/release/zapek/Xeres.svg?label=latest%20release)](https://github.com/zapek/Xeres/releases/latest)
[![Downloads](https://img.shields.io/github/downloads/zapek/Xeres/total)](https://github.com/zapek/Xeres/releases/latest)
[![License](https://img.shields.io/github/license/zapek/Xeres.svg?logo=gnu)](https://github.com/zapek/Xeres/blob/master/LICENSE)
[![CodeQL](https://github.com/zapek/Xeres/actions/workflows/analysis.yml/badge.svg)](https://github.com/zapek/Xeres/actions/workflows/analysis.yml)
[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=zapek_Xeres&metric=alert_status)](https://sonarcloud.io/summary/new_code?id=zapek_Xeres)
[![OpenSSF Best Practices](https://www.bestpractices.dev/projects/9469/badge)](https://www.bestpractices.dev/projects/9469)
[![GitHub Discussions](https://img.shields.io/badge/chat-Discussions-green?logo=github)](https://github.com/zapek/Xeres/discussions)

[Xeres](https://xeres.io) is a Friend-to-Friend, decentralized and secure application for communication and sharing.

![Xeres Desktop](docs/screenshot-chat.jpg)

[More screenshots](https://xeres.io/screenshots/)

---

## Features

- 🤝 Peer-to-Peer ([Friend-to-Friend](https://en.wikipedia.org/wiki/Friend-to-friend)), fully decentralized
- 🚫 No censorship. Cannot be censored
- 💬 Chat directly with your friends or in chat rooms
- 📢 Participate in forums and discuss any topic
- 📂 Share and search files anonymously
- 👋 Compatible with [Retroshare](https://retroshare.cc) 0.6.6 or higher
- 🛠️ Hardware accelerated encryption
- 🖥️ Modern looking desktop user interface with several themes including dark mode
- 📶 Remote access, access your instance on the go (Android mobile client available [here](https://github.com/zapek/Xeres-Android))
- 📖 Free software ([GPL](https://www.gnu.org/licenses/quick-guide-gplv3.html))
- 😃 Available for Windows and Linux

## Releases

Latest release [here](https://github.com/zapek/Xeres/releases/latest).

The mobile client for Android is [here](https://github.com/zapek/Xeres-Android/releases/latest).

The docker image for headless installations is [here](https://hub.docker.com/r/zapek/xeres)

## Quick try

Install Xeres then connect to a [ChatServer](https://retroshare.ch).

## Getting Help

- [User Documentation & FAQ](https://xeres.io/docs/)
- [Discussions & Forums](https://github.com/zapek/Xeres/discussions)
- [Issues Reporting](https://github.com/zapek/Xeres/issues)

## Documentation

- [Technical Documentation](https://github.com/zapek/Xeres/wiki)
- [Roadmap](https://github.com/users/zapek/projects/4)

## Development

- [Development Help](https://github.com/zapek/Xeres/wiki#development)
- [Contributing](docs/contributing.md)

