/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import routines.system.ThreadQueue;

class ThreadPoolWorker {
    private static int nextWorkerID = 0;
    private ThreadQueue idleWorkers;
    private int workerID;
    private ThreadQueue handoffBox;
    private Thread internalThread;
    private volatile boolean noStopRequested;

    public ThreadPoolWorker(ThreadQueue idleWorkers) {
        this.idleWorkers = idleWorkers;
        this.workerID = ThreadPoolWorker.getNextWorkerID();
        this.handoffBox = new ThreadQueue(1);
        this.noStopRequested = true;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    ThreadPoolWorker.this.runWork();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        };
        this.internalThread = new Thread(r);
        this.internalThread.start();
    }

    public static synchronized int getNextWorkerID() {
        int id = nextWorkerID++;
        return id;
    }

    public void process(Runnable target) throws InterruptedException {
        this.handoffBox.add(target);
    }

    private void runWork() {
        while (this.noStopRequested) {
            try {
                this.idleWorkers.add(this);
                Runnable r = (Runnable)this.handoffBox.remove();
                this.runIt(r);
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void runIt(Runnable r) {
        try {
            try {
                r.run();
            }
            catch (Exception runex) {
                runex.printStackTrace();
                Thread.interrupted();
            }
        }
        finally {
            Thread.interrupted();
        }
    }

    public void stopRequest() {
        this.noStopRequested = false;
        this.internalThread.interrupt();
    }

    public boolean isAlive() {
        return this.internalThread.isAlive();
    }
}

