/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String EMPTY = "";

    public static String newStringFromSplit(CharsetDecoder decoder, CharsetDecoder utf8Decoder, String encoding, byte[] fieldBytes, int length) {
        ByteBuffer fieldBuf = ByteBuffer.wrap(fieldBytes, 0, length);
        CharBuffer fieldCharBuf = CharBuffer.allocate(length);
        utf8Decoder.reset();
        CoderResult res = utf8Decoder.decode(fieldBuf, fieldCharBuf, true);
        if (res.isError() && decoder != null) {
            decoder.reset();
            res = decoder.decode(fieldBuf, fieldCharBuf, true);
            if (!res.isError()) {
                decoder.flush(fieldCharBuf);
                return new String(fieldCharBuf.array());
            }
        } else {
            utf8Decoder.flush(fieldCharBuf);
            return new String(fieldCharBuf.array());
        }
        return EMPTY;
    }

    public static String[] splitNotRegexWithEncoding(byte[] bline, String encoding, String separatorChars) throws UnsupportedEncodingException {
        int resultSize;
        if (bline == null) {
            return null;
        }
        ByteBuffer line = ByteBuffer.wrap(bline);
        byte[] sep = null;
        CharsetDecoder decoder = null;
        if (encoding != null) {
            sep = separatorChars.getBytes(encoding);
            decoder = Charset.forName(encoding).newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        } else {
            sep = separatorChars.getBytes();
        }
        if (sep.length == 0) {
            String[] result = new String[]{new String(bline, encoding)};
            return result;
        }
        CharsetDecoder utf8Decoder = Charset.forName("UTF-8").newDecoder();
        utf8Decoder.onMalformedInput(CodingErrorAction.REPORT);
        utf8Decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        ArrayList<String> substrings = new ArrayList<String>();
        int lineLength = line.limit();
        int sepCursor = 0;
        int fieldCursor = 0;
        byte[] fieldBytes = new byte[lineLength];
        while (line.position() < line.limit()) {
            if (sepCursor < sep.length) {
                byte currentByte = line.get();
                if (currentByte == sep[sepCursor]) {
                    ++sepCursor;
                    continue;
                }
                sepCursor = 0;
                fieldBytes[fieldCursor++] = currentByte;
                continue;
            }
            if (fieldCursor > 0) {
                substrings.add(StringUtils.newStringFromSplit(decoder, utf8Decoder, encoding, fieldBytes, fieldCursor));
                fieldCursor = 0;
            } else {
                substrings.add(EMPTY);
            }
            sepCursor = 0;
        }
        if (fieldCursor > 0) {
            substrings.add(StringUtils.newStringFromSplit(decoder, utf8Decoder, encoding, fieldBytes, fieldCursor));
        }
        if (sepCursor == sep.length) {
            substrings.add(EMPTY);
        }
        if ((resultSize = substrings.size()) == 0) {
            String[] result = new String[]{new String(bline, encoding)};
            return result;
        }
        String[] result = new String[resultSize];
        substrings.toArray(result);
        return result;
    }

    public static String[] splitNotRegex(String str, String separatorChars) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        int separatorLength = separatorChars.length();
        ArrayList<String> substrings = new ArrayList<String>();
        int beg = 0;
        int end = 0;
        while (end < len) {
            end = str.indexOf(separatorChars, beg);
            if (end > -1) {
                if (end > beg) {
                    substrings.add(str.substring(beg, end));
                    beg = end + separatorLength;
                    continue;
                }
                substrings.add(EMPTY);
                beg = end + separatorLength;
                continue;
            }
            substrings.add(str.substring(beg));
            end = len;
        }
        int resultSize = substrings.size();
        String[] result = substrings.toArray(new String[resultSize]);
        while (resultSize > 0 && ((String)substrings.get(resultSize - 1)).equals(EMPTY)) {
            result[--resultSize] = null;
        }
        return result;
    }

    public static String[] splitSQLColumns(String sql) {
        ArrayList<String> result = new ArrayList<String>();
        int blockCount = 0;
        int start = 0;
        int i = 0;
        while (i < sql.length()) {
            char c = sql.charAt(i);
            if (c == '(') {
                ++blockCount;
            } else if (c == ')') {
                --blockCount;
            }
            if (c == ',' && blockCount < 1) {
                result.add(sql.substring(start, i));
                start = i + 1;
            }
            if (i == sql.length() - 1) {
                result.add(sql.substring(start));
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }

    public static String[] split(String str, String separator) {
        return str.split(separator);
    }

    public static String deleteChar(String s, char delChar) {
        int len = s.length();
        char[] val = s.toCharArray();
        char[] buf = new char[len];
        int m = 0;
        int k = 0;
        while (k < len) {
            char c = val[k];
            if (c != delChar) {
                buf[m] = c;
                ++m;
            }
            ++k;
        }
        return new String(buf, 0, m);
    }

    public static String list(String[] stringArray) {
        return StringUtils.list(stringArray, null, null, null, null);
    }

    public static String list(String[] stringArray, String separator) {
        return StringUtils.list(stringArray, separator, null, null, null);
    }

    public static String list(String[] stringArray, String separator, String startEnclosure, String endEnclosure) {
        return StringUtils.list(stringArray, separator, startEnclosure, endEnclosure, null);
    }

    public static String list(String[] stringArray, String separator, String escaper) {
        return StringUtils.list(stringArray, separator, null, null, escaper);
    }

    public static String list(String[] stringArray, String separator, String startEnclosure, String endEnclosure, String escaper) {
        separator = separator == null ? EMPTY : separator.trim();
        startEnclosure = startEnclosure == null ? EMPTY : startEnclosure.trim();
        endEnclosure = endEnclosure == null ? EMPTY : endEnclosure.trim();
        escaper = escaper == null ? EMPTY : escaper.trim();
        StringBuilder result = new StringBuilder();
        result.append(startEnclosure);
        boolean flag = false;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray2[n2];
            item = item.trim();
            if (flag) {
                result.append(separator);
            } else {
                flag = true;
            }
            result.append(escaper);
            result.append(item);
            result.append(escaper);
            ++n2;
        }
        result.append(endEnclosure);
        return result.toString();
    }

    public static String replaceAll(String src, String regex, String replacement) {
        if (regex == null) {
            if (src == null) {
                return replacement;
            }
            return src;
        }
        if (src == null) {
            return null;
        }
        if (replacement == null) {
            if (src.matches(regex)) {
                return replacement;
            }
            return src;
        }
        return src.replaceAll(regex, replacement);
    }

    public static String replaceAllStrictly(String src, String search, String replacement, boolean entirelyMatch, boolean caseSensitive) {
        if (search == null) {
            if (src == null) {
                return replacement;
            }
            return src;
        }
        if (src == null) {
            return null;
        }
        if (replacement == null || entirelyMatch) {
            if (caseSensitive && src.equals(search) || !caseSensitive && src.equalsIgnoreCase(search)) {
                return replacement;
            }
            return src;
        }
        int flag = caseSensitive ? 16 : 18;
        return Pattern.compile(search, flag).matcher(src).replaceAll(Matcher.quoteReplacement(replacement));
    }

    public static String escapeChar(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        StringBuffer sb = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\").append('n');
                    break;
                }
                case '\r': {
                    sb.append("\\").append('r');
                    break;
                }
                case '\t': {
                    sb.append("\\").append('t');
                    break;
                }
                case '\f': {
                    sb.append("\\").append('f');
                    break;
                }
                case '\b': {
                    sb.append("\\").append('b');
                    break;
                }
                case '\"': {
                    sb.append("\\").append('\"');
                    break;
                }
                case '\'': {
                    sb.append("\\").append('\'');
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String valueOf(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static String valueOf(char[] data) {
        return String.valueOf(data);
    }

    public static String valueOf(boolean b) {
        return String.valueOf(b);
    }

    public static String valueOf(char c) {
        return String.valueOf(c);
    }

    public static String valueOf(int i) {
        return String.valueOf(i);
    }

    public static String valueOf(long l) {
        return String.valueOf(l);
    }

    public static String valueOf(float f) {
        return String.valueOf(f);
    }

    public static String valueOf(double d) {
        return String.valueOf(d);
    }
}

