/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class StatCatcherUtils {
    List<StatCatcherMessage> messages = Collections.synchronizedList(new ArrayList());
    String jobId = "";
    String jobVersion = "";

    public StatCatcherUtils(String jobId, String jobVersion) {
        this.jobId = jobId;
        this.jobVersion = jobVersion;
    }

    public void addMessage(String message, String origin, Long duration) {
        String messageType = "";
        if (message.compareTo("begin") == 0) {
            messageType = message;
            message = null;
        } else if (message.compareTo("end") == 0) {
            messageType = message;
            message = "success";
        } else if (message.compareTo("failure") == 0) {
            messageType = "end";
        }
        StatCatcherMessage scm = new StatCatcherMessage(message, messageType, origin, duration, this.jobVersion, this.jobId);
        this.messages.add(scm);
    }

    public void addMessage(String message, String origin) {
        this.addMessage(message, origin, null);
    }

    public void addMessage(String message, Long duration) {
        this.addMessage(message, "", duration);
    }

    public void addMessage(String message) {
        this.addMessage(message, "", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StatCatcherMessage> getMessages() {
        ArrayList<StatCatcherMessage> messagesToSend = new ArrayList<StatCatcherMessage>();
        List<StatCatcherMessage> list = this.messages;
        synchronized (list) {
            for (StatCatcherMessage scm : this.messages) {
                messagesToSend.add(scm);
            }
            this.messages.clear();
        }
        return messagesToSend;
    }

    public static long getPid() {
        RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
        String[] mxNameTable = mx.getName().split("@");
        if (mxNameTable.length == 2) {
            return Long.parseLong(mxNameTable[0]);
        }
        return Thread.currentThread().getId();
    }

    public class StatCatcherMessage {
        private String origin;
        private String message;
        private Long duration = null;
        private Date moment;
        private String messageType;
        private String jobVersion;
        private String jobId;
        private Long systemPid;

        public StatCatcherMessage(String message, String messageType, String origin, Long duration, String jobVersion, String jobId) {
            this.origin = origin;
            this.message = message;
            this.duration = duration;
            this.moment = Calendar.getInstance().getTime();
            this.messageType = messageType;
            this.jobVersion = jobVersion;
            this.jobId = jobId;
            this.systemPid = StatCatcherUtils.getPid();
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getOrigin() {
            return this.origin;
        }

        public void setOrigin(String origin) {
            this.origin = origin;
        }

        public Date getMoment() {
            return this.moment;
        }

        public void setMoment(Date d) {
            this.moment = d;
        }

        public Long getDuration() {
            return this.duration;
        }

        public void setDuration(Long duration) {
            this.duration = duration;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public String getJobVersion() {
            return this.jobVersion;
        }

        public void setJobVersion(String jobVersion) {
            this.jobVersion = jobVersion;
        }

        public String getMessageType() {
            return this.messageType;
        }

        public void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        public Long getSystemPid() {
            return this.systemPid;
        }

        public void setSystemPid(Long systemPid) {
            this.systemPid = systemPid;
        }
    }
}

