/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import routines.system.FormatterUtils;
import routines.system.JSONObject;
import routines.system.PasswordEncryptUtil;

public class ResumeUtil {
    String logFileName = null;
    SimpleCsvWriter csvWriter = null;
    ResumeCommonInfo commonInfo = null;
    private static boolean genDynamicPart = true;
    String root_pid = null;
    private static Map<String, SimpleCsvWriter> sharedWriterMap = new HashMap<String, SimpleCsvWriter>();
    private static Object lock = new Object();

    public static void setGenDynamicPart(boolean genDynamicPart) {
        ResumeUtil.genDynamicPart = genDynamicPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResumeUtil(String logFileName, boolean createNewFile, String root_pid) {
        if (logFileName == null || logFileName.equals("null")) {
            return;
        }
        if (this.root_pid == null) {
            this.root_pid = root_pid;
        }
        this.logFileName = logFileName;
        Object object = lock;
        synchronized (object) {
            SimpleCsvWriter sharedWriter = sharedWriterMap.get(root_pid);
            File file = new File(logFileName);
            try {
                if (sharedWriter == null) {
                    this.csvWriter = new SimpleCsvWriter(new FileWriter(logFileName, createNewFile));
                    sharedWriterMap.put(this.root_pid, this.csvWriter);
                    if (file.length() == 0L) {
                        if (genDynamicPart) {
                            this.csvWriter.write("eventDate");
                            this.csvWriter.write("pid");
                            this.csvWriter.write("root_pid");
                            this.csvWriter.write("father_pid");
                        }
                        this.csvWriter.write("type");
                        this.csvWriter.write("partName");
                        this.csvWriter.write("parentPart");
                        if (genDynamicPart) {
                            this.csvWriter.write("project");
                        }
                        this.csvWriter.write("jobName");
                        this.csvWriter.write("jobContext");
                        this.csvWriter.write("jobVersion");
                        this.csvWriter.write("threadId");
                        this.csvWriter.write("logPriority");
                        this.csvWriter.write("errorCode");
                        this.csvWriter.write("message");
                        this.csvWriter.write("stackTrace");
                        this.csvWriter.write("dynamicData");
                        this.csvWriter.endRecord();
                        this.csvWriter.flush();
                    }
                } else {
                    this.csvWriter = sharedWriter;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initCommonInfo(String pid, String root_pid, String father_pid, String project, String jobName, String jobContext, String jobVersion) {
        this.commonInfo = new ResumeCommonInfo();
        this.commonInfo.pid = pid;
        this.commonInfo.root_pid = root_pid;
        this.commonInfo.father_pid = father_pid;
        this.commonInfo.project = project;
        this.commonInfo.jobName = jobName;
        this.commonInfo.jobContext = jobContext;
        this.commonInfo.jobVersion = jobVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLog(String type, String partName, String parentPart, String threadId, String logPriority, String errorCode, String message, String stackTrace, String dynamicData) {
        if (this.csvWriter == null) {
            return;
        }
        String eventDate = FormatterUtils.format_Date(new Date(), "yyyy-MM-dd HH:mm:ss.S");
        JobLogItem item = new JobLogItem(eventDate, type, partName, parentPart, threadId, logPriority, errorCode, message, stackTrace, dynamicData);
        try {
            SimpleCsvWriter simpleCsvWriter = this.csvWriter;
            synchronized (simpleCsvWriter) {
                if (genDynamicPart) {
                    this.csvWriter.write(item.eventDate);
                    this.csvWriter.write(this.commonInfo.pid);
                    this.csvWriter.write(this.commonInfo.root_pid);
                    this.csvWriter.write(this.commonInfo.father_pid);
                }
                this.csvWriter.write(item.type);
                this.csvWriter.write(item.partName);
                this.csvWriter.write(item.parentPart);
                if (genDynamicPart) {
                    this.csvWriter.write(this.commonInfo.project);
                }
                this.csvWriter.write(this.commonInfo.jobName);
                this.csvWriter.write(this.commonInfo.jobContext);
                this.csvWriter.write(this.commonInfo.jobVersion);
                this.csvWriter.write(null);
                this.csvWriter.write(item.logPriority);
                this.csvWriter.write(item.errorCode);
                this.csvWriter.write(item.message);
                this.csvWriter.write(item.stackTrace);
                this.csvWriter.write(item.dynamicData);
                this.csvWriter.endRecord();
                this.csvWriter.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static void invokeTargetCheckPoint(String resuming_checkpoint_path, Object jobObject, Map<String, Object> globalMap) throws Exception {
        int indexOf;
        String currentJob_checkpoint_path = null;
        if (resuming_checkpoint_path != null) {
            int indexOf2 = resuming_checkpoint_path.indexOf("/NODE:");
            currentJob_checkpoint_path = indexOf2 != -1 ? resuming_checkpoint_path.substring(0, indexOf2) : resuming_checkpoint_path;
        }
        String currentJob_subJob_resuming = null;
        if (currentJob_checkpoint_path != null && (indexOf = currentJob_checkpoint_path.indexOf("/SUBJOB:")) != -1) {
            currentJob_subJob_resuming = currentJob_checkpoint_path.substring(indexOf + 8);
        }
        String subjobMethodName = String.valueOf(currentJob_subJob_resuming) + "Process";
        if (currentJob_subJob_resuming != null) {
            Method[] methodArray = jobObject.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getName().compareTo(subjobMethodName) == 0) {
                    m.invoke(jobObject, globalMap);
                    break;
                }
                ++n2;
            }
        }
    }

    public static String getResumeEntryMethodName(String resuming_checkpoint_path) {
        int indexOf;
        String currentJob_checkpoint_path = null;
        if (resuming_checkpoint_path != null) {
            int indexOf2 = resuming_checkpoint_path.indexOf("/NODE:");
            currentJob_checkpoint_path = indexOf2 != -1 ? resuming_checkpoint_path.substring(0, indexOf2) : resuming_checkpoint_path;
        }
        String currentJob_subJob_resuming = null;
        if (currentJob_checkpoint_path != null && (indexOf = currentJob_checkpoint_path.indexOf("/SUBJOB:")) != -1) {
            currentJob_subJob_resuming = currentJob_checkpoint_path.substring(indexOf + 8);
        }
        String subjobMethodName = null;
        if (currentJob_subJob_resuming != null) {
            subjobMethodName = String.valueOf(currentJob_subJob_resuming) + "Process";
        }
        if (!(resuming_checkpoint_path == null || subjobMethodName != null && subjobMethodName.matches("[\\w]*_[\\d]*Process"))) {
            throw new RuntimeException("Parse the \"resuming_checkpoint_path=" + resuming_checkpoint_path + "\" failed. There can't get the a valid resume subjob name.");
        }
        return subjobMethodName;
    }

    public static String getChildJobCheckPointPath(String resuming_checkpoint_path) {
        int indexOf;
        String childJob_checkpoint_path = null;
        if (resuming_checkpoint_path != null && (indexOf = resuming_checkpoint_path.indexOf("/NODE:")) != -1) {
            String temp = resuming_checkpoint_path.substring(indexOf);
            int index = temp.indexOf("/JOB:");
            childJob_checkpoint_path = temp.substring(index);
        }
        return childJob_checkpoint_path;
    }

    public static String getRighttRunJob(String resuming_checkpoint_path) {
        String temp;
        int index;
        int indexOf;
        String tRunJobName = null;
        if (resuming_checkpoint_path != null && (indexOf = resuming_checkpoint_path.indexOf("/NODE:")) != -1 && (index = (temp = resuming_checkpoint_path.substring(indexOf)).indexOf("/JOB:")) != -1) {
            tRunJobName = temp.substring(6, index);
        }
        return tRunJobName;
    }

    public static String getExceptionStackTrace(Exception exception) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out, true);
        exception.printStackTrace(ps);
        String str = ((Object)out).toString();
        return str;
    }

    public static String convertToJsonText(Object context, List<String> parametersToEncrypt) {
        String jsonText = "";
        try {
            JSONObject firstNode = new JSONObject();
            JSONObject secondNode = new JSONObject(context);
            if (parametersToEncrypt != null) {
                for (String parameterToEncrypt : parametersToEncrypt) {
                    if (secondNode.isNull(parameterToEncrypt)) continue;
                    secondNode.put(parameterToEncrypt, PasswordEncryptUtil.encryptPassword(secondNode.getString(parameterToEncrypt)));
                }
            }
            firstNode.putOpt("context_parameters", secondNode);
            jsonText = firstNode.toString(8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonText;
    }

    public static String convertToJsonText(Object context) {
        return ResumeUtil.convertToJsonText(context, null);
    }

    public class JobLogItem {
        public String eventDate = null;
        public String type = null;
        public String partName = null;
        public String parentPart = null;
        public String threadId = null;
        public String logPriority = null;
        public String errorCode = null;
        public String message = null;
        public String stackTrace = null;
        public String dynamicData = null;

        public JobLogItem(String eventDate, String type, String partName, String parentPart, String threadId, String logPriority, String errorCode, String message, String stackTrace, String dynamicData) {
            this.eventDate = eventDate;
            this.type = type;
            this.partName = partName;
            this.parentPart = parentPart;
            this.threadId = threadId;
            this.logPriority = logPriority;
            this.errorCode = errorCode;
            this.message = message;
            this.stackTrace = stackTrace;
            this.dynamicData = dynamicData;
        }
    }

    public static enum LogPriority {
        NONE,
        WARN,
        ERROR,
        FATAL;

    }

    public class ResumeCommonInfo {
        public String pid = null;
        public String root_pid = null;
        public String father_pid = null;
        public String project = null;
        public String jobName = null;
        public String jobContext = null;
        public String jobVersion = null;
    }

    public static enum ResumeEventType {
        JOB_STARTED,
        CHECKPOINT,
        SYSTEM_LOG,
        USER_DEF_LOG,
        JOB_ENDED;

    }

    public class SimpleCsvWriter {
        private Writer writer = null;
        private boolean firstColumn = true;
        private static final int ESCAPE_MODE_BACKSLASH = 2;
        private static final int ESCAPE_MODE_DOUBLED = 1;
        private static final int EscapeMode = 1;
        private static final char TextQualifier = '\"';
        private static final char BACKSLASH = '\\';
        private static final char Delimiter = ',';
        private String lineSeparator = System.getProperty("line.separator");

        public SimpleCsvWriter(Writer writer) {
            this.writer = writer;
        }

        public void write(String content) throws IOException {
            if (content == null) {
                content = "";
            }
            if (!this.firstColumn) {
                this.writer.write(44);
            }
            this.writer.write(34);
            content = this.replace(content, "\"", "\"\"");
            this.writer.write(content);
            this.writer.write(34);
            this.firstColumn = false;
        }

        public void endRecord() throws IOException {
            this.writer.write(this.lineSeparator);
            this.firstColumn = true;
        }

        public void flush() {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void close() {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private String replace(String original, String pattern, String replace) {
            int len = pattern.length();
            int found = original.indexOf(pattern);
            if (found > -1) {
                StringBuffer sb = new StringBuffer();
                int start = 0;
                while (found != -1) {
                    sb.append(original.substring(start, found));
                    sb.append(replace);
                    start = found + len;
                    found = original.indexOf(pattern, start);
                }
                sb.append(original.substring(start));
                return sb.toString();
            }
            return original;
        }
    }
}

