/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public class JDBCUtil {
    public static String getString(ResultSet rs, int index, boolean trim) throws SQLException {
        String result = rs.getString(index);
        if (trim && result != null) {
            return result.trim();
        }
        return result;
    }

    public static Double getDoubleObject(ResultSet rs, int index) throws SQLException {
        if (rs.getObject(index) != null) {
            return rs.getDouble(index);
        }
        return null;
    }

    public static Boolean getBooleanObject(ResultSet rs, int index) throws SQLException {
        if (rs.getObject(index) != null) {
            return rs.getBoolean(index);
        }
        return null;
    }

    public static double getDouble(ResultSet rs, int index) throws SQLException {
        if (rs.getObject(index) != null) {
            return rs.getDouble(index);
        }
        throw new RuntimeException("Null value in non-Nullable column");
    }

    public static boolean getBoolean(ResultSet rs, int index) throws SQLException {
        if (rs.getObject(index) != null) {
            return rs.getBoolean(index);
        }
        throw new RuntimeException("Null value in non-Nullable column");
    }

    public static Date getDate(ResultSet rs, int index) throws SQLException {
        if (rs.getTimestamp(index) != null) {
            return new Date(rs.getTimestamp(index).getTime());
        }
        return null;
    }

    public static Double getDoubleObject2(ResultSet rs, int index) throws SQLException {
        Double result = rs.getDouble(index);
        if (result == 0.0 && rs.getObject(index) == null) {
            return null;
        }
        return result;
    }

    public static double getDouble2(ResultSet rs, int index) throws SQLException {
        Double result = rs.getDouble(index);
        if (result == 0.0 && rs.getObject(index) == null) {
            throw new RuntimeException("Null value in non-Nullable column");
        }
        return result;
    }
}

