/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class FastDateParser {
    private static FastDateParser instance;
    private static ThreadLocal<HashMap<DateFormatKey, DateFormat>> localCache;
    private static ThreadLocal<DateFormatKey> localDateFormatKey;

    static {
        localCache = new ThreadLocal<HashMap<DateFormatKey, DateFormat>>(){

            @Override
            protected HashMap<DateFormatKey, DateFormat> initialValue() {
                return new HashMap<DateFormatKey, DateFormat>();
            }
        };
        localDateFormatKey = new ThreadLocal<DateFormatKey>(){

            @Override
            protected DateFormatKey initialValue() {
                return FastDateParser.getInstance().new DateFormatKey();
            }
        };
    }

    public static FastDateParser getInstance() {
        if (instance == null) {
            instance = new FastDateParser();
        }
        return instance;
    }

    private FastDateParser() {
    }

    public static DateFormat getInstance(String pattern) {
        return FastDateParser.getInstance(pattern, null, true);
    }

    public static DateFormat getInstance(String pattern, boolean lenient) {
        return FastDateParser.getInstance(pattern, null, lenient);
    }

    public static DateFormat getInstance(String pattern, Locale locale) {
        return FastDateParser.getInstance(pattern, locale, true);
    }

    public static DateFormat getInstance(String pattern, Locale locale, boolean lenient) {
        localDateFormatKey.get().pattern = pattern;
        localDateFormatKey.get().locale = locale;
        DateFormat format = localCache.get().get(localDateFormatKey.get());
        if (format == null) {
            format = pattern.equals("yyyy-MM-dd") ? new DateParser() : (pattern.equals("yyyy-MM-dd HH:mm:ss") ? new DateTimeParser() : (locale != null ? new SimpleDateFormat(pattern, locale) : new SimpleDateFormat(pattern)));
            FastDateParser fastDateParser = FastDateParser.getInstance();
            fastDateParser.getClass();
            localCache.get().put(fastDateParser.new DateFormatKey(pattern, locale), format);
        }
        if (format.isLenient() != lenient) {
            format.setLenient(lenient);
        }
        return format;
    }

    private class DateFormatKey {
        private String pattern;
        private Locale locale;

        public DateFormatKey() {
        }

        public DateFormatKey(String pattern, Locale locale) {
            this.pattern = pattern;
            this.locale = locale;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DateFormatKey other = (DateFormatKey)obj;
            if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
                return false;
            }
            return !(this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern));
        }
    }

    private static class DateParser
    extends DateFormat {
        private int year;
        private int month;
        private int day;

        public DateParser() {
            this.calendar = Calendar.getInstance();
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            this.calendar.setTime(date);
            toAppendTo.append(this.calendar.get(1));
            while (toAppendTo.length() < 4) {
                toAppendTo.insert(0, "0");
            }
            toAppendTo.append("-");
            this.month = this.calendar.get(2) + 1;
            if (this.month < 10) {
                toAppendTo.append("0");
            }
            toAppendTo.append(this.month);
            toAppendTo.append("-");
            this.day = this.calendar.get(5);
            if (this.day < 10) {
                toAppendTo.append("0");
            }
            toAppendTo.append(this.day);
            return toAppendTo;
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            int index = 0;
            try {
                this.year = Integer.parseInt(source.substring(0, 4));
                index = 5;
                this.month = Integer.parseInt(source.substring(5, 7)) - 1;
                index = 8;
                this.day = Integer.parseInt(source.substring(8, 10));
                pos.setIndex(source.length());
                this.calendar.clear();
                this.calendar.set(this.year, this.month, this.day);
                return this.calendar.getTime();
            }
            catch (Exception e) {
                pos.setErrorIndex(index);
                e.printStackTrace();
                return null;
            }
        }
    }

    private static class DateTimeParser
    extends DateFormat {
        private int year;
        private int month;
        private int day;
        private int hour;
        private int minute;
        private int second;

        public DateTimeParser() {
            this.calendar = Calendar.getInstance();
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            this.calendar.setTime(date);
            toAppendTo.append(this.calendar.get(1));
            while (toAppendTo.length() < 4) {
                toAppendTo.insert(0, "0");
            }
            toAppendTo.append("-");
            this.month = this.calendar.get(2) + 1;
            if (this.month < 10) {
                toAppendTo.append("0");
            }
            toAppendTo.append(this.month);
            toAppendTo.append("-");
            this.day = this.calendar.get(5);
            if (this.day < 10) {
                toAppendTo.append("0");
            }
            toAppendTo.append(this.day);
            toAppendTo.append(" ");
            this.hour = this.calendar.get(11);
            if (this.hour < 10) {
                toAppendTo.append("0");
            }
            toAppendTo.append(this.hour);
            toAppendTo.append(":");
            this.minute = this.calendar.get(12);
            if (this.minute < 10) {
                toAppendTo.append("0");
            }
            toAppendTo.append(this.minute);
            toAppendTo.append(":");
            this.second = this.calendar.get(13);
            if (this.second < 10) {
                toAppendTo.append("0");
            }
            toAppendTo.append(this.second);
            return toAppendTo;
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            int index = 0;
            try {
                this.year = Integer.parseInt(source.substring(0, 4));
                index = 5;
                this.month = Integer.parseInt(source.substring(5, 7)) - 1;
                index = 8;
                this.day = Integer.parseInt(source.substring(8, 10));
                index = 11;
                this.hour = Integer.parseInt(source.substring(11, 13));
                index = 14;
                this.minute = Integer.parseInt(source.substring(14, 16));
                index = 17;
                this.second = Integer.parseInt(source.substring(17, 19));
                pos.setIndex(source.length());
                this.calendar.clear();
                this.calendar.set(this.year, this.month, this.day, this.hour, this.minute, this.second);
                return this.calendar.getTime();
            }
            catch (Exception e) {
                pos.setErrorIndex(index);
                e.printStackTrace();
                return null;
            }
        }
    }
}

