/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import routines.TalendDate;
import routines.system.MysqlDateParser;

public abstract class DBDateParser {
    public static final String MYSQL = "mysql_id";
    private static Map<String, DBDateParser> managerMap = new HashMap<String, DBDateParser>();

    public static DBDateParser getDBDateParser(String dbmsId) {
        DBDateParser dBDateParser = managerMap.get(dbmsId);
        if (dBDateParser == null && MYSQL.equals(dbmsId)) {
            dBDateParser = new MysqlDateParser();
        }
        managerMap.put(dbmsId, dBDateParser);
        return dBDateParser;
    }

    public String getDateString(String dbmsId, String dbType, long date, String pattern) {
        String return_date = "";
        String defaultPattern = DBDateParser.getDBDateParser(dbmsId).getDefaultPattern(dbType);
        return_date = TalendDate.formatDate(defaultPattern, new Date(date));
        if (pattern == null || "".equals(pattern) || defaultPattern.equals(pattern)) {
            return return_date;
        }
        Date real_date = TalendDate.parseDate(defaultPattern, return_date);
        return TalendDate.formatDate(pattern, real_date);
    }

    public abstract String getDefaultPattern(String var1);
}

