/*
 * Decompiled with CFR 0.152.
 */
package routines;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import routines.StringHandling;
import routines.system.FastDateParser;
import routines.system.LocaleProvider;
import routines.system.TalendTimestampWithTZ;

public class TalendDate {
    public static int getPartOfDate(String partName, Date date) {
        if (partName == null || date == null) {
            return 0;
        }
        int ret = 0;
        String[] fieldsName = new String[]{"YEAR", "MONTH", "HOUR", "MINUTE", "SECOND", "DAY_OF_WEEK", "DAY_OF_MONTH", "DAY_OF_YEAR", "WEEK_OF_MONTH", "DAY_OF_WEEK_IN_MONTH", "WEEK_OF_YEAR", "TIMEZONE"};
        List<String> filedsList = Arrays.asList(fieldsName);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        switch (filedsList.indexOf(partName)) {
            case 0: {
                ret = c.get(1);
                break;
            }
            case 1: {
                ret = c.get(2);
                break;
            }
            case 2: {
                ret = c.get(10);
                break;
            }
            case 3: {
                ret = c.get(12);
                break;
            }
            case 4: {
                ret = c.get(13);
                break;
            }
            case 5: {
                ret = c.get(7);
                break;
            }
            case 6: {
                ret = c.get(5);
                break;
            }
            case 7: {
                ret = c.get(6);
                break;
            }
            case 8: {
                ret = c.get(4);
                break;
            }
            case 9: {
                ret = c.get(8);
                break;
            }
            case 10: {
                ret = c.get(3);
                break;
            }
            case 11: {
                ret = c.get(15) / 3600000;
                break;
            }
        }
        return ret;
    }

    public static synchronized String formatDate(String pattern, Date date) {
        DateFormat format = FastDateParser.getInstance(pattern);
        if (date instanceof TalendTimestampWithTZ) {
            format.setTimeZone(((TalendTimestampWithTZ)date).getTimeZone());
        } else {
            format.setTimeZone(TimeZone.getDefault());
        }
        return format.format(date);
    }

    public static synchronized String formatDateInUTC(String pattern, Date date) {
        DateFormat format = FastDateParser.getInstance(pattern);
        TimeZone originalTZ = format.getTimeZone();
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateStr = format.format(date);
        format.setTimeZone(originalTZ);
        return dateStr;
    }

    public static boolean isDate(String stringDate, String pattern) {
        if (stringDate == null) {
            return false;
        }
        if (pattern == null) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date testDate = null;
        try {
            testDate = sdf.parse(stringDate);
        }
        catch (ParseException e) {
            return false;
        }
        return sdf.format(testDate).equalsIgnoreCase(stringDate);
    }

    public static boolean isDate(String stringDate, String pattern, boolean ignoreTimeZone) {
        TimeZone tz = TimeZone.getDefault();
        if (ignoreTimeZone) {
            tz = TimeZone.getTimeZone("UTC");
        }
        if (stringDate == null) {
            return false;
        }
        if (pattern == null) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setTimeZone(tz);
        sdf.setLenient(false);
        Date testDate = null;
        try {
            testDate = sdf.parse(stringDate);
        }
        catch (ParseException e) {
            return false;
        }
        String formatDate = sdf.format(testDate);
        return formatDate.equalsIgnoreCase(stringDate) || formatDate.length() == stringDate.length();
    }

    public static boolean isDateStrict(String stringDate, String pattern) {
        if (stringDate == null) {
            return false;
        }
        DateTimeFormatter formatter = Optional.ofNullable(pattern).filter(entry -> !entry.isEmpty()).map(DateTimeFormatter::ofPattern).orElseThrow(() -> new IllegalArgumentException("Date format is not defined"));
        try {
            TemporalAccessor testDate = formatter.parse(stringDate);
            String formattedString = formatter.format(testDate);
            return stringDate.equalsIgnoreCase(formattedString);
        }
        catch (DateTimeException e) {
            return false;
        }
    }

    public static int compareDate(Date date1, Date date2, String pattern) {
        long time2;
        if (date1 == null && date2 == null) {
            return 0;
        }
        if (date1 != null && date2 == null) {
            return 1;
        }
        if (date1 == null && date2 != null) {
            return -1;
        }
        if (pattern != null) {
            String part2;
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            String part1 = sdf.format(date1);
            return part1.compareTo(part2 = sdf.format(date2)) >= 1 ? 1 : (part1.compareTo(part2) <= -1 ? -1 : 0);
        }
        long time1 = date1.getTime();
        return time1 < (time2 = date2.getTime()) ? -1 : (time1 == time2 ? 0 : 1);
    }

    public static int compareDate(Date date1, Date date2) {
        return TalendDate.compareDate(date1, date2, null);
    }

    public static Date addDate(Date date, int nb, String dateType) {
        if (date == null || dateType == null) {
            return null;
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date);
        if (dateType.equalsIgnoreCase("yyyy")) {
            c1.add(1, nb);
        } else if (dateType.equals("MM")) {
            c1.add(2, nb);
        } else if (dateType.equalsIgnoreCase("dd")) {
            c1.add(5, nb);
        } else if (dateType.equals("HH")) {
            c1.add(10, nb);
        } else if (dateType.equals("mm")) {
            c1.add(12, nb);
        } else if (dateType.equalsIgnoreCase("ss")) {
            c1.add(13, nb);
        } else if (dateType.equalsIgnoreCase("SSS")) {
            c1.add(14, nb);
        } else {
            throw new RuntimeException("Can't support the dateType: " + dateType);
        }
        return c1.getTime();
    }

    public static String addDate(String string, String pattern, int nb, String dateType) {
        if (string == null || dateType == null) {
            return null;
        }
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            date = sdf.parse(string);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.valueOf(pattern) + " can't support the date!");
        }
        String dateString = sdf.format(TalendDate.addDate(date, nb, dateType));
        return dateString;
    }

    public static long diffDate(Date date1, Date date2, String dateType) {
        return TalendDate.diffDate(date1, date2, dateType, false);
    }

    public static long diffDate(Date date1, Date date2, String dateType, boolean ignoreDST) {
        boolean d2In;
        boolean d1In;
        if (date1 == null) {
            date1 = new Date(0L);
        }
        if (date2 == null) {
            date2 = new Date(0L);
        }
        if (dateType == null) {
            dateType = "SSS";
        }
        int addDSTSavings = 0;
        if (ignoreDST && (d1In = TimeZone.getDefault().inDaylightTime(date1)) != (d2In = TimeZone.getDefault().inDaylightTime(date2))) {
            if (d1In) {
                addDSTSavings = TimeZone.getDefault().getDSTSavings();
            } else if (d2In) {
                addDSTSavings = -TimeZone.getDefault().getDSTSavings();
            }
        }
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        if (dateType.equalsIgnoreCase("yyyy")) {
            return c1.get(1) - c2.get(1);
        }
        if (dateType.equals("MM")) {
            return (c1.get(1) - c2.get(1)) * 12 + (c1.get(2) - c2.get(2));
        }
        long diffTime = date1.getTime() - date2.getTime() + (long)addDSTSavings;
        if (dateType.equalsIgnoreCase("HH")) {
            return diffTime / 3600000L;
        }
        if (dateType.equals("mm")) {
            return diffTime / 60000L;
        }
        if (dateType.equalsIgnoreCase("ss")) {
            return diffTime / 1000L;
        }
        if (dateType.equalsIgnoreCase("SSS")) {
            return diffTime;
        }
        if (dateType.equalsIgnoreCase("dd")) {
            return diffTime / 86400000L;
        }
        throw new RuntimeException("Can't support the dateType: " + dateType);
    }

    public static long diffDateIgnoreDST(Date date1, Date date2, String dateType) {
        return TalendDate.diffDate(date1, date2, dateType, true);
    }

    public static long diffDateIgnoreDST(Date date1, Date date2) {
        return TalendDate.diffDateIgnoreDST(date1, date2, "dd");
    }

    public static int diffDateFloor(Date date1, Date date2, String dateType) {
        if (date1 == null) {
            date1 = new Date(0L);
        }
        if (date2 == null) {
            date2 = new Date(0L);
        }
        if (dateType == null) {
            dateType = "yyyy";
        }
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        int result = 0;
        Calendar tmp = null;
        boolean flag = false;
        if (c1.compareTo(c2) < 0) {
            flag = true;
            tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
        result = (c1.get(1) - c2.get(1)) * 12 + (c1.get(2) - c2.get(2));
        c2.add(2, result);
        result += c2.after(c1) ? -1 : 0;
        if (flag) {
            result = -result;
        }
        if (dateType.equalsIgnoreCase("yyyy")) {
            return result / 12;
        }
        if (dateType.equals("MM")) {
            return result;
        }
        throw new RuntimeException("Can't support the dateType: " + dateType + " ,please try \"yyyy\" or \"MM\"");
    }

    public static long diffDate(Date date1, Date date2) {
        return TalendDate.diffDate(date1, date2, "dd");
    }

    public static Date getFirstDayOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        return c.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int lastDay = c.getActualMaximum(5);
        c.set(5, lastDay);
        return c.getTime();
    }

    public static Date setDate(Date date, int nb, String dateType) {
        if (date == null || dateType == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        if (dateType.equalsIgnoreCase("yyyy")) {
            c.set(1, nb);
        } else if (dateType.equals("MM")) {
            c.set(2, nb - 1);
        } else if (dateType.equalsIgnoreCase("dd")) {
            c.set(5, nb);
        } else if (dateType.equalsIgnoreCase("HH")) {
            c.set(11, nb);
        } else if (dateType.equals("mm")) {
            c.set(12, nb);
        } else {
            throw new RuntimeException("Can't support the dateType: " + dateType);
        }
        return c.getTime();
    }

    public static synchronized String formatDateLocale(String pattern, Date date, String languageOrCountyCode) {
        return FastDateParser.getInstance(pattern, LocaleProvider.getLocale(languageOrCountyCode)).format(date);
    }

    public static synchronized Date parseDate(String pattern, String stringDate) {
        return TalendDate.parseDate(pattern, stringDate, true);
    }

    public static synchronized Date parseDate(String pattern, String stringDate, boolean isLenient) {
        try {
            char[] ps;
            boolean hasZone = false;
            boolean inQuote = false;
            char[] cArray = ps = pattern.toCharArray();
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                char p = cArray[n2];
                if (p == '\'') {
                    inQuote = !inQuote;
                } else if (!(inQuote || p != 'Z' && p != 'z')) {
                    hasZone = true;
                    break;
                }
                ++n2;
            }
            DateFormat df = FastDateParser.getInstance(pattern);
            df.setLenient(isLenient);
            Date d = df.parse(stringDate);
            if (hasZone) {
                int offset = df.getCalendar().get(15);
                char sign = offset >= 0 ? (char)'+' : '-';
                int hour = Math.abs(offset) / 1000 / 60 / 60;
                int min = Math.abs(offset) / 1000 / 60 % 60;
                String minStr = min < 10 ? "0" + min : String.valueOf(min);
                TalendTimestampWithTZ tstz = new TalendTimestampWithTZ(new Timestamp(d.getTime()), TimeZone.getTimeZone("GMT" + sign + hour + ":" + minStr));
                return tstz;
            }
            return d;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized Date parseDateInUTC(String pattern, String stringDate) {
        return TalendDate.parseDateInUTC(pattern, stringDate, true);
    }

    public static synchronized Date parseDateInUTC(String pattern, String stringDate, boolean isLenient) {
        try {
            char[] ps;
            boolean hasZone = false;
            boolean inQuote = false;
            char[] cArray = ps = pattern.toCharArray();
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                char p = cArray[n2];
                if (p == '\'') {
                    inQuote = !inQuote;
                } else if (!(inQuote || p != 'Z' && p != 'z')) {
                    hasZone = true;
                    break;
                }
                ++n2;
            }
            DateFormat df = FastDateParser.getInstance(pattern);
            TimeZone originalTZ = df.getTimeZone();
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            df.setLenient(isLenient);
            Date d = df.parse(stringDate);
            df.setTimeZone(originalTZ);
            if (hasZone) {
                int offset = df.getCalendar().get(15);
                char sign = offset >= 0 ? (char)'+' : '-';
                int hour = Math.abs(offset) / 1000 / 60 / 60;
                int min = Math.abs(offset) / 1000 / 60 % 60;
                String minStr = min < 10 ? "0" + min : String.valueOf(min);
                TalendTimestampWithTZ tstz = new TalendTimestampWithTZ(new Timestamp(d.getTime()), TimeZone.getTimeZone("GMT" + sign + hour + ":" + minStr));
                return tstz;
            }
            return d;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized Date parseDateLocale(String pattern, String stringDate, String languageOrCountyCode) {
        try {
            return FastDateParser.getInstance(pattern, LocaleProvider.getLocale(languageOrCountyCode)).parse(stringDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDate(String pattern) {
        if (pattern == null) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        StringBuffer result = new StringBuffer();
        pattern = pattern.replace("CC", "yy");
        pattern = pattern.replace("YY", "yy");
        pattern = pattern.replace("MM", "MM");
        pattern = pattern.replace("DD", "dd");
        pattern = pattern.replace("hh", "HH");
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.format(Calendar.getInstance().getTime(), result, new FieldPosition(0));
        return result.toString();
    }

    public static Date getCurrentDate() {
        return new Date();
    }

    public static Date getRandomDate(String minDate, String maxDate) {
        if (minDate == null) {
            minDate = "1970-01-01";
        }
        if (maxDate == null) {
            maxDate = "2099-12-31";
        }
        if (!minDate.matches("\\d{4}-\\d{2}-\\d{2}") || !minDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new IllegalArgumentException("The parameter should be \"yyy-MM-dd\"");
        }
        int minYear = Integer.parseInt(minDate.substring(0, 4));
        int minMonth = Integer.parseInt(minDate.substring(5, 7));
        int minDay = Integer.parseInt(minDate.substring(8, 10));
        int maxYear = Integer.parseInt(maxDate.substring(0, 4));
        int maxMonth = Integer.parseInt(maxDate.substring(5, 7));
        int maxDay = Integer.parseInt(maxDate.substring(8, 10));
        Calendar minCal = Calendar.getInstance();
        minCal.set(1, minYear);
        minCal.set(2, minMonth - 1);
        minCal.set(5, minDay);
        Calendar maxCal = Calendar.getInstance();
        maxCal.set(1, maxYear);
        maxCal.set(2, maxMonth - 1);
        maxCal.set(5, maxDay);
        long random = minCal.getTimeInMillis() + (long)((double)(maxCal.getTimeInMillis() - minCal.getTimeInMillis() + 1L) * Math.random());
        return new Date(random);
    }

    public static void test_getRandomDate() {
        System.out.println("getRandomDate: " + TalendDate.formatDate("yyyy-MM-dd HH:mm:ss", TalendDate.getRandomDate(null, null)));
    }

    public static void test_compareDate() {
        System.out.println("compareDate: " + Boolean.toString(TalendDate.compareDate(new Date(), new Date(System.currentTimeMillis() - 10000L)) == 1));
    }

    public static void test_isDate() {
        System.out.println("isDate: " + Boolean.toString(!TalendDate.isDate("2008-11-35 12:15:25", "yyyy-MM-dd HH:mm")));
    }

    public static String formatDatetimeoffset(Date date) {
        String dateString = TalendDate.formatDate("yyyy-MM-dd HH:mm:ss.SSSZ", date);
        StringBuilder sb = new StringBuilder(30);
        sb.append(dateString);
        sb.insert(dateString.length() - 2, ':');
        return sb.toString();
    }

    public static void test_formatDate() {
        int LOOPS = 100000;
        String dateTimeRef_Test1 = "1979-03-23 mars 12:30";
        Thread test1 = new Thread(){

            @Override
            public void run() {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.set(1979, 2, 23, 12, 30, 40);
                Date dateCalendar = calendar.getTime();
                int i = 0;
                while (i < 100000) {
                    String date = TalendDate.formatDate("yyyy-MM-dd MMM HH:mm", dateCalendar);
                    if (!"1979-03-23 mars 12:30".equals(date)) {
                        throw new IllegalStateException("Test1: Date ref : '1979-03-23 mars 12:30' is different of '" + date + "'");
                    }
                    ++i;
                }
                System.out.println("test1 ok");
            }
        };
        String dateTimeRef_Test2 = "1980-03-23 mars 12:30";
        Thread test2 = new Thread(){

            @Override
            public void run() {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.set(1980, 2, 23, 12, 30, 40);
                Date dateCalendar = calendar.getTime();
                int i = 0;
                while (i < 100000) {
                    String date = TalendDate.formatDate("yyyy-MM-dd MMM HH:mm", dateCalendar);
                    if (!"1980-03-23 mars 12:30".equals(date)) {
                        throw new IllegalStateException("Test2: Date ref : '1980-03-23 mars 12:30' is different of '" + date + "'");
                    }
                    ++i;
                }
                System.out.println("test2 ok");
            }
        };
        String dateTimeRef_Test3 = "1979-03-23 mars 12:30";
        Thread test3 = new Thread(){

            @Override
            public void run() {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.set(1979, 2, 23, 12, 30, 40);
                Date dateCalendar = calendar.getTime();
                int i = 0;
                while (i < 100000) {
                    String date = TalendDate.formatDateLocale("yyyy-MM-dd MMM HH:mm", dateCalendar, "FR");
                    if (!"1979-03-23 mars 12:30".equals(date)) {
                        throw new IllegalStateException("Test3: Date ref : '1979-03-23 mars 12:30' is different of '" + date + "'");
                    }
                    ++i;
                }
                System.out.println("test3 ok");
            }
        };
        String dateTimeRef_Test4 = "1980-03-23 Mar 12:30";
        Thread test4 = new Thread(){

            @Override
            public void run() {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.set(1980, 2, 23, 12, 30, 40);
                Date dateCalendar = calendar.getTime();
                int i = 0;
                while (i < 100000) {
                    String date = TalendDate.formatDateLocale("yyyy-MM-dd MMM HH:mm", dateCalendar, "EN");
                    if (!"1980-03-23 Mar 12:30".equals(date)) {
                        throw new IllegalStateException("Test4: Date ref : '1980-03-23 Mar 12:30' is different of '" + date + "'");
                    }
                    ++i;
                }
                System.out.println("test4 ok");
            }
        };
        String dateTimeRef_Test5 = "1979-03-23";
        Thread test5 = new Thread(){

            @Override
            public void run() {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.set(1979, 2, 23, 12, 30, 40);
                Date dateCalendar = calendar.getTime();
                int i = 0;
                while (i < 100000) {
                    String date = TalendDate.formatDate("yyyy-MM-dd", dateCalendar);
                    if (!"1979-03-23".equals(date)) {
                        throw new IllegalStateException("Test5: Date ref : '1979-03-23' is different of '" + date + "'");
                    }
                    ++i;
                }
                System.out.println("test5 ok");
            }
        };
        test1.start();
        test2.start();
        test3.start();
        test4.start();
        test5.start();
    }

    public static Date TO_DATE(String string, String format) throws ParseException {
        String defaultFormat = "MM/dd/yyyy HH:mm:ss.SSS";
        if (StringHandling.isVacant(string)) {
            return null;
        }
        if (!StringHandling.isVacant(format)) {
            if (format.equals("J")) {
                return new Date(Long.parseLong(string));
            }
            SimpleDateFormat sdf = new SimpleDateFormat(TalendDate.dateFormatConvert(format));
            return sdf.parse(string);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(defaultFormat);
        return sdf.parse(string);
    }

    public static Date TO_DATE(String string) throws ParseException {
        return TalendDate.TO_DATE(string, null);
    }

    private static String dateFormatConvert(String format) {
        format = format.replaceAll("Y", "y");
        format = format.replaceAll("RR", "yy");
        format = format.replaceAll("MONTH", "MMMM");
        format = format.replaceAll("MON", "MMM");
        format = format.replaceAll("WW", "w");
        format = format.replaceAll("W", "F");
        format = format.replaceAll("(AM|A.M.|PM|P.M.)", "a");
        format = format.replaceAll("DY", "E");
        format = format.replaceAll("DDD", "D");
        format = format.replaceAll("DD", "d");
        format = format.replaceAll("HH24", "zx@i#o%l!");
        format = format.replaceAll("(HH|HH12)", "hh");
        format = format.replaceAll("zx@i#o%l!", "HH");
        format = format.replaceAll("MS", "sss");
        format = format.replaceAll("MI", "mm");
        format = format.replaceAll("SS", "ss");
        return format;
    }

    public static Date ADD_TO_DATE(Date date, String format, int amount) throws ParseException {
        if (date == null || StringHandling.isVacant(format)) {
            return null;
        }
        if (format != null) {
            format = TalendDate.dateFormatADD_TO_DATE(format);
        }
        Long time = date.getTime();
        Calendar calender = Calendar.getInstance();
        calender.setTime(date);
        switch (format) {
            case "Y": {
                calender.add(1, amount);
                time = calender.getTimeInMillis();
                break;
            }
            case "MONTH": {
                calender.add(2, amount);
                time = calender.getTimeInMillis();
                break;
            }
            case "DAY": {
                time = time + (long)amount * 86400000L;
                break;
            }
            case "HH": {
                time = time + (long)amount * 3600000L;
                break;
            }
            case "MI": {
                time = time + (long)amount * 60000L;
                break;
            }
            case "SS": {
                time = time + (long)amount * 1000L;
                break;
            }
            case "MS": {
                time = time + (long)amount;
                break;
            }
            case "US": {
                time = time + (long)(amount / 1000);
                break;
            }
            case "NS": {
                time = time + (long)(amount / 1000000);
                break;
            }
            default: {
                throw new ParseException("Please enter a vaild format.", 0);
            }
        }
        return new Date(time);
    }

    private static String dateFormatADD_TO_DATE(String format) {
        if (format.equals("Y") || format.equals("YY") || format.equals("YYY") || format.equals("YYYY")) {
            return "Y";
        }
        if (format.equals("MONTH") || format.equals("MM") || format.equals("MON")) {
            return "MONTH";
        }
        if (format.equals("D") || format.equals("DD") || format.equals("DDD") || format.equals("DAY") || format.equals("DY")) {
            return "DAY";
        }
        if (format.equals("HH") || format.equals("HH12") || format.equals("HH24")) {
            return "HH";
        }
        return format;
    }

    public static String TO_CHAR(Date date, String format) {
        if (date == null) {
            return null;
        }
        if (format == null || format.equals("")) {
            format = "MM/DD/YYYY HH24:MI:SS";
        }
        if ("J".equals(format)) {
            return Long.toString(date.getTime());
        }
        SimpleDateFormat sdf = new SimpleDateFormat(TalendDate.dateFormatConvert(format));
        return sdf.format(date);
    }
}

