/*
 * Decompiled with CFR 0.152.
 */
package routines;

import java.math.BigDecimal;

public class StringHandling {
    public static boolean ALPHA(String input) {
        if (input != null) {
            char[] val = input.toCharArray();
            int i = 0;
            while (i < val.length - 1) {
                if (val[i] > val[i + 1]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean IS_ALPHA(String input) {
        if (input != null) {
            char[] val = input.toCharArray();
            int i = 0;
            while (i < val.length) {
                if (!Character.isLetter(val[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String CHANGE(String oldStr, String regex, String replacement) {
        if (oldStr == null || regex == null || replacement == null) {
            return oldStr;
        }
        return oldStr.replaceAll(regex, replacement);
    }

    public static int COUNT(String string, String subString) {
        if (string == null || subString == null) {
            return 0;
        }
        int counter = 0;
        int i = -1;
        while ((i = string.indexOf(subString, i + 1)) != -1) {
            ++counter;
        }
        return counter;
    }

    public static String DOWNCASE(String string) {
        return string == null ? null : string.toLowerCase();
    }

    public static String UPCASE(String string) {
        return string == null ? null : string.toUpperCase();
    }

    public static String DQUOTE(String string) {
        return string == null ? null : "\"" + string + "\"";
    }

    public static String EREPLACE(String oldStr, String regex, String replacement) {
        return StringHandling.CHANGE(oldStr, regex, replacement);
    }

    public static int INDEX(String string, String element) {
        if (string == null || element == null) {
            return -1;
        }
        return string.indexOf(element);
    }

    public static String LEFT(String string, int index) {
        return string == null ? null : string.substring(0, Math.min(string.length(), index));
    }

    public static String RIGHT(String string, int index) {
        return string == null ? null : string.substring(string.length() - Math.min(string.length(), index));
    }

    public static int LEN(String string) {
        return string == null ? -1 : string.length();
    }

    public static String SPACE(int i) {
        StringBuffer buffer = new StringBuffer();
        int j = 0;
        while (j < i) {
            buffer.append(" ");
            ++j;
        }
        return buffer.toString();
    }

    public static String SQUOTE(String string) {
        return string == null ? null : "'" + string + "'";
    }

    public static String STR(char letter, int i) {
        StringBuffer buffer = new StringBuffer();
        int j = 0;
        while (j < i) {
            buffer.append(letter);
            ++j;
        }
        return buffer.toString();
    }

    public static String TRIM(String string) {
        return string == null ? null : string.trim();
    }

    public static String BTRIM(String string) {
        if (string == null) {
            return null;
        }
        char[] val = string.toCharArray();
        int len = val.length;
        while (len > 0 && val[len - 1] <= ' ') {
            --len;
        }
        return string.substring(0, len);
    }

    public static String FTRIM(String string) {
        if (string == null) {
            return null;
        }
        char[] val = string.toCharArray();
        int st = 0;
        int len = val.length;
        while (st < len && val[st] <= ' ') {
            ++st;
        }
        return string.substring(st);
    }

    public static String SUBSTR(String string, int start, Integer length) {
        String result;
        if (StringHandling.isVacant(string)) {
            return null;
        }
        if (start > string.length()) {
            return "";
        }
        if (start > 0) {
            --start;
        } else if (start < 0 && (start = string.length() + start) < 0) {
            start = 0;
        }
        if (length == null || length + start > string.length()) {
            result = string.substring(start);
        } else {
            if (length <= 0) {
                return "";
            }
            result = string.substring(start, length + start);
        }
        return result;
    }

    public static String LTRIM(String value, String trim_set) {
        if (StringHandling.isVacant(value)) {
            return null;
        }
        int len = value.length();
        int st = 0;
        char[] val = value.toCharArray();
        if (StringHandling.isVacant(trim_set)) {
            while (st < len && val[st] <= ' ') {
                ++st;
            }
            return st > 0 ? value.substring(st) : value;
        }
        char[] chars = trim_set.toCharArray();
        do {
            char[] cArray = chars;
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                while (value.indexOf(c, st) == st) {
                    ++st;
                }
                ++n2;
            }
            if (st != len) continue;
            return "";
        } while (trim_set.contains(String.valueOf(value.charAt(st))));
        return st > 0 ? value.substring(st) : value;
    }

    public static String LTRIM(String value) {
        return StringHandling.LTRIM(value, null);
    }

    /*
     * Unable to fully structure code
     */
    public static String RTRIM(String value, String trim_set) {
        if (StringHandling.isVacant(value)) {
            return null;
        }
        len = value.length();
        val = value.toCharArray();
        if (StringHandling.isVacant(trim_set)) {
            while (len > 0 && val[len - 1] <= ' ') {
                --len;
            }
            return len < value.length() ? value.substring(0, len) : value;
        }
        chars = trim_set.toCharArray();
        do {
            i = chars.length - 1;
            ** GOTO lbl21
            {
                if (len == 0) {
                    return "";
                }
                value = value.substring(0, len - 1);
                --len;
                do {
                    if (value.lastIndexOf(chars[i]) == len - 1) continue block2;
                    --i;
lbl21:
                    // 2 sources

                } while (i >= 0);
            }
        } while (trim_set.contains(value.substring(value.length() - 1)));
        return value;
    }

    public static String RTRIM(String value) {
        return StringHandling.RTRIM(value, null);
    }

    public static String LPAD(String first_string, int length, String second_string) {
        if (StringHandling.isVacant(first_string) || length < 1) {
            return null;
        }
        int OriginLength = first_string.length();
        if (OriginLength >= length) {
            return first_string;
        }
        if (StringHandling.isVacant(second_string)) {
            StringBuilder result = new StringBuilder();
            int i = OriginLength;
            while (i < length) {
                result.append(" ");
                ++i;
            }
            result.append(first_string);
            return result.toString();
        }
        StringBuilder result = new StringBuilder(second_string);
        int len = result.length();
        while (len < length - OriginLength) {
            len = result.length();
            result.append(second_string);
        }
        first_string = String.valueOf(result.substring(0, length - OriginLength)) + first_string;
        return first_string;
    }

    public static String LPAD(String first_string, int length) {
        return StringHandling.LPAD(first_string, length, null);
    }

    public static String RPAD(String first_string, int length, String second_string) {
        if (StringHandling.isVacant(first_string) || length < 1) {
            return null;
        }
        int OriginLength = first_string.length();
        if (OriginLength >= length) {
            return first_string;
        }
        StringBuilder result = new StringBuilder(first_string);
        int i = OriginLength;
        while (i < length) {
            if (StringHandling.isVacant(second_string)) {
                result.append(" ");
            } else {
                result.append(second_string);
                if (result.length() > length) {
                    return result.toString().substring(0, length);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String RPAD(String first_string, int length) {
        return StringHandling.RPAD(first_string, length, null);
    }

    public static Integer INSTR(String string, String search_value, Integer start, Integer occurrence) {
        int defaultStart = 1;
        int defaultOccurrence = 1;
        Integer result = 0;
        if (StringHandling.isVacant(string) || StringHandling.isVacant(search_value) || Math.abs(defaultStart) >= string.length()) {
            return null;
        }
        if (start != null && start != 0) {
            defaultStart = start;
        }
        if (occurrence != null) {
            if (occurrence <= 0) {
                throw new IllegalArgumentException("The occurrence argument can only accept a positive integer greater than 0.");
            }
            defaultOccurrence = occurrence;
        }
        if (defaultStart < 0) {
            string = string.substring(0, string.length() + defaultStart + 1);
            int temp = string.lastIndexOf(search_value);
            while (temp != -1 && defaultOccurrence != 1) {
                string = string.substring(0, temp);
                --defaultOccurrence;
                temp = string.lastIndexOf(search_value);
            }
            return ++temp;
        }
        string = string.substring(defaultStart - 1);
        if (defaultOccurrence != 1) {
            int temp;
            do {
                temp = string.indexOf(search_value) + 1;
                string = string.substring(temp);
                result = result + temp;
            } while (--defaultOccurrence != 0);
            if (temp == 0) {
                result = 0;
            }
        } else {
            result = string.indexOf(search_value) + 1;
        }
        return result;
    }

    public static Integer INSTR(byte[] string, byte[] search_value, Integer start, Integer occurrence) {
        int defaultStart = 1;
        int defaultOccurrence = 1;
        if (string == null || search_value == null || Math.abs(defaultStart) >= string.length) {
            return null;
        }
        if (start != null && start != 0) {
            defaultStart = start;
        }
        int max = string.length - 1;
        if (occurrence != null) {
            if (occurrence <= 0) {
                throw new IllegalArgumentException("The occurrence argument can only accept a positive integer greater than 0.");
            }
            defaultOccurrence = occurrence;
        }
        if (defaultStart > 0) {
            return StringHandling.byteINSTR(string, search_value, defaultStart, defaultOccurrence);
        }
        int total = string.length;
        byte[] revers = new byte[total];
        byte[] revers_search = new byte[search_value.length];
        int i = 0;
        while (i < total) {
            revers[max - i] = string[i];
            ++i;
        }
        i = 0;
        while (i < search_value.length) {
            revers_search[search_value.length - 1 - i] = search_value[i];
            ++i;
        }
        int result = StringHandling.byteINSTR(revers, revers_search, defaultStart = -defaultStart, defaultOccurrence);
        if (result == 0) {
            return 0;
        }
        return total - result + 2 - search_value.length;
    }

    private static int byteINSTR(byte[] string, byte[] search_value, int defaultStart, int defaultOccurrence) {
        int max = string.length - 1;
        int i = defaultStart - 1;
        while (i <= max) {
            if (string[i] != search_value[0]) {
                while (++i <= max && string[i] != search_value[0]) {
                }
            }
            if (i > max) {
                return 0;
            }
            if (search_value.length > 1) {
                if (i <= max) {
                    int j = i;
                    int end = i + search_value.length - 1;
                    int k = 1;
                    while (j + 1 <= max && k < search_value.length && string[j + 1] == search_value[k]) {
                        ++j;
                        ++k;
                    }
                    if (j == end) {
                        if (defaultOccurrence == 1) {
                            return i - defaultStart + 2;
                        }
                        --defaultOccurrence;
                    }
                }
            } else {
                if (defaultOccurrence == 1) {
                    return i - defaultStart + 2;
                }
                --defaultOccurrence;
            }
            ++i;
        }
        return 0;
    }

    protected static boolean isVacant(String value) {
        return value == null || "".equals(value);
    }

    public static String TO_CHAR(Object numeric_value) {
        if (numeric_value == null) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(numeric_value.toString());
        if (bigDecimal.abs().compareTo(new BigDecimal("1e16")) < 0 && bigDecimal.abs().compareTo(new BigDecimal("1e-16")) > 0) {
            return bigDecimal.toPlainString();
        }
        return numeric_value.toString();
    }
}

