---
layout: default
title: Prompt Engineering Holy Grail
---

Welcome to the Prompt Engineering Hub! This repository is a curated resource for anyone interested in learning and advancing prompt engineering techniques.

## Table of Contents

1. [Introduction](#1-introduction)
   - [Overview of Prompt Engineering](#overview-of-prompt-engineering)
   - [Purpose of This Repository](#purpose-of-this-repository)
2. [Learning Resources](#2-learning-resources)
   - [Free Tutorials, Videos & Guides](#free-tutorials-videos--guides)
   - [Additional Guides and Repositories](#additional-guides-and-repositories)
   - [Books and Reference Materials](#books-and-reference-materials)
   - [Essential Books on Prompt Engineering and ChatGPT](#essential-books-on-prompt-engineering-and-chatgpt)
   - [YouTube Videos on Prompt Engineering](#youtube-videos-on-prompt-engineering)
   - [YouTube Channels Dedicated to AI & Prompt Engineering](#youtube-channels-dedicated-to-ai--prompt-engineering)
   - [Newsletters and Blogs](#newsletters-and-blogs)
   - [Comprehensive List of Online Courses on Prompt Engineering](#comprehensive-list-of-online-courses-on-prompt-engineering)
3. [Prompt Engineering Tools](#3-prompt-engineering-tools)
   - [Prompt Marketplaces](#prompt-marketplaces)
   - [Prompt Generation Tools](#prompt-generation-tools)
   - [Prompt Management Platforms](#prompt-management-platforms)
   - [Prompt Testing and Experimentation](#prompt-testing-and-experimentation)
   - [Prompt Crafting Libraries](#prompt-crafting-libraries)
   - [Other](#other)
4. [Prompt Libraries, Collections & Datasets](#4-prompt-libraries-collections--datasets)
   - [Prompt Libraries](#prompt-libraries)
   - [Prompt Collections](#prompt-collections)
   - [GPT Stores and Libraries](#gpt-stores-and-libraries)
   - [Datasets](#datasets)
5. [Prompt Engineering Communities](#5-prompt-engineering-communities)
   - [Social Media Groups for Prompt Engineering](#social-media-groups-for-prompt-engineering)
     - [Reddit Communities](#reddit-communities)
     - [Facebook Communities](#facebook-communities)
   - [Discord Communities for Prompt Engineering](#discord-communities-for-prompt-engineering)
   - [Other Prompt Engineering Communities and Forums](#other-prompt-engineering-communities-and-forums)
6. [Freelance & Job Opportunities](#6-freelance--job-opportunities)
   - [Job Websites for Prompt Engineers](#job-websites-for-prompt-engineers)
   - [Freelance Platforms](#freelance-platforms)
7. [Contributing & Code of Conduct](#7-contributing--code-of-conduct)
8. [Support My Work](#8-support-my-work)
9. [Join Our Community on Discord](#9-join-our-community-on-discord)
10. [License](#10-license)
11. [Disclosure](#11-disclosure)
12. [Contact Me](#12-contact-me)

## 1. Introduction

Welcome to the **Prompt Engineering Hub**! This repository is a curated resource for all things related to prompt engineering, from beginner fundamentals to advanced techniques.

### Overview of Prompt Engineering
Prompt engineering involves crafting effective prompts to guide AI models like GPT-4, helping them generate accurate, context-aware outputs. As AI applications grow across industries, mastering prompt engineering unlocks powerful use cases in areas like text generation, sentiment analysis, translation, and more.

### Purpose of This Repository
This repo gathers essential resources, tools, templates, and best practices to support anyone learning or working in prompt engineering. Whether you’re just starting or have experience, you’ll find structured learning paths, advanced techniques, and real-world examples.

Each section is crafted to support your growth in prompt engineering, making it easy to find the resources you need. Explore, learn, and feel free to contribute!

## 2. Learning Resources

### Free Tutorials, Videos & Guides

1. **Learn Prompting** - Overview of Prompt Engineering and various techniques.
   - [A Complete Guide to Meta Prompting](https://www.prompthub.us/blog/a-complete-guide-to-meta-prompting#what-is-meta-prompting?) - Meta prompting is a prompt engineering method that uses large language models (LLMs) to create and refine prompts.
2. **Best Practices for Prompt Engineering with the OpenAI API** - OpenAI guide on best practices for prompt engineering.
   - [Brex's Prompt Engineering Guide](https://github.com/brexhq/prompt-engineering) - Tips and tricks for working with Large Language Models like OpenAI's GPT-4.
   - [Prompt Engineering Tutorial – Master ChatGPT and LLM Responses](https://www.youtube.com/watch?v=_ZvnD73m40o)
3. **Awesome GPT Super Prompting** - Collection of advanced techniques, including jailbreaks, prompt injection, and prompt security.
   - [Awesome GPT Super Prompting](https://github.com/CyberAlbSecOP/Awesome_GPT_Super_Prompting)
4. **Microsoft Prompt Engineering Fundamentals** - Comprehensive fundamentals and advanced prompt engineering from Microsoft.
   - [Microsoft - Prompt Engineering Fundamentals](https://github.com/microsoft/generative-ai-for-beginners/tree/main/04-prompt-engineering-fundamentals)
   - [Microsoft - Advanced Prompts](https://github.com/microsoft/generative-ai-for-beginners/tree/main/05-advanced-prompts)
5. **Learning Prompt** - Free prompt engineering course covering ChatGPT and Midjourney tutorials.
   - [Learning Prompt on GitHub](https://github.com/thinkingjimmy/Learning-Prompt)
6. **YouTube Video Tutorials**
   - [Master the Perfect ChatGPT Prompt Formula (8 minutes)](https://www.youtube.com/watch?v=jC4v5AS4RIM)
   - [AI Prompt Engineering: A Deep Dive (Anthropic)](https://www.youtube.com/watch?v=T9aRN5JkmL8)
   - [ChatGPT Prompt Engineering Course (16 free YouTube episodes)](https://www.youtube.com/watch?v=mBYu5NoXBcs&list=PLaWSKUwEzmonq85t2rHwZfuEXotqEnTyR)
   - [Learn Prompt Engineering: Full Beginner Crash Course (5 HOURS)](https://www.youtube.com/watch?v=LWiMwhDZ9as)
   - [ChatGPT Prompt Engineering (55 free YouTube episodes)](https://www.youtube.com/watch?v=ylEu4fz4eU8&list=PLtPgUfajvh_Z_utkISrRk9tIxvnaR17_X)
   - [Learn Prompt Engineering for ChatGPT](https://www.youtube.com/watch?v=2sEujkZ79E4)

### Additional Guides and Repositories

7. **Prompt-Engineering-Guide** - Comprehensive guide covering the latest papers, resources, and prompt engineering techniques.
   - [Prompt-Engineering-Guide by dair-ai](https://github.com/dair-ai/Prompt-Engineering-Guide?tab=readme-ov-file)
8. **Prompt Engineering Techniques** - Repository focused on advanced prompt engineering methods.
   - [Prompt Engineering Techniques by Nir Diamant](https://github.com/NirDiamant/Prompt_Engineering?tab=readme-ov-file)

### Books and Reference Materials

9. [**DALLE Prompt Book**](https://dallery.gallery/the-dalle-2-prompt-book/) - Guide on crafting prompts specifically for image generation models like DALLE.
10. [**OpenAI Cookbook**](https://github.com/openai/openai-cookbook) - Collection of OpenAI's best practices and examples for using language models effectively.
11. [**Prompt Engineering by Microsoft**](https://microsoft.github.io/prompt-engineering/) - Resources and guides by Microsoft on prompt engineering fundamentals.
12. [**Topic Page Research papers**](https://topics-beta.apps.semanticscholar.org/topic/20102634420) - Research papers that discuss prompt engineering techniques.

## Comprehensive List of Online Courses on Prompt Engineering

| **Course Name**                                                                                                     | 🏫 **Platform**      | ⭐ **Ratings/Reviews**            | ⏰ **Duration**                  | 💰 **Cost**   | 🎓 **Certification** |
|------------------------------------------------------------------------------------------------------------------------|-----------------------|-----------------------------------|----------------------------------|---------------|-----------------------|
| [Understanding Prompt Engineering](https://www.datacamp.com/courses/understanding-prompt-engineering)                  | DataCamp             | ⭐ 4.4 (55 reviews)               | n/a                              | n/a           | ✔️ Yes               |
| [Introduction to ChatGPT](https://www.datacamp.com/courses/introduction-to-chatgpt)                                    | DataCamp             | ⭐ 4.3 (295 reviews)              | n/a                              | n/a           | ✔️ Yes               |
| [Large Language Models (LLMs) & Text Generation](https://www.udacity.com/course/large-language-models-and-text-generation--cd13318#plans) | Udacity | n/a                           | n/a                              | n/a           | ✔️ Yes               |
| [Learn How to Use ChatGPT](https://www.codecademy.com/learn/intro-to-chatgpt)                                          | Codecademy           | ⭐ 4.4 (3536 reviews)             | 1 hour (Beginner)                | n/a           | ✔️ Yes               |
| [Prompt Engineering for Marketing](https://www.codecademy.com/learn/prompt-engineering-for-marketing)                  | Codecademy           | ⭐ 4.4 (227 reviews)              | 1 hour (Beginner)                | n/a           | ✔️ Yes               |
| [Prompt Engineering and Advanced ChatGPT](https://edx.sjv.io/QjOkLx) | edX | ⭐ 4.2 (148 ratings) | n/a | £31 | ✔️ Yes |
| [IBM: Introduction to Prompt Engineering](https://edx.sjv.io/RGyerR) | IBM on edX | ⭐ 4.4 (217 ratings) | n/a | £38 | ✔️ Yes |
| [Generative AI for Everyone](https://edx.sjv.io/7amY6d) | IBM on edX | n/a                       | 4 months (1-3 hrs/wk)             | £171         | ✔️ Yes               |
| [Generative AI Fundamentals](https://edx.sjv.io/qznPKN) | IBM on edX | n/a                       | 5 months (2-4 hrs/wk)             | £1,156       | ✔️ Yes               |
| [IBM Applied AI Developer](https://edx.sjv.io/jeWq76) | IBM on edX | n/a                       | 6 months (2-4 hrs/wk)             | £329         | ✔️ Yes               |
| [Large Language Model Operations (LLMOps)](https://edx.sjv.io/aO1Eoo) | edX | n/a | 7 months (3-6 hrs/wk)           | £1,910       | ✔️ Yes               |
| [Prompt Engineering Specialization](https://www.coursera.org/specializations/prompt-engineering)                              | Coursera      | ⭐ 4.8 (1862 reviews)       | 1 month (10 hrs/wk)               | n/a         | ✔️ Yes               |
| [Prompt Engineering for Law Specialization](https://www.coursera.org/specializations/prompt-engineering-for-law)               | Coursera      | ⭐ 4.8 (181 reviews)        | 1 month (10 hrs/wk)               | n/a         | ✔️ Yes               |
| [Prompt Engineering for Educators Specialization](https://www.coursera.org/specializations/prompt-engineering-for-educators)   | Coursera      | ⭐ 4.8 (97 reviews)         | 1 month (10 hrs/wk)               | n/a         | ✔️ Yes               |
| [Prompt Engineering for ChatGPT](https://www.coursera.org/learn/prompt-engineering)                                            | Coursera      | ⭐ 4.8 (4042 reviews)       | n/a                               | n/a         | ✔️ Yes               |
| [Generative AI: Prompt Engineering Basics](https://www.coursera.org/learn/generative-ai-prompt-engineering-for-everyone)       | Coursera      | ⭐ 4.8 (2095 reviews)       | n/a                               | n/a         | ✔️ Yes               |
| [ChatGPT Prompt Engineering for Developers](https://www.coursera.org/projects/chatgpt-prompt-engineering-for-developers-project) | Coursera | ⭐ 4.7 (1086 reviews)     | n/a                               | n/a         | ✔️ Yes               |
| [The Complete Prompt Engineering for AI Bootcamp (2024)](https://www.udemy.com/course/prompt-engineering-for-ai/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.5 (49378 reviews)   | 20.5 hours                        | £54.99      | ✔️ Yes               |
| [ChatGPT Complete Guide: Learn Generative AI, ChatGPT & More](https://www.udemy.com/course/complete-ai-guide/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.5 (39995 reviews) | 26.5 hours                        | £54.99      | ✔️ Yes               |
| [Complete Prompt Engineering Practical Course](https://www.udemy.com/course/complete-prompt-engineering-practical-course-cpepc/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.6 (977 reviews)   | 8 hours                           | £39.99      | ✔️ Yes               |
| [ChatGPT Masterclass: The Guide to AI & Prompt Engineering](https://www.udemy.com/course/chatgpt-ai-masterclass/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.7 (3759 reviews)   | 16 hours                          | £59.99      | ✔️ Yes               |
| [All of AI: ChatGPT, Midjourney, Stable Diffusion & App Dev](https://www.udemy.com/course/all-of-ai-chatgpt-midjourney-stable-diffusion-app-dev/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.7 (1124 reviews) | 36.5 hours                        | £59.99      | ✔️ Yes               |
| [Complete ChatGPT Prompt Engineering Course](https://www.udemy.com/course/complete-chatgpt-prompt-engineering-course/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.6 (373 reviews)    | 10.5 hours                        | £19.99      | ✔️ Yes               |
| [ChatGPT-4 Prompt Engineering: ChatGPT, Generative AI & LLM](https://www.udemy.com/course/chatgpt-pro-expert-prompt-engineering-strategies-udemy-course-bootcamp/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.4 (556 reviews) | 4 hours                           | £44.99      | ✔️ Yes               |
| [Open-source LLMs: Uncensored & secure AI locally with RAG](https://www.udemy.com/course/open-source-llms-uncensored-secure-ai-locally-with-rag/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.8 (475 reviews)    | 10 hours                          | £54.99      | ✔️ Yes               |
| [ChatGPT Complete Course - Prompt Engineering for ChatGPT](https://www.udemy.com/course/chat-gpt/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.4 (10082 reviews)  | 5.5 hours                         | £29.99      | ✔️ Yes               |
| [ChatGPT and GPT-4 LLM Guide- Prompt Engineering for Everyone](https://www.udemy.com/course/prompt-engineering-for-everybody/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.4 (654 reviews)   | 3 hours                           | £49.99      | ✔️ Yes               |
| [Prompt Engineering for Data Analysis Python, Pandas, ChatGPT](https://www.udemy.com/course/chatgptandpython/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.6 (680 reviews)   | 10.5 hours                        | £49.99      | ✔️ Yes               |
| [Prompt Engineering with ChatGPT 4 & Midjourney 2000+ prompts](https://www.udemy.com/course/gptcourse/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.4 (1350 reviews)  | 22.5 hours                        | £54.99      | ✔️ Yes               |
| [Ultimate ChatGPT Course for Beginners 2024](https://www.udemy.com/course/ultimate-chatgpt-course-for-beginners/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.7 (1308 reviews)  | n/a                               | £19.99      | ✔️ Yes               |
| [Digital Marketing Guide - 26 Courses in 1](https://www.udemy.com/course/digital-marketing-guide/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.6 (38119 reviews) | 72 hours                          | £199.99     | ✔️ Yes               |
| [Master Generative AI: Automate Content Effortlessly with AI](https://www.udemy.com/course/ai-content-generation/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.4 (5081 reviews)  | 11 hours                          | £39.99      | ✔️ Yes               |
| [How to ChatGPT: Master the Art of Prompt Engineering](https://www.udemy.com/course/chatgpt-a-master-guide-for-professionals/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.4 (19634 reviews) | 2.5 hours                         | £29.99      | ✔️ Yes               |
| [LangChain- Develop LLM powered applications with LangChain](https://www.udemy.com/course/langchain/?couponCode=LEARNNOWPLANS) | Udemy | ⭐ 4.6 (19450 reviews) | 9.5 hours                         | £54.99      | ✔️ Yes               |

## Essential Books on Prompt Engineering and ChatGPT

| 📘 **Book Title**                                                                                                                                | 🌍 **Link**                                                                                                                                          | ⭐ **Rating/Reviews**          | 💵 **Price**    | 📱 **Format** |
|--------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------|-----------------|---------------|
| **[Prompt Engineering and ChatGPT: How to Easily 10X Your Productivity, Creativity, and Make More Money Without Working Harder](https://www.amazon.co.uk/Prompt-Engineering-ChatGPT-Productivity-Creativity-ebook/dp/B0CP3CKHMN/ref=sr_1_16?crid=38L6HXGTLABQM&tag=zacfrulloni01-21)** | [Amazon UK](https://www.amazon.co.uk/Prompt-Engineering-ChatGPT-Productivity-Creativity-ebook/dp/B0CP3CKHMN&tag=zacfrulloni01-21) | ⭐ 3.9 (84 reviews)            | £7.61           | Kindle        |
| **[The Only ChatGPT Prompts Book You’ll Ever Need](https://www.amazon.co.uk/Only-ChatGPT-Prompts-Book-Youll/dp/B0CWB7KYW9/ref=sr_1_17?crid=38L6HXGTLABQM&tag=zacfrulloni01-21)** | [Amazon UK](https://www.amazon.co.uk/Only-ChatGPT-Prompts-Book-Youll/dp/B0CWB7KYW9&tag=zacfrulloni01-21)                            | ⭐ 4.1 (78 ratings)             | £7.97           | Kindle        |
| **[ChatGPT for Beginners Made Easy: Master Prompts, Boost Productivity, and Cash In](https://www.amazon.co.uk/ChatGPT-Beginners-Made-Easy-Conversational/dp/B0CQ7SSRFP/ref=sr_1_1_sspa?crid=38L6HXGTLABQM&tag=zacfrulloni01-21)** | [Amazon UK](https://www.amazon.co.uk/ChatGPT-Beginners-Made-Easy-Conversational/dp/B0CQ7SSRFP&tag=zacfrulloni01-21)                 | ⭐ 4.0 (62 reviews)             | £5.99           | Kindle        |
| **[Prompt Engineering for Generative AI: Future-Proof Inputs for Reliable AI Outputs](https://www.amazon.co.uk/Prompt-Engineering-Generative-AI-Future-Proof/dp/109815343X/ref=sr_1_3?crid=38L6HXGTLABQM&tag=zacfrulloni01-21)** | [Amazon UK](https://www.amazon.co.uk/Prompt-Engineering-Generative-AI-Future-Proof/dp/109815343X&tag=zacfrulloni01-21)              | ⭐ 4.5 (30 reviews)             | £46.29          | Kindle        |
| **[The Art of Prompt Engineering with chatGPT: A Hands-On Guide](https://www.amazon.co.uk/Art-Prompt-Engineering-chatGPT-Hands/dp/1739296710/ref=sr_1_6?crid=38L6HXGTLABQM&tag=zacfrulloni01-21)** | [Amazon UK](https://www.amazon.co.uk/Art-Prompt-Engineering-chatGPT-Hands/dp/1739296710&tag=zacfrulloni01-21)                       | ⭐ 4.1 (232 ratings)            | £9.99           | Kindle        |
| **[The Art of Prompt Engineering with ChatGPT: Accessible Edition](https://www.amazon.co.uk/Art-Prompt-Engineering-ChatGPT-Accessible-ebook/dp/B0BZ4T68Q4/ref=sr_1_11?crid=38L6HXGTLABQM&tag=zacfrulloni01-21)** | [Amazon UK](https://www.amazon.co.uk/Art-Prompt-Engineering-ChatGPT-Accessible-ebook/dp/B0BZ4T68Q4&tag=zacfrulloni01-21)            | ⭐ 4.4 (106 reviews)            | £9.99           | Kindle        |
| **[The Ultimate Guide to ChatGPT: A Beginner's Handbook on Prompt Engineering](https://www.amazon.co.uk/Ultimate-Guide-ChatGPT-understanding-intelligence/dp/B0C2RRQDMV/ref=sr_1_13_sspa?crid=38L6HXGTLABQM&tag=zacfrulloni01-21)** | [Amazon UK](https://www.amazon.co.uk/Ultimate-Guide-ChatGPT-understanding-intelligence/dp/B0C2RRQDMV&tag=zacfrulloni01-21)          | ⭐ 4.2 (112 reviews)            | £7.99           | Kindle        |

## YouTube Videos on Prompt Engineering

| **Video Title** | **Link** |
|-----------------|----------|
| **EfficientML.ai Lecture 20: Efficient Fine-tuning and Prompt Engineering (MIT 6.5940, Fall 2023)** | [Watch on YouTube](https://www.youtube.com/watch?v=vOPwwRCZ8q8) |
| **Prompt-Engineering for Open-Source LLMs** | [Watch on YouTube](https://www.youtube.com/watch?v=f32dc5M2Mn0) |
| **Advanced ChatGPT Prompt Engineering** | [Watch on YouTube](https://www.youtube.com/watch?v=bBiTR_1sEmI) |
| **ChatGPT: 5 Prompt Engineering Secrets For Beginners** | [Watch on YouTube](https://www.youtube.com/watch?v=2zg3V66-Fzs) |
| **ChatGPT Guide: 10x Your Results with Better Prompts** | [Watch on YouTube](https://www.youtube.com/watch?v=os-JX1ZQwIA) |
| **Promptbreeder: Self-Referential Self-Improvement Via Prompt Evolution (Paper Explained)** | [Watch on Youtube](https://www.youtube.com/watch?v=tkX0EfNl4Fc) |

## YouTube Channels Dedicated to AI & Prompt Engineering

| **Channel Name** | **Link** |
|------------------|----------|
| **Prompt Engineering** | [@engineerprompt](https://www.youtube.com/@engineerprompt) |
| **They Call Me Hoz** | [@theycallmehoz](https://www.youtube.com/@theycallmehoz) |
| **Jeff Su** | [@JeffSu](https://www.youtube.com/@JeffSu) |
| **AI Master** | [@iamAImaster](https://www.youtube.com/@iamAImaster) |
| **AssemblyAI** | [@AssemblyAI](https://www.youtube.com/@AssemblyAI) |
| **Hasan Aboul Hasan** | [@hasanaboulhasan](https://www.youtube.com/@hasanaboulhasan) |
| **AI Foundations** | [@ai-foundations](https://www.youtube.com/@ai-foundations) |
| **Prompt Engineer** | [@PromptEngineer48](https://www.youtube.com/@PromptEngineer48) |
| **All About AI** | [@AllAboutAI](https://www.youtube.com/@AllAboutAI) |
| **The AI Advantage** | [@aiadvantage](https://www.youtube.com/@aiadvantage) |
| **Yannic Kilcher** | [@YannicKilcher](https://www.youtube.com/@YannicKilcher) |
| **PromptHub** | [@PromptHub](https://www.youtube.com/@PromptHub_AI) |

## Newsletters and Blogs

| **Channel Name**                     | **Description**                                            | **Link**                                |
|--------------------------------------|------------------------------------------------------------|-----------------------------------------|
| **The Prompt Engineering Substack**  | Educational articles on prompt engineering techniques, tools, and best practices. | [Visit on Substack](https://prompthub.substack.com/) |
| **PromptHub Blog**                   | In-depth articles, guides, and insights on prompt engineering. | [Visit Blog](https://www.prompthub.us/blog) |

## 3. Prompt Engineering Tools

## Prompt Marketplaces

| **Tool**              | **Link** |
|-----------------------|----------|
| **PromptBase**        | [PromptBase](https://promptbase.com/) |

## Prompt Generation Tools

| **Tool**                     | **Link** |
|------------------------------|----------|
| **YiVal**                    | [YiVal](https://github.com/YiVal/YiVal) |
| **GPT Prompt Engineer**      | [GPT Prompt Engineer](https://github.com/mshumer/gpt-prompt-engineer) |
| **Promptify**                | [Promptify](https://github.com/promptslab/Promptify) |
| **HuggingFace ChatGPT Prompt Generator** | [HuggingFace ChatGPT Prompt Generator](https://huggingface.co/spaces/merve/ChatGPT-prompt-generator) |
| **PromptHub Prompt Generator** | [PromptHub Prompt Generator](https://www.prompthub.us/features/prompt-generator) |


## Prompt Management Platforms

| **Tool**                   | **Description** | **Link** |
|----------------------------|-----------------|----------|
| **Puzzlet**               | Streamline your GenAI workflows with Git-Based prompt management, detailed traceability, and actionable metrics. | [Puzzlet](https://www.puzzlet.ai) |
| **Opik**                   | Open-source end-to-end LLM development platform | [Opik](https://github.com/comet-ml/opik) |
| **Agenta**                 | All-in-one LLM developer platform with prompt management | [Agenta](https://github.com/agenta-ai/agenta) |
| **PromptInject**           | Framework for modular prompts and adversarial prompt robustness testing | [PromptInject](https://github.com/agencyenterprise/PromptInject) |
| **Langbear**               | Open-source AI prompt management platform | [Langbear](https://langbear.runbear.io/introduction) |
| **Agentic Workers**        | One Click Advanced ChatGPT Workflows  | [AgenticWorkers](https://agenticworkers.com/) |
| **PromptHub**              | Test, collaborate, version, and deploy prompts, from a single place | [PromptHub](https://www.prompthub.us/) |


## Prompt Testing and Experimentation

| **Tool**                   | **Description** | **Link** |
|----------------------------|-----------------|----------|
| **BetterPrompt**           | Test suite for LLM prompts | [BetterPrompt](https://github.com/stjordanis/betterprompt) |
| **OpenPrompt**             | Open-Source framework for prompt-learning | [OpenPrompt](https://github.com/thunlp/OpenPrompt) |
| **Guidance**               | Programming paradigm for controlling LLM output | [Guidance](https://github.com/guidance-ai/guidance) |
| **Prompt Tools**           | Tools for prompt testing and experimentation | [Prompt Tools](https://github.com/hegelai/prompttools) |
| **ThoughtSource**          | Resource for chain-of-thought reasoning tools | [ThoughtSource](https://github.com/OpenBioLink/ThoughtSource) |
| **ChatGPT Queue**          | Tool for Bulk Prompting and Prompt Chaining | [ChatGPT Queue](https://chromewebstore.google.com/detail/chatgpt-queue-save-time-w/iabnajjakkfbclflgaghociafnjclbem?hl=en&authuser=0) |


## Prompt Crafting Libraries

| **Tool**                   | **Description** | **Link** |
|----------------------------|-----------------|----------|
| **Prompt Engine**          | Library for crafting prompts for large language models | [Prompt Engine](https://github.com/microsoft/prompt-engine) |
| **PromptDX**          | A declarative, extensible, and composable approach for developing LLM prompts using Markdown and JSX. | [PromptDX](https://github.com/puzzlet-ai/promptdx) |
| **ClickPrompt**            | Tool for viewing, sharing, and running prompts with one click | [ClickPrompt](https://github.com/prompt-engineering/click-prompt) |
| **Outlines**               | Structured text generation toolkit | [Outlines](https://github.com/dottxt-ai/outlines) |
| **PromptSource**           | Toolkit for creating and sharing natural language prompts | [PromptSource](https://github.com/bigscience-workshop/promptsource) |
| **PromptMetheus**          | One-shot prompt engineering toolkit | [PromptMetheus](https://promptmetheus.com/) |

## Other

| **Tool**                   | **Description** | **Link** |
|----------------------------|-----------------|----------|
| **PromptKnit**             | Playground for prompt designers | [PromptKnit](https://promptknit.com/) |
| **Promptotype**            | Tool for developing, testing, and monitoring structured LLM tasks | [Promptotype](https://www.promptotype.io/) |
| **OpenICL**                | Framework for in-context learning research and prototyping | [OpenICL](https://github.com/Shark-NLP/OpenICL) |
| **Optimus Prompt AI**      | Experiment tracking and human annotation platform for LLM applications | [Optimus Prompt AI](https://www.optimusprompt.ai/) |

## 4.	Prompt Libraries, Collections & Datasets

## Prompt Libraries
| **Library**                   | **Description** | **Link** |
|-------------------------------|-----------------|----------|
| **ai-boost/awesome-prompts**  | Curated list of ChatGPT prompts with top-rated GPTs. Includes prompt engineering, attack & protection techniques, and advanced papers. | [ai-boost/awesome-prompts](https://github.com/ai-boost/awesome-prompts) |
| **B3o/GPTS-Prompt-Collection**| Extensive prompt collection for GPT models. | [B3o/GPTS-Prompt-Collection](https://github.com/B3o/GPTS-Prompt-Collection) |
| **abilzerian/LLM-Prompt-Library** | Advanced code and text manipulation prompts for various LLMs, including GPT-4o, Claude, and Llama3. | [abilzerian/LLM-Prompt-Library](https://github.com/abilzerian/LLM-Prompt-Library) |
| **yunwei37/prompt-hacker-collections** | Prompt hacking and defense, with injection and reverse engineering examples. | [yunwei37/prompt-hacker-collections](https://github.com/yunwei37/prompt-hacker-collections) |
| **alphatrait/100000-ai-prompts-by-contentifyai** | Extensive collection of 100,000+ prompts for ChatGPT, covering various topics like business and entertainment. | [alphatrait/100000-ai-prompts-by-contentifyai](https://github.com/alphatrait/100000-ai-prompts-by-contentifyai) |
| **DummyKitty/Cyber-Security-chatGPT-prompt** | Security-focused ChatGPT prompt library. | [DummyKitty/Cyber-Security-chatGPT-prompt](https://github.com/DummyKitty/Cyber-Security-chatGPT-prompt) |

## Prompt Collections

| **Collection**                | **Description** | **Link** |
|-------------------------------|-----------------|----------|
| **FlowGPT**                   | Largest open-source community for sharing prompts. | [FlowGPT](https://flowgpt.com) |
| **awesomegptprompts.com**     | Hundreds of the best curated ChatGPT prompts. | [awesomegptprompts.com](https://awesomegptprompts.com) |
| **fka/awesome-chatgpt-prompts** | Dataset with curated ChatGPT prompts for enhanced usage. | [fka/awesome-chatgpt-prompts](https://github.com/fka/awesome-chatgpt-prompts) |
| **PromptHub**                 | A variety of the latest prompt engineering templates. | [PromptHub](https://app.prompthub.us/templates) |
| **Snack Prompt**              | Collection of prompts with Chrome extension for easy access. | [Snack Prompt](https://snackprompt.com) |
| **Prompt Search**             | Search engine for locating AI prompts. | [Prompt Search](https://promptsearch.com) |
| **The Prompt Index**          | Curated index with a wide variety of prompts. | [The Prompt Index](https://thepromptindex.com) |
| **PromptDen**                 | Platform with thousands of prompts for text and image generation, with profile features for prompt engineers. | [PromptDen](https://promptden.com) |
| **PromptChains**              | Prompt chains maximize intelligence and results when using LLMs. | [PromptChains](https://github.com/MIATECHPARTNERS/PromptChains) |

## GPT Stores and Libraries

| **Store/Library**             | **Description** | **Link** |
|-------------------------------|-----------------|----------|
| **Awesome GPT Store**         | Comprehensive GPT store with major public GPTs. | [Awesome GPT Store](https://github.com/Anil-matcha/Awesome-GPT-Store) |
| **Awesome GPTs Big List**     | A large list of notable GPTs available publicly. | [Awesome GPTs Big List](https://github.com/friuns2/Awesome-GPTs-Big-List) |
| **BestGPTs**                  | Top-ranked OpenAI GPTs for various applications. | [BestGPTs](https://github.com/AgentOps-AI/BestGPTs) |
| **Awesome GPT Agents**        | Curated list of GPT agents, particularly for cybersecurity. | [Awesome GPT Agents](https://github.com/fr0gger/Awesome-GPT-Agents) |

## Datasets

| **Dataset Name**                        | **Description**                                                                                                                                                                                                                                     | **Link** |
|-----------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| **P3 (Public Pool of Prompts)**         | A collection of prompted English datasets covering a diverse set of NLP tasks.                                                                                                                              | [HuggingFace](https://huggingface.co/datasets/bigscience/P3) |
| **Awesome ChatGPT Prompts**             | Repository includes curated ChatGPT prompts to enhance interactions.                                                                                                                                         | [GitHub](https://github.com/f/awesome-chatgpt-prompts) |
| **Red Team Attempts**                   | A dataset of "red team" attempts for adversarial testing on models, created by Anthropic for testing potential harmful outputs.                                                                            | [GitHub](https://github.com/anthropics/hh-rlhf/tree/master/red-team-attempts) |
| **DiffusionDB**                         | A large-scale text-to-image prompt dataset, providing a gallery of prompts based on Stable Diffusion models.                                                                                                | [GitHub](https://github.com/poloclub/diffusiondb) |
| **Real Toxicity Prompts**               | A dataset of 100k sentence snippets from the web for research on reducing toxic degeneration in neural models.                                                                                              | [HuggingFace](https://huggingface.co/datasets/allenai/real-toxicity-prompts) |
| **Stable Diffusion Prompts**            | A set of about 80,000 prompts from "Lexica.art" for Stable Diffusion. Data extraction was challenging due to API limitations.                                                                              | [HuggingFace](https://huggingface.co/datasets/Gustavosta/Stable-Diffusion-Prompts) |

## 5. Prompt Engineering Communities

## Social Media Groups for Prompt Engineering

## Reddit Communities

| **Community Name**            | **Description** | **Link** |
|-------------------------------|-----------------|----------|
| r/ChatGPTJailbreak            | Community dedicated to ChatGPT jailbreak techniques. | [r/ChatGPTJailbreak](https://www.reddit.com/r/ChatGPTJailbreak/) |
| r/ChatGPTPromptGenius         | Subreddit focused on sharing and discovering GPT prompts. | [r/ChatGPTPromptGenius](https://www.reddit.com/r/ChatGPTPromptGenius/) |
| r/chatgpt_promptDesign        | Dedicated to designing effective ChatGPT prompts. | [r/chatgpt_promptDesign](https://www.reddit.com/r/chatgpt_promptDesign/) |
| r/PromptEngineering           | Discussion subreddit for prompt engineering topics. | [r/PromptEngineering](https://www.reddit.com/r/PromptEngineering/) |
| r/PromptDesign                | Community for discussing prompt design strategies. | [r/PromptDesign](https://www.reddit.com/r/PromptDesign/) |
| r/MachineLearning             | Machine learning discussions, including GPT and LLMs. | [r/MachineLearning](https://www.reddit.com/r/MachineLearning/) |
| r/GPT_jailbreaks              | A forum for discussions on GPT jailbreak methods. | [r/GPT_jailbreaks](https://www.reddit.com/r/GPT_jailbreaks/) |
| r/ChatGptDAN                  | Community focused on DAN mode and ChatGPT jailbreaks. | [r/ChatGptDAN](https://www.reddit.com/r/ChatGptDAN/) |
| r/PromptSharing               | Platform to share and discover prompts with the community. | [r/PromptSharing](https://www.reddit.com/r/PromptSharing/) |
| r/PromptWizardry              | A subreddit for creative and advanced prompting techniques. | [r/PromptWizardry](https://www.reddit.com/r/PromptWizardry/) |
| r/PromptWizards               | A community for experts in prompt engineering. | [r/PromptWizards](https://www.reddit.com/r/PromptWizards/) |
| r/ChatGPT_Prompts             | Community for sharing ChatGPT prompts. | [r/ChatGPT_Prompts](https://www.reddit.com/r/ChatGPT_Prompts/) |
| r/promptrequest               | A community for users to request help with generating prompts for AI art, writing, games, and more. | [r/promptrequest](https://www.reddit.com/r/promptrequest/) |

## Facebook Communities

| **Community Name**                     | **Description**                                           | **Link** |
|----------------------------------------|-----------------------------------------------------------|----------|
| ChatGPT Prompt Engineers               | Group for discussions on ChatGPT, AI news, and LLMs.      | [Facebook Group](https://www.facebook.com/groups/chatgptpromptengineers/) |
| AI Image Creator Prompts               | Group dedicated to sharing prompts for AI image generation.| [Facebook Group](https://www.facebook.com/groups/291344450322662/) |
| Prompt Engineering: ChatGPT Hiring and Recruiting | Group focused on prompt engineering hiring and recruitment.| [Facebook Group](https://www.facebook.com/groups/950660259275734/) |
| AI Prompt Shares                       | Community for sharing AI-generated prompts.               | [Facebook Group](https://www.facebook.com/groups/aipromptshares/) |

## Discord Communities for Prompt Engineering

| **Community Name**            | **Description** | **Link** |
|-------------------------------|-----------------|----------|
| Attention Architects          | Open-source community for prompt engineering experts. | [Attention Architects](https://discord.gg/yourlink) |
| ChatGPT Prompt Engineering     | Discord server dedicated to prompt engineering. | [ChatGPT Prompt Engineering](https://discord.gg/yourlink) |
| ChatGPT Community             | General ChatGPT community on Discord. | [ChatGPT Community](https://discord.gg/yourlink) |
| Reddit's ChatGPT Discord      | r/chatgpt's official Discord server. | [Reddit ChatGPT](https://discord.gg/yourlink) |
| PromptsLab                    | Knowledge-sharing community for generative models and LLMs. | [PromptsLab](https://discord.gg/yourlink) |
| Learn Prompting               | Discord server dedicated to learning prompt techniques. | [Learn Prompting](https://discord.gg/yourlink) |
| Artificial Intelligence       | Discord server for AI enthusiasts and prompt engineers. | [Artificial Intelligence](https://discord.gg/yourlink) |
| OpenAI Discord                | Official Discord server for OpenAI. | [OpenAI Discord](https://discord.gg/yourlink) |
| Promptify Discord             | Promptify's Discord for prompt engineering and LLMs. | [Promptify Discord](https://discord.gg/m88xfYMbK6) |
| MidJourney Discord            | Community focused on MidJourney AI models. | [MidJourney Discord](https://discord.gg/yourlink) |

## Other Prompt Engineering Communities and Forums

| **Platform**   | **Description** | **Link** |
|----------------|-----------------|----------|
| altenens.is    | Forum for sharing ChatGPT tools and resources. | [altenens ChatGPT Tools](https://altenens.is/forums/chatgpt-tools) |
| onehack.us     | Platform for discovering and sharing GPT prompts. | [onehack.us Prompts](https://onehack.us/prompt) |
| Hugging Face Forum | Forum for discussing Hugging Face models, including transformers and GPT. | [Hugging Face Forum](https://discuss.huggingface.co/) |

## 6. Freelance & Job Opportunities

## Job Websites for Prompt Engineers

1. [Prompt Engineer Jobs](https://promptengineerjobs.io/jobs) - Dedicated to various prompt engineering roles.
2. [Moai Jobs - Prompt Engineering](https://www.moaijobs.com/prompt-engineering-jobs) - Lists prompt engineering and AI-related positions.
3. [Prompt Engineer Jobs Org](https://promptengineerjobs.org/) - Platform featuring prompt engineering jobs.
4. [AI Jobs Net - Prompt Engineering](https://aijobs.net/list/prompt-engineering-related-jobs/) - Collection of jobs in AI, with a section for prompt engineers.
5. [AI Jobs](https://aijobs.ai/prompt-engineer) - A specialized site for jobs in AI, including prompt engineering roles.
6. [Promptly Hired](https://promptlyhired.com/) - Jobs in prompt engineering and related fields.
7. [Upwork - Prompt Engineering](https://www.upwork.com/en-gb/freelance-jobs/prompt-engineering/) - Freelance prompt engineering roles.
8. [Prompt Engineering Jobs](https://prompt-engineering-jobs.com/) - Portal for finding prompt engineering jobs.
9. [AI Careers - Prompt Engineer](https://aicareers.jobs/job-category/prompt-engineer/) - Job board for various AI careers, including prompt engineering.

## Freelance Platforms

| **Platform**      | **Description**                                | **Link**                                                         |
|-------------------|-----------------------------------------------|------------------------------------------------------------------|
| **Upwork**        | Freelance platform with prompt engineering jobs. | [Upwork Prompt Engineering Jobs](https://www.upwork.com/en-gb/freelance-jobs/prompt-engineering/) |
| **Fiverr**        | Hire prompt engineers for freelance projects. | [Fiverr Prompt Engineers](https://go.fiverr.com/visit/?bta=1056572&brand=fp) |
| **Freelancer**    | Freelance platform for prompt engineering roles. | [Freelancer Prompt Engineering](https://www.freelancer.com/jobs/prompt-engineering#) |
| **Toptal**        | Platform connecting top prompt engineers for freelance opportunities. | [Toptal Prompt Engineers](https://www.toptal.com/prompt-engineers) |

## 7. Contributing & Code of Conduct

Contributing
We welcome contributions to make this repository a comprehensive resource for prompt engineering enthusiasts. Here’s how you can help:

Guidelines for Contributing
Follow our step-by-step guide in the CONTRIBUTING.md file to learn how to add new resources, fix errors, or enhance existing sections.

Code of Conduct
We strive to maintain a respectful and inclusive community. Please read our Code of Conduct to understand the expected behavior when contributing.

Feedback and Suggestions
If you have ideas for improvements, feel free to open an issue or submit a pull request. Constructive feedback is always welcome!

## 8. Support My Work

Consider giving this repository a ⭐️ if you find it helpful, or share it with others who might benefit! Contributions are always welcome—your input and additions help make this resource better for the entire community. Some of the links here may contribute to supporting the project at no extra cost to you. If this project benefits you, consider [sponsoring me on GitHub](https://github.com/sponsors/zacfrulloni) or [buying me a coffee](https://www.buymeacoffee.com/zazacattack) to help support ongoing updates and improvements. 

If you'd like to reach out, feel free to check the [Contact Me section](#13-contact-me). Thank you for your support! 🙏

## 9. Join Our Community on Discord

Connect with other developers, AI enthusiasts, and prompt engineers! We’ve created a Discord server where you can share insights, ask questions, and stay updated on the latest in prompt engineering. It’s a place to collaborate, network, and learn together.

[Join the Discord Server](https://discord.gg/BYKsABxW)

Feel free to reach out if you have questions or suggestions in our **#general** or **#feedback** channels. Let’s build a community of knowledge and support.

## 10. License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

© 2024 [zac frulloni]. All rights reserved.

## 11. Disclosure

Disclosure: I am compensated through these affiliate partnerships, and this compensation helps support the resources and ongoing work within this repository. Affiliate links are provided in sections containing resources, including but not limited to learning materials, tools, and community memberships. This disclosure appears on all applicable pages of this repository.

## 12. Contact Me

If you have any questions, feedback, or suggestions, feel free to reach out! You can contact me via email at: zacfrull `[at]` hotmail `[dot]` com.

Looking forward to hearing from you!
