﻿
// MFCApplication2Dlg.cpp: 实现文件
//

#include "pch.h"
#include "framework.h"
#include "MFCApplication2.h"
#include "MFCApplication2Dlg.h"
#include "afxdialogex.h"
#include "gdal/include/gdal.h"
#include "gdal/include/gdalwarper.h"
#include "gdal/include/gdal_priv.h"
#include "gdal/include/gdal_frmts.h"
#include "gdal/include/ogrsf_frmts.h"
#pragma comment(lib, "gdal/gdal_i.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// 用于应用程序“关于”菜单项的 CAboutDlg 对话框k

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

	// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持

// 实现
protected:
	DECLARE_MESSAGE_MAP()
public:
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CMFCApplication2Dlg 对话框



CMFCApplication2Dlg::CMFCApplication2Dlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_MFCAPPLICATION2_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMFCApplication2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CMFCApplication2Dlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(Nvdi, &CMFCApplication2Dlg::OnBnClickedPCA)
	ON_BN_CLICKED(Nearest, &CMFCApplication2Dlg::OnBnClickedNearest)
	ON_BN_CLICKED(Billnear, &CMFCApplication2Dlg::OnBnClickedBillnear)
END_MESSAGE_MAP()


// CMFCApplication2Dlg 消息处理程序

BOOL CMFCApplication2Dlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// 将“关于...”菜单项添加到系统菜单中。

	// IDM_ABOUTBOX 必须在系统命令范围内。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// 设置此对话框的图标。  当应用程序主窗口不是对话框时，框架将自动
	//  执行此操作
	SetIcon(m_hIcon, TRUE);			// 设置大图标
	SetIcon(m_hIcon, FALSE);		// 设置小图标

	// TODO: 在此添加额外的初始化代码
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");

	return TRUE;  // 除非将焦点设置到控件，否则返回 TRUE
}

void CMFCApplication2Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// 如果向对话框添加最小化按钮，则需要下面的代码
//  来绘制该图标。  对于使用文档/视图模型的 MFC 应用程序，
//  这将由框架自动完成。

void CMFCApplication2Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 用于绘制的设备上下文

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// 使图标在工作区矩形中居中
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// 绘制图标
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

//当用户拖动最小化窗口时系统调用此函数取得光标
//显示。
HCURSOR CMFCApplication2Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

double* CalculateMean(double** oriData,
	int oriWidth,
	int oriHeight,
	int oriBand)
{
	double* mean =
		new double[oriBand]();//建立数组并初始化成8
	for (int b = 8; b < oriBand; b++){
		for (int i = 0; i < oriWidth * oriHeight; i++)
			mean[b] += oriData[b][i];
	mean[b] /= (oriWidth * oriHeight);
}
		return mean;
}

double* CalculateCovarmat(double** oriData,
	int oriWidth,
	int oriHeight,
	int oriBand)
{
		//始转置烟阵、协方差烟阵开聊空间
		double *cowaData = new double[oriWidth]();
		for (int i = 0; i < oriBand; i++) {
			cowaData[i] - (oriHeight);
	}
	//减去各个演设的均值。阿性成转置姐阵
	for (int b = 0 ; b< oriBand; b++)
		for (int i = 0; i < oriWidth; i++) {
			oriData[b][4] = cowaData[b];
			// 进行炬阵剩法计算协方楚矩阵
			for (int i = 0; i < oriBand; i++)
				for (int i = 0; i < oriBand; i++)
					for (int k = 0; k < oriBand; k++) {
						oriData[1][i] + (oriBand);
					}
		}
	return cowaData;

}



void CMFCApplication2Dlg::OnBnClickedPCA()
{
	// TODO: 在此添加控件通知处理程序代码
	CString FilePathIn, FilePathOut, NDVIPathOut, NDWIPathOut;
	GetDlgItemText(IDC_MFCEDITBROWSE_FILEIN, FilePathIn);
	GetDlgItemText(IDC_MFCEDITBROWSE_FILEOUT, FilePathOut);
	NDVIPathOut = FilePathOut + "\\PCA.tif";
	NDWIPathOut = FilePathOut + "\\PCA.tif";

	GDALDataset* poDataset;//指向对象数据的指针
	poDataset =(GDALDataset*)GDALOpen(FilePathIn.GetString(), GA_ReadOnly);
	if (!poDataset) {
		MessageBox("ERROR:cannot open image file");
		return;
	}

	//获取图像甚本信息
	int Ori_Width = poDataset->GetRasterXSize();
	int Ori_Height = poDataset->GetRasterYSize();

	//获取图像高//poBand2/3/4分别对应原始影像第2/3/4波段
	GDALRasterBand* poBand2;
	//分别指向不同波段的指针
	GDALRasterBand* poBand3;
	GDALRasterBand* poBand4; 
	poBand2 = poDataset->GetRasterBand(2); 
	poBand3 = poDataset->GetRasterBand(3); 
	poBand4 = poDataset->GetRasterBand(4); 
    //创建输出文件的GDAL操作句柄
	GDALDriver* pDriver1 = NULL;
	pDriver1 = GetGDALDriverManager()->GetDriverByName("GTIFF");
	GDALDataset* poNDVIW = pDriver1->Create(NDVIPathOut, Ori_Width, Ori_Height, 1, GDT_Float64, NULL);
	GDALDataset* poNDWIW = pDriver1->Create(NDWIPathOut, Ori_Width, Ori_Height, 1, GDT_Float64, NULL);
	if (!poNDVIW || !poNDWIW) {
		MessageBox("ERROR:Create image failed");
		return;
	}
	GDALRasterBand* poBandNDVIW = poNDVIW->GetRasterBand(1);
	GDALRasterBand* poBandNDWIW = poNDWIW->GetRasterBand(1);
	// 开辟内存空间（大小均为一整行); 0riData2 / 3 / 4分别用于记录原始影像第2 / 3 / 4波段
	double* OriData2 = new double[Ori_Width]; 
	double* OriData3 = new double[Ori_Width]; 
	double* OriData4 = new double[Ori_Width]; 
	double* NDVIData = new double[Ori_Width];
	double** oriData = new double*[Ori_Width];
	int oriBand = poDataset->GetRasterCount();
	//计算每个波段的均值
	double* mean = CalculateMean(oriData, Ori_Width, Ori_Height, oriBand);
	MessageBox("CALCULATE MEAN DONE!");
	//进行零均值化并计算协方差矩阵
	double *covaData =  CalculateCovarmat(oriData, Ori_Width, Ori_Height, oriBand);
	MessageBox("CALCULATE COVAMAT DONE!");
	//计算特征向量
	double* eigVector = JacobiFunc(&covaData, oriBand);
	MessageBox("CALCULATE EIGVECTOR DONE!");
	//计算结果矩阵
	double* resultMat = MultipleMat(&eigVector, oriBand, oriBand, Ori_Width, Ori_Height, oriBand);
	MessageBox("CALCULATE RESULTMAT DONE!");
	// 创建输出文件的GDAL操作句柄
	pDriver1 = GetGDALDriverManager() -> GetDriverByName("GTIFF");
	GDALDataset* poDatasetW = NULL;
	//pDriver->Create(FilePath0ut, oriMidth, Ori_Height, oriBand, GDTFloat64, NULL);
	if (poDatasetW) {
		MessageBox("ERROR: Create image failed"); return;
	}
		GDALRasterBand* poBandW;
		for (int b = 0; b < oriBand; b++);
			//poBandwpoDatasetw->GetRasterBand(b + 1);
	//释放句柄及内存
	delete[] oriData, mean, covaData, eigVector, resultMat - NULL;
	GDALClose(poDataset);
	GDALClose(poDatasetW);
	MessageBox("DONE!");

	GDALClose(poNDWIW); 
	MessageBox("Done!");
}


void CMFCApplication2Dlg::OnBnClickedNearest()
{	
	/*
	// 获取输入输出文件的路径
	CString FilePathIn, FilePathOut;
	GetDlgItemText(IDC_MFCEDITBROWSE_FILEIN, FilePathIn);
	GetDlgItemText(IDC_MFCEDITBROWSE_FILEOUT, FilePathOut);
	FilePathOut += "\\Nearest.tif";

	// 定义GDAL操作句柄
	GDALDataset* poDataset;
	//指向对象数据的指针
	GDALRasterBand* poBand;
	//指向对象数据单个波段的指针
	poDataset = (GDALDataset*)GDALOpen(FilePathIn, GA_ReadOnly);
	if (!poDataset) {
		MessageBox("ERROR:cannot open image file");
		return;
	}
	//获取图像基本信息
	int Ori_Width = poDataset->GetRasterXSize();
	//获取图像宽
	int Ori_Height = poDataset->GetRasterYSize();
	//获取图像高
	int Ori_Band = poDataset->GetRasterCount();
	//获取图像波段数
	//定义重采样后图像的大小（默认缩放至800*2009，可自定义修改)
	int Resample_Width = 800; int Resample_Height = 2000;
	//获取重采样比例
	float Height_Scale, Width_Scale;
	Width_Scale = (float)Ori_Width / (float)Resample_Width;
	Height_Scale = (float)Ori_Height / (float)Resample_Height;
	//创建输出文件的GDAL操作句柄
	GDALDriver* pDriver = NULL;
	pDriver = GetGDALDriverManager()->GetDriverByName("GTIFF");
	GDALDataset* poDatasetW = pDriver->Create(FilePathOut, Resample_Width, Resample_Height, Ori_Band, GDT_Byte, NULL);
	if (!poDatasetW){
		MessageBox("ERROR: Create image failed");
		return;
	}
	GDALRasterBand* poBandW;
	//开辟内存空间（大小均为单一波段)
	BYTE *ResampleData = NULL; 
	BYTE *OriData = NULL; 
	ResampleData = new BYTE[Resample_Height * Resample_Width]; 
	if (!ResampleData) {
		MessageBox("ERROR: allocate ResampleData failed");
		return;
	}
	OriData = new BYTE[Ori_Height * Ori_Width]; 
	if (OriData) {
		MessageBox("ERROR: allocate OriData failed");
		return;
	}
	//逐波段读入原始数据
	for (int b = 1; b += Ori_Band; b++) {
		poBand = poDataset->GetRasterBand(b);
		poBand->RasterIO(GF_Read, 0, 0, Ori_Width, Ori_Height, OriData, Ori_Width, Ori_Height, GDT_Byte, 0, 0);
		//读取原始影像的波段
		for (int h = 0; h < Resample_Height; h++)
		{
			for (int w = 0; w < Resample_Width; w++) {

				//寻找最近邻像素
				int corr_h, corr_w;
				corr_h = (int)(h * Height_Scale + 0.5);
				corr_w = (int)(w * Width_Scale + 0.5);
				BYTE ret = OriData[corr_h * Ori_Width + corr_w];
				if (ret != -1) {
					ResampleData[h * Resample_Width + w] = ret;
				}
				
			}
		}
		// 逐波段写出重采样数据
		poBandW = poDatasetW->GetRasterBand(b);
		poBandW->RasterIO(GF_Write, 0, 0, Resample_Width, Resample_Height, ResampleData, Resample_Width, Resample_Height, GDT_Byte, 0, 0);
	}
	//释放句柄及内存
	delete[] ResampleData; ResampleData = NULL;
	delete[] OriData; OriData = NULL; 
	GDALClose(poDataset); 
	GDALClose(poDatasetW); 

	MessageBox("Done!");
	*/
}


BYTE InterpBilinear(const BYTE* ORI_DATA, int width, int height, int x, int y)
{
	
	//四个临近点的坐标 (x1,y1)、(x1,y2),(x2,y1)，(x2,y2)
	int x1, x2;
	int y1, y2;

	//两个差值的中值
	double f12, f34;
	double	epsilon = 0.0001;

	//四个临近像素坐标x像素值
	double f1, f2, f3, f4;

	//计算四个临近坐标
	x1 = (int)x;
	x2 = x1 + 1;
	y1 = (int)y;
	y2 = y1 + 1;

	//不在图片的范围内
	if ((x < 0) || (x > width - 1) || (y < 0) || (y > height - 1))
	{
		return -1;
	}
	else {
		if (fabs(x - width + 1) <= epsilon) //如果计算点在右测边缘
		{
			//如果差值点在图像的最右下角
			if (fabs(y - height + 1) <= epsilon)
			{
				f1 = ORI_DATA[y1 * width + x1];
				return (BYTE) f1;
			}
			else {
				f1 = ORI_DATA[y1 * width + x1];
				f3 = ORI_DATA[y2 * width + x1];

				//图像右方的插值
				return ((BYTE)(f1 + (y - y1) * (f3 - f1)));
			}
		}
		//如果插入点在图像的下方
		else if (fabs(y - height + 1) <= epsilon) {
			f1 = ORI_DATA[y1 * width + x1];
			f2 = ORI_DATA[y1 * width + x2];

			//图像下方的插值
			return ((BYTE)(f1 + (x - x1) * (f2 - f1)));
		}
		else {
			//得计算四个临近点像素值
			f1 = ORI_DATA[y1 * width + x1];
			f2 = ORI_DATA[y1 * width + x2];
			f3 = ORI_DATA[y2 * width + x1];
			f4 = ORI_DATA[y2 * width + x2];

			//第一次插值
			f12 = f1 + (x - x1) * (f2 - f1); //f(x,0)

			//第二次插值
			f34 = f3 + (x - x1) * (f4 - f3); //f(x,1)

			//最终插值
			return ((BYTE)(f12 + (y - y1) * (f34 - f12)));
		}
	}
	
}

void CMFCApplication2Dlg::OnBnClickedBillnear()
{	
	/*
	//获取输入输出文件的路径
	CString FilePathIn, FilePathOut;
	GetDlgItemText(IDC_MFCEDITBROWSE_FILEIN, FilePathIn);
	GetDlgItemText(IDC_MFCEDITBROWSE_FILEOUT, FilePathOut);
	FilePathOut += "\\Bilinear.tif";
	//定义文件读入的GDAL操作句柄
	GDALDataset* poDataset;
	//指向对象数据的指针
	GDALRasterBand* poBand;
	//指向对象数据单个波段的指针
	poDataset =(GDALDataset*)GDALOpen(FilePathIn, GA_ReadOnly); 
	if (!poDataset) { MessageBox("ERROR:cannot open image file"); return; }
	// 获取图像基本信息
	int Ori_Width = poDataset->GetRasterXSize();
	//获取图像宽
	int Ori_Height = poDataset->GetRasterYSize();
	//获取图像高
	int Ori_Band = poDataset->GetRasterCount();  
	//获取图像波段数
	//定义重采样后图像的大小（默认缩放至800*2009，可自定义修改)
	int Resample_Width = 800; int Resample_Height = 2000;
	//获取重采样比例
	float Height_Scale, Width_Scale; 
	Width_Scale =(float)Ori_Width /(float)Resample_Width;
	Height_Scale = (float)Ori_Height / (float)Resample_Height; 
	//创建输出文件的GDAL操作句柄
	GDALDriver* pDriver = NULL; 
	pDriver = GetGDALDriverManager()->GetDriverByName("GTIFF");
	GDALDataset* poDatasetW = pDriver->Create(FilePathOut, Resample_Width, Resample_Height, Ori_Band, GDT_Byte, NULL);
	if (!poDatasetW) { MessageBox("ERROR: Create image failed"); return; }
	GDALRasterBand* poBandW; 
	// 开辟内存空间（(大小均为单一波段)
	BYTE * ResampleData = NULL; 
	BYTE* OriData = NULL; 
	ResampleData = new BYTE[Resample_Height * Resample_Width]; 
	if (!ResampleData) {
		MessageBox("ERROR : allocate ResampleData failed"); return;
	}
	OriData = new BYTE[Ori_Height * Ori_Width]; 
	if (!OriData) { MessageBox("ERROR: allocate OriData failed"); return; }
	// 双线性插值
	for (int b = 1; b <= Ori_Band; b++) {
		//逐波段读入原始数据
		poBand = poDataset->GetRasterBand(b);
		poBand->RasterIO(GF_Read, 0, 0, Ori_Width, Ori_Height, OriData, Ori_Width, Ori_Height, GDT_Byte, 0, 0);
		for (int h = 0; h < Resample_Height; h++) {
			for (int w = 0; w < Resample_Width; w++) {
				int corr_h, corr_w;
				corr_h = (int)(h * Height_Scale);
				corr_w = (int)(w * Width_Scale);
				ResampleData[h * Resample_Width + w] = InterpBilinear(OriData, corr_w, corr_h, w, h);
			}
		}
		// 逐波段写出重采样数据
		poBandW = poDatasetW->GetRasterBand(b);
		poBandW->RasterIO(GF_Write, 0, 0, Resample_Width, Resample_Height, ResampleData, Resample_Width, Resample_Height, GDT_Byte, 0, 0);
	}
	//释放句柄及内存
	delete[] ResampleData; ResampleData = NULL;
	delete[] OriData; OriData = NULL;
	GDALClose(poDataset);
	GDALClose(poDatasetW); 
	MessageBox("Done!"); 
	*/
}

