﻿
// MFCApplication2Dlg.cpp: 实现文件
//

#include "pch.h"
#include "framework.h"
#include "MFCApplication2.h"
#include "MFCApplication2Dlg.h"
#include "afxdialogex.h"
#include "gdal/include/gdal.h"
#include "gdal/include/gdalwarper.h"
#include "gdal/include/gdal_priv.h"
#include "gdal/include/gdal_frmts.h"
#include "gdal/include/ogrsf_frmts.h"
#pragma comment(lib, "gdal/lib/gdal.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define PI 3.14159265
#define pixelDepth 255

// 用于应用程序“关于”菜单项的 CAboutDlg 对话框k

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

	// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持

// 实现
protected:
	DECLARE_MESSAGE_MAP()
public:
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CMFCApplication2Dlg 对话框



CMFCApplication2Dlg::CMFCApplication2Dlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_MFCAPPLICATION2_DIALOG, pParent)
	, mssPath(_T(""))
	, panPath(_T(""))
	, outPath(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMFCApplication2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EBC_MSS, mssPath);
	DDX_Text(pDX, IDC_EBC_PAN, panPath);
	DDX_Text(pDX, IDC_EBC_Result, outPath);
}

BEGIN_MESSAGE_MAP(CMFCApplication2Dlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	
	ON_BN_CLICKED(IDC_BN_Implement, &CMFCApplication2Dlg::OnBnClickedBnImplement)
END_MESSAGE_MAP()


// CMFCApplication2Dlg 消息处理程序

BOOL CMFCApplication2Dlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// 将“关于...”菜单项添加到系统菜单中。

	// IDM_ABOUTBOX 必须在系统命令范围内。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// 设置此对话框的图标。  当应用程序主窗口不是对话框时，框架将自动
	//  执行此操作
	SetIcon(m_hIcon, TRUE);			// 设置大图标
	SetIcon(m_hIcon, FALSE);		// 设置小图标

	// TODO: 在此添加额外的初始化代码
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");
	return TRUE;  // 除非将焦点设置到控件，否则返回 TRUE
}

void CMFCApplication2Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// 如果向对话框添加最小化按钮，则需要下面的代码
//  来绘制该图标。  对于使用文档/视图模型的 MFC 应用程序，
//  这将由框架自动完成。

void CMFCApplication2Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 用于绘制的设备上下文

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// 使图标在工作区矩形中居中
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// 绘制图标
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

//当用户拖动最小化窗口时系统调用此函数取得光标
//显示。
HCURSOR CMFCApplication2Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}




void CMFCApplication2Dlg::OnDestroy()
{
	CDialogEx::OnDestroy();


}


float getMin(float x, float y, float z){
	float min = x;
	if (min >y)min = y;
	if (min >z)min = z;
	return min;
}

void RGB2HIS(float r, float g, float b, float &h, float &i, float &s){
	float R; float G; float B;
	float angle(0);
	//归一化
	R = r / pixelDepth;
	G = g / pixelDepth;
	B = b / pixelDepth;
	//三角形变换
	i = (R + G + B) / 3.0;
	s = 1 - getMin(R, G, B) / i;
	angle = acos(0.5 * (R - G  + R - B) / (sqrt((R - G) * (R - G) + (R - B) * (G - B))));
	angle = angle * 180.0 / PI;

	if(B > G) h = 360 - angle;
	else h = angle;

	h *= pixelDepth /360.0;
	i *= pixelDepth;
	s *=  pixelDepth;
}

void HIS2RGB(float h, float i, float s, float& r, float& g, float& b) {
	h = h * 360. / pixelDepth;
	i /= pixelDepth;
	s /= pixelDepth;

	float m[3];
	if (h < 0) { h = h + 360; }
	if (h >= 0 && h < 120) {
		m[0] = i * (1.0 + (s * cos(h * PI / 180) / cos((60 - h) * PI / 180)));
		m[2] = i * (1.0 - s);
		m[1] = 3.0 * i - (m[0] + m[2]);
	}
	if (h >= 120 && h < 240) {
		h = h - 120;
		m[1] = i * (1.0 + (s * cos(h * PI / 180) / cos((60 - h) * PI / 180)));
		m[0] = i * (1.0 - s);
		m[2] = 3.0 * i - (m[0] + m[1]);
	}
	if (h >= 240 && h <= 360) {
		h = h - 240;
		m[2] = i * (1.0 + (s * cos(h * PI / 180) / cos((60 - h) * PI / 180)));
		m[1] = i * (1.0 - s);
		m[0] = 3 * i - (m[1] + m[2]);
	}
	r = m[0] * pixelDepth;
	g = m[1] * pixelDepth;
	b = m[2] * pixelDepth;
}
void ComputeMaxAndMin(GDALDataset* dataset, int iband, float &max, float &min) {
	int col = dataset->GetRasterXSize();
	int row = dataset->GetRasterYSize();
	GDALRasterBand* band = dataset->GetRasterBand(iband);
	float* p = new float[col];
	// 先取一个点的值
	band->RasterIO(GF_Read, 0, 0, 1, 1, &max, 1, 1, GDT_Float32, 0, 0);
	min = max;
	for (int i = 0; i < row; i++) {
		band->RasterIO(GF_Read, 0, i, col, 1, p, col, 1, GDT_Float32, 0, 0);
		for (int j = 0; j < col; j++) {
			float temp = p[j];
			if (temp > max)max = temp;
			if (temp < min)min = temp;
		}
	}
	delete[] p;
}
void CMFCApplication2Dlg::OnBnClickedBnImplement()
{
	// TODO: 在此添加控件通知处理程序代码
//mss重采样到全色影像大小，在EVI中实现
	UpdateData(TRUE);
	// 打开RGB波段影像(MSSRemsample)与pan波段影像文件
	GDALDataset* poSrcMss = (GDALDataset*)GDALOpen(mssPath, GA_ReadOnly);
	GDALDataset* poSrcPan = (GDALDataset*)GDALOpen(panPath, GA_ReadOnly);
	if (poSrcMss == NULL || poSrcPan == NULL) {
		MessageBox("文件无法打开");
		return;
	}
	GDALDriver* poDriver = GetGDALDriverManager()->GetDriverByName("GTiff");
	GDALRasterBand* pBandR = poSrcMss->GetRasterBand(3);
	GDALRasterBand* pBandG = poSrcMss->GetRasterBand(2);
	GDALRasterBand* pBandB = poSrcMss->GetRasterBand(1);
	GDALRasterBand* pan = poSrcPan->GetRasterBand(1);
	if (poDriver == NULL) {
		GDALClose((GDALDatasetH)poSrcMss);
		GDALClose((GDALDatasetH)poSrcPan);
		MessageBox("驱动运行失败");

		return;
	}
	// 自定义重采样后全色和多波错影像尺寸一致
	int panXSize = poSrcPan->GetRasterXSize();
	int panYSize = poSrcPan->GetRasterYSize();
	float panMax = 0, panMin = 0;
	ComputeMaxAndMin(poSrcPan, 1, panMax, panMin);
	GDALDataset* pwDataset = poDriver->Create(outPath, panXSize, panYSize, 3, GDT_Float32, NULL);
	GDALRasterBand* pwBandR = pwDataset->GetRasterBand(3);
	GDALRasterBand* pwBandG = pwDataset->GetRasterBand(2);
	GDALRasterBand* pwBandB = pwDataset->GetRasterBand(1);
	float* R = new float[panXSize];
	float* G = new float[panXSize];
	float* B = new float[panXSize];
	float* H = new float[panXSize];
	float* I = new float[panXSize];
	float* S = new float[panXSize];
	float* panI = new float[panXSize];
	if (R == NULL || G == NULL || B == NULL || H == NULL || I == NULL || S == NULL || panI == NULL) {
		MessageBox("申请内存失败");
		return;
	}
	for (int i = 0; i < panYSize; i++) {
		pBandR->RasterIO(GF_Read, 0, i, panXSize, 1, R, panXSize, 1, GDT_Float32, 0, 0);
		pBandG->RasterIO(GF_Read, 0, i, panXSize, 1, G, panXSize, 1, GDT_Float32, 0, 0);
		pBandB->RasterIO(GF_Read, 0, i, panXSize, 1, B, panXSize, 1, GDT_Float32, 0, 0);
		pan->RasterIO(GF_Read, 0, i, panXSize, 1, panI, panXSize, 1, GDT_Float32, 0, 0);
		for (int j = 0; j < panXSize; j++) {
			RGB2HIS(R[j], G[j], B[j], H[j], I[j], S[j]);
			I[j] = (panI[j] - panMin) * pixelDepth / (panMax - panMin);
			HIS2RGB(H[j], I[j], S[j], R[j], G[j], B[j]);
		}

		pwBandB->RasterIO(GF_Write, 0, i, panXSize, 1, R, panXSize, 1, GDT_Float32, 0, 0);
		pwBandB->RasterIO(GF_Write, 0, i, panXSize, 1, G, panXSize, 1, GDT_Float32, 0, 0);
		pwBandB->RasterIO(GF_Write, 0, i, panXSize, 1, B, panXSize, 1, GDT_Float32, 0, 0);

	}
	GDALClose(poSrcMss);
	GDALClose(poSrcPan);
	GDALClose(pwDataset);
	delete[]R; delete[]G; delete[]B;
	delete[]H; delete[]I; delete[]S;
	delete[]panI;
	MessageBox("融合成功");
}