/******************************************************
 * EasyX Library for C++ (Ver:20151015(beta))
 * http://www.easyx.cn
 *
 * EasyX.h
 *	 VC ʵּ򵥵Ļͼ
 ******************************************************/

#pragma once

#ifndef WINVER
#define WINVER 0x0400			// Specifies that the minimum required platform is Windows 95 and Windows NT 4.0.
#endif

#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0500		// Specifies that the minimum required platform is Windows 2000.
#endif

#ifndef _WIN32_WINDOWS
#define _WIN32_WINDOWS 0x0410	// Specifies that the minimum required platform is Windows 98.
#endif

#if defined(UNICODE) && (_MSC_VER > 1200)
	#pragma comment(lib,"easyxw.lib")
#elif !defined(UNICODE) && (_MSC_VER > 1200)
	#pragma comment(lib,"easyx.lib")
#elif defined(UNICODE)
	#pragma comment(lib,"easyxw6.lib")
#elif !defined(UNICODE)
	#pragma comment(lib,"easyx6.lib")
#endif


#ifndef __cplusplus
#error EasyX is only for C++
#endif

#include <windows.h>
#include <tchar.h>

// ͼڳʼ
#define SHOWCONSOLE		1		// ͼδʱ̨ʾ
#define NOCLOSE			2		// ûйرչ
#define NOMINIMIZE		4		// ûС

// ɫ
#define	BLACK			0
#define	BLUE			0xAA0000
#define	GREEN			0x00AA00
#define	CYAN			0xAAAA00
#define	RED				0x0000AA
#define	MAGENTA			0xAA00AA
#define	BROWN			0x0055AA
#define	LIGHTGRAY		0xAAAAAA
#define	DARKGRAY		0x555555
#define	LIGHTBLUE		0xFF5555
#define	LIGHTGREEN		0x55FF55
#define	LIGHTCYAN		0xFFFF55
#define	LIGHTRED		0x5555FF
#define	LIGHTMAGENTA	0xFF55FF
#define	YELLOW			0x55FFFF
#define	WHITE			0xFFFFFF

// ɫת
#define BGR(color)	( (((color) & 0xFF) << 16) | ((color) & 0xFF00FF00) | (((color) & 0xFF0000) >> 16) )


class IMAGE;

// ߵʽ
class LINESTYLE
{
public:
	LINESTYLE();
	LINESTYLE(const LINESTYLE &style);
	LINESTYLE& operator = (const LINESTYLE &style);			// ֵغ
	virtual ~LINESTYLE();

	DWORD	style;
	DWORD	thickness;
	DWORD	*puserstyle;
	DWORD	userstylecount;
};

class FILLSTYLE
{
public:
	FILLSTYLE();
	FILLSTYLE(const FILLSTYLE &style);
	FILLSTYLE& operator = (const FILLSTYLE &style);			// ֵغ
	virtual ~FILLSTYLE();

	int			style;			// ʽ
	long		hatch;			// ͼʽ
	IMAGE*		ppattern;		// ͼ
};

// ͼ
class IMAGE
{
public:
	int getwidth() const;	// ȡĿ
	int getheight() const;	// ȡĸ߶

private:
	int width, height;		// Ŀ
	HBITMAP m_hBmp;
	HDC m_hMemDC;
	int m_MemCurX;			// ǰX
	int m_MemCurY;			// ǰY
	float m_data[6];
	COLORREF	m_LineColor;		// ǰɫ
	COLORREF	m_FillColor;		// ǰɫ
	COLORREF	m_TextColor;		// ǰɫ
	COLORREF	m_BkColor;			// ǰɫ
	DWORD*		m_pBuffer;			// ͼڴ

	LINESTYLE	m_LineStyle;		// ʽ
	FILLSTYLE	m_FillStyle;		// ʽ

	virtual void SetDefault();						// ΪĬ״̬

public:
	IMAGE(int _width = 0, int _height = 0);			// ͼ
	IMAGE(const IMAGE &img);						// 캯
	IMAGE& operator = (const IMAGE &img);			// ֵغ
	virtual ~IMAGE();
	virtual void Resize(int _width, int _height);	// ߴ
};



// ͼģʽغ

HWND initgraph(int width, int height, int flag = NULL);	// ʼͼλ
void closegraph();										// رͼλ

// ͼ

void cleardevice();					// 
void setcliprgn(HRGN hrgn);			// õǰͼ豸Ĳü
void clearcliprgn();				// üĻ

void getlinestyle(LINESTYLE* pstyle);						// ȡǰʽ
void setlinestyle(const LINESTYLE* pstyle);					// õǰʽ
void setlinestyle(int style, int thickness = 1, const DWORD *puserstyle = NULL, DWORD userstylecount = 0);	// õǰʽ
void getfillstyle(FILLSTYLE* pstyle);						// ȡǰʽ
void setfillstyle(const FILLSTYLE* pstyle);					// õǰʽ
void setfillstyle(int style, long hatch = NULL, IMAGE* ppattern = NULL);		// õǰʽ
void setfillstyle(BYTE* ppattern8x8);						// õǰʽ

void setorigin(int x, int y);							// ԭ
void getaspectratio(float *pxasp, float *pyasp);		// ȡǰ
void setaspectratio(float xasp, float yasp);			// õǰ

int  getrop2();						// ȡǰĶԪդģʽ
void setrop2(int mode);				// ǰĶԪդģʽ
int  getpolyfillmode();				// ȡģʽ
void setpolyfillmode(int mode);		// öģʽ

void graphdefaults();				// лͼΪĬֵ

COLORREF getlinecolor();			// ȡǰɫ
void setlinecolor(COLORREF color);	// õǰɫ
COLORREF gettextcolor();			// ȡǰɫ
void settextcolor(COLORREF color);	// õǰɫ
COLORREF getfillcolor();			// ȡǰɫ
void setfillcolor(COLORREF color);	// õǰɫ
COLORREF getbkcolor();				// ȡǰͼɫ
void setbkcolor(COLORREF color);	// õǰͼɫ
int  getbkmode();					// ȡģʽ
void setbkmode(int mode);			// ñģʽ

// ɫģת
COLORREF RGBtoGRAY(COLORREF rgb);
void RGBtoHSL(COLORREF rgb, float *H, float *S, float *L);
void RGBtoHSV(COLORREF rgb, float *H, float *S, float *V);
COLORREF HSLtoRGB(float H, float S, float L);
COLORREF HSVtoRGB(float H, float S, float V);


// ͼ

COLORREF getpixel(int x, int y);				// ȡɫ
void putpixel(int x, int y, COLORREF color);	// 

void moveto(int x, int y);						// ƶǰ()
void moverel(int dx, int dy);					// ƶǰ()

void line(int x1, int y1, int x2, int y2);		// 
void linerel(int dx, int dy);					// ()
void lineto(int x, int y);						// ()

void rectangle	   (int left, int top, int right, int bottom);	// 
void fillrectangle (int left, int top, int right, int bottom);	// (б߿)
void solidrectangle(int left, int top, int right, int bottom);	// (ޱ߿)
void clearrectangle(int left, int top, int right, int bottom);	// վ

void circle		(int x, int y, int radius);		// Բ
void fillcircle (int x, int y, int radius);		// Բ(б߿)
void solidcircle(int x, int y, int radius);		// Բ(ޱ߿)
void clearcircle(int x, int y, int radius);		// Բ

void ellipse	 (int left, int top, int right, int bottom);	// Բ
void fillellipse (int left, int top, int right, int bottom);	// Բ(б߿)
void solidellipse(int left, int top, int right, int bottom);	// Բ(ޱ߿)
void clearellipse(int left, int top, int right, int bottom);	// Բ

void roundrect	   (int left, int top, int right, int bottom, int ellipsewidth, int ellipseheight);		// ԲǾ
void fillroundrect (int left, int top, int right, int bottom, int ellipsewidth, int ellipseheight);		// ԲǾ(б߿)
void solidroundrect(int left, int top, int right, int bottom, int ellipsewidth, int ellipseheight);		// ԲǾ(ޱ߿)
void clearroundrect(int left, int top, int right, int bottom, int ellipsewidth, int ellipseheight);		// ԲǾ

void arc	 (int left, int top, int right, int bottom, double stangle, double endangle);	// Բ(ʼǶȺֹǶΪ)
void pie	 (int left, int top, int right, int bottom, double stangle, double endangle);	// Բ(ʼǶȺֹǶΪ)
void fillpie (int left, int top, int right, int bottom, double stangle, double endangle);	// Բ(б߿)
void solidpie(int left, int top, int right, int bottom, double stangle, double endangle);	// Բ(ޱ߿)
void clearpie(int left, int top, int right, int bottom, double stangle, double endangle);	// Բ

void polyline	 (const POINT *points, int num);	// 
void polygon	 (const POINT *points, int num);	// 
void fillpolygon (const POINT *points, int num);	// Ķ(б߿)
void solidpolygon(const POINT *points, int num);	// Ķ(ޱ߿)
void clearpolygon(const POINT *points, int num);	// ն

void floodfill(int x, int y, int border);			// 



// غ

void outtext(LPCTSTR str);					// ڵǰλַ
void outtext(TCHAR c);						// ڵǰλַ
void outtextxy(int x, int y, LPCTSTR str);	// ָλַ
void outtextxy(int x, int y, TCHAR c);		// ָλַ
int textwidth(LPCTSTR str);					// ȡַռõؿ
int textwidth(TCHAR c);						// ȡַռõؿ
int textheight(LPCTSTR str);				// ȡַռõظ
int textheight(TCHAR c);					// ȡַռõظ
int drawtext(LPCTSTR str, RECT* pRect, UINT uFormat);	// ָָʽַ
int drawtext(TCHAR c, RECT* pRect, UINT uFormat);		// ָָʽַ

// õǰʽ()
//		nHeight: ַƽ߶ȣ
//		nWidth: ַƽ(0 ʾӦ)
//		lpszFace: ƣ
//		nEscapement: ַдǶ(λ 0.1 )
//		nOrientation: ÿַдǶ(λ 0.1 )
//		nWeight: ַıʻϸ(0 ʾĬϴϸ)
//		bItalic: Ƿб壻
//		bUnderline: Ƿ»ߣ
//		bStrikeOut: Ƿɾߣ
//		fbCharSet: ַָ
//		fbOutPrecision: ֵָȣ
//		fbClipPrecision: ֵָļȣ
//		fbQuality: ֵָ
//		fbPitchAndFamily: ָԳ淽ʽϵС
void settextstyle(int nHeight, int nWidth, LPCTSTR lpszFace);
void settextstyle(int nHeight, int nWidth, LPCTSTR lpszFace, int nEscapement, int nOrientation, int nWeight, bool bItalic, bool bUnderline, bool bStrikeOut);
void settextstyle(int nHeight, int nWidth, LPCTSTR lpszFace, int nEscapement, int nOrientation, int nWeight, bool bItalic, bool bUnderline, bool bStrikeOut, BYTE fbCharSet, BYTE fbOutPrecision, BYTE fbClipPrecision, BYTE fbQuality, BYTE fbPitchAndFamily);
void settextstyle(const LOGFONT *font);	// õǰʽ
void gettextstyle(LOGFONT *font);		// ȡǰʽ



// ͼ
void loadimage(IMAGE *pDstImg, LPCTSTR pImgFile, int nWidth = 0, int nHeight = 0, bool bResize = false);					// ͼƬļȡͼ(bmp/jpg/gif/emf/wmf)
void loadimage(IMAGE *pDstImg, LPCTSTR pResType, LPCTSTR pResName, int nWidth = 0, int nHeight = 0, bool bResize = false);	// Դļȡͼ(bmp/jpg/gif/emf/wmf)
void saveimage(LPCTSTR pImgFile, IMAGE* pImg = NULL);																		// ͼ
void getimage(IMAGE *pDstImg, int srcX, int srcY, int srcWidth, int srcHeight);												// ӵǰͼ豸ȡͼ
void putimage(int dstX, int dstY, const IMAGE *pSrcImg, DWORD dwRop = SRCCOPY);												// ͼĻ
void putimage(int dstX, int dstY, int dstWidth, int dstHeight, const IMAGE *pSrcImg, int srcX, int srcY, DWORD dwRop = SRCCOPY);		// ͼĻ(ָ)
void rotateimage(IMAGE *dstimg, IMAGE *srcimg, double radian, COLORREF bkcolor = BLACK, bool autosize = false, bool highquality = true);// תͼ
void Resize(IMAGE* pImg, int width, int height);	// ͼ豸ĴС
DWORD* GetImageBuffer(IMAGE* pImg = NULL);			// ȡͼ豸Դָ
IMAGE* GetWorkingImage();							// ȡǰͼ豸
void SetWorkingImage(IMAGE* pImg = NULL);			// õǰͼ豸
HDC GetImageHDC(IMAGE* pImg = NULL);				// ȡͼ豸(HDC)


// 

int	getwidth();			// ȡͼ
int	getheight();		// ȡͼ߶
int	getx();				// ȡǰ x 
int	gety();				// ȡǰ y 

void BeginBatchDraw();	// ʼ
void FlushBatchDraw();	// ִδɵĻ
void FlushBatchDraw(int left, int top, int right, int bottom);	// ִָδɵĻ
void EndBatchDraw();	// ƣִδɵĻ
void EndBatchDraw(int left, int top, int right, int bottom);	// ƣִָδɵĻ

HWND GetHWnd();								// ȡͼھ(HWND)
TCHAR* GetEasyXVer();						// ȡ EasyX ǰ汾

// ȡû
bool InputBox(LPTSTR pString, int nMaxCount, LPCTSTR pPrompt = NULL, LPCTSTR pTitle = NULL, LPCTSTR pDefault = NULL, int width = 0, int height = 0, bool bOnlyOK = true);



// Ϣ
// ֧Ϣ
//		WM_MOUSEMOVE		ƶ
//		WM_MOUSEWHEEL		ֲ
//		WM_LBUTTONDOWN		
//		WM_LBUTTONUP		
//		WM_LBUTTONDBLCLK	˫
//		WM_MBUTTONDOWN		м
//		WM_MBUTTONUP		м
//		WM_MBUTTONDBLCLK	м˫
//		WM_RBUTTONDOWN		Ҽ
//		WM_RBUTTONUP		Ҽ
//		WM_RBUTTONDBLCLK	Ҽ˫
struct MOUSEMSG
{
	UINT uMsg;				// ǰϢ
	bool mkCtrl;			// Ctrl Ƿ
	bool mkShift;			// Shift Ƿ
	bool mkLButton;			// Ƿ
	bool mkMButton;			// мǷ
	bool mkRButton;			// ҼǷ
	short x;				// ǰ x 
	short y;				// ǰ y 
	short wheel;			// ֵֹ (120 ı)
};

bool MouseHit();			// ǷϢ
MOUSEMSG GetMouseMsg();		// ȡһϢûУ͵ȴ
void FlushMouseMsgBuffer();	// Ϣ
