# 开源之夏项目申请书

- 项目名称: eBPF 软件应用市场
- 项目主导师: 魏勇军
- 申请人:    郑昱笙
- 日期: 2023.06.02
- 邮箱: <1067852565@qq.com>

## 项目背景

### 项目简述

目前在容器、软件加速及维测上，社区开发了很多相应eBPF程序，而对于这些eBPF程序缺乏统一的分发方式。cilium等独立组件都有自己的管理方式，bcc等工具集也有自己的打包方式，openEuler内核开发的一些eBPF插件在内核仓进行发布。但是这些eBPF程序的升级及增加新的功能都依赖于整体软件的发布，存在升级周期长等问题。另外eBPF程序开发难度需要了解内核eBPF程序框架，相对来所开发难度较高。本任务希望能借鉴docker hub的管理模式，提供openEuler内核eBPF开发模板，及相应的编译分发的工具，解决eBPF软件打包分发难题。

### 项目产出要求

1. 构建 openEuler 应用市场基础设施，提供类似于 docker hub 的 eBPF 程序管理模式
2. 提供 openEuler eBPF 软件编写模板，简化编译和打包及分发流程

### 项目技术要求

1. 熟悉 eBPF 技术原理及eBPF软件开发过程；
2. 熟悉 linux 内核构建过程；
3. 熟悉一种 web 服务构建及开发框架；
4. 熟悉 eunomia, L3AF等开源项目；

## 技术方法与可行性

接下来会在 OpenEuler eBPF SIG 上和大家详细沟通和讨论具体的设计方案。

### eBPF 生态现有的问题

现行的 eBPF 生态存在两个主要问题：

1. 首先，对于初学者，设置并开发 eBPF 程序的难度较高，复杂度较大，他们必须同时考虑内核态和用户态的交互和信息处理。

2. 其次，将个人编写的 eBPF 程序直接添加到大型工具集（如 bcc）中，而无需审查，是一个困难的工作，因为：

   - 这些程序可能使用多种用户态语言开发（如 Go，Rust，C/C++等），具有各种不同的接口。
   - 它们并没有预先编译好的二进制程序，用户必须自行配置环境和编译才能使用。
   - 并不能轻松地将它们作为插件集成到大型可观察性或其他系统中。一般来说，必须修改代码并重新编译整个可观察性框架然后部署上线，才能更新其中的 BPF 探针。

综上，eBPF 缺少对新手友好的开发方案和一个类似于 Github 或 Docker hub 的通用分发和托管平台。

### 期望的实现方式

鉴于以上背景，我们期望达成以下两个目标：

1. 提供一个通用、规范的 eBPF 程序/应用插件/工具托管平台或应用商店，以及包管理器。这样，用户只需一行命令就能启动程序，无需配置环境或重新编译，同时，通过 exporter 获取可视化信息。
2. 提供一个前端界面，列出 Hub 中所有的 eBPF 工具的介绍和索引，帮助其他人搜索和找到 eBPF 程序。

一个规范的 eBPF 程序应具备以下特性：

- `可移植性`：eBPF 工具和应用应该完全平台/架构无关、可移植，无需重新编译即可跨平台/跨架构分发，不受内核版本限制，用户无需在本地配置任何 eBPF 相关环境。
- `隔离性`：eBPF 程序的加载和执行，以及用户态的数据处理流程应该安全可靠。它们应该能作为可观测性插件在大型应用中使用，而不会影响其他项目本身。
- `跨语言`：应允许各种语言背景的开发者（C、Go、Rust、Java、TypeScript 等）使用他们熟悉的语言编写 eBPF 用户态程序，无需学新的语言；
- `轻量级`：包的数量和大小尽量小，启动速度尽可能快，本地安装的二进制尽可能小，不需要其他依赖；

包管理器是一个命令行工具，前端是一个网页，二者可以完全独立运行，不存在依赖关系。只是前端界面中有命令行工具的相关介绍文档，以及运行 eBPF 程序的一行命令。

对于编写 eBPF 代码的新手来说，应该可以屏蔽底层的实现方式，用户态如果需要编写一些代码的话，也应当是用他们熟悉的语言，不需要了解底层的编译流程。

## 项目实现细节梳理

以下是一些可能的用例，更细节的部分之后在 OpenEuler eBPF SIG 上和大家详细沟通和讨论具体的方案，也许可以把 btfhub 的相关内容一起集成进来。

### GitHub eBPF 软件编写模板：轻松构建 eBPF 项目和开发环境，一键在线编译运行 eBPF 程序

这是目前 eunomia-bpf 社区已经提供的内容，我们准备了一系列 GitHub 模板，以便您快速启动一个全新的eBPF项目。只需在GitHub上点击 `Use this template` 按钮，即可开始使用。

- <https://github.com/eunomia-bpf/libbpf-starter-template>：基于 C 语言和 libbpf 框架的eBPF 项目模板
- <https://github.com/eunomia-bpf/cilium-ebpf-starter-template>：基于 Go 语言和cilium/框架的的 eBPF 项目模板
- <https://github.com/eunomia-bpf/libbpf-rs-starter-template>：基于 Rust 语言和libbpf-rs 框架的 eBPF 项目模板
- <https://github.com/eunomia-bpf/eunomia-template>：基于 C 语言和 eunomia-bpf 框架的eBPF 项目模板

这些启动模板包含以下功能：

- 一个 Makefile，让您可以一键构建项目
- 一个 Dockerfile，用于为您的 eBPF 项目自动创建一个容器化环境并发布到 Github Packages
- GitHub Actions，用于自动化构建、测试和发布流程
- eBPF 开发所需的所有依赖项

> 通过将现有仓库设置为模板，您和其他人可以快速生成具有相同基础结构的新仓库，从而省去了手动创建和配置的繁琐过程。借助 GitHub 模板仓库，开发者可以专注于项目的核心功能和逻辑，而无需为基础设置和结构浪费时间。更多关于模板仓库的信息，请参阅官方文档：<https://docs.github.com/en/repositories/creating-and-managing-repositories/creating-a-template-repository>

当您使用上述 eBPF 项目模板中的一个创建了一个新仓库时，您可以使用 GitHub Codespaces 轻松地设置和启动一个在线开发环境。

接下来，可以将这些模板进一步完善，并且迁移到 openEuler 仓库中，以便更多的人可以使用。

### Docker Hub 管理模式

1. 为 eBPF Hub 提供一个较为完善的前端界面，包含首页和项目列表、项目详情页面等，可以供使用者浏览对应的 eBPF 程序/应用插件/工具的信息，选择希望使用的软件包。
2. 使用 Docker 或者 OCI 存储打包现有的 eBPF Hub 的内容，存储到 OCI 镜像仓库，可以在本地使用命令行工具一键拉取并使用。

### 角色 1：普通用户/user

首先，我们有一个开发人员的用例，他想使用 ebpf 二进制文件或者程序，但不知道如何/在哪里找到它:

直接运行

```console
$ ecli run opensnoop                                                     # 使用一个名字直接跑起来，如果本地没有，就去网上对应的 repo 下载
running and waiting for the ebpf events from perf event...
$ ecli run opensnoop:latest                                              # 使用一个名字和版本号
running and waiting for the ebpf events from perf event...
$ ecli run https://github.com/ebpf-io/raw/master/examples/opensnoop/app.wasm # 使用一个http API
running and waiting for the ebpf events from perf event...
$ ecli run ./opensnoop.bpf                                               # 使用一个本地路径
running and waiting for the ebpf events from perf event...
$ ecli run sigsnoop -h                                                  # 带参数
Usage: sigsnoop [-h] [-x] [-k] [-n] [-p PID] [-s SIGNAL]
Trace standard and real-time signals.


    -h, --help  show this help message and exit
    -x, --failed  failed signals only
    -k, --killed  kill only
    -p, --pid=<int>  target pid
    -s, --signal=<int>  target signal
```

run 命令实际上包含了 pull 命令，如果本地没有对应的 ebpf 文件，就会去网上下载，如果本地有，就直接使用本地的：

```console
$ ecli pull opensnoop
$ ecli run opensnoop
running and waiting for the ebpf events from perf event...
```

或者他/她也可以在网页上进行搜索，然后直接下载（具体查看下章）.

可以切换源，比如从 github 切换到 ecli 静态服务器:

```console
ecli_REPOSITORY=https://ecli.ebpf.io ecli run opensnoop # 从 ecli 静态服务器下载，前缀路径改为 https://ecli.ebpf.io
```

`ecli run opensnoop` 实际上等效为 `ecli run https://github.com/ebpf-io/raw/master/examples/opensnoop/app.wasm`。
`ecli run opensnoop:v1` 实际上等效为 `ecli run https://github.com/ebpf-io/raw/master/examples/tags/v1/app.wasm`。

这一部分是目前 eunomia-bpf 社区已经支持的内容，目前支持 JSON 和 Wasm，为了更方便用户态和内核态一起打包使用，也许可以扩展到通用的 Docker 镜像支持。

### 角色 2：通用 ebpf 数据文件发布者/ebpf developer

我们的第二个角色是一个开发人员，他想要创建一个通用 eBPF/WASM 预编译二进制，并在任何机器和操作系统上分发它，并且动态加载运行。这对于命令行工具或者可以直接在 Shell 中运行的任何东西都很有用，也可以作为大型项目的插件使用。

生成 ebpf 数据文件

```bash
$ ecli init opensnoop  # 生成一个项目模板
init project opensnoop success.
$ cd opensnoop  # 会创建一个新的目录
$ ls # 生成如下一些文件
opensnoop.bpf.c opensnoop.h README.md config.json .gitignore
$ ecli build # 编译
$ sudo ./ecli run app.wasm -h
Usage: opensnoop [-h] [-x] [-k] [-n] [-p PID]
```

发布 ebpf 数据文件（可选：可以不在命令行和网站实现相关内容，使用 Github 等等代码托管平台的 PR 和 CI 完成添加项目）

```bash
$ ecli login
success login
$ ecli build opensnoop:latest
success
$ ecli publish
success
$ ecli push opensnoop:latest # 推送新的文件：
success
```

这一部分关于 OCI 存储的内容 eunomia-bpf 社区已经有一些对应的实践，但还未完全完善关于构建的模板等等部分。

## 进度规划

## 进度规划

根据项目的需求和目标，我们将项目进度规划为两个主要阶段：

### 项目研发第一阶段（07 月 01 日 - 08 月 15 日）：

1. **设计并构建 eBPF 程序托管平台的初步框架**：研发与测试基础功能，例如程序上传、下载、搜索和评论等。
2. **开发包管理器**：实现程序的一键安装、更新和卸载功能，验证包管理器的基本功能。
3. **进行初步的集成测试**：确保托管平台和包管理器可以稳定运行，初步实现对eBPF程序的管理和分发。
4. **编写和完善相关文档**：包括用户手册、开发者指南和API文档等，帮助用户和开发者更好地理解和使用托管平台和包管理器。

### 项目研发第二阶段（08 月 16 日 - 09 月 30 日）：

1. **开发前端界面**：根据用户反馈和需求，设计和实现用户友好的前端界面。
2. **完善 eBPF 程序托管平台**：根据用户反馈和实际需求，添加新的功能，优化现有功能，提高平台的稳定性和可用性。
3. **优化包管理器**：根据用户反馈和实际需求，优化包管理器的功能和性能，提高用户体验。
4. **进行大规模的测试**：进行压力测试，性能测试和兼容性测试，确保托管平台和包管理器可以在各种环境下稳定运行。
5. **完善相关文档**：根据第二阶段的研发情况，更新和完善相关文档。

请注意，以上计划可能会根据项目的实际情况进行调整，接下来我会在 OpenEuler eBPF SIG 上和大家详细沟通和讨论具体的设计方案。
