# 开题报告

各位老师好！我叫郑昱笙，很抱歉因为我感染了新冠还没有康复，目前是完全没有办法用声带发出声音的状态，因此我采用合成的语音和大家交流。我将在本次开题报告中介绍我所研究的主题，以及我所预期采用的方法。

之前我的选题一开始是深海多金属结壳矿产资源实景分析，后来和苏程老师以及吴森森老师沟通过后，打算换成基于 WebAssembly 的云原生时空数据分析 SaaS 平台关键技术研究：以 GPlates 为例，这部分和我自己目前在学校外部做的一些工作有关，因此我也希望把它和毕业设计结合起来。

第一个部分是选题背景和意义，主要介绍了一下软件即服务的概念、无服务器计算技术、WebAssembly, GPlates 软件等相关的技术。

SaaS 指软件即服务 (Software as a Service)，是一种软件提供模式，允许用户通过互联网使用软件而无需在本地安装软件。SaaS 公司通常将软件托管在自己的服务器上，并向用户收费使用。

无服务计算，又称函数计算、函数即服务(FaaS)，是完全依托于云而产生的新型计算模式，它使得我们无需管理服务器，只需专注于业务逻辑，就可以更快构建和部署应用程序。但同时无服务计算也存在一些对应的挑战：例如调用和执行方式带来的冷启动开销：启动容器时间占比过长、Function 之间的调用复杂、性能低下等。

WebAssembly(缩写 Wasm)是基于堆栈虚拟机的二进制指令格式。Wasm为了一个可移植的目标而设计的，可用于编译C/C+/RUST等高级语言，使高性能的客户端和服务器应用程序能够在浏览器上部署和执行，获得即时的可视化和数据分析结果，并减少服务器资源开销。

WASM 不仅可以运行在浏览器上，也可以运行在非web环境下；Serverless 强依赖高度优化的冷启动，WASM 运行时非常适合为下一代无服务器平台提供动力。

GPlates是用于板块构造的互动可视化的桌面软件，通过地质时间操纵地质和古地理特征的重建，交互式地可视化矢量、栅格和体积数据。之前有一些 Python 对应的开发包，但是并没有以 SaaS 方式进行提供的软件或前端模块；

接下来来看一下本研究的目的和意义，主要有两个方面：

为搭建云原生时空数据 SaaS 平台提供技术支持。通过本研究，可以探索评估使用基于 WebAssembly 的无服务器函数计算在加速 GIS 时空数据分析方面的性能提升，并使用 eBPF、RDMA 等技术更进一步提升无服务器函数计算平台的性能，使类似的 SaaS 平台能够更加高效、灵活和可扩展地为用户提供时空数据分析服务，同时也为搭建更多的基于 WebAssembly 的时空数据分析应用提供参考。

以 GPlates 为例，基于 WASM 相关技术为用户提供便捷的 SaaS 时空数据分析服务。通过使用基于 WebAssembly 的无服务器函数计算和云端函数即服务的技术，以及在浏览器中运行复杂数据处理逻辑的能力，可以在浏览器中或云端为用户提供 GPlates 等工具的功能，而无需在本地安装软件或搭建硬件环境，并且可以从云中利用弹性计算和存储资源来扩展应用程序的性能和可用性。通过类似的方式，还可以更轻松地将 GPlates 集成到网站或 web 应用程序中，可以更方便地进行在线协作，因为多个用户可以共享一个 GPlates 实例。

然后是国内外研究现状，第一个部分主要是 GIS 和 WebAssembly 相关的研究，已经有相当多的研究工作在这个方面进行，不过主要集中在浏览器内外的地理数据的处理和可视化方面；第二个部分是使用 WebAssembly 来加速无服务器计算，这部分也有相当多现成的例子，第三个部分是 serverless 本身的一些研究进展以及 serverless 和 GIS 相结合的部分，这部分也有一些现成的例子。

第三个部分是主要内容和技术路线

第一个是主要研究内容，第一个部分比如将 GPlates 对应的功能移植到 WebAssembly 中，并以 SaaS 的方式对外提供服务，保留和之前类似的界面，将对应的分析计算在浏览器中完成；将其对应的 GIS 空间分析功能拆分成多个具体单一的函数或模块，并可在基于 WebAssembly 的函数即服务中独立部署和弹性伸缩运行；

第二个部分是使用 RDMA、 eBPF 等技术，探索和尝试提升基于 WebAssembly 的无服务器函数计算在 GIS 时空数据分析方面的性能，并通过实验评估 WebAssembly 在 GIS 时空数据分析方面的性能提升。

GPlates 是用 C++ 编写的，使用 OpenGL 来渲染其3D地球仪和2D地图视图。它使用Qt作为GUI框架。Boost C++库也被广泛使用。其他库包括GDAL、CGAL、proj、qwt 和 GLEW。

浏览器前端 GUI 框架部分还是使用 QT 来完成，并编译到 WebAssembly 中，在浏览器中运行；
渲染和可视化部分：OpenGL 的 WebAssembly 编译目标；
其他大部分库都可以直接迁移到 WebAssembly 中，并在浏览器前端中运行。

Serverless 运行时：Faasm:  High-performance stateful serverless runtime based on WebAssembly
我们希望尽可能把所有的业务逻辑，包含其他一些登录模块等，使用 FaaS 的形态进行开发，不使用传统的有服务器架构，然后使用 S3 或对象存储服务进行数据存储；

接下来是可行性分析，本次工作主要的工作量集中在两个方面，一个是使用 C++ 移植和编写对应的前端 WebAssembly 代码，并进行逻辑拆分以便在 FaaS 平台上执行；所有的依赖库之前均有编译到 WASM 的前置工作，且 GPlates 本身不存在大量的平台依赖逻辑，因此完全可行；另一方面是对基于 WebAssembly 的无服务器计算平台的改进和增强，这一部分之前也有相当多的工作和论文基于其他类型的无服务器计算平台完成，因此也有迹可循。

接下来是进度安排和预期目标，和之前上面描述的差不多；
