# LMP 可视化文档组织设计

## 背景

LMP 项目目标：

- 面向 eBPF 初学者和爱好者，提供 eBPF 学习资料、程序/项目案例，构建 eBPF 学习社区
- 成为 eBPF 工具集散地，我们相信每一位 eBPF 初学者和爱好者都有无限的创造力
- 孵化 eBPF 想法、相关工具、项目

个人感觉 LMP 当前可能存在的一些问题：

- Supermarket 里面每个子项目的文档都是独立的，目前还没有很好的整合起来；
- 如果需要查找 LMP 中某个功能是由什么工具实现的，使用什么框架开发的较为困难：比如查找哪个工具能实现比较好的对 HTTP HTTP2 协议的追踪，或者查找 libbpf 写的工具有哪些，目前没有一个很好的组织目录；
- 存在非常多而且复杂的用户态可视化、展示方案，有许多套系统提供可视化的实现并且有多种语言混合，缺乏展示标准、难以进行整合；
- 由于上述情况，可能会存在一些重复的无意义的劳动和人力浪费，比如让开发 eBPF 程序功能的人需要操心可视化的整合方式的情况，没有一个可视化的标准数据格式；
- 作为开源项目，缺少一个提供贡献的指导手册，虽然参与开源的成本较低（把项目上传就行），但是项目的复杂度、混乱度可能会随之上升；
- 项目目录缺乏整合和组织，虽然已经有同学在努力了；

核心：

- 对于初学者和爱好者，项目本身的可理解性不够强；
- 对于使用者而言，使用项目中工具的成本比较高；

同时还可以存在一些其他的需求：

- 市面上有各种各样的 eBPF 小工具，有很多重复性的功能，但并没有一个很好的索引和组织方式，比如如果我想做一个新的、对于某个子系统进行分析的工具，我并不知道我有哪些资料可以参考；
- 大型 eBPF 商业项目虽然功能完善，但是可理解性并不好，对于初学者来说直接阅读源代码困难；
- 操作系统可视化教学方向：
  - 存在不少相关的动画、课件、图表，但是难以设计和真实的操作系统相结合的可视化实验，而 eBPF 提供了这种可能；
- 其他（待补充）

## 一个可能的解决方案

基础思路：

1. 从 LMP 的文档出发，整理形成一个文档网站，提供对所有 eBPF 工具的介绍和索引，也提供更多关于内核介绍、eBPF 介绍的文章的索引功能；
2. 对 LMP 本身的开发提供帮助：对于一个由非常多小工具组成的开源项目，需要提供一个框架来帮助规范开发方式，包括提供标准的可视化、使用方式、数据格式、文档和代码结构等等；可以通过网站目录组织起来，进行索引和可视化；先确保索引中存在，再进行开发（可视化驱动开发或索引驱动开发？）
3. 提供对操作系统的可视化教学帮助，通过 eBPF 让初学者整体地、动态地、可视化地理解内核；

呈现效果：

1. 主页提供一个操作系统模块的全景地图，例如：

![bcc](../img/bcc_tracing_tools_2019.png)

或者

![kd](../img/kernel_diagram.png)

其中每个模块都是可以点击的超链接，或者可以放大缩小的地图，可以看到其中有哪些子模块；

2. 点击后进行弹窗，或者放大之后，可以看到该模块的详细信息，有哪些子模块、重要函数等等：

- 子模块可以使用类似数据流图或者状态转换等图表组织起来；
- 把每个 eBPF 程序的名称和链接放在子模块的图表的对应位置，点击即可查看 eBPF 程序的详细资料或在线编辑 eBPF 程序、在线运行，查看输出并进行简单的 grafana、prometheus 等的存储和可视化；也可以点击即跳转到下载运行的界面，或者在本地部署一键运行；

核心思路：通过操作系统的整体图表，以地图的方式来进行 LMP 中 eBPF 程序的索引和可视化、在线运行或者下载运行，把各个子模块以地图的方式有机地组合起来；

3. 进行更进一步地可视化，例如：

- 通过 eBPF 展示数据流动或状态转换，例如点击进入进程调度相关页面之后
  - 通过 eBPF 在前端展示出进程的几个状态，比如运行、阻塞等等之间的转换；
  - 展示网络协议栈中每一层的数据流流动；
  - 展示文件系统的各种操作；
- 通过 eBPF 对正在运行的内核进行 debug 和动态插桩和追踪；

## 怎样开始做

1. 最开始的阶段，例如在前端把这张图画出来（页面1）：

![bcc](../img/bcc_tracing_tools_2019.png)

2. 把每个框框变成一个按钮或者超链接，点击就能打开一个新的窗口或者跳出来弹窗或者放大该模块，显示更细粒度的子模块，把 eBPF 工具的链接标注在子模块上面：

（我建议使用弹窗或者放大缩小的模式）

3. 点击 eBPF 工具名称即可查看对对应的 eBPF 工具的功能简介和文档页面（页面2）；在这个页面可以点击链接跳转到在线运行界面（页面4），也可以下载 json 本地运行；提供 prometheus 之类的可视化存储；类似 https://bolipi.com/ebpf/home/online 现在做的；
4. 点击子模块本身或者别的详解按钮即可以跳转到更详细的对该模块的介绍和可视化页面，里面提供一些可视化的数据流图或者状态转换图，提供各种各样的文档链接（页面3）；这部分具体内容可以不急着填充，可以先把框架搭起来；

我觉得上面说的这个框架搭起来工作量应该不大，把初始框架搭起来之后就会比较好办：

一点小建议：

- 整个可视化索引项目是一个纯前端界面，不需要后端和数据库（在开始启动阶段最简单）；需要在线运行和在线可视化的部分应该跳转到另外一个网页去运行（比如 bolipi 那个运行界面），或者提供编译好的 package.json 让用户下载到本地运行；
- 文档应该尽可能复用开源的框架，例如 hexo 等等，其他 eBPF 小工具的贡献者只需要把文档提 PR 到正确的目录，然后在大地图里面添加链接就行；eBPF 小工具的介绍页面，或者其他内核博客文章使用 markdown 格式编写；
- 使用 Github pages 或者别的什么 CI 进行自动构建和部署；
- 它可以是 linuxkerneltravel 社区下面的一个独立的项目，不仅包含 LMP 的内容，也可以包含别的文档和工具；
- 建议把这个页面的前端和后端组件独立出来，不放在 bolipi 下面，方便维护和多个项目复用（应该把 vue 的组件代码复制出来单独放个仓库就行了，后端好像也不是很多）；

关于使用的 eBPF 程序：

- 仅包含内核态和用户态代码（这是最方便、最容易让初学者上手和理解的）；
- 如果上面做不到的话，可以先不提供在线可视化和演示，但是应该需要把文档和链接先放到地图上来，作为索引；
- 可以先从 https://github.com/iovisor/bcc/tree/master/libbpf-tools 移植到 eunomia-bpf 的代码来，应该不难，也可以很好地填充第一张地图；
- 在线运行界面需要允许跳转的时候接受一些参数，比如 eBPF 程序源代码和配置信息；

## 参考资料

README 驱动开发

- <https://tom.preston-werner.com/2010/08/23/readme-driven-development.html>

BCC 的组织方式和 README

- https://github.com/iovisor/bcc

BCC 的贡献手册：

If you want to contribute scripts to bcc, or improve your own bcc programs, great! Please read this first.

- https://github.com/iovisor/bcc/blob/master/CONTRIBUTING-SCRIPTS.md

Linux Kernel Diagram

- https://makelinux.github.io/kernel/map/
