#! https://zhuanlan.zhihu.com/p/600638396
# eunomia-bpf：展望 2023，让 eBPF 插上 Wasm 的翅膀

回望过去的 2022 年，有两项技术备受瞩目：eBPF 和 WebAssembly。

## eBPF: 全新的可能性

eBPF 是一项革命性的技术，起源于Linux内核，可以在操作系统的内核中运行沙盒程序。它被用来安全和有效地扩展内核的功能，而不需要改变内核的源代码或加载内核模块。

过去一年中，可观测技术得到了极大关注，也被 Gartner 列为 2023 年十大战略技术趋势之一。eBPF 本身是对传统观测能力一个非常好的补充，在对内核无侵入的前提下，它通过动态地向内核中插入一段自己的代码，实现定义监控及跟踪等多种多样的能力。同时， eBPF 也促进了网络，安全性，应用程序配置跟踪和性能故障排除等等领域的新一代工具的开发，这些工具不再依赖现有的内核功能，而是在不影响执行效率或安全性的情况下主动重新运行。

如今， eBPF 被广泛应用在云原生、可观测、性能调优、安全、硬件加速等领域，并且其应用场景还在快速扩展，各种场景基于 eBPF 技术的创新项目呈现井喷现象，对于操作系统社区而言，eBPF 技术带来了一个全新的可能性以及广阔的天地， eBPF 的时代已然来临。

过去的 eBPF summit 2022 中，《The future of eBPF in the Linux Kernel》展望了 eBPF 相关技术的发展方向，具体的演进方向可能包含几个方面：

- 更完备的编程语义支持：当前 eBPF 的编程能力存在一些局限性（比如不支持变量边界的循环，指令数量受限等），未来希望能进一步提供图灵完备的编程能力，增强 eBPF 的循环、内存分配等多种语言特性。
- 更强的安全性：支持类型安全，增强运行时 Verifier，希望 BPF 也能提供媲美 Rust 的安全编程能力，以及尝试有没有可能结合 Rust 和 BPF 的特性，提供更进一步的、同时保证可移植和安全性的内核功能。
- 更广泛的移植能力：增强 CO-RE，加强 Helper 接口可移植能力，实现跨体系、平台的移植能力。
- 更强的内核可编程能力：支持访问/修改内核任意参数、返回值，实现更强的内核编程能力，甚至使用 BPF 来帮助构建和增强内核本身的安全性。

## Wasm: 引领下一代计算范式

相对于 eBPF 主要关注于内核态或者和内核相关的应用，用户态的 WebAssembly 也成为了 2022 年新的焦点。

WebAssembly（简称 Wasm）是一个自诞生之日起就充满潜力的技术，一开始为了一个可移植的目标而设计的一种类似汇编字节码的指令格式标准，可用于编译C/C+/RUST等高级语言，使客户端和服务器应用程序能够在浏览器上部署；时至今日，WebAssembly 正在沿着其名字中 Web 和 Assembly 两个领域之外的方向发展，使用与 Wasm 兼容的运行时，Wasm 文件可以在客户端和服务器端执行，从 "JavaScript 杀手" 到 "云计算的下一个前沿方向" 几乎覆盖了全部新兴领域，同时在从云计算、serverless 向边缘计算渗透，Wasm 已经远远超出了起作为第四种 Web 标准语言的角色。甚至重新定义了应用软件的开发模式，正逐渐接近其 “一次编写，随处运行” 的愿景。

Wasm 有几个关键的设计目标使其出生开始就自带令人亮眼的关注：

- 可移植：Wasm 被设计为针对低级虚拟机架构，其指令由物理机单独翻译成机器代码。这意味着 Wasm 二进制文件最终可以在各种操作系统和芯片架构上运行 —— 无论是在运行 X86 笔记本电脑的浏览器中，还是在内部或云端的服务器上，在移动设备、物联网设备上等等。
- 多语言：因为 Wasm 是一个编译目标，用于编程模块的具体语言并不重要，重要的是是否有支持将该语言编译到 Wasm。开发人员可以灵活地使用多种语言（如 C、C++、Rust、凹语言等）来构建二进制文件，并享受 Wasm 带来的红利。
- 轻量和高效：作为一个低级别的二进制指令格式，只需要较少的操作来将 Wasm 翻译成优化的机器代码。
- 安全：Wasm 目标之一是安全，它在一个沙盒环境中执行，对主机运行时没有初始可见性。这意味着对系统资源（如文件系统，硬件等）的访问是受限制的，除非明确导入了对应的函数以支持。因此 Wasm 极大限制了攻击面，实现了多租户环境中不受信任的代码安全受限地执行。

过去的 2022 年 Wasm 取得了不少激动人心的成就，许多新的 Wasm 初创公司涌现，老牌云服务商和公司宣布支持 Wasm，字节码联盟推出了许多新的 Wasm 标准，CNCF主办了两次 WasmDay 活动，而 Wasm 最大的用户之一 Figma 被 Adobe 以惊人的 200 亿美元收购。对于 WebAssembly 而言，2023 年很有可能也会是爆发的一年：

- 组件模型描述了Wasm二进制文件相互交互的方式，正在迅速成熟，已经出现了参考实现。开发人员可以声明他们的应用程序需要哪些组件，或者更抽象地说，他们的应用需要哪些功能（而不是用他们首选的源语言查找库），然后Wasm运行时可以代表用户组装正确的组件集。2023 年将是组件模型开始重新定义我们如何编写软件的一年。
- Wasm改变了无服务器环境的潜力。由于几乎即时的启动时间、较小的二进制文件大小以及平台和架构中立性，Wasm二进制文件可以用运行当今无服务器基础设施所需的一小部分资源来执行。
- 2022年底，OCI Registry工作组宣布了一种存储容器镜像以外的其他内容的官方方式。这可能包括Helm图表、照片或Wasm应用程序。这个新功能被称为“工件存储”。
- 所有大型编程语言都将得到Wasm支持：Wasm GC提案很可能在 2023 年初就能可用并得到支持，因此 Kotlin 和 Dart 将很快发布Wasm编译器，Java 也很可能将成为最流行的 Wasm 开发语言。

## Coolbpf + eunomia-bpf = eunomia-lcc

在过去的一年中，阿里云龙蜥社区系统运维SIG（Special Interest Group） 正式开源了 Coolbpf 项目。Coolbpf 以 CO-RE（Compile Once-Run Everywhere）为基础实现，保留了资源占用低、可移植性强等优点，融合了BCC动态编译特性，通过远程服务能力，极大简化开发编译和运行效率，适合在生产环境批量部署应用。Coolbpf 还支持在没有 eBPF 特性的低内核版本上，通过提供的 eBPF 驱动，帮助它安全的在低版本上运行，从内核态和批量部署两个角度充分增强了 eBPF 程序"一次编译，到处运行” 的能力。

eunomia-bpf 也是一个结合 Wasm 的通用、轻量级、多语言的下一代 eBPF 开发框架/组件库，2022 年下半年在龙蜥社区 `eBPF 技术探索 SIG` [3] [5] 发起并孵化。eunomia-bpf 包含一个运行时和编译工具链，主要关注于改进 eBPF 程序用户态的开发和使用体验，主要有三个特性：

1. 只需编写内核态代码即可运行 eBPF 程序，内核态前端完全兼容 bcc、原生 libbpf 等多种语法，可以降低 eBPF 开发的学习成本，提高开发效率；
2. 编译工具链和运行时完全分离，保证不同版本编译工具链和运行时之间的兼容性，以 CO-RE（一次编译、到处运行）的方式加载，降低部署和使用的资源消耗；还可以让 BCC/bpftrace 类型的代码也支持 AOT 编译，在加载的的时候不依赖 llvm 等库，同时保留 bpftrace 类似脚本一样的简单使用方式；
3. 用户态也支持多种语言，例如 C++/C/Rust 等，可以使用多种语言在 Wasm 中开发 eBPF 的用户态程序，并且以 Wasm 模块，或者 JSON/YAML 配置文件的方式分发和动态加载 eBPF 程序，同时以 Wasm OCI 镜像的形式存储和管理任意包含用户态和内核态的 eBPF 应用。

eunomia-bpf 希望成为一个以类库或者松散组合的框架的方式提供，在编译构建和分发运行 eBPF 程序方面做更多的探索工作，让其他公司和个人，想要基于自己的内核态 ebpf 基础设施，搭建一个类似的用户态开发运行环境，或者完整的开发平台、插件运行时，变得更容易很多。

在 2022 年底，我们尝试将 Coolbpf 和 eunomia-bpf 结合起来，借助 Coolbpf 提供的低内核版本支持的内核态基础设施，以及批量部署应用的能力，以及 eunomia-bpf 提供的结合 Wasm 的用户态开发、分发特性，在 Coolbpf 的大框架下创建了一个新的 eBPF 用户态开发库：[eunomia-lcc](https://gitee.com/anolis/coolbpf/pulls/17)，希望让 Coolbpf 也能：

- 在编写 eBPF 程序或工具时只编写内核态代码，就能自动获取内核态导出信息，自动生成命令行参数、直方图输出等；
- 使用 Wasm 进行用户态交互程序的开发，在 Wasm 虚拟机内部控制整个 eBPF 程序的加载和执行，以及处理 eBPF 上报的数据；
- 可以将预编译的 eBPF 程序打包为通用的 JSON 或 Wasm 模块，跨架构和内核版本进行分发，无需重新编译即可动态加载运行。

同时还能保留 Coolbpf 的低版本兼容、BTF 自动获取、远程编译等特性，让 eBPF 程序的开发更加简便易行。

展望未来，eunomia-bpf 的团队在 2023 年也希望尝试探索、改进、完善 eBPF 程序开发、编译、打包、发布、安装、升级等的流程和工具、SDK，并积极向上游社区反馈，进一步增强 eBPF 的编程体验和语言能力；以及更进一步地和 WebAssembly 相结合，在可观测性、serverless、可编程内核等诸多方面做更多的探索和实践，朝着图灵完备和更完善的语言支持迈进。

## 参考资料

1. Wasm 将引领下一代计算范式 [译]：<https://www.oschina.net/news/214580>
2. WebAssembly：2023年的5个预测: <https://www.sohu.com/a/626985661_121119003>
3. eBPF 技术探索 SIG 主页： [https://openanolis.cn/sig/ebpfresearch](https://openanolis.cn/sig/ebpfresearch)
4. Coolbpf 项目开源仓库: <https://gitee.com/anolis/coolbpf>
5. eunomia-bpf 龙蜥社区镜像仓库：[https://gitee.com/anolis/eunomia](https://gitee.com/anolis/eunomia)
6. eunomia-bpf Github 仓库：<https://github.com/eunomia-bpf/eunomia-bpf>
7. 当 Wasm 遇见 eBPF：使用 WebAssembly 编写、分发、加载运行 eBPF 程序 | 龙蜥技术: <https://developer.aliyun.com/article/1050439>
8. 2023，可观测性需求将迎来“爆发之年”？<https://36kr.com/p/dp2063589382737542>
