#include "graphics.h"
#include "extgraph.h"
#include "genlib.h"
#include "simpio.h"
#include "conio.h"
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>

#include <windows.h>
#include <olectl.h>
#include <stdio.h>
#include <mmsystem.h>
#include <wingdi.h>
#include <ole2.h>
#include <ocidl.h>
#include <winuser.h>

#define deltax 0.03
#define deltay 0.03

#define TIMER_BLINK500  1     /*500msʱ¼־*/
#define TIMER_BLINK1000 2     /*1000msʱʱ־*/

const int mseconds500 = 500;   
const int mseconds1000 = 1000; 

static double ccx = 1.0, ccy = 1.0;/*Բ*/
static double radius = 0.05; /*Բ뾶*/

static char text[100]; /*ַ*/
static int textlen = 0;/*ַ*/
static double textx, texty; /*ַʼλ*/

static bool isBlink = FALSE;   /*Ƿ˸־*/
static bool isDisplayText = FALSE; /*ַʾ־*/
static bool isDisplayCircle = TRUE; /*Բʾ־*/

void DrawCenteredCircle(double x, double y, double r);/*Բ*/
/*жϵ(x0,y0)ǷھΰΧ(x1, y1) --> (x2, y2)Χ*/
bool inBox(double x0, double y0, double x1, double x2, double y1, double y2);

void KeyboardEventProcess(int key,int event);/*Ϣص*/
void CharEventProcess(char c);/*ַϢص*/
void MouseEventProcess(int x, int y, int button, int event);/*Ϣص*/
void TimerEventProcess(int timerID);/*ʱϢص*/

void Main() /*ʼִһ*/
{
    InitGraphics();        	
	//InitConsole();
	
	registerKeyboardEvent(KeyboardEventProcess);/*עϢص*/
	registerCharEvent(CharEventProcess);/*עַϢص*/
	registerMouseEvent(MouseEventProcess);/*עϢص*/
	registerTimerEvent(TimerEventProcess);/*עᶨʱϢص*/

	//printf("hello");

	SetPenColor("Red"); 
    SetPenSize(1);
    
    ccx = GetWindowWidth()/2;
    ccy = GetWindowHeight()/2;

    startTimer(TIMER_BLINK500, mseconds500);/*500msʱ*/
    startTimer(TIMER_BLINK1000, mseconds1000);/*1000msʱ*/
}

void DrawCenteredCircle(double x, double y, double r)
{	
	StartFilledRegion(1);
    MovePen(x + r, y);
	//DrawLine(r, r);
    DrawArc(r, 0.0, 360.0);
	EndFilledRegion();
}

void KeyboardEventProcess(int key,int event)/*ÿϢҪִ*/
{
 	 double oldradius;
 	 
     switch (event) {
	 	case KEY_DOWN:
			 switch (key) {
			     case VK_UP:/*UP*/
			         SetEraseMode(TRUE);/*ǰһ*/
                     DrawCenteredCircle(ccx, ccy, radius);
					 ccy += deltay;
					 SetEraseMode(FALSE);/*µ*/
                     DrawCenteredCircle(ccx, ccy, radius);
                     break;
			     case VK_DOWN:
			         SetEraseMode(TRUE);
                     DrawCenteredCircle(ccx, ccy, radius);
					 ccy -= deltay;
					 SetEraseMode(FALSE);
                     DrawCenteredCircle(ccx, ccy, radius);
                     break;
			     case VK_LEFT:
			         SetEraseMode(TRUE);
                     DrawCenteredCircle(ccx, ccy, radius);
					 ccx -= deltax;
					 SetEraseMode(FALSE);
                     DrawCenteredCircle(ccx, ccy, radius);
                     break;
			     case VK_RIGHT:
			         SetEraseMode(TRUE);
                     DrawCenteredCircle(ccx, ccy, radius);
					 ccx += deltax;
					 SetEraseMode(FALSE);
                     DrawCenteredCircle(ccx, ccy, radius);
                     break;
			     case VK_F1:
  					 SetEraseMode(TRUE);
                     DrawCenteredCircle(ccx, ccy, radius);
		 	         SetPenSize(GetPenSize()+1);
					 SetEraseMode(FALSE);
                     DrawCenteredCircle(ccx, ccy, radius);
					 break;
			     case VK_F2:
  					 SetEraseMode(TRUE);
                     DrawCenteredCircle(ccx, ccy, radius);
		 	         SetPenSize(GetPenSize()-1);
					 SetEraseMode(FALSE);
                     DrawCenteredCircle(ccx, ccy, radius);
                     break;
			     case VK_F3:
			     case VK_PRIOR:
	 	     		 SetEraseMode(TRUE);
                     DrawCenteredCircle(ccx, ccy, radius);
                     radius += 0.1;
					 SetEraseMode(FALSE);
                     DrawCenteredCircle(ccx, ccy, radius);
                     break;
			     case VK_F4:
			     case VK_NEXT:
		 	         SetEraseMode(TRUE);
                     DrawCenteredCircle(ccx, ccy, radius);
                     radius -= 0.1;
					 SetEraseMode(FALSE);
                     DrawCenteredCircle(ccx, ccy, radius);
                     break;
			     case VK_F5:
                     break;
			     case VK_F6:
                     break;
			     case VK_F9:
			         InitConsole();
			         oldradius = radius;
			         printf("Input radius: ");
			         radius = GetReal();
			         FreeConsole();
  					 SetEraseMode(TRUE);
                     DrawCenteredCircle(ccx, ccy, oldradius);
					 SetEraseMode(FALSE);
                     DrawCenteredCircle(ccx, ccy, radius);
                     break;
			     case VK_ESCAPE:/*ù˸־*/
                     isBlink = !isBlink;
                     if (isBlink ) {
						startTimer(TIMER_BLINK500, mseconds500);
						startTimer(TIMER_BLINK1000, mseconds1000);
                     } else {
						cancelTimer(TIMER_BLINK500);
    					cancelTimer(TIMER_BLINK1000);
					 }
                     break;
			 }
			 break;
		case KEY_UP:
			 break;
	 }	 
}

void CharEventProcess(char c)
{
 	 static char str[2] = {0, 0};

     switch (c) {
       case '\r':  /* ע⣺سﷵصַ'\r''\n'*/
		   isDisplayText = TRUE;/*ַʾ־*/
           textx = GetCurrentX()-TextStringWidth(text);/*ַʼ*/
		   texty = GetCurrentY();
   	 	   break;
 	   case 27: /*ESC*/
 	       break;
      default:
	  	   str[0] = c;/*γɵǰַַ*/
	 	   text[textlen++] = c;/*ǰַ뵽ַ*/
	 	   text[textlen] = '\0';
	 	   DrawTextString(str);/*ǰַλӦ*/
	 	   break;
    }
}

bool inBox(double x0, double y0, double x1, double x2, double y1, double y2)
{
	return (x0 >= x1 && x0 <= x2 && y0 >= y1 && y0 <= y2);
}

void MouseEventProcess(int x, int y, int button, int event)
{
 	 static bool isMoveCircle = FALSE;/*ƶԲ־*/
 	 static bool isMoveText = FALSE; /*ƶı־*/ 
	 static bool isChangeRadius = FALSE;/*ıԲ뾶־*/
     static double r = 0.2;
 	 static double omx = 0.0, omy = 0.0;
     double mx, my;

 	 mx = ScaleXInches(x);/*pixels --> inches*/
 	 my = ScaleYInches(y);/*pixels --> inches*/

     switch (event) {
         case BUTTON_DOWN:
   		 	  if (button == LEFT_BUTTON) {
				 if (inBox(mx, my, textx, textx+TextStringWidth(text), 
				                           texty, texty+GetFontHeight())){
				  	  isMoveText = TRUE;
				  }else
					 isMoveCircle = TRUE;
			  } else if (button == RIGHT_BUTTON) {
					  isChangeRadius = TRUE;
			  }
		      omx = mx; omy = my;
              break;
    	 case BUTTON_DOUBLECLICK:
			  break;
         case BUTTON_UP:
  		 	  if (button == LEFT_BUTTON) {
  		 	  	isMoveCircle = FALSE;
  		 	  	isMoveText = FALSE;
  		 	  }else if (button == RIGHT_BUTTON) {
  		 	  	isChangeRadius = FALSE;
  		 	  } 
              break;
         case MOUSEMOVE:
			  if (isMoveCircle) {
                  //SetEraseMode(TRUE);/*ǰһ*/
                  //DrawCenteredCircle(ccx, ccy, radius);
				  ccx = mx;
				  ccy = my;
				  omx = mx;
				  omy = my;
				  //SetEraseMode(FALSE);/*µ*/
                  DrawCenteredCircle(ccx, ccy, radius);
			  } else if (isChangeRadius) {
                  SetEraseMode(TRUE);/*ǰһ*/
                  DrawCenteredCircle(ccx, ccy, radius);
				  radius += mx - omx;
				  omx = mx;
				  omy = my;
				  SetEraseMode(FALSE);/*µ*/
                  DrawCenteredCircle(ccx, ccy, radius);
			  } else if (isMoveText) {
					SetEraseMode(TRUE);
	          		MovePen(textx, texty);/*ʼλ*/
					DrawTextString(text);
	 				textx += mx - omx;
					texty += my - omy;
					omx = mx;
					omy = my;				
					SetEraseMode(FALSE);
					MovePen(textx, texty);/*ʼλ*/
					DrawTextString(text);
					break;
			  }
              break;
     }	
}

void TimerEventProcess(int timerID)
{
      bool erasemode;

	  switch (timerID) {
	    case TIMER_BLINK500: /*500ms˸ʱ*/
		  if (!isBlink) return;
	      erasemode = GetEraseMode();
          MovePen(textx, texty);/*ʼλ*/
		  SetEraseMode(isDisplayText);/*ݵǰʾ־ʾַ*/
		  DrawTextString(text);/*ǰλûַ*/
	      SetEraseMode(erasemode);
		  isDisplayText = !isDisplayText;/*ʾ/ַ*/
		  break;
	    case TIMER_BLINK1000: /*1000ms˸ʱ*/
		  if (!isBlink) return;
	      erasemode = GetEraseMode();
		  SetEraseMode(isDisplayCircle);
          DrawCenteredCircle(ccx, ccy, radius);
	      SetEraseMode(erasemode);
		  isDisplayCircle = !isDisplayCircle;
		  break;
	    default:
		  break;
	  }
}
