## 注记文本模型

空间数据模型分为：

- 矢量模型
- 栅格模型
- 注记文本模型

注记文本模型是GIS的空间数据模型的一种。

### 分类

GIS的注记可以分为以下3类：

- 注记标签 annotation label：
    - 选择要素层中的某个属性值作为标记，附着在各要素的旁边显示，与要素具有正式的连接关系
    - 标签的显示风格与该要素层的文本风格定义一致
    - 在漫游和缩放后按照当前地图比例尺下的最佳位置重叠
- 注记文本 annotation text
    - 独立于要素层的一个文本数据集，由一些有序的格子独立放置的文本元素组成
    - 这些文本元素可能会沿着地理要素的方向、根据某地理要素的范围进行放置，与地理要素无正式连接
    - 例如，地图上用于命名山脉的文本通常就是一个标准注记文本
    - 注记文本的字体大小和位置都是固定的，不受地图视窗漫游与缩放的影像
- 注记尺寸 annotation size
    - 用于标注几何体长、宽、高数值的注记
    - 常用于在地块、房屋的测量等应用
    - ESRI的GeoDatabase也提供了DimensionFeature用于描述注记尺寸类

总结：

> 注记标签中的文字是要素的某个字段属性、其显示与该层的本文风格一致，因此无需额外对其进行定义;
标记文本具有自己地理位置（文本要素的放置方向或范围）和属性（文本要素的文字或显示字样），其将和点、线、多边形一样，是一种类型的要素；
标注尺寸的文本可能来自要素的某属性，但其有自己的显示模式和风格，地理空间数据对其也有相应的定义，但目前标准尚未涉及此部分

### 注记文本模型的存储

- 基于预定义数据类型的文本标注的逻辑模型

- 基于扩展Geometry数据类型的文本标注的逻辑模型

