# 地理空间数据库复习笔记

<!-- TOC -->

- [地理空间数据库复习笔记](#地理空间数据库复习笔记)
  - [Lecture 5 空间扩展E/R图](#lecture-5-空间扩展er图)

<!-- /TOC -->

## Lecture 5 空间扩展E/R图

数据库的设计任务:

- 对某个给定的应用领域，为某一个部门或组织设计出某种数据库管理系统所支持的一个结构合理、使用方便、效率较高的数据库及其应用系统

基本步骤:

- 需求分析阶段：全面了解与分析用户需求，需求分析做的是否充分与准确，决定了构建数据库系统的速度与质量
- 概念结构设计阶段：是整个数据库设计的关键，通过对用户需求进行综合、归纳与抽象，形成一个独立于具体DBMS的概念模型
- 逻辑结构设计阶段：将概念结构转换为某个DBMS所支持的数据模型，对其进行优化
- 物理结构设计阶段：为逻辑数据模型选取一个最适合应用环境的物理结构，使数据库的运行达到某种性能要求，如响应时间、处理频率、存储空间、维护代价等，保证数据库的安全性，如用户权限等
- 数据库实施阶段：运用DBMS提供的数据语言、工具及宿主语言，根据逻辑设计和物理设计的结果建立数据库、编制与调试应用程序、组织数据入库、并进行试运行
- 数据库运行和维护阶段：数据库应用系统经过试运行后即可投入正式运行。在数据库系统运行过程中必须不断地对其进行评价、调整与修改

实体-联系(E-R)数据模型：

- 实体集：是相同类型，即具有相同性质（或属性）的一个实体（现实世界中可区别于所有其他对象的一个“事务”或对象）集合
  - 实体集不必互不相交
  - 实体集通过一组属性来表示，属性是实体集中每个成员所拥有的描述性性质
- 联系集：是相同类型联系（多个实体间的相互关联）的集合，是n≥2个（可能相同的）实体集上的数学关系

关系：

- 实体集之间的关联称为参与，即E1, E2, …参与联系集R，
- E-R模式中的一个联系实例表示现实中实体间的一个关联
- 实体在联系中扮演的功能称为实体的“角色”（role）
- 联系也可以具有描述性属性
- 参与联系集的实体集的数目称为联系集的度（degree）

每个属性都有一个可取值的集合，称为“域”，属性是将实体集映射到域的函数

E-R模型中的属性可以按照如下属性类型来划分：

-	简单和复合属性（姓名分为姓和名）
-	单值和多值属性（多个电话号码）
-	派生属性：由生日派生出年龄，此时生日称为基属性，派生属性的值不储存，而在需要时计算出来

弱实体集：没有足够的属性以形成主码（例子见数据库系统概念，158）

- 弱实体集必须域另一个称作“标识”或者“属主实体集”的实体集关联才能有意义，即弱实体集存在依赖于标识实体集，其联系称为标识性联系
- 弱实体集通过分辨符（若干个属性的集合）来区分实体，也称为部分码
