﻿
// MFCApplication2Dlg.cpp: 实现文件
//

#include "pch.h"
#include "framework.h"
#include "MFCApplication2.h"
#include "MFCApplication2Dlg.h"
#include "afxdialogex.h"
#include "gdal/include/gdal.h"
#include "gdal/include/gdalwarper.h"
#include "gdal/include/gdal_priv.h"
#include "gdal/include/gdal_frmts.h"
#include "gdal/include/ogrsf_frmts.h"
#pragma comment(lib, "gdal/lib/gdal.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// 用于应用程序“关于”菜单项的 CAboutDlg 对话框k

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

	// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持

// 实现
protected:
	DECLARE_MESSAGE_MAP()
public:
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CMFCApplication2Dlg 对话框



CMFCApplication2Dlg::CMFCApplication2Dlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_MFCAPPLICATION2_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMFCApplication2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CMFCApplication2Dlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	
	ON_BN_CLICKED(IDC_BN_LOAD, &CMFCApplication2Dlg::OnBnClickedBnLoad)
	ON_BN_CLICKED(IDC_BN_SMOOTH, &CMFCApplication2Dlg::OnBnClickedBnSmooth)
	ON_BN_CLICKED(IDC_BN_SHARPEN, &CMFCApplication2Dlg::OnBnClickedBnSharpen)
END_MESSAGE_MAP()


// CMFCApplication2Dlg 消息处理程序

BOOL CMFCApplication2Dlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// 将“关于...”菜单项添加到系统菜单中。

	// IDM_ABOUTBOX 必须在系统命令范围内。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// 设置此对话框的图标。  当应用程序主窗口不是对话框时，框架将自动
	//  执行此操作
	SetIcon(m_hIcon, TRUE);			// 设置大图标
	SetIcon(m_hIcon, FALSE);		// 设置小图标

	// TODO: 在此添加额外的初始化代码
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");

	bFileLoad = false;
	pDataRead = NULL;
	pDataWrite = NULL;
	nCols = 6837;
	nRows = 5733;
	_Smooth_Template[0] = 1; _Smooth_Template[1] = 1; _Smooth_Template[2] = 1; 
	_Smooth_Template[3] = 1; _Smooth_Template[4] = 1; _Smooth_Template[5] = 1;
	_Smooth_Template[6] = 1; _Smooth_Template[7] = 1; _Smooth_Template[8] = 1;

	_Sharpen_Template[0] = 1; _Sharpen_Template[1] = -1; _Sharpen_Template[2] = 0; 
	_Sharpen_Template[3] = -1;_Sharpen_Template[4] = 5; _Sharpen_Template[5] = -1;
	_Sharpen_Template[6] = 0; _Sharpen_Template[7] = -1; _Sharpen_Template[8] = 0;

	return TRUE;  // 除非将焦点设置到控件，否则返回 TRUE
}

void CMFCApplication2Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// 如果向对话框添加最小化按钮，则需要下面的代码
//  来绘制该图标。  对于使用文档/视图模型的 MFC 应用程序，
//  这将由框架自动完成。

void CMFCApplication2Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 用于绘制的设备上下文

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// 使图标在工作区矩形中居中
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// 绘制图标
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

//当用户拖动最小化窗口时系统调用此函数取得光标
//显示。
HCURSOR CMFCApplication2Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}





void CMFCApplication2Dlg::OnBnClickedBnLoad()
{
	// TODO: 在此添加控件通知处理程序代码
	GDALDataset* poDataset; // 指向对象数据的指针
		GDALRasterBand * poBand;//指向对象数据单个波段的指针
	poDataset = (GDALDataset*)GDALOpen(".\\band1.tif", GA_ReadOnly);
	if (!poDataset) {
		MessageBox("Open image error！");
		return;
	}
	//申请原始数据内存空间
	pDataRead = (BYTE*)malloc(nCols * nRows);
	if (pDataRead == NULL) {
		MessageBox("Read memory error!");
		return;
	}
	// 申请增强数据内存空间
	pDataWrite = (BYTE*)malloc(nCols * nRows);
	if (pDataWrite == NULL) {
		MessageBox("Write memory error!");
		return;
	}
	//读入原始图像数据
	poBand = poDataset->GetRasterBand(1);
	poBand->RasterIO(GF_Read, 0, 0, nCols, nRows, pDataRead, nCols, nRows, GDT_Byte, 0, 0);
	// 初始化增强数据
	memset(pDataWrite, 0, nCols * nRows);
	// 释放句柄
	GDALClose(poDataset);
	// 标志文件数据载入成功
	bFileLoad = TRUE;
	// 提示文件数据载入成功
	this->SetWindowTextA("Load Image Done!");
}



void CMFCApplication2Dlg::OnDestroy()
{
	CDialogEx::OnDestroy();

	if (pDataRead != NULL) {
		free(pDataRead);
	}
	if (pDataWrite != NULL) {
		free(pDataWrite);
	}
}


void CMFCApplication2Dlg::OnBnClickedBnSmooth()
{
	// TODO: 在此添加控件通知处理程序代码
	if (!bFileLoad) {
		MessageBox("File not load!");
		return;
	}
	int iMinX, iMaxX;
	int iMinY, iMaxY;
	double dTmp;
	// 循化滑动模板
	for (UINT i = 0; i < nCols; i++) {
		for (UINT j = 0; j < nRows; j++) {
			iMinX = (int)i - 1; iMaxX = (int)i + 1;
			iMinY = (int)j - 1; iMaxY = (int)j + 1;
			if (iMinX <0 || iMaxX >= (int)nCols) {
				continue;
			}
			if (iMinY <0 || iMaxY >= (int)nRows) { continue; }
			// 计算模板中心数值
			dTmp = pDataRead[(j - 1) * nCols + (i - 1)] * _Smooth_Template[0]
				+ pDataRead[(j - 1) * nCols + (i - 0)] * _Smooth_Template[1]
				+ pDataRead[(j - 1) * nCols + (i + 1)] * _Smooth_Template[2]
				+ pDataRead[(j - 0) * nCols + (i - 1)] * _Smooth_Template[3]
				+ pDataRead[(j - 0) * nCols + (i - 0)] * _Smooth_Template[4]
				+ pDataRead[(j - 0) * nCols + (i + 1)] * _Smooth_Template[5]
				+ pDataRead[(j + 1) * nCols + (i - 1)] * _Smooth_Template[6]
				+ pDataRead[(j + 1) * nCols + (i - 0)] * _Smooth_Template[7]
				+ pDataRead[(j + 1) * nCols + (i + 1)] * _Smooth_Template[8];

			dTmp = dTmp / 9;

			// 更新中心像元值
			if (dTmp < 0) {
				pDataWrite[j * nCols + i] = 0;
			}
			else if (dTmp > 255) {
				pDataWrite[j * nCols + i] = 255;
			}
			else {
				pDataWrite[j * nCols + i] = (BYTE)dTmp;
			}
		}
	}
	// 保存增强数据至结果文件
	// 创健输出文件的GDAL操作句柄
	GDALDriver* pDriver = NULL;
	pDriver = GetGDALDriverManager()->GetDriverByName("GTIFF");
	GDALDataset* poDatasetW = pDriver->Create(".\\band1_smooth.tif", nCols, nRows, 1, GDT_Byte, NULL);
	if (!poDatasetW) {
		MessageBox("Open write file error!"); return;
	}
	GDALRasterBand* poBandW;
	// 写输出数据
	poBandW = poDatasetW->GetRasterBand(1);
	poBandW->RasterIO(GF_Write, 0, 0, nCols, nRows, pDataWrite, nCols, nRows, GDT_Byte, 0, 0);
	// 释放句柄
	GDALClose(poDatasetW);
	MessageBox("Smooth Done"); 
}


void CMFCApplication2Dlg::OnBnClickedBnSharpen()
{
	// TODO: 在此添加控件通知处理程序代码
	if (!bFileLoad) {
		MessageBox("File not load!");
		return;
	}
	int iMinX, iMaxX;
	int iMinY, iMaxY;
	double dTmp;
	// 循化滑动模板
	for (UINT i = 0; i < nCols; i++) {
		for (UINT j = 0; j < nRows; j++) {
			iMinX = (int)i - 1; iMaxX = (int)i + 1;
			iMinY = (int)j - 1; iMaxY = (int)j + 1;
			if (iMinX <0 || iMaxX >= (int)nCols) {
				continue;
			}
			if (iMinY <0 || iMaxY >= (int)nRows) { continue; }
			// 计算模板中心数值
			dTmp = pDataRead[(j - 1) * nCols + (i - 1)] * _Sharpen_Template[0]
				+ pDataRead[(j - 1) * nCols + (i - 0)] * _Sharpen_Template[1]
				+ pDataRead[(j - 1) * nCols + (i + 1)] * _Sharpen_Template[2]
				+ pDataRead[(j - 0) * nCols + (i - 1)] * _Sharpen_Template[3]
				+ pDataRead[(j - 0) * nCols + (i - 0)] * _Sharpen_Template[4]
				+ pDataRead[(j - 0) * nCols + (i + 1)] * _Sharpen_Template[5]
				+ pDataRead[(j + 1) * nCols + (i - 1)] * _Sharpen_Template[6]
				+ pDataRead[(j + 1) * nCols + (i - 0)] * _Sharpen_Template[7]
				+ pDataRead[(j + 1) * nCols + (i + 1)] * _Sharpen_Template[8];

			// 更新中心像元值
			if (dTmp < 0) {
				pDataWrite[j * nCols + i] = 0;
			}
			else if (dTmp > 255) {
				pDataWrite[j * nCols + i] = 255;
			}
			else {
				pDataWrite[j * nCols + i] = (BYTE)dTmp;
			}
		}
	}
	// 保存增强数据至结果文件
	// 创健输出文件的GDAL操作句柄
	GDALDriver* pDriver = NULL;
	pDriver = GetGDALDriverManager()->GetDriverByName("GTIFF");
	GDALDataset* poDatasetW = pDriver->Create(".\\band1_sharpen.tif", nCols, nRows, 1, GDT_Byte, NULL);
	if (!poDatasetW) {
		MessageBox("Open write file error!"); return;
	}
	GDALRasterBand* poBandW;
	// 写输出数据
	poBandW = poDatasetW->GetRasterBand(1);
	poBandW->RasterIO(GF_Write, 0, 0, nCols, nRows, pDataWrite, nCols, nRows, GDT_Byte, 0, 0);
	// 释放句柄
	GDALClose(poDatasetW);
	MessageBox("Smooth Done");
}
