﻿
// MFCApplication1Dlg.cpp: 实现文件
//

#include "pch.h"
#include "framework.h"
#include "MFCApplication1.h"
#include "MFCApplication1Dlg.h"
#include "afxdialogex.h"

#pragma once
#include "gdal/include/gdal_priv.h"
#include "gdal/include/gdalwarper.h"
#include "gdal/include/ogrsf_frmts.h"
#pragma comment(lib, "gdal/gdal_i.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// 用于应用程序“关于”菜单项的 CAboutDlg 对话框

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持

// 实现
protected:
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedButton1();
	afx_msg void OnBnClickedButton2();
	afx_msg void OnBnClickedButton3();
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
	ON_BN_CLICKED(IDC_BUTTON1, &CAboutDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CAboutDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CAboutDlg::OnBnClickedButton3)
END_MESSAGE_MAP()


// CMFCApplication1Dlg 对话框



CMFCApplication1Dlg::CMFCApplication1Dlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_MFCAPPLICATION1_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMFCApplication1Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CMFCApplication1Dlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
END_MESSAGE_MAP()


// CMFCApplication1Dlg 消息处理程序

BOOL CMFCApplication1Dlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();
	GDALAllRegister();
	CPLSetConfigOption("GDAL_ FILENAME _IS_ _UTF8", "NO");

	// 将“关于...”菜单项添加到系统菜单中。

	// IDM_ABOUTBOX 必须在系统命令范围内。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// 设置此对话框的图标。  当应用程序主窗口不是对话框时，框架将自动
	//  执行此操作
	SetIcon(m_hIcon, TRUE);			// 设置大图标
	SetIcon(m_hIcon, FALSE);		// 设置小图标

	// TODO: 在此添加额外的初始化代码

	return TRUE;  // 除非将焦点设置到控件，否则返回 TRUE
}

void CMFCApplication1Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// 如果向对话框添加最小化按钮，则需要下面的代码
//  来绘制该图标。  对于使用文档/视图模型的 MFC 应用程序，
//  这将由框架自动完成。

void CMFCApplication1Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 用于绘制的设备上下文

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// 使图标在工作区矩形中居中
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// 绘制图标
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

//当用户拖动最小化窗口时系统调用此函数取得光标
//显示。
HCURSOR CMFCApplication1Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CAboutDlg::OnBnClickedButton1()
{
		//打开目标栅格图像
		GDALDataset* pDataset = (GDALDataset*)GDALOpen("C:\\Users\\云微\\Documents\\repo\\vs\\MFCApplication1\\Iknos_pan.tif", GA_ReadOnly);
		if (!pDataset) {
			AfxMessageBox((const wchar_t*)"Open Image Error!!");
			return;
	}
	//读取图像中的投影信息
	CString strProjectionInfo;
	strProjectionInfo = pDataset->GetProjectionRef();
	this ->GetDlgItem(IDC_EDIT1)->SetWindowText(strProjectionInfo);

	double arrGeoTransform[6];
	CString strGeoTransform;
	pDataset->GetGeoTransform(arrGeoTransform);
	strGeoTransform.Format((const wchar_t*)"%.6f, %.6f, %.6f, %.6f, %.6f, %.6f", arrGeoTransform[8],
		arrGeoTransform[1],
		arrGeoTransform[2],
		arrGeoTransform[3],
		arrGeoTransform[4],
		arrGeoTransform[5]);
	this->GetDlgItem(IDC_EDIT2)->SetWindowText(strGeoTransform);
	GDALClose(pDataset);
}


void CAboutDlg::OnBnClickedButton2()
{
		//打开质始图像文件
	GDALDataset* pDataset = (GDALDataset*)GDALOpen("C:\\Users\\云微\\Documents\\repo\\vs\\MFCApplication1\\Iknos_pan.tif", GA_ReadOnly);
	if (!pDataset) {
		AfxMessageBox((const wchar_t*)"Open Image Error!!");
		return;
	}
		//建立用于写出TFF格式文件的驱动
		GDALDriver *pDriver =GetGDALDriverManager()->GetDriverByName("GTIFF");
		if (pDriver)
			AfxMessageBox((const wchar_t* )"Get Driver Errorl!");
		return;
		//在输出路径建立原阳像的拷贝
		CString outPath("C:\\Iknos_pan.tif");
		GDALDataset *pOutDataset;
		pOutDataset =
			pDriver->CreateCopy((const char*)outPath.GetString(), pDataset, FALSE, NULL, NULL, NULL);
			//读取原图的投影字符串并赋值给新图像
		CString strProjectionInfo;
		strProjectionInfo = pDataset->GetProjectionRef();
		pOutDataset->SetProjection((const char*)strProjectionInfo.GetString());

		//(可自由调整)设置新的仿射变换系数并赋值给图像
		double arrGeoTransform[6];
		arrGeoTransform[8] = 180;
		arrGeoTransform[1] = 280;
		arrGeoTransform[2] = 300;
		arrGeoTransform[3] = 400;
		arrGeoTransform[4] =  500;
		arrGeoTransform[5] = 600;
		pOutDataset->SetGeoTransform(arrGeoTransform);
		//再一次读取投影字符串和仿射变换系数，井格其组织成字符串形式显示
		CString strGeoTransform;
		pOutDataset-> GetGeoTransform(arrGeoTransform);
		strGeoTransform.Format((const wchar_t*)"%.6f, %.6f, %.6f, %.6f, %.6f, %.6f", arrGeoTransform[0],
			arrGeoTransform[1],
			arrGeoTransform[2],
			arrGeoTransform[3],
			arrGeoTransform[4],
			arrGeoTransform[5]);
		strProjectionInfo = pOutDataset->GetProjectionRef();
		this->GetDlgItem(IDC_EDIT2)->SetWindowText(strGeoTransform);
		this ->GetDlgItem(IDC_EDIT1) -> SetWindowText(strProjectionInfo);
		GDALClose(pDataset);
		GDALClose(pOutDataset);
		AfxMessageBox((const wchar_t*)"Write Inage Done!");

}


void CAboutDlg::OnBnClickedButton3()
{
	GDALDataset* pDataset = (GDALDataset*)GDALOpen("C:\\Iknos_pan.tif", GA_ReadOnly);
	if (!pDataset) {
		AfxMessageBox((const wchar_t*)"Open Image Error!!");
		return;
	}
	CString strProjectionInfo;
	strProjectionInfo = pDataset->GetProjectionRef();
	this->GetDlgItem(IDC_EDIT1)->SetWindowText(strProjectionInfo);
	char* ori_SRS_WKT = NULL;
	ori_SRS_WKT = _strdup((char*)strProjectionInfo.GetString());
	OGRSpatialReference ogi;
	ogi.importFromWkt(&ori_SRS_WKT);

	double arrGeoTransform[6];
	pDataset->GetGeoTransform(arrGeoTransform);

	//建立转换后的目标空间参考(原图为UTM投影51N分带，目标Gauss为WG584坐标系， 3度带带41的高斯克格投影)
	OGRSpatialReference* destSpatialReferenceGauss;
	destSpatialReferenceGauss = ogi.CloneGeogCS();
	destSpatialReferenceGauss->SetTM(0, 123, 1.0, 41500088, 0);
	OGRCoordinateTransformation* ProjectTransformGauss = OGRCreateCoordinateTransformation(&ogi, destSpatialReferenceGauss);
	if (!ProjectTransformGauss) {
		AfxMessageBox((const wchar_t*)"Create ProjectTransform Gauss Error!!");
		return;
	}
	double projXGauss = 0, projYGauss = 0, projX_TM = 0, projY_TM = 0;

	ProjectTransformGauss->Transform(1, &projXGauss, &projYGauss);
	//在NessageBox中显示转换结果
	CString transformResult;
	transformResult.Format((const wchar_t*)"原始影像(180, 188)位置的点在UTM投影下经纬度为: % .5f, % . 5f; 在高斯克吕格投影下的经纬度为: % .5f, % .5f" ,
		projX_TM, projY_TM, projXGauss, projYGauss);
	AfxMessageBox(transformResult.GetString());
	OGRCoordinateTransformation::DestroyCT(ProjectTransformGauss);
	ProjectTransformGauss = nullptr;

}
