﻿
// 3180102760SX15Dlg.cpp: 实现文件
//

#include "pch.h"
#include "framework.h"
#include "3180102760SX15.h"
#include "3180102760SX15Dlg.h"
#include "afxdialogex.h"


#include "gdal/include/gdal_priv.h"
#include "gdal/include/gdalwarper.h"
#include "gdal/include/ogrsf_frmts.h"
#pragma comment(lib,"gdal/gdal_i.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

//算子的大小
#define structureX 3
#define structureY 3

//循环次数
#define repeatTime 3

CString filePathIn = "";

//算子
BYTE structure[structureX][structureY] = { {1,1,1},{1,1,1},{1,1,1} };

//原点位置
int point[] = { 1,1 };

//输出位置，因为如果用GetDlgItemText好像是要CString，但是之后是路径要char *，所以只能固定位置
const char* erosions = "C:\\Users\\DELL\\Desktop\\形态学\\形态学图像处理\\erosion.tif";
const char *dilations = "C:\\Users\\DELL\\Desktop\\形态学\\形态学图像处理\\dilation.tif";
const char * opens = "C:\\Users\\DELL\\Desktop\\形态学\\形态学图像处理\\open.tif";
const char * closes = "C:\\Users\\DELL\\Desktop\\形态学\\形态学图像处理\\close.tif";


GDALDataset*setDstImg(GDALDataset*poSrcDS, const char*pszDstFile);
GDALDataset*erosion(GDALDataset*pSrcImg, GDALDataset*pDstImg);
GDALDataset*dilation(GDALDataset*pSrcImg, GDALDataset*pDstImg);

// 用于应用程序“关于”菜单项的 CAboutDlg 对话框

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持

// 实现
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CMy3180102760SX15Dlg 对话框



CMy3180102760SX15Dlg::CMy3180102760SX15Dlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_MY3180102760SX15_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMy3180102760SX15Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CMy3180102760SX15Dlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON5, &CMy3180102760SX15Dlg::OnBnClickedButton5)
	ON_BN_CLICKED(IDC_BUTTON6, &CMy3180102760SX15Dlg::OnBnClickedButton6)
END_MESSAGE_MAP()


// CMy3180102760SX15Dlg 消息处理程序

BOOL CMy3180102760SX15Dlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// 将“关于...”菜单项添加到系统菜单中。

	// IDM_ABOUTBOX 必须在系统命令范围内。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// 设置此对话框的图标。  当应用程序主窗口不是对话框时，框架将自动
	//  执行此操作
	SetIcon(m_hIcon, TRUE);			// 设置大图标
	SetIcon(m_hIcon, FALSE);		// 设置小图标

	// TODO: 在此添加额外的初始化代码
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");
	return TRUE;  // 除非将焦点设置到控件，否则返回 TRUE
}

void CMy3180102760SX15Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// 如果向对话框添加最小化按钮，则需要下面的代码
//  来绘制该图标。  对于使用文档/视图模型的 MFC 应用程序，
//  这将由框架自动完成。

void CMy3180102760SX15Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 用于绘制的设备上下文

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// 使图标在工作区矩形中居中
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// 绘制图标
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

//当用户拖动最小化窗口时系统调用此函数取得光标
//显示。
HCURSOR CMy3180102760SX15Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CMy3180102760SX15Dlg::OnBnClickedButton5()
{
	exit(0);
}


void CMy3180102760SX15Dlg::OnBnClickedButton6()
{
	GetDlgItemText(IDC_MFCEDITBROWSE1, filePathIn);
	
	const char *pszFormat = "GTiff";
	GDALDataset *dataSet = (GDALDataset *)GDALOpen(filePathIn, GA_ReadOnly);

	if (dataSet == NULL)
	{
		printf("文件无法打开");
	}
	GDALDriver*poDriver = GetGDALDriverManager()->GetDriverByName(pszFormat);
	if (poDriver == NULL)
	{
		GDALClose((GDALDatasetH)dataSet);
		printf("驱动运行失败");
	}
	
	GDALDataset *pErosion = setDstImg(dataSet, erosions);
	pErosion = erosion(dataSet, pErosion);
	for (int i = 1; i < repeatTime; i++)
	{
		pErosion = erosion(pErosion,pErosion);
	}

	if (pErosion != NULL)
	{
		MessageBox("腐蚀输出成功");
	}
	
	GDALDataset *pDilation = setDstImg(dataSet, dilations);
	pDilation = dilation(dataSet, pDilation);
	for (int i = 1; i < repeatTime; i++)
	{
		pDilation = dilation(pDilation, pDilation);
	}
	if (pDilation != NULL)
	{
		MessageBox("膨胀输出成功");
	}

	//envi开运算循环k次，是k次腐蚀，k次膨胀
	GDALDataset *pOpen = setDstImg(dataSet, opens);
	pOpen = erosion(dataSet, pOpen);	
	for (int i = 1; i < repeatTime; i++)
	{
		pOpen = erosion(pOpen, pOpen);
	}
	for (int i = 0; i < repeatTime; i++)
	{
		pOpen = dilation(pOpen, pOpen);
	}
	if (pOpen != NULL)
	{
		MessageBox("开运算输出成功");
	}

	GDALDataset *pClose = setDstImg(dataSet, closes);
	pClose = dilation(dataSet, pClose);
	for (int i = 1; i < repeatTime; i++)
	{
		pClose = dilation(pClose,pClose);
	}
	for (int i = 0; i < repeatTime; i++)
	{
		pClose = erosion(pClose,pClose);
	}
	if (pClose != NULL)
	{
		MessageBox("闭运算输出成功");
	}

	GDALClose(dataSet);
	GDALClose(pErosion);
	GDALClose(pDilation);
	GDALClose(pOpen);
	GDALClose(pClose);
	MessageBox("Done!");

}


GDALDataset*setDstImg(GDALDataset*poSrcDS, const char*pszDstFile)
{
	const char *pszFormat = "GTiff";/*CProcessBase*pProcess=NULL;*/
	GDALDriver *poDriver = GetGDALDriverManager()->GetDriverByName(pszFormat);
	//获取图像高和波段数、数据类型信息
	int iXSize = poSrcDS->GetRasterXSize();
	int iYSize = poSrcDS->GetRasterYSize();
	int iBandCount = poSrcDS->GetRasterCount();
	GDALDataType eDT = poSrcDS->GetRasterBand(1)->GetRasterDataType();
	GDALDataset *poDstDS = poDriver->Create(pszDstFile, iXSize, iYSize, iBandCount, eDT, NULL);
	double GeoTrans[6] = { 0 };
	//设置输出图像投影信息
	poSrcDS->GetGeoTransform(GeoTrans);
	poDstDS->SetGeoTransform(GeoTrans);
	//设置图像投影信息	
	poDstDS->SetProjection(poSrcDS->GetProjectionRef());
	return poDstDS;
}

GDALDataset*erosion(GDALDataset*pSrcImg, GDALDataset*pDstImg)
{
	int iBandCount = pSrcImg->GetRasterCount();
	int iXSize = pSrcImg->GetRasterXSize();
	int iYSize = pSrcImg->GetRasterYSize();
	for (int k = 1; k <= iBandCount; k++)
	{
		BYTE *pdata = (BYTE*)malloc(iXSize*iYSize * sizeof(BYTE));
		BYTE *pdataImg = (BYTE*)malloc(iXSize*iYSize * sizeof(BYTE));
		memset(pdataImg, 0, iXSize*iYSize);
		GDALRasterBand*pSrcBand = pSrcImg->GetRasterBand(k);
		GDALRasterBand*pDstBand = pDstImg->GetRasterBand(k);
		pSrcBand->RasterIO(GF_Read, 0, 0, iXSize, iYSize, pdata, iXSize, iYSize, GDT_Byte, 0, 0);

		for (int i = 0; i < iYSize; i++)
		{
			for (int j = 0; j < iXSize; j++)
			{
				int flag = 1;
				for (int m = 0; m < structureY; m++)
				{
					for (int n = 0; n < structureY; n++)
					{
						if (j + n - point[0] >= 0 && j + n - point[0] < iXSize && i + m - point[1] >= 0 && i + m < iYSize)
						{
							if (structure[m][n] == 1)
							{
								if (pdata[(i + m-point[1])*iYSize + (j + n-point[0])] == 0)
								{
									flag = 0;
									break;
								}
																	
							}
						}							
					}
					if (flag == 0)break;
				}
				if (flag == 1)pdataImg[i*iYSize + j] = 1;
			}
		}
	
		pDstBand->RasterIO(GF_Write, 0, 0, iXSize, iYSize, pdataImg, iXSize, iYSize, GDT_Byte,0, 0);
		free(pdata);
		pdata = NULL;
		free(pdataImg);
		pdataImg = NULL;
	}
	
	return pDstImg;
}
GDALDataset*dilation(GDALDataset*pSrcImg, GDALDataset*pDstImg)
{
	int iBandCount = pSrcImg->GetRasterCount();
	int iXSize = pSrcImg->GetRasterXSize();
	int iYSize = pSrcImg->GetRasterYSize();
	for (int k = 1; k <= iBandCount; k++)
	{
		BYTE *pdata = (BYTE*)malloc(iXSize*iYSize * sizeof(BYTE));
		BYTE *pdataImg = (BYTE*)malloc(iXSize*iYSize * sizeof(BYTE));
		memset(pdataImg, 0, iXSize*iYSize);
		GDALRasterBand*pSrcBand = pSrcImg->GetRasterBand(k);
		GDALRasterBand*pDstBand = pDstImg->GetRasterBand(k);
		pSrcBand->RasterIO(GF_Read, 0, 0, iXSize, iYSize, pdata, iXSize, iYSize, GDT_Byte, 0, 0);

		for (int i = 0; i < iYSize; i++)
		{
			for (int j = 0; j < iXSize; j++)
			{
				int flag = 0;
				for (int m = 0; m < structureY; m++)
				{
					for (int n = 0; n < structureX; n++)
					{
						if (j + n - point[0] >= 0 && j + n - point[0] < iXSize && i + m - point[1] >= 0 && i + m < iYSize)
						{
							if (structure[m][n] == 1)
							{
								if (pdata[(i + m - point[1])*iYSize + (j + n - point[0])] == 1)
								{
									flag = 1;
									break;
								}
							}
						}

					}
					if (flag == 1)break;
				}
				if (flag == 1)pdataImg[i*iYSize + j] = 1;
			}
		}
		
		pDstBand->RasterIO(GF_Write, 0, 0, iXSize, iYSize, pdataImg, iXSize, iYSize, GDT_Byte, 0, 0);
		free(pdata);
		pdata = NULL;
		free(pdataImg);
		pdataImg = NULL;
	}
	return pDstImg;
}
