﻿
// MFCApplication2Dlg.cpp: 实现文件
//

#include "pch.h"
#include "framework.h"
#include "MFCApplication2.h"
#include "MFCApplication2Dlg.h"
#include "afxdialogex.h"
#include "gdal/include/gdal.h"
#include "gdal/include/gdal_priv.h"
#include "gdal/include/gdal_frmts.h"
#include "gdal/include/ogrsf_frmts.h"
#pragma comment(lib, "C:\\Users\\云微\\Documents\\repo\\vs\\MFCApplication2\\MFCApplication2\\gdal\\gdal_i.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// 用于应用程序“关于”菜单项的 CAboutDlg 对话框

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

	// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持

// 实现
protected:
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedButton1();
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
	ON_BN_CLICKED(IDC_BUTTON1, &CAboutDlg::OnBnClickedButton1)
END_MESSAGE_MAP()


// CMFCApplication2Dlg 对话框



CMFCApplication2Dlg::CMFCApplication2Dlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_MFCAPPLICATION2_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMFCApplication2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CMFCApplication2Dlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
END_MESSAGE_MAP()


// CMFCApplication2Dlg 消息处理程序

BOOL CMFCApplication2Dlg::OnInitDialog()
{
	GDALAllRegister();
	CPLSetConfigOption("GDAL_ FILENAME _IS_ _UTF8", "NO");
	CDialogEx::OnInitDialog();

	// 将“关于...”菜单项添加到系统菜单中。

	// IDM_ABOUTBOX 必须在系统命令范围内。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// 设置此对话框的图标。  当应用程序主窗口不是对话框时，框架将自动
	//  执行此操作
	SetIcon(m_hIcon, TRUE);			// 设置大图标
	SetIcon(m_hIcon, FALSE);		// 设置小图标

	// TODO: 在此添加额外的初始化代码

	return TRUE;  // 除非将焦点设置到控件，否则返回 TRUE
}

void CMFCApplication2Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// 如果向对话框添加最小化按钮，则需要下面的代码
//  来绘制该图标。  对于使用文档/视图模型的 MFC 应用程序，
//  这将由框架自动完成。

void CMFCApplication2Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 用于绘制的设备上下文

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// 使图标在工作区矩形中居中
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// 绘制图标
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

//当用户拖动最小化窗口时系统调用此函数取得光标
//显示。
HCURSOR CMFCApplication2Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CAboutDlg::OnBnClickedButton1()
{
	GDALDataset* pDatasetRead;
	pDatasetRead = (GDALDataset*)GDALOpen("SpiderMan.jpg", GA_ReadOnly);
	if (pDatasetRead == NULL) {
		MessageBox((wchar_t*)"Open Image Error!");
		return;
	}
	int iCols = pDatasetRead->GetRasterXSize();
	int iRows = pDatasetRead->GetRasterYSize();
	int iBand = pDatasetRead->GetRasterCount();
	BYTE* pDataR = (BYTE*)malloc(iCols * iRows * sizeof(BYTE));
	BYTE* pDataG = (BYTE*)malloc(iCols * iRows * sizeof(BYTE));
	BYTE* pDataB = (BYTE*)malloc(iCols * iRows * sizeof(BYTE));
	if (pDataR == NULL || pDataG == NULL || pDataB == NULL) {
		MessageBox((wchar_t*)" mem error");
		return;
	}
	GDALRasterBand* pBand = NULL;
	pBand = pDatasetRead->GetRasterBand(1);
	pBand->RasterIO(GF_Read, 0, 0, iCols, iRows, pDataR, iCols, iRows, GDT_Byte, 0, 0);

	pBand = pDatasetRead->GetRasterBand(1);
	pBand->RasterIO(GF_Read, 0, 0, iCols, iRows, pDataR, iCols, iRows, GDT_Byte, 0, 0);
	pBand = pDatasetRead->GetRasterBand(2);
	pBand->RasterIO(GF_Read, 0, 0, iCols, iRows, pDataG, iCols, iRows, GDT_Byte, 0, 0);
	pBand = pDatasetRead->GetRasterBand(3);
	pBand->RasterIO(GF_Read, 0, 0, iCols, iRows, pDataB, iCols, iRows, GDT_Byte, 0, 0);

	CFile FileRed, FileCyan;
	FileRed.Open((wchar_t*)"SpiderMan_Red.dat", CFile::modeCreate | CFile::modeWrite | CFile::typeBinary, NULL);
	FileCyan.Open((wchar_t*)"SpiderMan_Cyan.dat", CFile::modeCreate | CFile::modeWrite | CFile::typeBinary, NULL);
	BYTE byZero = 0;
	FileRed.Write(pDataR, iCols * iRows * sizeof(BYTE));

	for (int i = 0; i < iCols * iRows * 2; i++)
		FileRed.Write(&byZero, 1);


	FileRed.Write(pDataR, iCols * iRows * sizeof(BYTE));
	for (int i = 0; i < iCols * iRows * 2; i++)
		FileRed.Write(&byZero, 1);
	for (int i = 0; i < iCols * iRows; i++)
		FileCyan.Write(&byZero, 1);

	FileCyan.Write(pDataG, iCols * iRows * sizeof(BYTE));
	FileCyan.Write(pDataB, iCols * iRows * sizeof(BYTE));
	free(pDataR); free(pDataG); free(pDataB);
	FileRed.Close(); FileCyan.Close();
	CString str;
	str.Format((wchar_t*)"COL:%d，ROW:%d", iCols, iRows);
	MessageBox(str);

}

