﻿
// MFCApplication2Dlg.cpp: 实现文件
//

#include "pch.h"
#include "framework.h"
#include "MFCApplication2.h"
#include "MFCApplication2Dlg.h"
#include "afxdialogex.h"
#include "gdal/include/gdal.h"
#include "gdal/include/gdalwarper.h"
#include "gdal/include/gdal_priv.h"
#include "gdal/include/gdal_frmts.h"
#include "gdal/include/ogrsf_frmts.h"
#include <fstream>
#include <iostream>
#pragma comment(lib, "gdal/lib/gdal.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define PI 3.14159265
#define pixelDepth 255

// 用于应用程序“关于”菜单项的 CAboutDlg 对话框k

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

	// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持

};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}


// CMFCApplication2Dlg 对话框



CMFCApplication2Dlg::CMFCApplication2Dlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_MFCAPPLICATION2_DIALOG, pParent)
	, ImgPath(_T(""))
	, ROIPath(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMFCApplication2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EBC_INPUTImg, ImgPath);
	DDX_Text(pDX, IDC_EBC_INPUTROI, ROIPath);
}

BEGIN_MESSAGE_MAP(CMFCApplication2Dlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	
	ON_BN_CLICKED(IDC_BNDone, &CMFCApplication2Dlg::OnBnClickedBndone)
END_MESSAGE_MAP()


// CMFCApplication2Dlg 消息处理程序

BOOL CMFCApplication2Dlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// 将“关于...”菜单项添加到系统菜单中。

	// IDM_ABOUTBOX 必须在系统命令范围内。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// 设置此对话框的图标。  当应用程序主窗口不是对话框时，框架将自动
	//  执行此操作
	SetIcon(m_hIcon, TRUE);			// 设置大图标
	SetIcon(m_hIcon, FALSE);		// 设置小图标

	// TODO: 在此添加额外的初始化代码
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");
	return TRUE;  // 除非将焦点设置到控件，否则返回 TRUE
}

void CMFCApplication2Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// 如果向对话框添加最小化按钮，则需要下面的代码
//  来绘制该图标。  对于使用文档/视图模型的 MFC 应用程序，
//  这将由框架自动完成。

void CMFCApplication2Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 用于绘制的设备上下文

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// 使图标在工作区矩形中居中
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// 绘制图标
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

//当用户拖动最小化窗口时系统调用此函数取得光标
//显示。
HCURSOR CMFCApplication2Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}




void CMFCApplication2Dlg::OnDestroy()
{
	CDialogEx::OnDestroy();


}

void ComputeClassNum(GDALDataset* dataset, int& max) {
	int col = dataset->GetRasterXSize();
	int row = dataset->GetRasterYSize();
	GDALRasterBand* band = dataset->GetRasterBand(1);
	int* p = new int[col];
	// 先取一个点的值
	band->RasterIO(GF_Read, 0, 0, 1, 1, &max, 1, 1, GDT_Int32, 0, 0);
	for (int i = 0; i < row; i++) {
		band->RasterIO(GF_Read, 0, i, col, 1, p, col, 1, GDT_Int32, 0, 0);
		for (int j = 0; j < col; j++) {
			int temp = p[j];
			if (temp > max) max = temp;
		}
	}
	delete []p;
}


void CMFCApplication2Dlg::OnBnClickedBndone()
{
	//读取输入文件
	UpdateData(TRUE);
	GDALDataset* poImg = (GDALDataset*)GDALOpen(ImgPath, GA_ReadOnly);
	GDALDataset* poROI = (GDALDataset*)GDALOpen(ROIPath, GA_ReadOnly);
	if (poImg == NULL || poROI == NULL) {
		AfxMessageBox("文件打开失败！");
		return;
	}
	GDALDriver* poDriver = GetGDALDriverManager()->GetDriverByName("GTiff");
	if (poDriver = NULL) {
		GDALClose((GDALDatasetH)poImg);
		GDALClose((GDALDatasetH)poROI);
		AfxMessageBox("驱动运行失败！");
		return;
	}
	// 图像基本参数的获取
	int XSize = poImg->GetRasterXSize();
	int YSize = poImg->GetRasterYSize();
	int RXSize = poROI->GetRasterXSize();
	int RYSize = poROI->GetRasterYSize();
	if (XSize != RXSize || YSize != RYSize) {
		AfxMessageBox("长宽不一数！");
	}
	GDALRasterBand* pBandI = poImg->GetRasterBand(1);
	GDALRasterBand* pBandR = poROI->GetRasterBand(1);
	int* I = new int[XSize];
	int* R = new int[XSize];
	// 获取类别数
	int ClassNum = 0;
	int RClassNum = 0;
	ComputeClassNum(poImg, ClassNum);
	ComputeClassNum(poROI, RClassNum);
	if (ClassNum > 10) {
		AfxMessageBox("类别数过多！");
	}
	if (ClassNum != RClassNum) {
		AfxMessageBox("类别数不一致！");
	}
	// 混淆矩阵、生产者精度、用户精度
	int CM[10][10] = { 0 };
	float PA[10] = { 0.0 };
	float PU[10] = { 0.0 };
	// 混淆矩阵像元点数量获取
	for (int i = 0; i < YSize; i++) {
		// 逐行读取数据
		pBandI->RasterIO(GF_Read, 0, i, XSize, 1, I, XSize, 1, GDT_Int32, 0, 0);
		pBandR->RasterIO(GF_Read, 0, i, XSize, 1, R, XSize, 1, GDT_Int32, 0, 0);
		for (int j = 0; j < XSize; j++) {
			CM[I[j]][R[j]]++;
		}
	}

	// 计算生产者精度和用户精度
	for (int ii = 0; ii < ClassNum; ii++) {
		int sum = 0;
		for (int jj = 0; jj < ClassNum; jj++) {
			sum += CM[ii][jj];
		}
		CM[ii][XSize] = CM[ii][ii] * 100.0 / sum;
	}
	for (int jj = 0; jj < ClassNum; jj++) {
		int sum = 0;
		for (int ii = 0; ii < ClassNum; ii++) {
			sum += CM[ii][jj];
		}
		CM[YSize][jj] = CM[jj][jj] * 100.0 / sum;
	}
	// text写出
	std::ofstream out("混淆矩阵.text");
	out << "Class\tClass1\tClass2\tClass3\tClass4\tClass5\tPU(100%)\n";
	for (int ii = 0; ii < ClassNum; ii++) {
		out << "Class" << ii + 1;
		for (int jj = 0; jj < ClassNum; jj++) {
			out << "\t" << CM[ii][jj];
		}
		out << "\t" << PU[ii] << "\n";
	}

	out << "PA(100%)";

	for (int ii = 0; ii < ClassNum; ii++) {
		out << "\t" << PA[ii];
	}
	out.close();
	GDALClose((GDALDatasetH)poImg);
	GDALClose((GDALDatasetH)poROI);
	AfxMessageBox("OK");
}