﻿
// 3180102760SX16Dlg.cpp: 实现文件
//

#include "pch.h"
#include "framework.h"
#include "3180102760SX16.h"
#include "3180102760SX16Dlg.h"
#include "afxdialogex.h"

#include "gdal/include/gdal_priv.h"
#include "gdal/include/gdalwarper.h"
#include "gdal/include/ogrsf_frmts.h"
#pragma comment(lib,"gdal/gdal_i.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

GDALDataset*setDstImg(GDALDataset*poSrcDS, const char*pszDstFile);
// 用于应用程序“关于”菜单项的 CAboutDlg 对话框

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持

// 实现
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CMy3180102760SX16Dlg 对话框



CMy3180102760SX16Dlg::CMy3180102760SX16Dlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_MY3180102760SX16_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMy3180102760SX16Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CMy3180102760SX16Dlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON2, &CMy3180102760SX16Dlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON1, &CMy3180102760SX16Dlg::OnBnClickedButton1)
END_MESSAGE_MAP()


// CMy3180102760SX16Dlg 消息处理程序

BOOL CMy3180102760SX16Dlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// 将“关于...”菜单项添加到系统菜单中。

	// IDM_ABOUTBOX 必须在系统命令范围内。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// 设置此对话框的图标。  当应用程序主窗口不是对话框时，框架将自动
	//  执行此操作
	SetIcon(m_hIcon, TRUE);			// 设置大图标
	SetIcon(m_hIcon, FALSE);		// 设置小图标

	// TODO: 在此添加额外的初始化代码
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");

	return TRUE;  // 除非将焦点设置到控件，否则返回 TRUE
}

void CMy3180102760SX16Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// 如果向对话框添加最小化按钮，则需要下面的代码
//  来绘制该图标。  对于使用文档/视图模型的 MFC 应用程序，
//  这将由框架自动完成。

void CMy3180102760SX16Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 用于绘制的设备上下文

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// 使图标在工作区矩形中居中
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// 绘制图标
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

//当用户拖动最小化窗口时系统调用此函数取得光标
//显示。
HCURSOR CMy3180102760SX16Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CMy3180102760SX16Dlg::OnBnClickedButton2()
{
	exit(0);
}


void CMy3180102760SX16Dlg::OnBnClickedButton1()
{
	CString filePathIn;
	GetDlgItemText(IDC_MFCEDITBROWSE1, filePathIn);

	CString filePathOut;
	GetDlgItemText(IDC_MFCEDITBROWSE2, filePathOut);


	/*
	filePathIn = "C:\\Users\\DELL\\Desktop\\ex16\\N27E118.tif";
	filePathOut = "C:\\Users\\DELL\\Desktop\\ex16\\aa";
	*/
	const char *pszFormat = "GTiff";
	GDALDataset *dataSet = (GDALDataset *)GDALOpen(filePathIn, GA_ReadOnly);

	if (dataSet == NULL)
	{
		printf("文件无法打开");
	}
	GDALDriver*poDriver = GetGDALDriverManager()->GetDriverByName(pszFormat);
	if (poDriver == NULL)
	{
		GDALClose((GDALDatasetH)dataSet);
		printf("驱动运行失败");
	}
	
	
	GDALDataType edt = dataSet->GetRasterBand(1)->GetRasterDataType();

	int xsize = dataSet->GetRasterXSize();
	int ysize = dataSet->GetRasterYSize();
	short *pdata = (short*)malloc(xsize*ysize * sizeof(short));


	short *pdataPoint = (short*)malloc(xsize*ysize * sizeof(short));
	memset(pdataPoint, 0, xsize*ysize);
	short *pdataRes = (short*)malloc(xsize*ysize * sizeof(short));
	memset(pdataRes, 0, xsize*ysize);

	GDALRasterBand *pBand = dataSet->GetRasterBand(1);
	pBand->RasterIO(GF_Read, 0, 0, xsize, ysize, pdata, xsize, ysize, edt, 0, 0);

	
	for (int i = 0; i < ysize; i++)
	{
		for (int j = 0; j < xsize; j++)
		{
			if (i == 0 || j == 0 || i == ysize - 1 || j == xsize - 1)
			{
				pdataPoint[i*xsize + j] = 126;
				continue;
			}
			int x1 = pdata[i*xsize + j - 1] - pdata[i*xsize + j], x2 = pdata[i*xsize + j] - pdata[i*xsize + j + 1],
				y1 = pdata[(i - 1)*xsize + j] - pdata[i*xsize + j], y2 = pdata[(i + 1)*xsize + j - 1] - pdata[i*xsize + j],
				a1 = pdata[(i - 1)*xsize + j - 1] - pdata[i*xsize + j], a2 = pdata[i*xsize + j] - pdata[(i + 1)*xsize + j + 1],
				b1 = pdata[(i - 1)*xsize + j + 1] - pdata[i*xsize + j], b2 = pdata[i *xsize + j] - pdata[(i + 1)*xsize + j - 1];
			if ((x1 < 0 && x2 > 0 && y1 == 0 && y2 == 0) || (x1 == 0 && x2 == 0 && y1 < 0 && y2 > 0)||(a1 < 0 && a2 > 0 && b1 == 0 && b2 == 0)||(a1 == 0 && a2 == 0 && b1 < 0 && b2 > 0))
				pdataPoint[i*xsize + j] = 255;
			else if ((x1 > 0 && x2 < 0 && y1 == 0 && y2 == 0) || (x1 == 0 && x2 == 0 && y1 > 0 && y2 < 0) || (a1 > 0 && a2 < 0 && b1 == 0 && b2 == 0) || (a1 == 0 && a2 == 0 && b1 > 0 && b2 < 0))
				pdataPoint[i*xsize + j] = 0;
			else
				pdataPoint[i*xsize + j] = 126;

		}
	}
	CString f1 = filePathOut + "_Point.tif";
	GDALDataset *pPoints = setDstImg(dataSet, f1);
	GDALRasterBand *pBandPoint = pPoints->GetRasterBand(1);
	pBandPoint->RasterIO(GF_Write, 0, 0, xsize, ysize, pdataPoint, xsize, ysize, edt, 0, 0);

	if (pPoints != NULL)
	{
		MessageBox("Point is done!");
	}
	else
	{
		MessageBox("something wrong!");
	}
	
	const float sq = sqrt(2);
	//E:0 SE:1 S:2 SW:3 W:4 NW:5 N:6 NE:7
	float dir[8] = { 0,0,0,0,0,0,0,0 };
	for (int i = 0; i < ysize; i++)
	{
		for (int j = 0; j < xsize; j++)
		{
			dir[2] = (i != (ysize - 1)) ? (pdata[i*xsize + j] - pdata[(i + 1)*xsize + j])*1.0 : -1;
			dir[1] = (i != (ysize - 1) && j != (xsize - 1)) ? (pdata[i*xsize + j] - pdata[(i + 1)*xsize + j + 1]) / sq : -1;
			dir[6] = (i != 0) ? (pdata[i*xsize + j] - pdata[(i - 1)*xsize + j])*1.0 : -1;
			dir[0] = (j != (xsize - 1)) ? (pdata[i*xsize + j] - pdata[i*xsize + j + 1])*1.0 : -1;
			dir[7] = (i != 0 && j != (xsize - 1)) ? (pdata[i*xsize + j] - pdata[(i - 1)*xsize + j + 1]) / sq : -1;
			dir[5] = (i != 0 && j != 0) ? (pdata[i*xsize + j] - pdata[(i - 1)*xsize + j - 1]) / sq : -1;
			dir[4] = (j != 0) ? (pdata[i*xsize + j] - pdata[i*xsize + j - 1])*1.0 : -1;
			dir[3] = (i != (ysize - 1) && j != 0) ? (pdata[i*xsize + j] - pdata[(i + 1)*xsize + j - 1]) / sq : -1;


			float max = -1;
			int index = 0;
			for (int k = 0; k < 8; k++)
			{
				if (max < dir[k])
				{
					max = dir[k];
					index = k;
				}
			}

			int num0 = 0;
			if (max == 0)
			{
				for (int k = 0; k < 7; k++)
				{
					if (max == 0)num0++;
				}
			}

			if (max < 0)
				pdataRes[i*xsize + j] = 0;
			else
			{
				//d)如果最大落差等于0，且有一个以上的0值，则以这些0值所对应的方向值相加。
				//在极端情况下，如果8个邻域高程值都与中心格网高程值相同，则中心网格方向值赋以255；
				if (max == 0 && num0 > 1)
				{
					int sum = 0;
					for (int k = 0; k < 8; k++)
					{
						if (dir[k] == 0)sum += pow(2, k);
					}
					pdataRes[i*xsize + j]=sum;
				}
				else
				{
					pdataRes[xsize*i + j] = pow(2, index);
				}
			}
		}
	}

	CString f2= filePathOut + "_Flow_Direction.tif";
	GDALDataset *pRes = setDstImg(dataSet, f2);
	GDALRasterBand *pBandRes = pRes->GetRasterBand(1);
	pBandRes->RasterIO(GF_Write, 0, 0, xsize, ysize, pdataRes, xsize, ysize, edt, 0, 0);

	if (pRes !=  NULL)
	{
		MessageBox("Flow direction  with D8 is done!");
	}
	else
	{
		MessageBox("something wrong!");
	}
	GDALClose(dataSet);
	GDALClose(pPoints);
	GDALClose(pRes);
	free(pdata);
	pdata = NULL;
	free(pdataPoint);
	pdataPoint = NULL;
	free(pdataRes);
	pdataRes = NULL;

}
GDALDataset*setDstImg(GDALDataset*poSrcDS, const char*pszDstFile)
{
	const char *pszFormat = "GTiff";/*CProcessBase*pProcess=NULL;*/
	GDALDriver *poDriver = GetGDALDriverManager()->GetDriverByName(pszFormat);
	//获取图像高和波段数、数据类型信息
	int iXSize = poSrcDS->GetRasterXSize();
	int iYSize = poSrcDS->GetRasterYSize();
	int iBandCount = poSrcDS->GetRasterCount();
	GDALDataType eDT = poSrcDS->GetRasterBand(1)->GetRasterDataType();
	GDALDataset *poDstDS = poDriver->Create(pszDstFile, iXSize, iYSize, iBandCount, eDT, NULL);
	double GeoTrans[6] = { 0 };
	//设置输出图像投影信息
	poSrcDS->GetGeoTransform(GeoTrans);
	poDstDS->SetGeoTransform(GeoTrans);
	//设置图像投影信息	
	poDstDS->SetProjection(poSrcDS->GetProjectionRef());
	return poDstDS;
}
