﻿
// MFCApplication2Dlg.cpp: 实现文件
//

#include "pch.h"
#include "framework.h"
#include "MFCApplication2.h"
#include "MFCApplication2Dlg.h"
#include "afxdialogex.h"
#include "gdal/include/gdal.h"
#include "gdal/include/gdalwarper.h"
#include "gdal/include/gdal_priv.h"
#include "gdal/include/gdal_frmts.h"
#include "gdal/include/ogrsf_frmts.h"
#pragma comment(lib, "gdal/lib/gdal.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define PI 3.14159265
#define pixelDepth 255

// 用于应用程序“关于”菜单项的 CAboutDlg 对话框k

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

	// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持

// 实现
protected:
	DECLARE_MESSAGE_MAP()
public:
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CMFCApplication2Dlg 对话框



CMFCApplication2Dlg::CMFCApplication2Dlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_MFCAPPLICATION2_DIALOG, pParent)
	, mssPath(_T(""))
	, panPath(_T(""))
	, outPath(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMFCApplication2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EBC_MSS, mssPath);
	DDX_Text(pDX, IDC_EBC_PAN, panPath);
	DDX_Text(pDX, IDC_EBC_Result, outPath);
}

BEGIN_MESSAGE_MAP(CMFCApplication2Dlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	
	ON_BN_CLICKED(IDC_BN_Implement, &CMFCApplication2Dlg::OnBnClickedBnImplement)
	ON_EN_CHANGE(IDC_EDIT2, &CMFCApplication2Dlg::OnEnChangeEdit2)
END_MESSAGE_MAP()


// CMFCApplication2Dlg 消息处理程序

BOOL CMFCApplication2Dlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// 将“关于...”菜单项添加到系统菜单中。

	// IDM_ABOUTBOX 必须在系统命令范围内。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// 设置此对话框的图标。  当应用程序主窗口不是对话框时，框架将自动
	//  执行此操作
	SetIcon(m_hIcon, TRUE);			// 设置大图标
	SetIcon(m_hIcon, FALSE);		// 设置小图标

	// TODO: 在此添加额外的初始化代码
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");
	return TRUE;  // 除非将焦点设置到控件，否则返回 TRUE
}

void CMFCApplication2Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// 如果向对话框添加最小化按钮，则需要下面的代码
//  来绘制该图标。  对于使用文档/视图模型的 MFC 应用程序，
//  这将由框架自动完成。

void CMFCApplication2Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 用于绘制的设备上下文

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// 使图标在工作区矩形中居中
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// 绘制图标
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

//当用户拖动最小化窗口时系统调用此函数取得光标
//显示。
HCURSOR CMFCApplication2Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CMFCApplication2Dlg::OnDestroy()
{
	CDialogEx::OnDestroy();


}


// 计算欧式距离
float disEclud(unsigned long** DATA, int i, int j, unsigned long** center, int x)
{
	double sum = 0;
	for (int a = 0; a < BandNum; a++)
	{
		sum += (DATA[a][j * Xsize + i] - center[x][a]) * (DATA[a][j * Xsize + i] - center[x][a]);
	}
	return (float)sqrt(sum);
}


void CMFCApplication2Dlg::OnBnClickedBnImplement()
{
	CString str1 = "", str2 = "", str3 = "";
	if (str1 == "" || str2 == "" || str3 == "")
	{
		MessageBox("There is empty information");
		return;
	}
	int k = atoi(str1);
	int repeatTimes = atoi(str2);
	int changeRadio = atof(str3);
	/*
	k = 4;
	repeatTimes =20 ;
	changeRadio = 5;
	FilePathIn = "C:\\Users\\DELL\\Desktop\\ex10\\09非监督分类\\data\\LC8.tif";
	FilePathOut = "C:\\Users\\DELL\\Desktop\\ex10\\09非监督分类\\data\\b";
	*/
	GDALDataset* pDataset;
	pDataset = (GDALDataset*)GDALOpen(FilePathIn, GA_ReadOnly);
	if (!pDataset)
	{
		MessageBox("Can't open the file ！");
		return;
	}

	const char* pszFormat = "GTiff";
	GDALDriver* poDriver = GetGDALDriverManager()->GetDriverByName(pszFormat);
	if (poDriver == NULL) {
		GDALClose(pDataset);
		printf("驱动失败");
		return;
	}


	//获取行列，波段信息
	int Xsize = pDataset->GetRasterXSize();
	int Ysize = pDataset->GetRasterYSize();
	int BandNum = pDataset->GetRasterCount();


	//二阶指针，读取bandNum个波段数据
	unsigned long** pData = NULL;
	pData = (unsigned long**)malloc(BandNum * sizeof(unsigned long*));
	for (int i = 0; i < BandNum; i++)
	{
		pData[i] = (unsigned long*)malloc(Xsize * Ysize * sizeof(unsigned long));

		GDALRasterBand* pBand = pDataset->GetRasterBand(i + 1);
		GDALDataType eDT = pDataset->GetRasterBand(i + 1)->GetRasterDataType();
		CPLErr Ret = pBand->RasterIO(GF_Read, 0, 0, Xsize, Ysize, pData[i], Xsize, Ysize, eDT, 0, 0);
	}

	//用来记录最小簇，初始化.temp用来记录之前一次的情况，因为这里要用像元变化率
	int* pDatamin = NULL;
	int* temp = NULL;
	pDatamin = (int*)malloc(Xsize * Ysize * sizeof(int));
	temp = (int*)malloc(Xsize * Ysize * sizeof(int));
	for (int i = 0; i < Ysize; i++)
	{
		for (int j = 0; j < Xsize; j++)
		{
			pDatamin[i * Xsize + j] = 0;
			temp[i * Xsize + j] = 0;
		}
	}
	//找到每个段最大值和最小值，然后再随机
	int* max = NULL;
	int* min = NULL;
	max = (int*)malloc(BandNum * sizeof(int));
	min = (int*)malloc(BandNum * sizeof(int));
	for (int i = 0; i < BandNum; i++)
	{
		max[i] = pData[i][0];
		min[i] = pData[i][0];
		for (int j = 0; j < Ysize; j++)
		{
			for (int x = 0; x < Xsize; x++)
			{
				if (pData[i][x + j * Xsize] > max[i])
					max[i] = pData[i][x + j * Xsize];
				if (pData[i][x + j * Xsize] < min[i])
					min[i] = pData[i][x + j * Xsize];
			}
		}
	}

	//init the center，k个bandNum维度的中心点，随机产生

	unsigned long** center = NULL;
	center = (unsigned long**)malloc(k * sizeof(unsigned long*));
	for (int i = 0; i < k; i++)
	{
		center[i] = (unsigned long*)malloc(BandNum * sizeof(unsigned long));
		for (int j = 0; j < BandNum; j++)
		{
			center[i][j] = (unsigned long)(rand() * (max[j] - min[j]) + min[j]);
		}
	}

	//正式开始计算
	for (int re = 0; re < repeatTimes; re++)
	{
		//复制这一次改变之前的分类结果，要计算像元变化率
		for (int i = 0; i < Ysize; i++)
		{
			for (int j = 0; j < Xsize; j++)
			{
				temp[i * Xsize + j] = pDatamin[i * Xsize + j];
			}
		}


		//计算最小簇
		//int c1, c2, c3, c4; c1 = 0; c2 = 0; c3 = 0; c4 = 0; 记录一下各个类别的数目
		for (int j = 0; j < Ysize; j++)
		{
			for (int i = 0; i < Xsize; i++)
			{
				float dmin = MAXINT;
				int index = 0;
				for (int x = 0; x < k; x++)
				{
					float dist = disEclud(pData, i, j, center, x);
					if (dist < dmin) {
						dmin = dist;
						index = x;
					}
				}
				/*
				switch (index)
				{
				case 0: {
					c1++;
					break;
				}
				case 1: {
					c2++;
					break;
				}
				case 2: {
					c3++;
					break;
				}
				case 3: {
					c4++;
					break;
				}
				default:
					break;
				}*/
				pDatamin[j * Xsize + i] = index;
			}
		}
		//如果小于像元变化率的要求
		if (re >= 1)
		{
			int cnt = 0;
			for (int i = 0; i < Ysize; i++)
			{
				for (int j = 0; j < Xsize; j++)
				{
					if (temp[i * Xsize + j] != pDatamin[i * Xsize + j])
						cnt++;
				}
			}
			if (cnt * 1.0 / (Xsize * Ysize) < changeRadio * 1.0 / 100)
				break;

		}

		//sumForEveryBand用来记录每一个中心向量的每一个维度的值
		//sumNum用来记录类别数目
		//求向量的每一个维度的均值，用来给下一次。
		//这里没有T，就是如果小于这个T，这个中心点向量就不变。文档没有说，也就没有做
		float* sumForEveryBand = NULL;
		sumForEveryBand = (float*)malloc(k * BandNum * sizeof(float));
		int* sumNum = NULL;
		sumNum = (int*)malloc(k * sizeof(int));

		for (int i = 0; i < k; i++)
		{
			for (int j = 0; j < BandNum; j++) {
				sumForEveryBand[i * BandNum + j] = 0;
			}
			sumNum[i] = 0;
		}

		for (int j = 0; j < Ysize; j++)
		{
			for (int i = 0; i < Xsize; i++)
			{
				sumNum[pDatamin[j * Xsize + i]]++;
				for (int x = 0; x < BandNum; x++)
				{
					sumForEveryBand[pDatamin[j * Xsize + i] * BandNum + x] += pData[x][j * Xsize + i];
				}
			}
		}
		//更新中心点的信息
		for (int i = 0; i < k; i++)
		{
			if (sumNum[i] == 0)
			{
				MessageBox("There is 0 in certain class. Please try again.");
				return;
			}

			for (int j = 0; j < BandNum; j++)
			{

				center[i][j] = sumForEveryBand[i * BandNum + j] / sumNum[i];
			}
		}

		free(sumForEveryBand);
		sumForEveryBand = NULL;
		free(sumNum);
		sumNum = NULL;
	}
	/*
	CFile fWrite;
	if (!fWrite.Open(FilePathOut + ".dat", CFile::modeCreate | CFile::modeWrite | CFile::typeBinary, NULL))
	{
		MessageBox("open white file error");
		return;
	}
	fWrite.Write(pDatamin, Xsize*Ysize*sizeof(int));
	fWrite.Close();
	*/
	GDALDataType eDT = GDT_Int32;
	GDALDataset* poDS = poDriver->Create(FilePathOut + ".tif", Xsize, Ysize, 1, eDT, NULL);
	double geoTrans[6] = { 0 };
	pDataset->GetGeoTransform(geoTrans);
	poDS->SetGeoTransform(geoTrans);
	poDS->SetProjection(poDS->GetProjectionRef());
	GDALRasterBand* poband = poDS->GetRasterBand(1);
	poband->RasterIO(GF_Write, 0, 0, Xsize, Ysize, pDatamin, Xsize, Ysize, eDT, 0, 0);

	if (poDS != NULL)
	{
		MessageBox("done!");
	}
	//释放内存
	GDALClose(pDataset);
	for (int i = 0; i < BandNum; i++)
	{
		free(pData[i]);
		pData[i] = NULL;
	}
	free(pData);
	pData = NULL;
	for (int i = 0; i < k; i++)
	{
		free(center[i]);
		center[i] = NULL;
	}
	free(center);
	center = NULL;
	free(pDatamin);
	pDatamin = NULL;
	free(temp);
	temp = NULL;
	free(max);
	max = NULL;
	free(min);
	min = NULL;



}

void CMFCApplication2Dlg::OnCbnSelchangeComboboxex1()
{
	// TODO: 在此添加控件通知处理程序代码
}


void CMFCApplication2Dlg::OnEnChangeEdit2()
{
	// TODO:  如果该控件是 RICHEDIT 控件，它将不
	// 发送此通知，除非重写 CDialogEx::OnInitDialog()
	// 函数并调用 CRichEditCtrl().SetEventMask()，
	// 同时将 ENM_CHANGE 标志“或”运算到掩码中。

	// TODO:  在此添加控件通知处理程序代码
}
