package com.yunbao.main.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.yunbao.common.CommonAppConfig;
import com.yunbao.common.adapter.RefreshAdapter;
import com.yunbao.common.bean.LevelBean;
import com.yunbao.common.bean.UserBean;
import com.yunbao.common.glide.ImgLoader;
import com.yunbao.common.utils.StringUtil;
import com.yunbao.common.utils.WordUtil;
import com.yunbao.main.R;

// +———————————————————————————————————
// | Created by Yunbao
// +———————————————————————————————————
// | Copyright (c) 2013~2022 http://www.yunbaokj.com All rights reserved.
// +———————————————————————————————————
// | Author: https://gitee.com/yunbaokeji
// +———————————————————————————————————
// | Date: 2022-03-22
// +———————————————————————————————————
public class FansAdapter extends RefreshAdapter<UserBean> {

    private View.OnClickListener mClickListener;
    private ActionListener mActionListener;
    private String mIdString;
    private String mFanString;

    public FansAdapter(Context context) {
        super(context);
        mClickListener = new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Object tag = v.getTag();
                if (tag == null) {
                    return;
                }
                UserBean bean = (UserBean) tag;
                if (mActionListener != null) {
                    mActionListener.onItemClick(bean);
                }
            }
        };



        mIdString = WordUtil.getString(R.string.search_id);
        mFanString = WordUtil.getString(R.string.search_fans);
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new Vh(mInflater.inflate(R.layout.item_fans, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder vh, int position) {
        ((Vh) vh).setData(mList.get(position));
    }


    class Vh extends RecyclerView.ViewHolder {

        ImageView mAvatar;
        TextView mName;
        TextView mID;
        TextView mFans;

        public Vh(View itemView) {
            super(itemView);
            mAvatar = itemView.findViewById(R.id.avatar);
            mName = itemView.findViewById(R.id.name);
            mID = itemView.findViewById(R.id.id_val);
            mFans = itemView.findViewById(R.id.fans);
            itemView.setOnClickListener(mClickListener);
        }

        void setData(UserBean bean) {
            itemView.setTag(bean);
            ImgLoader.displayAvatar(mContext, bean.getAvatar(), mAvatar);
            mName.setText(bean.getUserNiceName());
            mID.setText(StringUtil.contact(mIdString, bean.getId()));
            mFans.setText(StringUtil.contact(mFanString, StringUtil.toWan(bean.getFans())));

        }
    }

    public interface ActionListener {
        void onItemClick(UserBean u);

    }

    public void setActionListener(ActionListener actionListener) {
        mActionListener = actionListener;
    }
}
