package com.yunbao.main.activity;

import android.view.View;
import android.view.ViewGroup;

import com.yunbao.common.activity.AbsActivity;
import com.yunbao.common.utils.WordUtil;
import com.yunbao.main.R;
import com.yunbao.main.views.MyAlbumViewHolder;

// +———————————————————————————————————
// | Created by Yunbao
// +———————————————————————————————————
// | Copyright (c) 2013~2022 http://www.yunbaokj.com All rights reserved.
// +———————————————————————————————————
// | Author: https://gitee.com/yunbaokeji
// +———————————————————————————————————
// | Date: 2022-03-22
// +———————————————————————————————————
public class MyPhotoActivity extends AbsActivity implements View.OnClickListener {

    private MyAlbumViewHolder mAlbumViewHolder;

    @Override
    protected int getLayoutId() {
        return R.layout.activity_my_album;
    }

    @Override
    protected void main() {
        setTitle(WordUtil.getString(R.string.video_my_album));
        findViewById(R.id.btn_add).setOnClickListener(this);
        mAlbumViewHolder = new MyAlbumViewHolder(mContext, (ViewGroup) findViewById(R.id.container));
        mAlbumViewHolder.addToParent();
        mAlbumViewHolder.subscribeActivityLifeCycle();
    }


    @Override
    protected void onResume() {
        super.onResume();
        if (mAlbumViewHolder != null) {
            mAlbumViewHolder.loadData();
        }
    }

    @Override
    public void onClick(View v) {
        MyPhotoPubActivity.forward(mContext);
    }
}
