package com.yunbao.common.upload;

import java.io.File;

// +———————————————————————————————————
// | Created by Yunbao
// +———————————————————————————————————
// | Copyright (c) 2013~2022 http://www.yunbaokj.com All rights reserved.
// +———————————————————————————————————
// | Author: https://gitee.com/yunbaokeji
// +———————————————————————————————————
// | Date: 2022-03-22
// +———————————————————————————————————
public class UploadBean {
    private File mOriginFile;//要被上传的源文件
    private String mRemoteFileName;//上传成功后在云存储上的文件名字
    private String mRemoteAccessUrl;//上传成功后在云存储上的访问地址
    private boolean mSuccess;//是否上传成功了
    private Object mTag;



    public static final int IMG = 1;
    public static final int VIDEO = 2;
    public static final int VOICE = 3;
    private int mType;
    private boolean mChecked;

    public UploadBean() {
    }

    public UploadBean(File originFile) {
        mOriginFile = originFile;
    }

    public File getOriginFile() {
        return mOriginFile;
    }

    public void setOriginFile(File originFile) {
        mOriginFile = originFile;
    }

    public String getRemoteFileName() {
        return mRemoteFileName;
    }

    public void setRemoteFileName(String remoteFileName) {
        mRemoteFileName = remoteFileName;
    }

    public String getRemoteAccessUrl() {
        return mRemoteAccessUrl;
    }

    public void setRemoteAccessUrl(String remoteAccessUrl) {
        mRemoteAccessUrl = remoteAccessUrl;
    }

    public boolean isSuccess() {
        return mSuccess;
    }

    public void setSuccess(boolean success) {
        mSuccess = success;
    }


    public void setEmpty() {
        mOriginFile = null;
        mRemoteFileName = null;
        mRemoteAccessUrl = null;
    }

    public boolean isEmpty() {
        return mOriginFile == null && mRemoteFileName == null && mRemoteAccessUrl == null;
    }

    public int getType() {
        return mType;
    }

    public void setType(int type) {
        mType = type;
    }

    public boolean isChecked() {
        return mChecked;
    }

    public void setChecked(boolean checked) {
        mChecked = checked;
    }

    public Object getTag() {
        return mTag;
    }

    public void setTag(Object tag) {
        mTag = tag;
    }
}
