/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.media.AudioRecord;
import android.media.MediaFormat;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.liteav.audio.TXCAudioUGCRecorder;
import com.tencent.liteav.audio.TXCUGCBGMPlayer;
import com.tencent.liteav.audio.impl.TXCAudioEngineJNI;
import com.tencent.liteav.basic.c.b;
import com.tencent.liteav.basic.datareport.TXCDRApi;
import com.tencent.liteav.basic.license.LicenceCheck;
import com.tencent.liteav.basic.license.f;
import com.tencent.liteav.basic.license.i;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.opengl.o;
import com.tencent.liteav.basic.opengl.p;
import com.tencent.liteav.basic.structs.TXSNALPacket;
import com.tencent.liteav.basic.util.TXCCommonUtil;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.basic.util.g;
import com.tencent.liteav.beauty.TXBeautyManager;
import com.tencent.liteav.beauty.e;
import com.tencent.liteav.capturer.a;
import com.tencent.liteav.k;
import com.tencent.liteav.muxer.c;
import com.tencent.liteav.renderer.TXCGLSurfaceView;
import com.tencent.liteav.videoediter.ffmpeg.b;
import com.tencent.liteav.videoencoder.TXSVideoEncoderParam;
import com.tencent.liteav.videoencoder.d;
import com.tencent.rtmp.TXLog;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.ugc.PartInfo;
import com.tencent.ugc.TXRecordCommon;
import com.tencent.ugc.TXUGCPartsManager;
import com.tencent.ugc.TXVideoEditConstants;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;

public class TXUGCRecord
implements com.tencent.liteav.audio.f,
b,
o,
com.tencent.liteav.beauty.f,
d,
TXUGCPartsManager.IPartsManagerListener {
    private static final String TAG = "TXUGCRecord";
    private static TXUGCRecord instance;
    private static final String OUTPUT_DIR_NAME = "TXUGC";
    private static final String OUTPUT_TEMP_DIR_NAME = "TXUGCParts";
    private static final String OUTPUT_VIDEO_NAME = "TXUGCRecord.mp4";
    private static final String OUTPUT_VIDEO_COVER_NAME = "TXUGCCover.jpg";
    private static final int STATE_RECORD_INIT = 1;
    private static final int STATE_RECORD_RECORDING = 2;
    private static final int STATE_RECORD_PAUSE = 3;
    private static final int DEFAULT_CHANNEL = 1;
    private volatile int mRecordState = 1;
    private boolean mUseSWEncoder = false;
    private int mFps = 20;
    private int mGop = 3;
    private final int AAC_FRAME_SIZE = 4096;
    private Context mContext;
    private Handler mMainHandler;
    private TXRecordCommon.ITXVideoRecordListener mVideoRecordListener;
    private long mRecordStartTime = 0L;
    private long mEncodePcmDataSize = 0L;
    private boolean mStartMuxer = false;
    private boolean mRecording = false;
    private boolean needCompose = false;
    private String mSaveDir = null;
    private String mVideoFileCurTempPath = null;
    private String mVideoFilePath = null;
    private String mVideoFileTempDir = null;
    private String mCoverCurTempPath = null;
    private String mCoverPath = null;
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;
    private a.a mCameraResolution = a.a.f;
    private AtomicBoolean mStartPreview = new AtomicBoolean(false);
    private boolean mCapturing = false;
    private k mConfig = new k();
    private TXCGLSurfaceView mVideoView;
    private com.tencent.liteav.capturer.a mCameraCapture = null;
    private e mVideoPreprocessor = null;
    private com.tencent.liteav.videoencoder.b mVideoEncoder = null;
    private c mMP4Muxer = null;
    private com.tencent.liteav.videoediter.a.c mTXMultiMediaComposer = null;
    private VideoCustomProcessListener mCustomProcessListener;
    private int mRenderRotationReadyChange = -1;
    private int mCameraOrientationReadyChange = -1;
    private int mRenderMode = 0;
    private int mMinDuration;
    private int mMaxDuration;
    private boolean isReachedMaxDuration = false;
    private com.tencent.liteav.audio.g mBGMNotifyProxy = null;
    private TXRecordCommon.ITXBGMNotify mBGMNotify = null;
    private CopyOnWriteArrayList<Long> mBgmPartBytesList;
    private boolean mBGMDeletePart = false;
    private String mBGMPath;
    private long mBGMStartTime;
    private long mBGMEndTime;
    private boolean mBGMPlayStop;
    private Bitmap mWatermarkBitmap;
    private TXVideoEditConstants.TXRect mTxWaterMarkRect;
    private int mCropWidth;
    private int mCropHeight;
    private int mDisplayType;
    private TXUGCPartsManager mTXUGCPartsManager;
    private long mCurrentRecordDuration;
    private int mRecordRetCode;
    private int mRecordSpeed = 2;
    private com.tencent.liteav.videoediter.ffmpeg.b mTXFFQuickJoiner;
    private boolean mInitCompelete = false;
    private TXCloudVideoView mTXCloudVideoView;
    private boolean mSnapshotRunning = false;
    private int mVoiceChangerType = 0;
    private float mSpecialRadio = 0.5f;
    private boolean mSmartLicenseSupport = true;
    private TXBeautyManager mBeautyManager;
    private i mUGCLicenceControl;
    private a mTouchFocusRunnable = new a();
    public static float PLAY_SPEED_FASTEST;
    public static float PLAY_SPEED_FAST;
    public static float PLAY_SPEED_SLOW;
    public static float PLAY_SPEED_SLOWEST;
    public static float ENCODE_SPEED_FASTEST;
    public static float ENCODE_SPEED_FAST;
    public static float ENCODE_SPEED_SLOW;
    public static float ENCODE_SPEED_SLOWEST;
    private static final int STATE_SUCCESS = 0;
    private static final int STATE_RECORDING = 1;
    private static final int STATE_NO_PERMISSION = -1;

    public static synchronized TXUGCRecord getInstance(Context context) {
        if (instance == null) {
            instance = new TXUGCRecord(context);
        }
        return instance;
    }

    protected TXUGCRecord(Context context) {
        if (context != null) {
            this.mContext = context.getApplicationContext();
            this.mMainHandler = new Handler(this.mContext.getMainLooper());
            TXCCommonUtil.setAppContext(this.mContext);
            TXCLog.init();
            this.mTXUGCPartsManager = new TXUGCPartsManager(this.mContext);
            this.mBgmPartBytesList = new CopyOnWriteArrayList();
            LicenceCheck.a().a((f)null, this.mContext);
        }
        this.mUseSWEncoder = g.h();
        this.initFileAndFolder();
        this.mUGCLicenceControl = new i(this.mContext);
        this.mBeautyManager = new com.tencent.liteav.beauty.b(this.mUGCLicenceControl);
        TXCAudioEngineJNI.nativeUseSysAudioDevice(true);
    }

    private void initFileAndFolder() {
        this.mSaveDir = this.getDefaultDir();
        this.mVideoFilePath = this.mSaveDir + File.separator + OUTPUT_VIDEO_NAME;
        this.mCoverPath = this.mSaveDir + File.separator + OUTPUT_VIDEO_COVER_NAME;
        this.mVideoFileTempDir = this.mSaveDir + File.separator + OUTPUT_TEMP_DIR_NAME;
        File file = new File(this.mVideoFileTempDir);
        if (!file.exists()) {
            file.mkdir();
        }
        this.mVideoFileCurTempPath = this.mVideoFileTempDir + File.separator + String.format("temp_TXUGC_%s.mp4", this.getTimeString());
        File file2 = new File(this.mVideoFilePath);
        if (file2.exists()) {
            file2.delete();
        }
    }

    public void setVideoRecordListener(TXRecordCommon.ITXVideoRecordListener iTXVideoRecordListener) {
        this.mVideoRecordListener = iTXVideoRecordListener;
    }

    @Override
    public void onDeleteLastPart() {
        if (this.mBgmPartBytesList.size() != 0) {
            this.mBgmPartBytesList.remove(this.mBgmPartBytesList.size() - 1);
            this.mBGMDeletePart = true;
            this.mEncodePcmDataSize = this.mBgmPartBytesList.size() > 0 ? this.mBgmPartBytesList.get(this.mBgmPartBytesList.size() - 1) : 0L;
        }
    }

    @Override
    public void onDeleteAllParts() {
        TXCLog.i(TAG, "onDeleteAllParts");
        this.mBgmPartBytesList.clear();
        this.mBGMDeletePart = false;
        this.mEncodePcmDataSize = 0L;
    }

    public int startCameraSimplePreview(TXRecordCommon.TXUGCSimpleConfig tXUGCSimpleConfig, TXCloudVideoView tXCloudVideoView) {
        if (tXCloudVideoView == null || tXUGCSimpleConfig == null) {
            TXCLog.e(TAG, "startCameraPreview: invalid param");
            return -1;
        }
        this.mConfig.u = tXUGCSimpleConfig.needEdit;
        this.mConfig.a = tXUGCSimpleConfig.videoQuality;
        this.mConfig.o = tXUGCSimpleConfig.isFront;
        this.mConfig.f = tXUGCSimpleConfig.touchFocus;
        this.mMinDuration = tXUGCSimpleConfig.minDuration;
        this.mMaxDuration = tXUGCSimpleConfig.maxDuration;
        this.startCameraPreviewInternal(tXCloudVideoView, this.mConfig);
        return 0;
    }

    public int startCameraCustomPreview(TXRecordCommon.TXUGCCustomConfig tXUGCCustomConfig, TXCloudVideoView tXCloudVideoView) {
        this.mConfig.u = tXUGCCustomConfig.needEdit;
        if (tXCloudVideoView == null || tXUGCCustomConfig == null) {
            TXCLog.e(TAG, "startCameraPreview: invalid param");
            return -1;
        }
        this.mConfig.a = -1;
        if (tXUGCCustomConfig.videoBitrate < 600) {
            tXUGCCustomConfig.videoBitrate = 600;
        }
        this.mConfig.d = tXUGCCustomConfig.needEdit ? 10000 : tXUGCCustomConfig.videoBitrate;
        TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bi, this.mConfig.d, "");
        if (tXUGCCustomConfig.videoFps < 15) {
            tXUGCCustomConfig.videoFps = 15;
        } else if (tXUGCCustomConfig.videoFps > 30) {
            tXUGCCustomConfig.videoFps = 30;
        }
        this.mConfig.c = tXUGCCustomConfig.videoFps;
        TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bj, this.mConfig.c, "");
        if (tXUGCCustomConfig.videoGop < 1) {
            tXUGCCustomConfig.videoGop = 1;
        } else if (tXUGCCustomConfig.videoGop > 10) {
            tXUGCCustomConfig.videoGop = 10;
        }
        this.mConfig.e = tXUGCCustomConfig.needEdit ? 0 : tXUGCCustomConfig.videoGop;
        TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bk, this.mConfig.e, "");
        this.mConfig.t = tXUGCCustomConfig.audioSampleRate != 8000 && tXUGCCustomConfig.audioSampleRate != 16000 && tXUGCCustomConfig.audioSampleRate != 32000 && tXUGCCustomConfig.audioSampleRate != 44100 && tXUGCCustomConfig.audioSampleRate != 48000 ? 48000 : tXUGCCustomConfig.audioSampleRate;
        this.mConfig.b = tXUGCCustomConfig.videoResolution;
        this.mConfig.o = tXUGCCustomConfig.isFront;
        this.mConfig.f = tXUGCCustomConfig.touchFocus;
        this.mConfig.q = tXUGCCustomConfig.enableHighResolutionCapture;
        this.mMinDuration = tXUGCCustomConfig.minDuration;
        this.mMaxDuration = tXUGCCustomConfig.maxDuration;
        this.mConfig.u = tXUGCCustomConfig.needEdit;
        this.startCameraPreviewInternal(tXCloudVideoView, this.mConfig);
        return 0;
    }

    public void setVideoResolution(int n2) {
        if (this.mRecordState != 1) {
            TXCLog.e(TAG, "setVideoResolution err, state not init");
            return;
        }
        if (this.mTXCloudVideoView == null) {
            TXCLog.e(TAG, "setVideoResolution, mTXCloudVideoView is null");
            return;
        }
        if (this.mConfig.b == n2) {
            TXCLog.i(TAG, "setVideoResolution, resolution not change");
            return;
        }
        this.mConfig.a = -1;
        this.mConfig.b = n2;
        this.stopCameraPreview();
        this.startCameraPreviewInternal(this.mTXCloudVideoView, this.mConfig);
    }

    public void setVideoBitrate(int n2) {
        if (this.mRecordState != 1) {
            TXCLog.e(TAG, "setVideoBitrate err, state not init");
            return;
        }
        this.mConfig.a = -1;
        this.mConfig.d = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCameraPreview() {
        this.mStartPreview.set(false);
        try {
            TXCLog.i(TAG, "ugcRecord, stopCameraPreview");
            TXUGCRecord tXUGCRecord = this;
            synchronized (tXUGCRecord) {
                this.mCapturing = false;
                if (this.mCameraCapture != null) {
                    this.mCameraCapture.g();
                }
            }
            if (this.mVideoView != null) {
                this.mVideoView.b(new Runnable(){

                    @Override
                    public void run() {
                        if (TXUGCRecord.this.mVideoPreprocessor != null) {
                            TXUGCRecord.this.mVideoPreprocessor.b();
                        }
                    }
                });
                this.mVideoView.b(false);
                this.mVideoView = null;
            }
            if (this.mCustomProcessListener != null) {
                this.mCustomProcessListener.onTextureDestroyed();
            }
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "stop camera preview failed.", exception);
        }
    }

    public TXUGCPartsManager getPartsManager() {
        return this.mTXUGCPartsManager;
    }

    public void setMute(boolean bl) {
        TXCAudioUGCRecorder.getInstance().setMute(bl);
    }

    public int startRecord() {
        TXCAudioEngineJNI.nativeUseSysAudioDevice(true);
        if (Build.VERSION.SDK_INT < 18) {
            TXCLog.e(TAG, "API level is too low (record need 18, current is " + Build.VERSION.SDK_INT + ")");
            return -3;
        }
        if (this.mRecording) {
            TXCLog.e(TAG, "startRecord: there is existing uncompleted record task");
            return -1;
        }
        try {
            TXCDRApi.initCrashReport(this.mContext);
            this.mCoverCurTempPath = this.mCoverPath;
            File file = new File(this.mCoverPath);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "delete file failed.", exception);
        }
        int n2 = this.startRecordInternal(true);
        return n2;
    }

    public int startRecord(String string2, String string3) {
        TXCAudioEngineJNI.nativeUseSysAudioDevice(true);
        if (Build.VERSION.SDK_INT < 18) {
            TXCLog.e(TAG, "API level is too low (record need 18, current is " + Build.VERSION.SDK_INT + ")");
            return -3;
        }
        if (this.mRecording) {
            TXCLog.e(TAG, "startRecord: there is existing uncompleted record task");
            return -1;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            TXCLog.e(TAG, "startRecord: init videoRecord failed, videoFilePath is empty");
            return -2;
        }
        this.mVideoFilePath = string2;
        File file = new File(string2);
        if (file.exists()) {
            file.delete();
        }
        String string4 = this.getDefaultDir();
        this.mVideoFileTempDir = string4 + File.separator + OUTPUT_TEMP_DIR_NAME;
        File file2 = new File(this.mVideoFileTempDir);
        if (!file2.exists()) {
            file2.mkdir();
        }
        this.mVideoFileCurTempPath = this.mVideoFileTempDir + File.separator + String.format("temp_TXUGC_%s.mp4", this.getTimeString());
        this.mCoverPath = string3;
        this.mCoverCurTempPath = string3;
        int n2 = this.startRecordInternal(true);
        return n2;
    }

    public int startRecord(String string2, String string3, String string4) {
        Object object;
        TXCAudioEngineJNI.nativeUseSysAudioDevice(true);
        if (Build.VERSION.SDK_INT < 18) {
            TXCLog.e(TAG, "API level is too low (record need 18, current is " + Build.VERSION.SDK_INT + ")");
            return -3;
        }
        if (this.mRecording) {
            TXCLog.e(TAG, "startRecord: there is existing uncompleted record task");
            return -1;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            TXCLog.e(TAG, "startRecord: init videoRecord failed, videoFilePath is empty");
            return -2;
        }
        this.mVideoFilePath = string2;
        File file = new File(string2);
        if (file.exists()) {
            file.delete();
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            this.mVideoFileTempDir = string3;
        } else {
            object = this.getDefaultDir();
            this.mVideoFileTempDir = (String)object + File.separator + OUTPUT_TEMP_DIR_NAME;
        }
        object = new File(this.mVideoFileTempDir);
        if (!((File)object).exists()) {
            ((File)object).mkdir();
        }
        this.mVideoFileCurTempPath = this.mVideoFileTempDir + File.separator + String.format("temp_TXUGC_%s.mp4", this.getTimeString());
        this.mCoverPath = string4;
        this.mCoverCurTempPath = string4;
        int n2 = this.startRecordInternal(true);
        return n2;
    }

    private int startRecordInternal(boolean bl) {
        File file;
        if (!this.mInitCompelete) {
            TXCLog.i(TAG, "startRecordInternal, mInitCompelete = " + this.mInitCompelete);
            return -4;
        }
        if (!this.checkLicenseMatch()) {
            return -5;
        }
        TXCAudioUGCRecorder.getInstance().setAECType(0, this.mContext);
        TXCAudioUGCRecorder.getInstance().setListener(this);
        TXCAudioUGCRecorder.getInstance().setChannels(1);
        TXCAudioUGCRecorder.getInstance().setSampleRate(this.mConfig.t);
        if (bl) {
            TXCAudioUGCRecorder.getInstance().startRecord(this.mContext);
        }
        switch (this.mRecordSpeed) {
            case 4: {
                TXCAudioUGCRecorder.getInstance().setSpeedRate(ENCODE_SPEED_FASTEST);
                break;
            }
            case 3: {
                TXCAudioUGCRecorder.getInstance().setSpeedRate(ENCODE_SPEED_FAST);
                break;
            }
            case 2: {
                TXCAudioUGCRecorder.getInstance().setSpeedRate(1.0f);
                break;
            }
            case 1: {
                TXCAudioUGCRecorder.getInstance().setSpeedRate(ENCODE_SPEED_SLOW);
                break;
            }
            case 0: {
                TXCAudioUGCRecorder.getInstance().setSpeedRate(ENCODE_SPEED_SLOWEST);
            }
        }
        if (this.mVideoEncoder != null) {
            this.mVideoWidth = 0;
            this.mVideoHeight = 0;
        }
        boolean bl2 = this.mUseSWEncoder = this.mConfig.g < 1280 && this.mConfig.h < 1280;
        if (this.mMP4Muxer == null) {
            this.mMP4Muxer = new c(this.mContext, this.mUseSWEncoder ? 0 : 2);
        }
        if (!(file = new File(this.mVideoFileCurTempPath)).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                TXCLog.e(TAG, "create new file failed.", iOException);
            }
        }
        TXCLog.i(TAG, "startRecord");
        this.mMP4Muxer.a(this.mRecordSpeed);
        this.mMP4Muxer.a(this.mVideoFileCurTempPath);
        this.addAudioTrack();
        TXCDRApi.txReportDAU(this.mContext.getApplicationContext(), com.tencent.liteav.basic.datareport.a.au);
        this.mRecordState = 2;
        this.mRecording = true;
        this.mRecordStartTime = 0L;
        TXCAudioUGCRecorder.getInstance().resume();
        return 0;
    }

    public int stopRecord() {
        TXCLog.i(TAG, "stopRecord called, mRecording = " + this.mRecording + ", needCompose = " + this.needCompose);
        if (this.mRecording) {
            this.needCompose = true;
            return this.stopRecordForClip();
        }
        int n2 = this.quickJoiner();
        if (n2 != 0) {
            this.callbackRecordFail(n2);
        }
        this.mBgmPartBytesList.clear();
        this.mEncodePcmDataSize = 0L;
        return 0;
    }

    private int quickJoiner() {
        if (this.mTXFFQuickJoiner == null) {
            this.mTXFFQuickJoiner = new com.tencent.liteav.videoediter.ffmpeg.b("compose");
        }
        this.mTXFFQuickJoiner.a(new b.a(){

            @Override
            public void a(com.tencent.liteav.videoediter.ffmpeg.b b2, int n2, String string2) {
                if (n2 == 0) {
                    TXUGCRecord.this.callbackRecordSuccess();
                } else if (n2 == 1) {
                    TXUGCRecord.this.callbackRecordFail(-7);
                    TXLog.e(TXUGCRecord.TAG, "quickJoiner, quick joiner result cancel");
                } else if (n2 == -1) {
                    TXUGCRecord.this.callbackRecordFail(-8);
                    TXLog.e(TXUGCRecord.TAG, "quickJoiner, quick joiner result verify fail");
                } else if (n2 == -2) {
                    TXUGCRecord.this.callbackRecordFail(-9);
                    TXLog.e(TXUGCRecord.TAG, "quickJoiner, quick joiner result err");
                }
                b2.a((b.a)null);
                b2.c();
                b2.d();
                TXUGCRecord.this.mTXFFQuickJoiner = null;
                TXUGCRecord.this.mRecordState = 1;
            }

            @Override
            public void a(com.tencent.liteav.videoediter.ffmpeg.b b2, float f2) {
                TXCLog.i(TXUGCRecord.TAG, "joiner progress " + f2);
            }
        });
        int n2 = 0;
        n2 = this.mTXFFQuickJoiner.a(this.mTXUGCPartsManager.getPartsPathList());
        if (n2 != 0) {
            TXLog.e(TAG, "quickJoiner, quick joiner set src path err");
            this.destroyQuickJoiner();
            return -4;
        }
        n2 = this.mTXFFQuickJoiner.a(this.mVideoFilePath);
        if (n2 != 0) {
            TXLog.e(TAG, "quickJoiner, quick joiner set dst path err, mVideoFilePath = " + this.mVideoFilePath);
            this.destroyQuickJoiner();
            return -5;
        }
        n2 = this.mTXFFQuickJoiner.b();
        TXCLog.i(TAG, "quickJoiner start");
        if (n2 != 0) {
            TXLog.e(TAG, "quickJoiner, quick joiner start fail");
            this.destroyQuickJoiner();
            return -6;
        }
        return 0;
    }

    private void destroyQuickJoiner() {
        if (this.mTXFFQuickJoiner != null) {
            this.mTXFFQuickJoiner.a((b.a)null);
            this.mTXFFQuickJoiner.c();
            this.mTXFFQuickJoiner.d();
        }
        this.mTXFFQuickJoiner = null;
        this.mRecordState = 1;
    }

    public void release() {
        TXCLog.i(TAG, "release");
        TXCAudioUGCRecorder.getInstance().stopRecord();
        TXCAudioUGCRecorder.getInstance().setChangerType(0);
        TXCAudioUGCRecorder.getInstance().setReverbType(0);
        TXCAudioUGCRecorder.getInstance().setSpeedRate(1.0f);
        this.mTXCloudVideoView = null;
        this.mRecordState = 1;
        this.mRenderMode = 0;
        if (this.mVideoPreprocessor != null) {
            this.mVideoPreprocessor.a((com.tencent.liteav.beauty.f)null);
        }
        TXCAudioEngineJNI.nativeUseSysAudioDevice(false);
        this.mRecordStartTime = 0L;
        this.mEncodePcmDataSize = 0L;
        this.mStartMuxer = false;
        this.mRecording = false;
        this.needCompose = false;
        this.isReachedMaxDuration = false;
        this.mSnapshotRunning = false;
        this.mCapturing = false;
        this.mCurrentRecordDuration = 0L;
        this.mBGMDeletePart = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stopRecordForClip() {
        Object object;
        TXCLog.i(TAG, "stopRecordForClip");
        if (!this.mRecording) {
            TXCLog.e(TAG, "stopRecordForClip: there is no existing uncompleted record task");
            return -2;
        }
        int n2 = 0;
        TXCAudioUGCRecorder.getInstance().pause();
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.c();
        }
        this.mStartMuxer = false;
        this.stopEncoder(this.mVideoEncoder);
        this.mVideoEncoder = null;
        Object object2 = this;
        synchronized (object2) {
            this.mRecording = false;
            if (this.mMP4Muxer != null) {
                n2 = this.mMP4Muxer.b();
                this.mMP4Muxer = null;
            }
        }
        object2 = new File(this.mVideoFileCurTempPath);
        if (n2 != 0) {
            if (((File)object2).exists()) {
                this.asyncDeleteFile(this.mVideoFileCurTempPath);
                this.mVideoFileCurTempPath = null;
            }
            TXCLog.e(TAG, "stopRecordForClip, maybe mMP4Muxer not write data");
            if (!TextUtils.isEmpty((CharSequence)this.mBGMPath)) {
                this.mBGMDeletePart = true;
            }
            if (!this.needCompose && !this.isReachedMaxDuration) {
                return -3;
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.mVideoFileCurTempPath) || !((File)object2).exists() || ((File)object2).length() == 0L || this.mCurrentRecordDuration < 150L) {
            TXCLog.e(TAG, "stopRecordForClip, file err ---> path = " + this.mVideoFileCurTempPath + ", mCurrentRecordDuration(ms) too short = " + this.mCurrentRecordDuration);
            if (!TextUtils.isEmpty((CharSequence)this.mBGMPath)) {
                this.mBGMDeletePart = true;
            }
            if (((File)object2).exists()) {
                this.asyncDeleteFile(this.mVideoFileCurTempPath);
            }
            if (!this.needCompose && !this.isReachedMaxDuration) {
                return -3;
            }
        } else {
            TXCLog.i(TAG, "stopRecordForClip, tempVideoFile exist, path = " + this.mVideoFileCurTempPath + ", length = " + ((File)object2).length());
            object = new PartInfo();
            ((PartInfo)object).setPath(this.mVideoFileCurTempPath);
            ((PartInfo)object).setDuration(this.mCurrentRecordDuration);
            this.mTXUGCPartsManager.addClipInfo((PartInfo)object);
            if (!TextUtils.isEmpty((CharSequence)this.mBGMPath)) {
                long l2 = this.mEncodePcmDataSize;
                this.mBgmPartBytesList.add(l2);
                this.mBGMDeletePart = false;
            }
            this.callbackEvent(1, null);
        }
        object = this.mCoverCurTempPath;
        if (!TextUtils.isEmpty((CharSequence)this.mCoverCurTempPath)) {
            this.mCoverCurTempPath = null;
        }
        this.asyncGenCoverAndDetermineCompose((String)object);
        return 0;
    }

    private void asyncGenCoverAndDetermineCompose(final String string2) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!TextUtils.isEmpty((CharSequence)TXUGCRecord.this.mVideoFileCurTempPath) && !TextUtils.isEmpty((CharSequence)string2)) {
                        g.a(TXUGCRecord.this.mVideoFileCurTempPath, string2);
                    }
                }
                catch (Exception exception) {
                    TXCLog.e(TXUGCRecord.TAG, "gen video thumb failed.", exception);
                }
                TXUGCRecord.this.mMainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        TXCLog.i(TXUGCRecord.TAG, "stopRecordForClip, isReachedMaxDuration = " + TXUGCRecord.this.isReachedMaxDuration + ", needCompose = " + TXUGCRecord.this.needCompose);
                        if (TXUGCRecord.this.isReachedMaxDuration) {
                            TXUGCRecord.this.mRecordRetCode = 2;
                            int n2 = TXUGCRecord.this.quickJoiner();
                            if (n2 != 0) {
                                TXUGCRecord.this.callbackRecordFail(n2);
                            }
                            return;
                        }
                        if (TXUGCRecord.this.needCompose) {
                            TXUGCRecord.this.mRecordRetCode = 0;
                            TXUGCRecord.this.needCompose = false;
                            int n3 = TXUGCRecord.this.quickJoiner();
                            if (n3 != 0) {
                                TXUGCRecord.this.callbackRecordFail(n3);
                            }
                        }
                    }
                });
            }
        }).start();
    }

    private void callbackRecordFail(int n2) {
        TXRecordCommon.TXRecordResult tXRecordResult = new TXRecordCommon.TXRecordResult();
        tXRecordResult.retCode = n2;
        tXRecordResult.descMsg = "record video failed";
        if (this.mVideoRecordListener != null) {
            this.mVideoRecordListener.onRecordComplete(tXRecordResult);
        }
    }

    private void callbackRecordSuccess() {
        TXRecordCommon.TXRecordResult tXRecordResult = new TXRecordCommon.TXRecordResult();
        long l2 = this.mTXUGCPartsManager.getDuration();
        if (l2 < (long)this.mMinDuration) {
            this.mRecordRetCode = 1;
        }
        tXRecordResult.retCode = this.mRecordRetCode;
        tXRecordResult.descMsg = "record success";
        tXRecordResult.videoPath = this.mVideoFilePath;
        tXRecordResult.coverPath = this.mCoverPath;
        if (this.mVideoRecordListener != null) {
            this.mVideoRecordListener.onRecordComplete(tXRecordResult);
        }
    }

    private String getDefaultDir() {
        String string2 = null;
        if ("mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable()) {
            File file = this.mContext.getExternalFilesDir(null);
            if (file == null) {
                Log.e((String)TAG, (String)"getDefaultDir sdcardDir is null");
                return null;
            }
            String string3 = file + File.separator + OUTPUT_DIR_NAME;
            File file2 = new File(string3);
            if (!file2.exists()) {
                file2.mkdir();
            }
            return string3;
        }
        File file = this.mContext.getFilesDir();
        if (file != null) {
            string2 = file.getPath();
        }
        return string2;
    }

    private String getTimeString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmssSSS");
        return simpleDateFormat.format(new Date(System.currentTimeMillis()));
    }

    private void asyncDeleteFile(final String string2) {
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        try {
            new AsyncTask(){

                protected Object doInBackground(Object[] objectArray) {
                    File file = new File(string2);
                    if (file.isFile() && file.exists()) {
                        file.delete();
                    }
                    return null;
                }
            }.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Object[0]);
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "asyncDeleteFile, exception = " + exception);
        }
    }

    public int pauseRecord() {
        if (!this.mRecording) {
            TXCLog.e(TAG, "pauseRecord: there is no existing uncompleted record task");
            return -2;
        }
        TXCLog.i(TAG, "pauseRecord called");
        this.mRecordState = 3;
        int n2 = this.stopRecordForClip();
        return n2;
    }

    public int resumeRecord() {
        if (this.mRecording) {
            TXCLog.e(TAG, "resumeRecord: there is existing uncompleted record task");
            return -1;
        }
        TXCLog.i(TAG, "resumeRecord called");
        this.mVideoFileCurTempPath = this.mVideoFileTempDir + File.separator + String.format("temp_TXUGC_%s.mp4", this.getTimeString());
        int n2 = this.startRecordInternal(false);
        this.callbackEvent(2, null);
        return n2;
    }

    private void changeRecordSpeed() {
        switch (this.mRecordSpeed) {
            case 3: {
                TXCUGCBGMPlayer.getInstance().setSpeedRate(PLAY_SPEED_FAST);
                TXCAudioUGCRecorder.getInstance().setSpeedRate(ENCODE_SPEED_FAST);
                TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bl, this.mRecordSpeed, "FAST");
                break;
            }
            case 4: {
                TXCUGCBGMPlayer.getInstance().setSpeedRate(PLAY_SPEED_FASTEST);
                TXCAudioUGCRecorder.getInstance().setSpeedRate(ENCODE_SPEED_FASTEST);
                TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bb);
                TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bl, this.mRecordSpeed, "FASTEST");
                break;
            }
            case 2: {
                TXCUGCBGMPlayer.getInstance().setSpeedRate(1.0f);
                TXCAudioUGCRecorder.getInstance().setSpeedRate(1.0f);
                TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bl, this.mRecordSpeed, "NORMAL");
                break;
            }
            case 1: {
                TXCUGCBGMPlayer.getInstance().setSpeedRate(PLAY_SPEED_SLOW);
                TXCAudioUGCRecorder.getInstance().setSpeedRate(ENCODE_SPEED_SLOW);
                TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bl, this.mRecordSpeed, "SLOW");
                break;
            }
            case 0: {
                TXCUGCBGMPlayer.getInstance().setSpeedRate(PLAY_SPEED_SLOWEST);
                TXCAudioUGCRecorder.getInstance().setSpeedRate(ENCODE_SPEED_SLOWEST);
                TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bl, this.mRecordSpeed, "SLOWEST");
            }
        }
    }

    public boolean setMicVolume(float f2) {
        TXCAudioUGCRecorder.getInstance().setVolume(f2);
        return true;
    }

    public boolean switchCamera(final boolean bl) {
        this.mConfig.o = bl;
        if (this.mVideoView != null) {
            final TXCGLSurfaceView tXCGLSurfaceView = this.mVideoView;
            this.mVideoView.b(new Runnable(){

                @Override
                public void run() {
                    if (TXUGCRecord.this.mCameraCapture != null && tXCGLSurfaceView != null) {
                        TXUGCRecord.this.mCameraCapture.g();
                        tXCGLSurfaceView.a(false);
                        TXUGCRecord.this.mCameraCapture.a(tXCGLSurfaceView.getSurfaceTexture());
                        int n2 = TXUGCRecord.this.mCameraCapture.d(bl);
                        if (n2 == 0) {
                            TXUGCRecord.this.mCapturing = true;
                        } else {
                            TXUGCRecord.this.mCapturing = false;
                            TXUGCRecord.this.callbackEvent(3, null);
                        }
                        tXCGLSurfaceView.a(((TXUGCRecord)TXUGCRecord.this).mConfig.c, true);
                    }
                    TXUGCRecord.this.setWatermark(TXUGCRecord.this.mWatermarkBitmap, TXUGCRecord.this.mTxWaterMarkRect);
                }
            });
        }
        return true;
    }

    public void setAspectRatio(int n2) {
        this.mDisplayType = n2;
        if (n2 == 0) {
            this.mCropWidth = this.mConfig.g;
            this.mCropHeight = this.mConfig.h;
            TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bd);
        } else if (n2 == 1) {
            int n3 = (int)((float)this.mConfig.g * 4.0f / 3.0f);
            this.mCropHeight = n3 / 16 * 16;
            this.mCropWidth = this.mConfig.g;
            TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bc);
        } else if (n2 == 2) {
            this.mCropHeight = this.mConfig.g;
            this.mCropWidth = this.mConfig.g;
            TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bb);
        } else if (n2 == 3) {
            this.mCropHeight = this.mConfig.g * 9 / 16;
            this.mCropHeight = (this.mCropHeight + 15) / 16 * 16;
            this.mCropWidth = this.mConfig.g;
            TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bp);
        } else if (n2 == 4) {
            int n4 = (int)((float)this.mConfig.g * 3.0f / 4.0f);
            this.mCropHeight = n4 / 16 * 16;
            this.mCropWidth = this.mConfig.g;
            TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bq);
        }
    }

    private boolean checkLicenseMatch() {
        int n2 = LicenceCheck.a().a((f)null, this.mContext);
        if (n2 != 0) {
            TXCLog.e(TAG, "checkLicenseMatch, checkErrCode = " + n2);
            return false;
        }
        if (LicenceCheck.a().b() == 2 && !this.mSmartLicenseSupport) {
            TXCLog.e(TAG, "checkLicenseMatch, called UnSupported method!");
        }
        return true;
    }

    private boolean isSmartLicense() {
        LicenceCheck.a().a((f)null, this.mContext);
        if (LicenceCheck.a().b() == -1) {
            TXCLog.i(TAG, "isSmartLicense, license type is = " + LicenceCheck.a().b());
            this.mSmartLicenseSupport = false;
        } else if (LicenceCheck.a().b() == 2) {
            return true;
        }
        return false;
    }

    public void snapshot(final TXRecordCommon.ITXSnapshotListener iTXSnapshotListener) {
        if (!this.checkLicenseMatch()) {
            return;
        }
        if (this.mSnapshotRunning || iTXSnapshotListener == null) {
            return;
        }
        this.mSnapshotRunning = true;
        if (this.mVideoView != null) {
            this.mVideoView.a(new p(){

                @Override
                public void onTakePhotoComplete(Bitmap bitmap) {
                    iTXSnapshotListener.onSnapshot(bitmap);
                }
            });
        }
        this.mSnapshotRunning = false;
    }

    public void setRecordSpeed(int n2) {
        if (this.isSmartLicense()) {
            TXCLog.e(TAG, "setRecordSpeed is not supported in UGC_Smart license");
            return;
        }
        this.mRecordSpeed = n2;
        if (!TextUtils.isEmpty((CharSequence)this.mBGMPath)) {
            this.changeRecordSpeed();
        }
    }

    public void setVideoProcessListener(VideoCustomProcessListener videoCustomProcessListener) {
        if (this.isSmartLicense()) {
            TXCLog.e(TAG, "setVideoProcessListener is not supported in UGC_Smart license");
            return;
        }
        this.mCustomProcessListener = videoCustomProcessListener;
    }

    public void setReverb(int n2) {
        if (this.isSmartLicense()) {
            TXCLog.e(TAG, "setReverb is not supported in UGC_Smart license");
            return;
        }
        TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bo, n2, "");
        TXCAudioUGCRecorder.getInstance().setReverbType(n2);
        TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.az);
    }

    public void setVoiceChangerType(int n2) {
        if (this.isSmartLicense()) {
            TXCLog.e(TAG, "setVoiceChangerType is not supported in UGC_Smart license");
            return;
        }
        this.mVoiceChangerType = n2;
        TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bn, n2, "");
        TXCAudioUGCRecorder.getInstance().setChangerType(n2);
    }

    public int setBGM(String string2) {
        TXCAudioEngineJNI.nativeUseSysAudioDevice(true);
        if (this.isSmartLicense()) {
            TXCLog.e(TAG, "setBGM is not supported in UGC_Smart license");
            return -1;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            TXCLog.e(TAG, "setBGM, path is empty");
            this.stopBGM();
            TXCUGCBGMPlayer.getInstance().setOnPlayListener(null);
            return 0;
        }
        this.mBGMPath = string2;
        TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bm);
        if (this.mBGMNotifyProxy == null) {
            this.mBGMNotifyProxy = new com.tencent.liteav.audio.g(){

                @Override
                public void onPlayStart() {
                    TXUGCRecord.this.mBGMPlayStop = false;
                    if (TXUGCRecord.this.mBGMNotify != null) {
                        TXUGCRecord.this.mBGMNotify.onBGMStart();
                    }
                }

                @Override
                public void onPlayEnd(int n2) {
                    if (TXUGCRecord.this.mBGMNotify != null) {
                        TXUGCRecord.this.mBGMNotify.onBGMComplete(0);
                    }
                    TXUGCRecord.this.mMainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (TXUGCRecord.this.mRecording) {
                                TXCUGCBGMPlayer.getInstance().stopPlay();
                                TXCUGCBGMPlayer.getInstance().playFromTime(TXUGCRecord.this.mBGMStartTime, TXUGCRecord.this.mBGMEndTime);
                                TXCUGCBGMPlayer.getInstance().startPlay(TXUGCRecord.this.mBGMPath, true);
                            }
                        }
                    });
                }

                @Override
                public void onPlayProgress(long l2, long l3) {
                    if (TXUGCRecord.this.mBGMNotify != null) {
                        TXUGCRecord.this.mBGMNotify.onBGMProgress(l2, l3);
                    }
                }
            };
        }
        TXCUGCBGMPlayer.getInstance().setOnPlayListener(this.mBGMNotifyProxy);
        return (int)TXCUGCBGMPlayer.getInstance().getDurationMS(string2);
    }

    public void setBGMNofify(TXRecordCommon.ITXBGMNotify iTXBGMNotify) {
        if (this.isSmartLicense()) {
            TXCLog.e(TAG, "setBGMNofify is not supported in UGC_Smart license");
            return;
        }
        this.mBGMNotify = iTXBGMNotify == null ? null : iTXBGMNotify;
    }

    public boolean playBGMFromTime(int n2, int n3) {
        if (this.isSmartLicense()) {
            TXCLog.e(TAG, "playBGMFromTime is not supported in UGC_Smart license");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mBGMPath)) {
            TXCLog.e(TAG, "playBGMFromTime, path is empty");
            return false;
        }
        if (n2 < 0 || n3 < 0) {
            TXCLog.e(TAG, "playBGMFromTime, time is negative number");
            return false;
        }
        if (n2 >= n3) {
            TXCLog.e(TAG, "playBGMFromTime, start time is bigger than end time");
            return false;
        }
        this.mBGMStartTime = n2;
        this.mBGMEndTime = n3;
        this.mBGMDeletePart = false;
        this.mTXUGCPartsManager.setPartsManagerObserver(this);
        this.changeRecordSpeed();
        TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.aA);
        if (TXCAudioUGCRecorder.getInstance().isRecording()) {
            TXCAudioUGCRecorder.getInstance().enableBGMRecord(true);
        }
        TXCUGCBGMPlayer.getInstance().playFromTime(n2, n3);
        TXCUGCBGMPlayer.getInstance().startPlay(this.mBGMPath, TXCAudioUGCRecorder.getInstance().isRecording() && !TXCAudioUGCRecorder.getInstance().isPaused());
        return true;
    }

    public boolean stopBGM() {
        if (this.isSmartLicense()) {
            TXCLog.e(TAG, "stopBGM is not supported in UGC_Smart license");
            return false;
        }
        this.mBGMPath = null;
        this.mTXUGCPartsManager.removePartsManagerObserver(this);
        TXCUGCBGMPlayer.getInstance().stopPlay();
        TXCAudioUGCRecorder.getInstance().enableBGMRecord(false);
        TXCUGCBGMPlayer.getInstance().setOnPlayListener(null);
        return true;
    }

    public boolean pauseBGM() {
        if (this.isSmartLicense()) {
            TXCLog.e(TAG, "pauseBGM is not supported in UGC_Smart license");
            return false;
        }
        TXCUGCBGMPlayer.getInstance().pause();
        return true;
    }

    public boolean resumeBGM() {
        if (this.isSmartLicense()) {
            TXCLog.e(TAG, "resumeBGM is not supported in UGC_Smart license");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mBGMPath)) {
            TXCLog.e(TAG, "resumeBGM, mBGMPath is empty");
            return false;
        }
        this.changeRecordSpeed();
        if (this.mBGMDeletePart) {
            long l2 = 0L;
            if (this.mBgmPartBytesList.size() > 0) {
                l2 = this.mBgmPartBytesList.get(this.mBgmPartBytesList.size() - 1);
            }
            TXCLog.i(TAG, "resumeBGM, curBGMBytesProgress = " + l2);
            if (this.mBGMPlayStop) {
                TXCUGCBGMPlayer.getInstance().startPlay(this.mBGMPath, TXCAudioUGCRecorder.getInstance().isRecording());
            }
            TXCAudioUGCRecorder.getInstance().clearCache();
            TXCUGCBGMPlayer.getInstance().seekBytes(l2);
        }
        TXCUGCBGMPlayer.getInstance().resume();
        return true;
    }

    public boolean seekBGM(int n2, int n3) {
        if (this.isSmartLicense()) {
            TXCLog.e(TAG, "seekBGM is not supported in UGC_Smart license");
            return false;
        }
        TXCUGCBGMPlayer.getInstance().playFromTime(n2, n3);
        return true;
    }

    public boolean setBGMVolume(float f2) {
        if (this.isSmartLicense()) {
            TXCLog.e(TAG, "setBGMVolume is not supported in UGC_Smart license");
            return false;
        }
        TXCUGCBGMPlayer.getInstance().setVolume(f2);
        return true;
    }

    public int getMusicDuration(String string2) {
        if (this.isSmartLicense()) {
            TXCLog.e(TAG, "getMusicDuration is not supported in UGC_Smart license");
            return 0;
        }
        return (int)TXCUGCBGMPlayer.getInstance().getDurationMS(string2);
    }

    public void setWatermark(Bitmap bitmap, TXVideoEditConstants.TXRect tXRect) {
        if (this.isSmartLicense()) {
            TXCLog.e(TAG, "setWatermark is not supported in UGC_Smart license");
            return;
        }
        if (this.mVideoPreprocessor != null && bitmap != null && tXRect != null) {
            this.mVideoPreprocessor.a(bitmap, tXRect.x, tXRect.y, tXRect.width);
        }
        this.mWatermarkBitmap = bitmap;
        this.mTxWaterMarkRect = tXRect;
    }

    @Deprecated
    public void setMotionTmpl(String string2) {
        this.mBeautyManager.setMotionTmpl(string2);
    }

    @Deprecated
    public void setMotionMute(boolean bl) {
        this.mBeautyManager.setMotionMute(bl);
    }

    @Deprecated
    @TargetApi(value=18)
    public void setGreenScreenFile(String string2, boolean bl) {
        if (Build.VERSION.SDK_INT < 18) {
            return;
        }
        this.getBeautyManager().setGreenScreenFile(string2);
    }

    @Deprecated
    public void setFaceVLevel(int n2) {
        this.mBeautyManager.setFaceVLevel(n2);
    }

    @Deprecated
    public void setFaceShortLevel(int n2) {
        this.mBeautyManager.setFaceShortLevel(n2);
    }

    @Deprecated
    public void setChinLevel(int n2) {
        this.mBeautyManager.setChinLevel(n2);
    }

    @Deprecated
    public void setNoseSlimLevel(int n2) {
        this.mBeautyManager.setNoseSlimLevel(n2);
    }

    @Deprecated
    public void setEyeScaleLevel(float f2) {
        this.mBeautyManager.setEyeScaleLevel((int)f2);
    }

    @Deprecated
    public void setFaceScaleLevel(float f2) {
        this.mBeautyManager.setFaceSlimLevel((int)f2);
    }

    @Deprecated
    public void setBeautyStyle(int n2) {
        this.mBeautyManager.setBeautyStyle(n2);
    }

    @Deprecated
    public void setBeautyDepth(int n2, int n3, int n4, int n5) {
        this.mBeautyManager.setBeautyStyle(n2);
        this.mBeautyManager.setBeautyLevel(n3);
        this.mBeautyManager.setWhitenessLevel(n4);
        this.mBeautyManager.setRuddyLevel(n5);
    }

    @Deprecated
    public void setFilter(Bitmap bitmap) {
        this.getBeautyManager().setFilter(bitmap);
    }

    public void setFilter(Bitmap bitmap, float f2, Bitmap bitmap2, float f3, float f4) {
        if (this.mVideoPreprocessor != null) {
            this.mVideoPreprocessor.a(f4, bitmap, f2, bitmap2, f3);
        }
    }

    @Deprecated
    public void setSpecialRatio(float f2) {
        this.mSpecialRadio = f2;
        this.getBeautyManager().setFilterStrength(f2);
    }

    private void setSharpenLevel(int n2) {
        if (this.mVideoPreprocessor != null) {
            this.mVideoPreprocessor.f(n2);
        }
    }

    public boolean toggleTorch(boolean bl) {
        if (this.mCameraCapture != null) {
            this.mCameraCapture.a(bl);
        }
        return true;
    }

    public int getMaxZoom() {
        if (this.mCameraCapture == null) {
            return 0;
        }
        return this.mCameraCapture.f();
    }

    public boolean setZoom(int n2) {
        if (this.mCameraCapture != null) {
            return this.mCameraCapture.b(n2);
        }
        return false;
    }

    public void setFocusPosition(float f2, float f3) {
        this.mTouchFocusRunnable.a(f2, f3);
        this.mMainHandler.postDelayed((Runnable)this.mTouchFocusRunnable, 100L);
    }

    public void setVideoRenderMode(int n2) {
        this.mRenderMode = n2 == 1 ? 1 : 0;
    }

    private int startCameraPreviewInternal(TXCloudVideoView tXCloudVideoView, k k2) {
        TXCLog.i(TAG, "ugcRecord, startCameraPreviewInternal");
        this.mStartPreview.set(true);
        if (this.mTXCloudVideoView != null) {
            this.mTXCloudVideoView.removeVideoView();
            this.mTXCloudVideoView.removeFocusIndicatorView();
        }
        this.mTXCloudVideoView = tXCloudVideoView;
        this.initConfig();
        this.calcVideoEncInfo();
        this.initModules();
        this.mInitCompelete = false;
        this.mVideoView.setRendMode(this.mRenderMode);
        this.mVideoView.setSurfaceTextureListener(this);
        return 0;
    }

    public void setHomeOrientation(int n2) {
        this.mCameraOrientationReadyChange = n2;
        this.resetRotation();
    }

    public void setRenderRotation(int n2) {
        this.mRenderRotationReadyChange = n2;
        this.resetRotation();
    }

    private void resetRotation() {
        if (this.mVideoView != null) {
            this.mVideoView.b(new Runnable(){

                @Override
                public void run() {
                    if (TXUGCRecord.this.mRenderRotationReadyChange != -1) {
                        ((TXUGCRecord)TXUGCRecord.this).mConfig.s = TXUGCRecord.this.mRenderRotationReadyChange;
                        TXUGCRecord.this.mRenderRotationReadyChange = -1;
                    }
                    if (TXUGCRecord.this.mCameraOrientationReadyChange != -1) {
                        ((TXUGCRecord)TXUGCRecord.this).mConfig.r = TXUGCRecord.this.mCameraOrientationReadyChange;
                        TXUGCRecord.this.mCameraCapture.c(((TXUGCRecord)TXUGCRecord.this).mConfig.r);
                        TXUGCRecord.this.mCameraOrientationReadyChange = -1;
                    }
                }
            });
        } else {
            this.mConfig.s = this.mRenderRotationReadyChange;
            this.mConfig.r = this.mCameraOrientationReadyChange;
        }
    }

    @TargetApi(value=16)
    private void addAudioTrack() {
        MediaFormat mediaFormat = g.a(TXCAudioUGCRecorder.getInstance().getSampleRate(), TXCAudioUGCRecorder.getInstance().getChannels(), 2);
        if (this.mMP4Muxer != null) {
            this.mMP4Muxer.b(mediaFormat);
        }
    }

    private void initModules() {
        this.mVideoView = this.mTXCloudVideoView.getGLSurfaceView();
        if (this.mVideoView == null) {
            this.mVideoView = new TXCGLSurfaceView(this.mTXCloudVideoView.getContext());
            this.mTXCloudVideoView.addVideoView(this.mVideoView);
        }
        if (this.mCameraCapture == null) {
            this.mCameraCapture = new com.tencent.liteav.capturer.a();
        }
        this.mCameraCapture.a(this.mConfig.q ? a.a.i : this.mCameraResolution);
        this.mCameraCapture.a(this.mConfig.c);
        if (this.mVideoPreprocessor == null) {
            this.mVideoPreprocessor = new e(this.mContext, true);
        }
        this.mVideoPreprocessor.a(this);
        this.mVideoEncoder = null;
        this.mBeautyManager.setPreprocessor(this.mVideoPreprocessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startCapture(SurfaceTexture surfaceTexture) {
        TXUGCRecord tXUGCRecord = this;
        synchronized (tXUGCRecord) {
            TXCLog.i(TAG, "startCapture, mCapturing = " + this.mCapturing + ", mCameraCapture = " + this.mCameraCapture);
            if (surfaceTexture != null && !this.mCapturing) {
                this.mCameraCapture.a(surfaceTexture);
                this.mCameraCapture.a(this.mConfig.c);
                this.mCameraCapture.c(this.mConfig.f);
                TXCLog.i(TAG, "startCapture, setHomeOriention = " + this.mConfig.r);
                this.mCameraCapture.c(this.mConfig.r);
                int n2 = this.mCameraCapture.d(this.mConfig.o);
                if (n2 == 0) {
                    this.mCapturing = true;
                    if (this.mVideoView != null) {
                        this.mVideoView.setFPS(this.mConfig.c);
                        this.mVideoView.setSurfaceTextureListener(this);
                        this.mVideoView.setNotifyListener(this);
                        this.mVideoView.a(this.mConfig.c, true);
                    }
                    return true;
                }
                this.mCapturing = false;
                TXLog.e(TAG, "startCapture fail!");
                this.onRecordError();
                return false;
            }
        }
        return false;
    }

    private void stopEncoder(final com.tencent.liteav.videoencoder.b b2) {
        if (this.mVideoView != null) {
            this.mVideoView.b(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (b2 != null) {
                            b2.a();
                            b2.a((d)null);
                        }
                    }
                    catch (Exception exception) {
                        TXCLog.e(TXUGCRecord.TAG, "stop encoder failed.", exception);
                    }
                }
            });
        }
    }

    private void startEncoder(int n2, int n3) {
        TXCLog.i(TAG, "New encode size width = " + n2 + " height = " + n3 + ", mVideoView = " + this.mVideoView);
        this.stopEncoder(this.mVideoEncoder);
        this.mVideoEncoder = null;
        EGL10 eGL10 = (EGL10)EGLContext.getEGL();
        EGLContext eGLContext = eGL10.eglGetCurrentContext();
        this.mVideoWidth = n2;
        this.mVideoHeight = n3;
        TXSVideoEncoderParam tXSVideoEncoderParam = new TXSVideoEncoderParam();
        tXSVideoEncoderParam.width = n2;
        tXSVideoEncoderParam.height = n3;
        tXSVideoEncoderParam.fps = this.mConfig.c;
        tXSVideoEncoderParam.fullIFrame = this.mConfig.u;
        tXSVideoEncoderParam.glContext = eGLContext;
        tXSVideoEncoderParam.annexb = true;
        tXSVideoEncoderParam.appendSpsPps = false;
        if (this.mUseSWEncoder) {
            this.mVideoEncoder = new com.tencent.liteav.videoencoder.b(2);
            tXSVideoEncoderParam.encoderMode = 1;
            tXSVideoEncoderParam.encoderProfile = 3;
        } else {
            this.mVideoEncoder = new com.tencent.liteav.videoencoder.b(1);
            tXSVideoEncoderParam.encoderMode = 3;
            tXSVideoEncoderParam.forceHwEncoderBaseLine = false;
            tXSVideoEncoderParam.encoderProfile = 3;
        }
        tXSVideoEncoderParam.record = true;
        if (this.mConfig.u) {
            if (this.mUseSWEncoder) {
                this.mVideoEncoder.c(24000);
            } else {
                this.mVideoEncoder.c(15000);
            }
        } else {
            this.mVideoEncoder.c(this.mConfig.d);
        }
        tXSVideoEncoderParam.realTime = true;
        tXSVideoEncoderParam.enableBlackList = false;
        this.mVideoEncoder.a(this);
        this.mVideoEncoder.a(tXSVideoEncoderParam);
    }

    private void encodeFrame(int n2, int n3, int n4) {
        if (this.mVideoEncoder == null || this.mVideoWidth != n3 || this.mVideoHeight != n4) {
            this.startEncoder(n3, n4);
        }
        long l2 = TXCTimeUtil.getTimeTick();
        this.mVideoEncoder.a(n2, n3, n4, l2);
    }

    private void onRecordError() {
        if (this.mVideoRecordListener != null && this.mRecording) {
            this.mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    TXUGCRecord.this.stopRecordForClip();
                }
            });
            TXCUGCBGMPlayer.getInstance().pause();
            this.mRecording = false;
            this.mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    TXRecordCommon.TXRecordResult tXRecordResult = new TXRecordCommon.TXRecordResult();
                    tXRecordResult.descMsg = "record video failed";
                    tXRecordResult.retCode = -1;
                    if (TXUGCRecord.this.mVideoRecordListener != null) {
                        TXUGCRecord.this.mVideoRecordListener.onRecordComplete(tXRecordResult);
                    }
                }
            });
        }
    }

    private void initConfig() {
        if (this.mConfig.a >= 0) {
            switch (this.mConfig.a) {
                case 0: {
                    this.mConfig.b = 0;
                    this.mConfig.g = 360;
                    this.mConfig.h = 640;
                    this.mConfig.d = 2400;
                    this.mCameraResolution = a.a.e;
                    TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.be);
                    TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bi, 2400, "");
                    break;
                }
                case 1: {
                    this.mConfig.b = 1;
                    this.mConfig.g = 540;
                    this.mConfig.h = 960;
                    this.mConfig.d = 6500;
                    this.mCameraResolution = a.a.f;
                    TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bf);
                    TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bi, 6500, "");
                    break;
                }
                case 2: {
                    this.mConfig.b = 2;
                    this.mConfig.g = 720;
                    this.mConfig.h = 1280;
                    this.mConfig.d = 9600;
                    this.mCameraResolution = a.a.g;
                    TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bg);
                    TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bi, 9600, "");
                    break;
                }
                default: {
                    this.mConfig.b = 1;
                    this.mConfig.g = 540;
                    this.mConfig.h = 960;
                    this.mConfig.d = 6500;
                    this.mCameraResolution = a.a.f;
                    TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bf);
                    TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bi, 6500, "");
                }
            }
            this.mConfig.c = this.mFps;
            TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bj, this.mFps, "");
        } else {
            switch (this.mConfig.b) {
                case 0: {
                    this.mConfig.g = 360;
                    this.mConfig.h = 640;
                    this.mCameraResolution = a.a.e;
                    TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.be, 360, "360x640");
                    break;
                }
                case 1: {
                    this.mConfig.g = 540;
                    this.mConfig.h = 960;
                    this.mCameraResolution = a.a.f;
                    TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bf, 540, "540x960");
                    break;
                }
                case 2: {
                    this.mConfig.g = 720;
                    this.mConfig.h = 1280;
                    this.mCameraResolution = a.a.g;
                    TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bg, 720, "720x1280");
                    break;
                }
                case 3: {
                    this.mConfig.g = 1080;
                    this.mConfig.h = 1920;
                    this.mCameraResolution = a.a.i;
                    TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bh, 1080, "1080x1920");
                    break;
                }
                default: {
                    this.mConfig.g = 540;
                    this.mConfig.h = 960;
                    this.mCameraResolution = a.a.f;
                    TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bf, 720, "720x1280");
                }
            }
        }
        TXCLog.w(TAG, "record:camera init record param, width:" + this.mConfig.g + ",height:" + this.mConfig.h + ",bitrate:" + this.mConfig.d + ",fps:" + this.mConfig.c);
    }

    private void calcVideoEncInfo() {
        if (this.mConfig.h == 0) {
            return;
        }
        double d2 = (double)this.mConfig.g / (double)this.mConfig.h;
        this.mConfig.g = (this.mConfig.g + 15) / 16 * 16;
        this.mConfig.h = (this.mConfig.h + 15) / 16 * 16;
        double d3 = (double)this.mConfig.g / (double)this.mConfig.h;
        double d4 = (double)(this.mConfig.g + 16) / (double)this.mConfig.h;
        double d5 = (double)(this.mConfig.g - 16) / (double)this.mConfig.h;
        this.mConfig.g = Math.abs(d3 - d2) < Math.abs(d4 - d2) ? (Math.abs(d3 - d2) < Math.abs(d5 - d2) ? this.mConfig.g : this.mConfig.g - 16) : (Math.abs(d4 - d2) < Math.abs(d5 - d2) ? this.mConfig.g + 16 : this.mConfig.g - 16);
    }

    private boolean onRecordProgress(long l2) {
        if (this.mRecordSpeed != 2) {
            if (this.mRecordSpeed == 3) {
                l2 = (long)((float)l2 / ENCODE_SPEED_FAST);
            } else if (this.mRecordSpeed == 4) {
                l2 = (long)((float)l2 / ENCODE_SPEED_FASTEST);
            } else if (this.mRecordSpeed == 1) {
                l2 = (long)((float)l2 / ENCODE_SPEED_SLOW);
            } else if (this.mRecordSpeed == 0) {
                l2 = (long)((float)l2 / ENCODE_SPEED_SLOWEST);
            }
        }
        this.mCurrentRecordDuration = l2;
        final long l3 = (long)this.mTXUGCPartsManager.getDuration() + this.mCurrentRecordDuration;
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (TXUGCRecord.this.mVideoRecordListener != null) {
                    TXUGCRecord.this.mVideoRecordListener.onRecordProgress(l3);
                }
            }
        });
        if (l3 >= (long)this.mMaxDuration) {
            this.isReachedMaxDuration = true;
            TXCLog.i(TAG, "onRecordProgress ReachMacDuration mMaxDuration= " + this.mMaxDuration);
            this.mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    TXUGCRecord.this.stopRecordForClip();
                }
            });
            return false;
        }
        this.isReachedMaxDuration = false;
        return true;
    }

    private int getSreenRotation() {
        if (this.mContext != null) {
            Configuration configuration = this.mContext.getResources().getConfiguration();
            int n2 = configuration.orientation;
            if (n2 == 2) {
                return 90;
            }
        }
        return 0;
    }

    private int getRecordState() {
        int n2 = AudioRecord.getMinBufferSize((int)44100, (int)16, (int)2);
        AudioRecord audioRecord = new AudioRecord(0, 44100, 16, 2, n2 * 100);
        short[] sArray = new short[n2];
        int n3 = 0;
        try {
            audioRecord.startRecording();
        }
        catch (Exception exception) {
            if (audioRecord != null) {
                audioRecord.release();
                audioRecord = null;
                TXCLog.e("CheckAudioPermission", "Unable to enter the initial state of audio recording");
            }
            return -1;
        }
        if (audioRecord.getRecordingState() != 3) {
            if (audioRecord != null) {
                audioRecord.stop();
                audioRecord.release();
                audioRecord = null;
                TXCLog.e("CheckAudioPermission", "The audio recorder is in use");
            }
            return 1;
        }
        n3 = audioRecord.read(sArray, 0, sArray.length);
        if (n3 <= 0) {
            if (audioRecord != null) {
                audioRecord.stop();
                audioRecord.release();
                audioRecord = null;
            }
            TXCLog.e("CheckAudioPermission", "The audio recording result is empty");
            return -1;
        }
        if (audioRecord != null) {
            audioRecord.stop();
            audioRecord.release();
            audioRecord = null;
        }
        return 0;
    }

    private void callbackEvent(final int n2, final Bundle bundle) {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (TXUGCRecord.this.mVideoRecordListener != null) {
                    TXUGCRecord.this.mVideoRecordListener.onRecordEvent(n2, bundle);
                }
            }
        });
    }

    @Override
    public void onRecordRawPcmData(byte[] byArray, long l2, int n2, int n3, int n4, boolean bl) {
    }

    @Override
    public void onRecordPcmData(byte[] byArray, long l2, int n2, int n3, int n4) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRecordEncData(byte[] byArray, long l2, int n2, int n3, int n4) {
        TXUGCRecord tXUGCRecord = this;
        synchronized (tXUGCRecord) {
            if (this.mMP4Muxer != null && this.mRecording) {
                this.mEncodePcmDataSize += 4096L;
                long l3 = l2;
                this.mMP4Muxer.a(byArray, 0, byArray.length, l3 * 1000L, 0);
            } else {
                TXCLog.e(TAG, "onRecordEncData err!");
            }
        }
    }

    @Override
    public void onRecordError(int n2, String string2) {
        if (n2 == -1) {
            TXLog.e(TAG, "onRecordError, audio no mic permit");
            this.onRecordError();
        }
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture) {
        TXCLog.i(TAG, "ugcRecord, onSurfaceTextureAvailable, surfaceTexture = " + surfaceTexture + ", mCapturing = " + this.mCapturing + ", mStartPreview = " + this.mStartPreview.get());
        if (!this.mStartPreview.get()) {
            return;
        }
        if (surfaceTexture == null) {
            return;
        }
        if (this.startCapture(surfaceTexture)) {
            if (TXCAudioUGCRecorder.getInstance().isRecording()) {
                this.mInitCompelete = true;
                TXCLog.i(TAG, "onSurfaceTextureAvailable mInitCompelete = true");
                return;
            }
            if (this.getRecordState() == -1) {
                this.callbackEvent(4, null);
            }
        } else {
            this.callbackEvent(3, null);
        }
        this.mInitCompelete = true;
    }

    @Override
    public void onSurfaceTextureDestroy(SurfaceTexture surfaceTexture) {
        TXCLog.i(TAG, "ugcRecord, onSurfaceTextureDestroy, surfaceTexture = " + surfaceTexture + ", mCapturing = " + this.mCapturing);
        if (this.mCustomProcessListener != null) {
            this.mCustomProcessListener.onTextureDestroyed();
        }
        if (this.mVideoPreprocessor != null) {
            this.mVideoPreprocessor.b();
        }
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.a();
            this.mVideoEncoder.a((d)null);
            this.mVideoEncoder = null;
        }
    }

    @Override
    public void onNotifyEvent(int n2, Bundle bundle) {
    }

    @Override
    public int willAddWatermark(int n2, int n3, int n4) {
        if (this.mCustomProcessListener != null) {
            n2 = this.mCustomProcessListener.onTextureCustomProcess(n2, n3, n4);
        }
        if (this.mVideoView != null) {
            this.mVideoView.a(n2, false, this.mConfig.s, n3, n4, this.mCameraCapture.i());
        }
        return n2;
    }

    @Override
    public void didProcessFrame(int n2, int n3, int n4, long l2) {
        if (this.mRecording) {
            this.encodeFrame(n2, n3, n4);
        }
    }

    @Override
    public void didProcessFrame(byte[] byArray, int n2, int n3, int n4, long l2) {
    }

    public void didDetectFacePoints(float[] fArray) {
        if (this.mCustomProcessListener != null) {
            this.mCustomProcessListener.onDetectFacePoints(fArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEncodeNAL(TXSNALPacket tXSNALPacket, int n2) {
        if (n2 == 0) {
            TXUGCRecord tXUGCRecord = this;
            synchronized (tXUGCRecord) {
                if (this.mMP4Muxer == null) {
                    return;
                }
                if (tXSNALPacket != null && tXSNALPacket.nalData != null) {
                    if (this.mStartMuxer) {
                        this.recordVideoData(tXSNALPacket, tXSNALPacket.nalData);
                    } else if (tXSNALPacket.nalType == 0) {
                        MediaFormat mediaFormat = g.a(tXSNALPacket.nalData, this.mVideoWidth, this.mVideoHeight);
                        if (mediaFormat != null) {
                            this.mMP4Muxer.a(mediaFormat);
                            this.mMP4Muxer.a();
                            this.mStartMuxer = true;
                            this.mRecordStartTime = 0L;
                            TXLog.i(TAG, "onEncodeNAL, mMP4Muxer.start(), mStartMuxer = true");
                        }
                        this.recordVideoData(tXSNALPacket, tXSNALPacket.nalData);
                    }
                }
            }
        } else {
            TXCLog.e(TAG, "onEncodeNAL error: " + n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEncodeFormat(MediaFormat mediaFormat) {
        TXUGCRecord tXUGCRecord = this;
        synchronized (tXUGCRecord) {
            TXCLog.i(TAG, "onEncodeFormat: " + mediaFormat.toString());
            if (this.mMP4Muxer != null) {
                this.mMP4Muxer.a(mediaFormat);
                if (!this.mStartMuxer) {
                    this.mMP4Muxer.a();
                    this.mStartMuxer = true;
                    TXCLog.i(TAG, "onEncodeFormat, mMP4Muxer.start(), mStartMuxer = true");
                }
            }
        }
    }

    @Override
    public void onEncodeFinished(int n2, long l2, long l3) {
    }

    @Override
    public void onRestartEncoder(int n2) {
    }

    @Override
    public void onEncodeDataIn(int n2) {
    }

    private void recordVideoData(TXSNALPacket tXSNALPacket, byte[] byArray) {
        if (this.mRecordStartTime == 0L) {
            this.mRecordStartTime = tXSNALPacket.pts;
        }
        int n2 = 0;
        if (tXSNALPacket.info == null) {
            if (tXSNALPacket.nalType == 0) {
                n2 = 1;
            }
        } else {
            n2 = tXSNALPacket.info.flags;
        }
        if (this.onRecordProgress(tXSNALPacket.pts - this.mRecordStartTime)) {
            this.mMP4Muxer.b(byArray, 0, byArray.length, tXSNALPacket.pts * 1000L, n2);
        }
    }

    @Override
    public int onTextureProcess(int n2, float[] fArray) {
        if (this.mVideoPreprocessor != null) {
            int n3 = this.mConfig.g;
            int n4 = this.mConfig.h;
            int n5 = this.mCropWidth;
            int n6 = this.mCropHeight;
            if (this.mConfig.r == 2 || this.mConfig.r == 0) {
                n3 = this.mConfig.h;
                n4 = this.mConfig.g;
                n5 = this.mCropHeight;
                n6 = this.mCropWidth;
            }
            if (this.mDisplayType != 0) {
                com.tencent.liteav.basic.opengl.a a2 = g.a(this.mCameraCapture.j(), this.mCameraCapture.k(), this.mCropHeight, this.mCropWidth);
                this.mVideoPreprocessor.a(a2);
                this.mVideoPreprocessor.a(n5, n6);
                this.mVideoView.setRendMode(1);
            } else {
                com.tencent.liteav.basic.opengl.a a3 = g.a(this.mCameraCapture.j(), this.mCameraCapture.k(), this.mConfig.h, this.mConfig.g);
                this.mVideoPreprocessor.a(a3);
                this.mVideoPreprocessor.a(n3, n4);
                this.mVideoView.setRendMode(this.mRenderMode);
            }
            this.mVideoPreprocessor.b(false);
            this.mVideoPreprocessor.a(fArray);
            this.mVideoPreprocessor.a(this.mConfig.r);
            this.mVideoPreprocessor.a(n2, this.mCameraCapture.j(), this.mCameraCapture.k(), this.mCameraCapture.h(), 4, 0);
        }
        return 0;
    }

    @Override
    public void onBufferProcess(byte[] byArray, float[] fArray) {
    }

    public TXBeautyManager getBeautyManager() {
        return this.mBeautyManager;
    }

    static {
        PLAY_SPEED_FASTEST = 0.5f;
        PLAY_SPEED_FAST = 0.8f;
        PLAY_SPEED_SLOW = 1.25f;
        PLAY_SPEED_SLOWEST = 2.0f;
        ENCODE_SPEED_FASTEST = 2.0f;
        ENCODE_SPEED_FAST = 1.25f;
        ENCODE_SPEED_SLOW = 0.8f;
        ENCODE_SPEED_SLOWEST = 0.5f;
    }

    public static interface VideoCustomProcessListener {
        public int onTextureCustomProcess(int var1, int var2, int var3);

        public void onDetectFacePoints(float[] var1);

        public void onTextureDestroyed();
    }

    private class a
    implements Runnable {
        private float b;
        private float c;

        private a() {
        }

        public void a(float f2, float f3) {
            this.b = f2;
            this.c = f3;
        }

        @Override
        public void run() {
            if (TXUGCRecord.this.mTXCloudVideoView == null) {
                return;
            }
            if (TXUGCRecord.this.mCameraCapture != null && ((TXUGCRecord)TXUGCRecord.this).mConfig.f) {
                TXUGCRecord.this.mCameraCapture.a(this.b / (float)TXUGCRecord.this.mTXCloudVideoView.getWidth(), this.c / (float)TXUGCRecord.this.mTXCloudVideoView.getHeight());
            }
            if (((TXUGCRecord)TXUGCRecord.this).mConfig.f) {
                TXUGCRecord.this.mTXCloudVideoView.onTouchFocus((int)this.b, (int)this.c);
            }
        }
    }
}

