/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.ugc.PartInfo;
import com.tencent.ugc.TXVideoInfoReader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class TXUGCPartsManager {
    private final String TAG = "TXUGCPartsManager";
    private final Context mContext;
    private CopyOnWriteArrayList<PartInfo> mPartsList;
    private int mDuration;
    private ArrayList<IPartsManagerListener> iPartsManagerObservers;

    public TXUGCPartsManager(Context context) {
        this.mContext = context;
        this.mPartsList = new CopyOnWriteArrayList();
        this.iPartsManagerObservers = new ArrayList();
    }

    public synchronized void setPartsManagerObserver(IPartsManagerListener iPartsManagerListener) {
        if (iPartsManagerListener != null && !this.iPartsManagerObservers.contains(iPartsManagerListener)) {
            this.iPartsManagerObservers.add(iPartsManagerListener);
        }
    }

    public synchronized void removePartsManagerObserver(IPartsManagerListener iPartsManagerListener) {
        if (iPartsManagerListener != null) {
            this.iPartsManagerObservers.remove(iPartsManagerListener);
        }
    }

    public void addClipInfo(PartInfo partInfo) {
        this.mPartsList.add(partInfo);
        this.mDuration = (int)((long)this.mDuration + partInfo.getDuration());
    }

    public void insertPart(String string2, int n2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            TXCLog.e("TXUGCPartsManager", "insertPart, videoPath is empty, ignore");
            return;
        }
        long l2 = TXVideoInfoReader.getInstance(this.mContext).getDuration(string2);
        if (l2 <= 0L) {
            TXCLog.e("TXUGCPartsManager", "insertPart, duration = " + l2);
            return;
        }
        this.mDuration = (int)((long)this.mDuration + l2);
        PartInfo partInfo = new PartInfo();
        partInfo.setPath(string2);
        partInfo.setDuration(l2);
        this.mPartsList.add(n2, partInfo);
    }

    public int getDuration() {
        return this.mDuration;
    }

    public List<String> getPartsPathList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PartInfo partInfo : this.mPartsList) {
            arrayList.add(partInfo.getPath());
        }
        return arrayList;
    }

    public void deleteLastPart() {
        if (this.mPartsList.size() != 0) {
            PartInfo partInfo = this.mPartsList.remove(this.mPartsList.size() - 1);
            this.mDuration = (int)((long)this.mDuration - partInfo.getDuration());
            this.deleteFile(partInfo.getPath());
            this.callbackDeleteLastPart();
        }
    }

    public void deletePart(int n2) {
        if (n2 <= 0) {
            return;
        }
        if (this.mPartsList.size() == 0) {
            return;
        }
        PartInfo partInfo = this.mPartsList.remove(n2 - 1);
        this.mDuration = (int)((long)this.mDuration - partInfo.getDuration());
        this.deleteFile(partInfo.getPath());
    }

    public void deleteAllParts() {
        for (PartInfo partInfo : this.mPartsList) {
            this.deleteFile(partInfo.getPath());
        }
        this.mPartsList.clear();
        this.mDuration = 0;
        this.callbackDeleteAllParts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackDeleteLastPart() {
        TXUGCPartsManager tXUGCPartsManager = this;
        synchronized (tXUGCPartsManager) {
            for (IPartsManagerListener iPartsManagerListener : this.iPartsManagerObservers) {
                iPartsManagerListener.onDeleteLastPart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackDeleteAllParts() {
        TXUGCPartsManager tXUGCPartsManager = this;
        synchronized (tXUGCPartsManager) {
            for (IPartsManagerListener iPartsManagerListener : this.iPartsManagerObservers) {
                iPartsManagerListener.onDeleteAllParts();
            }
        }
    }

    private void deleteFile(final String string2) {
        new AsyncTask(){

            protected Object doInBackground(Object[] objectArray) {
                File file = new File(string2);
                if (file.exists()) {
                    file.delete();
                }
                return null;
            }
        }.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Object[0]);
    }

    public static interface IPartsManagerListener {
        public void onDeleteLastPart();

        public void onDeleteAllParts();
    }
}

