/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.sharp.jni;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import com.tencent.liteav.basic.util.TXCCommonUtil;
import com.tencent.rtmp.sharp.jni.QLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MediaCodecEncoder {
    private static final String TAG = "MediaCodecEncoder";
    private Context mContext;
    private MediaCodec mAudioAACEncoder = null;
    private MediaFormat mAudioFormat = null;
    private MediaCodec.BufferInfo mAACEncBufferInfo = null;
    private ByteBuffer mInputBuffer = null;
    private ByteBuffer mOutputBuffer = null;
    private ByteBuffer[] mMediaInputBuffers;
    private ByteBuffer[] mMediaOutputBuffers;
    private ByteBuffer mEncInBuffer;
    private ByteBuffer mEncOutBuffer;
    private byte[] mTempBufEncIn;
    private byte[] mTempBufEncOut;
    private int mSampleRate = 48000;
    private int mChannels = 1;
    private int mBitrate = 32000;
    private int nMaxBitRate = 256000;
    private boolean mFormatChangeFlag = false;
    private File mRecFileDump = null;
    private FileOutputStream mRecFileOut = null;
    private static boolean mDumpEnable = false;

    public MediaCodecEncoder() {
        this.mContext = TXCCommonUtil.getAppContext();
        this.mEncInBuffer = ByteBuffer.allocateDirect(7680);
        this.mTempBufEncIn = new byte[7680];
        this.mEncOutBuffer = ByteBuffer.allocateDirect(this.nMaxBitRate * 2 / 8 / 50 + 100);
        this.mTempBufEncOut = new byte[this.nMaxBitRate * 2 / 8 / 50 + 100];
    }

    public MediaCodecEncoder(Context context) {
        this.mContext = context;
        this.mEncInBuffer = ByteBuffer.allocateDirect(7680);
        this.mTempBufEncIn = new byte[7680];
        this.mEncOutBuffer = ByteBuffer.allocateDirect(this.nMaxBitRate * 2 / 8 / 50 + 100);
        this.mTempBufEncOut = new byte[this.nMaxBitRate * 2 / 8 / 50 + 100];
    }

    private String getDumpFilePath(String string2) {
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "manufacture:" + Build.MANUFACTURER);
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "MODEL:" + Build.MODEL);
        }
        if (this.mContext == null) {
            return null;
        }
        File file = this.mContext.getExternalFilesDir(null);
        if (file == null) {
            return null;
        }
        String string3 = file.getPath() + "/MF-" + Build.MANUFACTURER + "-M-" + Build.MODEL + "-" + string2;
        File file2 = new File(string3);
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "dump:" + string3);
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "dump replace:" + string3.replace(" ", "_"));
        }
        return string3.replace(" ", "_");
    }

    private void addADTStoPacket(byte[] byArray, int n2) {
        int n3 = 2;
        int n4 = 3;
        if (this.mSampleRate == 48000) {
            n4 = 3;
        } else if (this.mSampleRate == 44100) {
            n4 = 4;
        } else if (this.mSampleRate == 32000) {
            n4 = 5;
        } else if (this.mSampleRate == 24000) {
            n4 = 6;
        } else if (this.mSampleRate == 16000) {
            n4 = 8;
        }
        int n5 = this.mChannels;
        byArray[0] = -1;
        byArray[1] = -7;
        byArray[2] = (byte)((n3 - 1 << 6) + (n4 << 2) + (n5 >> 2));
        byArray[3] = (byte)(((n5 & 3) << 6) + (n2 >> 11));
        byArray[4] = (byte)((n2 & 0x7FF) >> 3);
        byArray[5] = (byte)(((n2 & 7) << 5) + 31);
        byArray[6] = -4;
    }

    @SuppressLint(value={"NewApi"})
    public int createAACEncoder(int n2, int n3, int n4) {
        try {
            block9: {
                this.mAudioAACEncoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
                this.mAudioFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)n2, (int)n3);
                this.mAudioFormat.setInteger("aac-profile", 2);
                this.mAudioFormat.setInteger("sample-rate", n2);
                this.mAudioFormat.setInteger("channel-count", n3);
                this.mAudioFormat.setInteger("bitrate", n4);
                this.mAudioAACEncoder.configure(this.mAudioFormat, null, null, 1);
                if (this.mAudioAACEncoder != null) {
                    this.mAudioAACEncoder.start();
                    this.mAACEncBufferInfo = new MediaCodec.BufferInfo();
                    this.mSampleRate = n2;
                    this.mChannels = n3;
                    this.mBitrate = n4;
                }
                if (mDumpEnable) {
                    this.mRecFileDump = new File(this.getDumpFilePath("jnirecord.aac"));
                    try {
                        this.mRecFileOut = new FileOutputStream(this.mRecFileDump);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (!QLog.isColorLevel()) break block9;
                        QLog.e(TAG, 2, "open jnirecord.aac file failed.");
                    }
                }
            }
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "createAACEncoder succeed!!! : (" + n2 + ", " + n3 + ", " + n4 + ")");
            }
            return 0;
        }
        catch (Exception exception) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "create AAC Encoder failed.");
            }
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "[ERROR] creating aac encode stream failed!!! : (" + n2 + ", " + n3 + ", " + n4 + ")");
            }
            return -1;
        }
    }

    @SuppressLint(value={"NewApi"})
    public int encodeAACFrame(int n2) {
        if (this.mFormatChangeFlag) {
            this.mFormatChangeFlag = false;
            this.mAudioAACEncoder.stop();
            this.mAudioFormat.setInteger("bitrate", this.mBitrate);
            this.mAudioAACEncoder.configure(this.mAudioFormat, null, null, 1);
            this.mAudioAACEncoder.start();
        }
        this.mEncInBuffer.get(this.mTempBufEncIn, 0, n2);
        int n3 = this.encodeInternalAACFrame(n2);
        this.mEncOutBuffer.rewind();
        if (n3 > 0) {
            this.mEncOutBuffer.put(this.mTempBufEncOut, 0, n3);
            if (mDumpEnable && this.mRecFileOut != null) {
                try {
                    int n4 = n3 + 7;
                    byte[] byArray = new byte[n4];
                    this.addADTStoPacket(byArray, n4);
                    System.arraycopy(this.mTempBufEncOut, 0, byArray, 7, n3);
                    this.mRecFileOut.write(byArray, 0, n4);
                }
                catch (IOException iOException) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 2, "write file failed.");
                    }
                }
            }
        } else {
            n3 = 0;
        }
        return n3;
    }

    @SuppressLint(value={"NewApi"})
    public int encodeInternalAACFrame(int n2) {
        int n3;
        block11: {
            n3 = 0;
            try {
                int n4;
                int n5 = this.mAudioAACEncoder.dequeueInputBuffer(2000L);
                if (n5 != -1) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        this.mInputBuffer = this.mAudioAACEncoder.getInputBuffer(n5);
                    } else {
                        this.mMediaInputBuffers = this.mAudioAACEncoder.getInputBuffers();
                        this.mInputBuffer = this.mMediaInputBuffers[n5];
                    }
                    this.mInputBuffer.clear();
                    this.mInputBuffer.put(this.mTempBufEncIn, 0, n2);
                    this.mAudioAACEncoder.queueInputBuffer(n5, 0, n2, 0L, 0);
                    this.mEncInBuffer.rewind();
                }
                if ((n4 = this.mAudioAACEncoder.dequeueOutputBuffer(this.mAACEncBufferInfo, 0L)) < 0) {
                    return n3;
                }
                int n6 = this.mAACEncBufferInfo.size;
                if (Build.VERSION.SDK_INT >= 21) {
                    this.mOutputBuffer = this.mAudioAACEncoder.getOutputBuffer(n4);
                } else {
                    this.mMediaOutputBuffers = this.mAudioAACEncoder.getOutputBuffers();
                    this.mOutputBuffer = this.mMediaOutputBuffers[n4];
                }
                n3 = (this.mAACEncBufferInfo.flags & 2) == 2 ? 0 : this.mAACEncBufferInfo.size;
                try {
                    this.mOutputBuffer.position(this.mAACEncBufferInfo.offset);
                    this.mOutputBuffer.limit(this.mAACEncBufferInfo.offset + n6);
                    this.mOutputBuffer.get(this.mTempBufEncOut, 0, n3);
                    this.mOutputBuffer.position(0);
                    this.mAudioAACEncoder.releaseOutputBuffer(n4, false);
                    return n3;
                }
                catch (Exception exception) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 2, "[ERROR] encoding aac stream failed!!!");
                    }
                }
            }
            catch (Exception exception) {
                n3 = 0;
                if (!QLog.isColorLevel()) break block11;
                QLog.e(TAG, 2, "encode failed." + exception.getMessage());
            }
        }
        return n3;
    }

    @SuppressLint(value={"NewApi"})
    public int releaseAACEncoder() {
        block5: {
            try {
                if (this.mAudioAACEncoder != null) {
                    this.mAudioAACEncoder.stop();
                    this.mAudioAACEncoder.release();
                    this.mAudioAACEncoder = null;
                    if (QLog.isColorLevel()) {
                        QLog.w(TAG, 2, "releaseAACEncoder, release aac encode stream succeed!!");
                    }
                    return 0;
                }
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block5;
                QLog.e(TAG, 2, "release aac encoder failed." + exception.getMessage());
            }
        }
        if (QLog.isColorLevel()) {
            QLog.e(TAG, 2, "[ERROR] releaseAACEncoder, release aac encode stream failed!!!");
        }
        return -1;
    }

    @SuppressLint(value={"NewApi"})
    public int setAACEncodeBitrate(int n2) {
        if (this.mAudioAACEncoder != null && this.mBitrate != n2) {
            this.mFormatChangeFlag = true;
            this.mBitrate = n2;
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "Set AAC bitrate = " + n2);
            }
        }
        return 0;
    }
}

