/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.downloader;

import android.net.Uri;
import android.text.TextUtils;
import com.tencent.ijk.media.player.IjkDownloadCenter;
import com.tencent.ijk.media.player.IjkDownloadMedia;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.network.f;
import com.tencent.liteav.network.g;
import com.tencent.liteav.network.i;
import com.tencent.liteav.network.j;
import com.tencent.rtmp.TXPlayerAuthBuilder;
import com.tencent.rtmp.downloader.ITXVodDownloadListener;
import com.tencent.rtmp.downloader.TXVodDownloadDataSource;
import com.tencent.rtmp.downloader.TXVodDownloadMediaInfo;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;

public class TXVodDownloadManager {
    private static final String TAG = "TXVodDownloadManager";
    public static final int DOWNLOAD_SUCCESS = 0;
    public static final int DOWNLOAD_AUTH_FAILED = -5001;
    public static final int DOWNLOAD_NO_FILE = -5003;
    public static final int DOWNLOAD_FORMAT_ERROR = -5004;
    public static final int DOWNLOAD_DISCONNECT = -5005;
    public static final int DOWNLOAD_HLS_KEY_ERROR = -5006;
    public static final int DOWNLOAD_PATH_ERROR = -5007;
    private static final int IJKDM_EVT_NET_DISCONNECT = 1001;
    private static final int IJKDM_EVT_FILE_OPEN_ERROR = 1008;
    private static final int IJKDM_EVT_HLS_KEY_ERROR = 1008;
    protected IjkDownloadCenter mDownloadCenter;
    protected String mDownloadPath;
    protected ArrayList<TXVodDownloadMediaInfo> mMediaInfoArray;
    protected ITXVodDownloadListener mListener;
    protected Map<String, String> mHeaders;
    private static TXVodDownloadManager instance = null;
    IjkDownloadCenter.OnDownloadListener mDownloadCenterListener = new IjkDownloadCenter.OnDownloadListener(){

        @Override
        public void downloadBegin(IjkDownloadCenter ijkDownloadCenter, IjkDownloadMedia ijkDownloadMedia) {
            TXVodDownloadMediaInfo tXVodDownloadMediaInfo = TXVodDownloadManager.this.convertMedia(ijkDownloadMedia);
            if (tXVodDownloadMediaInfo != null) {
                TXCLog.i(TXVodDownloadManager.TAG, "downloadBegin " + tXVodDownloadMediaInfo.playPath);
                TXVodDownloadManager.this.mListener.onDownloadStart(tXVodDownloadMediaInfo);
                if (new File(tXVodDownloadMediaInfo.playPath).isFile()) {
                    TXCLog.d(TXVodDownloadManager.TAG, "file state ok");
                } else {
                    TXCLog.e(TXVodDownloadManager.TAG, "file not create!");
                }
            }
        }

        @Override
        public void downloadEnd(IjkDownloadCenter ijkDownloadCenter, IjkDownloadMedia ijkDownloadMedia) {
            TXVodDownloadMediaInfo tXVodDownloadMediaInfo = TXVodDownloadManager.this.convertMedia(ijkDownloadMedia);
            if (tXVodDownloadMediaInfo != null) {
                TXCLog.i(TXVodDownloadManager.TAG, "downloadEnd " + tXVodDownloadMediaInfo.playPath);
                TXVodDownloadManager.this.mMediaInfoArray.remove(tXVodDownloadMediaInfo);
                TXVodDownloadManager.this.mListener.onDownloadStop(tXVodDownloadMediaInfo);
            }
        }

        @Override
        public void downloadFinish(IjkDownloadCenter ijkDownloadCenter, IjkDownloadMedia ijkDownloadMedia) {
            TXVodDownloadMediaInfo tXVodDownloadMediaInfo = TXVodDownloadManager.this.convertMedia(ijkDownloadMedia);
            if (tXVodDownloadMediaInfo != null) {
                TXCLog.i(TXVodDownloadManager.TAG, "downloadFinish " + tXVodDownloadMediaInfo.playPath);
                TXVodDownloadManager.this.mMediaInfoArray.remove(tXVodDownloadMediaInfo);
                if (new File(tXVodDownloadMediaInfo.playPath).isFile()) {
                    TXVodDownloadManager.this.mListener.onDownloadFinish(tXVodDownloadMediaInfo);
                } else {
                    TXVodDownloadManager.this.mListener.onDownloadError(tXVodDownloadMediaInfo, -5003, "The file has been deleted");
                }
            }
        }

        @Override
        public void downloadError(IjkDownloadCenter ijkDownloadCenter, IjkDownloadMedia ijkDownloadMedia, int n2, String string2) {
            TXVodDownloadMediaInfo tXVodDownloadMediaInfo = TXVodDownloadManager.this.convertMedia(ijkDownloadMedia);
            if (tXVodDownloadMediaInfo != null) {
                TXCLog.e(TXVodDownloadManager.TAG, "downloadError " + tXVodDownloadMediaInfo.playPath + " " + string2);
                TXVodDownloadManager.this.mMediaInfoArray.remove(tXVodDownloadMediaInfo);
                if (tXVodDownloadMediaInfo.isStop) {
                    TXVodDownloadManager.this.mListener.onDownloadStop(tXVodDownloadMediaInfo);
                } else if (n2 == 1008) {
                    TXVodDownloadManager.this.mListener.onDownloadError(tXVodDownloadMediaInfo, -5006, string2);
                } else {
                    TXVodDownloadManager.this.mListener.onDownloadError(tXVodDownloadMediaInfo, -5005, string2);
                }
            }
        }

        @Override
        public void downloadProgress(IjkDownloadCenter ijkDownloadCenter, IjkDownloadMedia ijkDownloadMedia) {
            TXVodDownloadMediaInfo tXVodDownloadMediaInfo = TXVodDownloadManager.this.convertMedia(ijkDownloadMedia);
            if (tXVodDownloadMediaInfo != null) {
                TXVodDownloadManager.this.mListener.onDownloadProgress(tXVodDownloadMediaInfo);
            }
        }

        @Override
        public int hlsKeyVerify(IjkDownloadCenter ijkDownloadCenter, IjkDownloadMedia ijkDownloadMedia, String string2, byte[] byArray) {
            TXVodDownloadMediaInfo tXVodDownloadMediaInfo = TXVodDownloadManager.this.convertMedia(ijkDownloadMedia);
            if (tXVodDownloadMediaInfo != null) {
                return TXVodDownloadManager.this.mListener.hlsKeyVerify(tXVodDownloadMediaInfo, string2, byArray);
            }
            return 0;
        }
    };

    private TXVodDownloadManager() {
        this.mDownloadCenter = IjkDownloadCenter.getInstance();
        this.mDownloadCenter.setListener(this.mDownloadCenterListener);
        this.mMediaInfoArray = new ArrayList();
    }

    public static TXVodDownloadManager getInstance() {
        if (instance == null) {
            instance = new TXVodDownloadManager();
        }
        return instance;
    }

    public void setDownloadPath(String string2) {
        if (string2 == null) {
            return;
        }
        File file = new File(string2);
        file.mkdirs();
        this.mDownloadPath = string2;
    }

    public void setHeaders(Map<String, String> map) {
        this.mHeaders = map;
        this.mDownloadCenter.setHeaders(map);
    }

    public void setListener(ITXVodDownloadListener iTXVodDownloadListener) {
        this.mListener = iTXVodDownloadListener;
    }

    public TXVodDownloadMediaInfo startDownloadUrl(String string2) {
        TXVodDownloadMediaInfo tXVodDownloadMediaInfo = new TXVodDownloadMediaInfo();
        tXVodDownloadMediaInfo.url = string2;
        this.mMediaInfoArray.add(tXVodDownloadMediaInfo);
        this.downloadMedia(tXVodDownloadMediaInfo);
        return tXVodDownloadMediaInfo;
    }

    public TXVodDownloadMediaInfo startDownload(final TXVodDownloadDataSource tXVodDownloadDataSource) {
        final TXVodDownloadMediaInfo tXVodDownloadMediaInfo = new TXVodDownloadMediaInfo();
        tXVodDownloadMediaInfo.dataSource = tXVodDownloadDataSource;
        if (tXVodDownloadDataSource.authBuilder != null) {
            TXPlayerAuthBuilder tXPlayerAuthBuilder = tXVodDownloadDataSource.authBuilder;
            f f2 = new f();
            f2.a(tXPlayerAuthBuilder.isHttps());
            f2.a(new g(){

                @Override
                public void onNetSuccess(f f2) {
                    if (tXVodDownloadMediaInfo.isStop) {
                        TXVodDownloadManager.this.mMediaInfoArray.remove(tXVodDownloadMediaInfo);
                        if (TXVodDownloadManager.this.mListener != null) {
                            TXVodDownloadManager.this.mListener.onDownloadStop(tXVodDownloadMediaInfo);
                        }
                        TXCLog.w(TXVodDownloadManager.TAG, "Download task canceled");
                        return;
                    }
                    i i2 = f2.a();
                    j j2 = null;
                    if (tXVodDownloadDataSource.quality != 1000) {
                        j2 = TXVodDownloadManager.this.getClassificationSource(i2, tXVodDownloadDataSource.quality);
                    } else if (tXVodDownloadDataSource.templateName != null) {
                        j2 = TXVodDownloadManager.this.getTemplateSource(i2, tXVodDownloadDataSource.templateName);
                    }
                    if (j2 == null) {
                        TXVodDownloadManager.this.mMediaInfoArray.remove(tXVodDownloadMediaInfo);
                        if (TXVodDownloadManager.this.mListener != null) {
                            TXVodDownloadManager.this.mListener.onDownloadError(tXVodDownloadMediaInfo, -5003, "No such resolution");
                        }
                        return;
                    }
                    tXVodDownloadMediaInfo.url = j2.b();
                    tXVodDownloadMediaInfo.size = j2.d();
                    tXVodDownloadMediaInfo.duration = j2.c();
                    TXVodDownloadManager.this.downloadMedia(tXVodDownloadMediaInfo);
                }

                @Override
                public void onNetFailed(f f2, String string2, int n2) {
                    TXVodDownloadManager.this.mMediaInfoArray.remove(tXVodDownloadMediaInfo);
                    if (TXVodDownloadManager.this.mListener != null) {
                        TXVodDownloadManager.this.mListener.onDownloadError(tXVodDownloadMediaInfo, -5001, string2);
                    }
                }
            });
            if (f2.a(tXPlayerAuthBuilder.getAppId(), tXPlayerAuthBuilder.getFileId(), tXPlayerAuthBuilder.getTimeout(), tXPlayerAuthBuilder.getUs(), tXPlayerAuthBuilder.getExper(), tXPlayerAuthBuilder.getSign()) == 0) {
                tXVodDownloadMediaInfo.netApi = f2;
                this.mMediaInfoArray.add(tXVodDownloadMediaInfo);
                return tXVodDownloadMediaInfo;
            }
            TXCLog.e(TAG, "unable to getPlayInfo");
        }
        return null;
    }

    public void stopDownload(TXVodDownloadMediaInfo tXVodDownloadMediaInfo) {
        if (tXVodDownloadMediaInfo == null) {
            return;
        }
        tXVodDownloadMediaInfo.isStop = true;
        if (tXVodDownloadMediaInfo.tid < 0) {
            TXCLog.w(TAG, "stop download not start task");
            return;
        }
        this.mDownloadCenter.stop(tXVodDownloadMediaInfo.tid);
        TXCLog.d(TAG, "stop download " + tXVodDownloadMediaInfo.url);
    }

    public boolean deleteDownloadFile(String string2) {
        TXCLog.d(TAG, "delete file " + string2);
        for (TXVodDownloadMediaInfo tXVodDownloadMediaInfo : this.mMediaInfoArray) {
            if (tXVodDownloadMediaInfo.playPath == null || !tXVodDownloadMediaInfo.playPath.equals(string2)) continue;
            TXCLog.e(TAG, "file is downloading, can not be delete");
            return false;
        }
        File file = new File(string2);
        file.delete();
        TXCLog.e(TAG, "delete success");
        return true;
    }

    protected void downloadMedia(TXVodDownloadMediaInfo tXVodDownloadMediaInfo) {
        String string2 = tXVodDownloadMediaInfo.url;
        if (string2 == null) {
            return;
        }
        Uri uri = Uri.parse((String)string2);
        if (uri.getPath().endsWith(".m3u8")) {
            String[] stringArray;
            tXVodDownloadMediaInfo.playPath = this.makePlayPath(string2);
            if (tXVodDownloadMediaInfo.playPath == null) {
                if (this.mListener != null) {
                    this.mListener.onDownloadError(tXVodDownloadMediaInfo, -5007, "Failed to create local path");
                }
                return;
            }
            if (tXVodDownloadMediaInfo.dataSource != null && tXVodDownloadMediaInfo.dataSource.token != null && (stringArray = string2.split("/")).length > 0) {
                String string3 = stringArray[stringArray.length - 1];
                int n2 = string2.lastIndexOf(string3);
                string2 = string2.substring(0, n2) + "voddrm.token." + tXVodDownloadMediaInfo.dataSource.token + "." + string2.substring(n2);
            }
            TXCLog.d(TAG, "download hls " + string2 + " to " + tXVodDownloadMediaInfo.playPath);
            tXVodDownloadMediaInfo.tid = this.mDownloadCenter.downloadHls(string2, tXVodDownloadMediaInfo.playPath);
            if (tXVodDownloadMediaInfo.tid < 0) {
                TXCLog.e(TAG, "start download failed");
                if (this.mListener != null) {
                    this.mListener.onDownloadError(tXVodDownloadMediaInfo, -5004, "Internal error");
                }
            }
            return;
        }
        TXCLog.e(TAG, "format error: " + string2);
        if (this.mListener != null) {
            this.mListener.onDownloadError(tXVodDownloadMediaInfo, -5004, "No support format");
        }
    }

    protected String makePlayPath(String string2) {
        String string3 = this.mDownloadPath + "/txdownload";
        File file = new File(string3);
        if (!(file.exists() && file.isDirectory() || file.mkdir())) {
            TXCLog.e(TAG, "Failed to create download path" + string3);
            return null;
        }
        Uri uri = Uri.parse((String)string2);
        if (uri.getPath().endsWith(".m3u8")) {
            return string3 + "/" + TXVodDownloadManager.md5(string2) + ".m3u8.sqlite";
        }
        TXCLog.e(TAG, "Unsupported format");
        return null;
    }

    protected static String md5(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = messageDigest.digest(string2.getBytes());
            String string3 = "";
            for (byte by : byArray) {
                String string4 = Integer.toHexString(by & 0xFF);
                if (string4.length() == 1) {
                    string4 = "0" + string4;
                }
                string3 = string3 + string4;
            }
            return string3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            TXCLog.e(TAG, "md5 failed.", noSuchAlgorithmException);
            return "";
        }
    }

    j getClassificationSource(i i2, int n2) {
        j j2 = null;
        if (n2 == 0) {
            j2 = i2.d();
        } else {
            String string2 = TXVodDownloadDataSource.qualityToId(n2);
            j2 = i2.a(string2, "hls");
        }
        return j2;
    }

    j getTemplateSource(i i2, String string2) {
        return i2.b(string2, "hls");
    }

    TXVodDownloadMediaInfo convertMedia(IjkDownloadMedia ijkDownloadMedia) {
        for (TXVodDownloadMediaInfo tXVodDownloadMediaInfo : this.mMediaInfoArray) {
            if (tXVodDownloadMediaInfo.tid != ijkDownloadMedia.tid) continue;
            tXVodDownloadMediaInfo.downloadSize = ijkDownloadMedia.downloadSize;
            if (tXVodDownloadMediaInfo.size == 0) {
                tXVodDownloadMediaInfo.size = ijkDownloadMedia.size;
            }
            return tXVodDownloadMediaInfo;
        }
        return null;
    }
}

