/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.Surface;
import android.view.TextureView;
import com.tencent.liteav.basic.c.b;
import com.tencent.liteav.basic.datareport.TXCDRApi;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.TXCCommonUtil;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.j;
import com.tencent.liteav.network.f;
import com.tencent.liteav.network.g;
import com.tencent.liteav.network.i;
import com.tencent.liteav.o;
import com.tencent.liteav.txcvodplayer.TextureRenderView;
import com.tencent.rtmp.ITXLivePlayListener;
import com.tencent.rtmp.ITXVodPlayListener;
import com.tencent.rtmp.TXBitrateItem;
import com.tencent.rtmp.TXLivePlayer;
import com.tencent.rtmp.TXPlayerAuthBuilder;
import com.tencent.rtmp.TXVodPlayConfig;
import com.tencent.rtmp.ui.TXCloudVideoView;
import java.util.ArrayList;

public class TXVodPlayer
implements b,
g {
    public static final String TAG = "TXVodPlayer";
    public static final int PLAYER_TYPE_FFPLAY = 0;
    public static final int PLAYER_TYPE_EXO = 1;
    private TXCloudVideoView mTXCloudVideoView;
    private Surface mSurface;
    private TextureRenderView mTextureView;
    private ITXLivePlayListener mListener = null;
    private ITXVodPlayListener mNewListener = null;
    private TXVodPlayConfig mConfig;
    private boolean mEnableHWDec = false;
    private int mRenderMode;
    private int mRenderRotation;
    private String mPlayUrl = "";
    private boolean mMute = false;
    private int mAudioPlayoutVolume = 100;
    private Context mContext;
    private o mPlayer;
    private boolean mIsGainAudioFocus = true;
    private boolean mAutoPlay = true;
    private float mRate = 1.0f;
    private boolean mSnapshotRunning = false;
    private f mNetApi;
    private String mToken;
    private int mBitrateIndex;
    private boolean mMirror;
    private boolean mIsGetPlayInfo;
    private boolean mLoop;
    protected float mStartTime;

    public TXVodPlayer(Context context) {
        this.mContext = context.getApplicationContext();
        TXCCommonUtil.setAppContext(this.mContext);
        TXCLog.init();
    }

    public void setConfig(TXVodPlayConfig tXVodPlayConfig) {
        this.mConfig = tXVodPlayConfig;
        if (this.mConfig == null) {
            this.mConfig = new TXVodPlayConfig();
        }
        if (this.mPlayer != null) {
            j j2 = this.mPlayer.q();
            if (j2 == null) {
                j2 = new j();
            }
            j2.e = this.mConfig.mConnectRetryCount;
            j2.f = this.mConfig.mConnectRetryInterval;
            j2.r = this.mConfig.mTimeout;
            j2.h = this.mEnableHWDec;
            j2.n = this.mConfig.mCacheFolderPath;
            j2.o = this.mConfig.mMaxCacheItems;
            j2.p = this.mConfig.mPlayerType;
            j2.q = this.mConfig.mHeaders;
            j2.s = this.mConfig.enableAccurateSeek;
            j2.t = this.mConfig.autoRotate;
            j2.u = this.mConfig.smoothSwitchBitrate;
            j2.v = this.mConfig.cacheMp4ExtName;
            j2.w = this.mConfig.progressInterval;
            j2.x = this.mConfig.maxBufferSize;
            TXCLog.i(TAG, "setConfig [connectRetryCount:" + this.mConfig.mConnectRetryCount + "(default 3 times)][connectRetryInterval:" + this.mConfig.mConnectRetryInterval + "(default 3s,min:3s max:30s)][vodTimeout:" + this.mConfig.mTimeout + "(default 10s)][enableHardwareDecoder:" + this.mEnableHWDec + "(default false)][cacheFolderPath for mp4/HLS:" + this.mConfig.mCacheFolderPath + "][maxCacheItems:" + this.mConfig.mMaxCacheItems + "][enableAccurateSeek:" + this.mConfig.enableAccurateSeek + "(default true)][autoRotate:" + this.mConfig.autoRotate + "(default true)][HLS smoothSwitchBitrate:" + this.mConfig.smoothSwitchBitrate + "(default false)][progressInterval:" + this.mConfig.progressInterval + "(default 0.5s)][preload maxBufferSize:" + this.mConfig.maxBufferSize + "]");
            this.mPlayer.a(j2);
        }
    }

    public void setPlayerView(TXCloudVideoView tXCloudVideoView) {
        TXCLog.i(TAG, "setPlayerView TXCloudVideoView:" + (Object)((Object)tXCloudVideoView));
        this.mTXCloudVideoView = tXCloudVideoView;
        if (this.mPlayer != null) {
            this.mPlayer.a(tXCloudVideoView);
        }
    }

    public void setPlayerView(TextureRenderView textureRenderView) {
        TXCLog.i(TAG, "setPlayerView TextureRenderView:" + textureRenderView);
        this.mTextureView = textureRenderView;
        if (this.mPlayer != null) {
            this.mPlayer.a(textureRenderView);
        }
    }

    public void setSurface(Surface surface) {
        TXCLog.i(TAG, "setSurface Surface:" + surface);
        this.mSurface = surface;
        if (this.mPlayer != null) {
            this.mPlayer.a(this.mSurface);
        }
    }

    public int startPlay(String string2) {
        String[] stringArray;
        Uri uri;
        String string3;
        if (string2 == null || TextUtils.isEmpty((CharSequence)string2)) {
            TXCLog.i(TAG, "startPlay playUrl is empty");
            return -1;
        }
        TXCDRApi.initCrashReport(this.mContext);
        int n2 = this.mBitrateIndex;
        this.stopPlay(false);
        this.mBitrateIndex = n2;
        if (this.mToken != null && (string3 = (uri = Uri.parse((String)string2)).getPath()) != null && (stringArray = string3.split("/")).length > 0) {
            String string4 = stringArray[stringArray.length - 1];
            int n3 = string2.lastIndexOf(string4);
            string2 = string2.substring(0, n3) + "voddrm.token." + this.mToken + "." + string2.substring(n3);
        }
        this.mPlayUrl = this.checkPlayUrl(string2);
        TXCLog.i(TAG, "===========================================================================================================================================================");
        TXCLog.i(TAG, "===========================================================================================================================================================");
        TXCLog.i(TAG, "=====  StartPlay url = " + this.mPlayUrl + " SDKVersion = " + TXCCommonUtil.getSDKID() + " , " + TXCCommonUtil.getSDKVersionStr() + "    ======");
        TXCLog.i(TAG, "===========================================================================================================================================================");
        TXCLog.i(TAG, "===========================================================================================================================================================");
        if (this.mPlayer == null) {
            this.mPlayer = new o(this.mContext);
        }
        this.updateConfig();
        if (this.mTXCloudVideoView != null) {
            this.mTXCloudVideoView.clearLog();
            this.mTXCloudVideoView.setVisibility(0);
            this.mPlayer.a(this.mTXCloudVideoView);
        } else if (this.mSurface != null) {
            this.mPlayer.a(this.mSurface);
        } else if (this.mTextureView != null) {
            this.mPlayer.a(this.mTextureView);
        }
        this.mPlayer.g(this.mBitrateIndex);
        this.mPlayer.a(this);
        this.mPlayer.d(this.mIsGainAudioFocus);
        this.mPlayer.e(this.mAutoPlay);
        this.mPlayer.c(this.mStartTime);
        this.mPlayer.a(this.mPlayUrl, 0);
        this.mPlayer.b(this.mMute);
        this.mPlayer.f(this.mAudioPlayoutVolume);
        this.mPlayer.b(this.mRate);
        this.mPlayer.b(this.mRenderRotation);
        this.mPlayer.a(this.mRenderMode);
        this.mPlayer.f(this.mLoop);
        this.setMirror(this.mMirror);
        return 0;
    }

    public int startPlay(TXPlayerAuthBuilder tXPlayerAuthBuilder) {
        this.mNetApi = new f();
        this.mNetApi.a(tXPlayerAuthBuilder.isHttps);
        this.mNetApi.a(this);
        TXCLog.i(TAG, "startPlay [FileId:" + tXPlayerAuthBuilder.fileId + "][Timeout:" + tXPlayerAuthBuilder.timeout + "][Unique identification request:" + tXPlayerAuthBuilder.us + "][Trial duration:" + tXPlayerAuthBuilder.exper + "][Sign:" + tXPlayerAuthBuilder.sign + "]");
        return this.mNetApi.a(tXPlayerAuthBuilder.appId, tXPlayerAuthBuilder.fileId, tXPlayerAuthBuilder.timeout, tXPlayerAuthBuilder.us, tXPlayerAuthBuilder.exper, tXPlayerAuthBuilder.sign);
    }

    private String checkPlayUrl(String string2) {
        if (string2.startsWith("http")) {
            try {
                byte[] byArray = string2.getBytes("UTF-8");
                StringBuilder stringBuilder = new StringBuilder(byArray.length);
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    int n2;
                    int n3 = n2 = byArray[i2] < 0 ? byArray[i2] + 256 : byArray[i2];
                    if (n2 <= 32 || n2 >= 127 || n2 == 34 || n2 == 37 || n2 == 60 || n2 == 62 || n2 == 91 || n2 == 125 || n2 == 92 || n2 == 93 || n2 == 94 || n2 == 96 || n2 == 123 || n2 == 124) {
                        if (n2 == 37) {
                            TXCLog.w(TAG, "URL has been transcoded");
                            return string2;
                        }
                        stringBuilder.append(String.format("%%%02X", n2));
                        continue;
                    }
                    stringBuilder.append((char)n2);
                }
                string2 = stringBuilder.toString();
            }
            catch (Exception exception) {
                TXCLog.e(TAG, "get utf-8 string failed.", exception);
            }
        }
        string2 = string2.trim();
        return string2;
    }

    public int stopPlay(boolean bl) {
        TXCLog.i(TAG, "stopPlay needClearLastImg:" + bl);
        if (bl && this.mTXCloudVideoView != null) {
            this.mTXCloudVideoView.setVisibility(8);
        }
        if (this.mPlayer != null) {
            this.mPlayer.a(bl);
        }
        this.mPlayUrl = "";
        if (this.mNetApi != null) {
            this.mNetApi.a((g)null);
            this.mNetApi = null;
        }
        this.mBitrateIndex = 0;
        this.mIsGetPlayInfo = false;
        return 0;
    }

    public boolean isPlaying() {
        if (this.mPlayer != null) {
            return this.mPlayer.c();
        }
        return false;
    }

    public void pause() {
        TXCLog.i(TAG, "pause");
        if (this.mPlayer != null) {
            this.mPlayer.a();
        }
    }

    public void resume() {
        TXCLog.i(TAG, "resume");
        if (this.mPlayer != null) {
            this.mPlayer.b();
        }
    }

    public void seek(int n2) {
        if (this.mPlayer != null) {
            this.mPlayer.e(n2);
        }
    }

    public void seek(float f2) {
        if (this.mPlayer != null) {
            this.mPlayer.a(f2);
        }
    }

    public float getCurrentPlaybackTime() {
        if (this.mPlayer != null) {
            return this.mPlayer.h();
        }
        return 0.0f;
    }

    public float getBufferDuration() {
        if (this.mPlayer != null) {
            return this.mPlayer.j();
        }
        return 0.0f;
    }

    public float getDuration() {
        if (this.mPlayer != null) {
            return this.mPlayer.k();
        }
        return 0.0f;
    }

    public float getPlayableDuration() {
        if (this.mPlayer != null) {
            return this.mPlayer.l();
        }
        return 0.0f;
    }

    public int getWidth() {
        if (this.mPlayer != null) {
            return this.mPlayer.m();
        }
        return 0;
    }

    public int getHeight() {
        if (this.mPlayer != null) {
            return this.mPlayer.n();
        }
        return 0;
    }

    @Deprecated
    public void setPlayListener(ITXLivePlayListener iTXLivePlayListener) {
        this.mListener = iTXLivePlayListener;
    }

    public void setVodListener(ITXVodPlayListener iTXVodPlayListener) {
        this.mNewListener = iTXVodPlayListener;
    }

    public void setRenderMode(int n2) {
        this.mRenderMode = n2;
        if (this.mPlayer != null) {
            this.mPlayer.a(n2);
        }
    }

    public void setRenderRotation(int n2) {
        this.mRenderRotation = n2;
        if (this.mPlayer != null) {
            this.mPlayer.b(n2);
        }
    }

    public boolean enableHardwareDecode(boolean bl) {
        if (bl) {
            if (Build.VERSION.SDK_INT < 18) {
                TXCLog.e("HardwareDecode", "enableHardwareDecode failed, android system build.version = " + Build.VERSION.SDK_INT + ", the minimum build.version should be 18(android 4.3 or later)");
                return false;
            }
            if (this.isAVCDecBlacklistDevices()) {
                TXCLog.e("HardwareDecode", "enableHardwareDecode failed, MANUFACTURER = " + Build.MANUFACTURER + ", MODEL" + Build.MODEL);
                return false;
            }
        }
        this.mEnableHWDec = bl;
        this.updateConfig();
        return true;
    }

    public void setMute(boolean bl) {
        TXCLog.i(TAG, "setMute:" + bl);
        this.mMute = bl;
        if (this.mPlayer != null) {
            this.mPlayer.b(bl);
        }
    }

    public void setAudioPlayoutVolume(int n2) {
        TXCLog.i(TAG, "setAudioPlayoutVolume:" + n2);
        this.mAudioPlayoutVolume = n2;
        if (this.mPlayer != null) {
            this.mPlayer.f(n2);
        }
    }

    public boolean setRequestAudioFocus(boolean bl) {
        this.mIsGainAudioFocus = bl;
        if (this.mPlayer != null) {
            return this.mPlayer.d(bl);
        }
        return true;
    }

    public void setAutoPlay(boolean bl) {
        TXCLog.i(TAG, "setAutoPlay:" + bl);
        this.mAutoPlay = bl;
        if (this.mPlayer != null) {
            this.mPlayer.e(bl);
        }
    }

    public void setRate(float f2) {
        this.mRate = f2;
        if (this.mPlayer != null) {
            this.mPlayer.b(f2);
        }
    }

    public int getBitrateIndex() {
        if (this.mPlayer != null) {
            return this.mPlayer.o();
        }
        return 0;
    }

    public void setBitrateIndex(int n2) {
        if (this.mPlayer != null) {
            this.mPlayer.g(n2);
        }
        this.mBitrateIndex = n2;
    }

    public ArrayList<TXBitrateItem> getSupportedBitrates() {
        if (this.mPlayer != null) {
            return this.mPlayer.p();
        }
        return new ArrayList<TXBitrateItem>();
    }

    public void snapshot(TXLivePlayer.ITXSnapshotListener iTXSnapshotListener) {
        if (this.mSnapshotRunning || iTXSnapshotListener == null) {
            return;
        }
        this.mSnapshotRunning = true;
        TextureView textureView = null;
        if (this.mPlayer != null) {
            textureView = this.mPlayer.d();
        }
        if (textureView != null) {
            Bitmap bitmap = textureView.getBitmap();
            Bitmap bitmap2 = bitmap;
            if (null != bitmap2) {
                Matrix matrix = textureView.getTransform(null);
                if (this.mMirror) {
                    matrix.postScale(-1.0f, 1.0f);
                }
                bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)bitmap2.getWidth(), (int)bitmap2.getHeight(), (Matrix)matrix, (boolean)true);
                bitmap2.recycle();
            }
            this.postBitmapToMainThread(iTXSnapshotListener, bitmap);
        } else {
            this.mSnapshotRunning = false;
        }
    }

    public void setMirror(boolean bl) {
        TXCLog.i(TAG, "setMirror:" + bl);
        if (this.mPlayer != null) {
            this.mPlayer.g(bl);
        }
        this.mMirror = bl;
    }

    public void setStartTime(float f2) {
        this.mStartTime = f2;
    }

    @Override
    public void onNotifyEvent(int n2, Bundle bundle) {
        if (n2 == 15001) {
            if (this.mTXCloudVideoView != null) {
                this.mTXCloudVideoView.setLogText(bundle, null, 0);
            }
            if (this.mListener != null) {
                this.mListener.onNetStatus(bundle);
            }
            if (this.mNewListener != null) {
                this.mNewListener.onNetStatus(this, bundle);
            }
        } else {
            if (this.mTXCloudVideoView != null) {
                this.mTXCloudVideoView.setLogText(null, bundle, n2);
            }
            if (this.mListener != null) {
                this.mListener.onPlayEvent(n2, bundle);
            }
            if (this.mNewListener != null) {
                this.mNewListener.onPlayEvent(this, n2, bundle);
            }
        }
    }

    private boolean isAVCDecBlacklistDevices() {
        return Build.MANUFACTURER.equalsIgnoreCase("HUAWEI") && Build.MODEL.equalsIgnoreCase("Che2-TL00");
    }

    private void postBitmapToMainThread(final TXLivePlayer.ITXSnapshotListener iTXSnapshotListener, final Bitmap bitmap) {
        if (null == iTXSnapshotListener) {
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (null != iTXSnapshotListener) {
                    iTXSnapshotListener.onSnapshot(bitmap);
                }
                TXVodPlayer.this.mSnapshotRunning = false;
            }
        });
    }

    void updateConfig() {
        this.setConfig(this.mConfig);
    }

    @Override
    public void onNetSuccess(f f2) {
        if (f2 != this.mNetApi) {
            return;
        }
        i i2 = f2.a();
        if (!this.mIsGetPlayInfo) {
            this.startPlay(i2.a());
        }
        this.mIsGetPlayInfo = false;
        Bundle bundle = new Bundle();
        bundle.putInt("EVT_ID", 2010);
        bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
        bundle.putLong("EVT_UTC_TIME", TXCTimeUtil.getUtcTimeTick());
        bundle.putString("EVT_MSG", "Requested file information successfully");
        bundle.putString("EVT_PLAY_URL", i2.a());
        bundle.putString("EVT_PLAY_COVER_URL", i2.b());
        bundle.putString("EVT_PLAY_NAME", i2.f());
        bundle.putString("EVT_PLAY_DESCRIPTION", i2.g());
        if (i2.d() != null) {
            bundle.putInt("EVT_PLAY_DURATION", i2.d().c());
        }
        this.onNotifyEvent(2010, bundle);
        TXCLog.i(TAG, "onNetSuccess: Requested file information successfully");
    }

    @Override
    public void onNetFailed(f f2, String string2, int n2) {
        if (f2 != this.mNetApi) {
            return;
        }
        this.mIsGetPlayInfo = false;
        Bundle bundle = new Bundle();
        bundle.putInt("EVT_ID", 2010);
        bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
        bundle.putLong("EVT_UTC_TIME", TXCTimeUtil.getUtcTimeTick());
        bundle.putString("EVT_MSG", string2);
        bundle.putInt("EVT_PARAM1", n2);
        this.onNotifyEvent(-2306, bundle);
        TXCLog.i(TAG, "onNetFailed: eventId: -2306 description:" + string2);
    }

    public void setToken(String string2) {
        this.mToken = string2;
    }

    public void setLoop(boolean bl) {
        TXCLog.i(TAG, "setLoop:" + bl);
        this.mLoop = bl;
        if (this.mPlayer != null) {
            this.mPlayer.f(this.mLoop);
        }
    }

    public boolean isLoop() {
        return this.mLoop;
    }
}

