/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoediter.ffmpeg.jni;

import com.tencent.liteav.basic.log.TXCLog;
import java.util.List;

public class TXFFQuickJointerJNI {
    private static final String TAG = "TXFFQuickJointerJNI";
    private long handle = this.init();
    private boolean isInitSuccess;
    private int mTotalVideoNums;
    private a mCallback;

    private native long init();

    private native void setSrcPaths(long var1, String[] var3);

    private native void setDstPath(long var1, String var3);

    private native int start(long var1);

    private native int stop(long var1);

    private native void destroy(long var1);

    private native int verify(long var1);

    private native int getVideoWidth(long var1);

    private native int getVideoHeight(long var1);

    public TXFFQuickJointerJNI() {
        if (this.handle != -1L) {
            this.isInitSuccess = true;
        }
    }

    public synchronized void destroy() {
        if (this.isInitSuccess) {
            this.destroy(this.handle);
            this.isInitSuccess = false;
            this.handle = -1L;
        }
    }

    public synchronized int getVideoWidth() {
        if (this.isInitSuccess) {
            return this.getVideoWidth(this.handle);
        }
        return 0;
    }

    public synchronized int getVideoHeight() {
        if (this.isInitSuccess) {
            return this.getVideoHeight(this.handle);
        }
        return 0;
    }

    public synchronized void setSrcPaths(List<String> list) {
        if (this.isInitSuccess) {
            if (list == null || list.size() == 0) {
                TXCLog.e(TAG, "quick joiner path empty!!!");
                return;
            }
            this.mTotalVideoNums = list.size();
            String[] stringArray = new String[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                stringArray[i2] = list.get(i2);
            }
            this.setSrcPaths(this.handle, stringArray);
        }
    }

    public synchronized void setDstPath(String string) {
        if (this.isInitSuccess) {
            this.setDstPath(this.handle, string);
        }
    }

    public synchronized int start() {
        if (this.isInitSuccess) {
            if (this.mTotalVideoNums == 0) {
                TXCLog.e(TAG, "quick joiner path empty!!!");
                return -1;
            }
            int n2 = this.start(this.handle);
            return n2;
        }
        return -1;
    }

    public synchronized int verify() {
        if (this.isInitSuccess) {
            int n2 = this.verify(this.handle);
            return n2;
        }
        return -1;
    }

    public synchronized void stop() {
        if (this.isInitSuccess) {
            this.stop(this.handle);
        }
    }

    public void setOnJoinerCallback(a a2) {
        this.mCallback = a2;
    }

    public void callbackFromNative(int n2) {
        TXCLog.i(TAG, "callbackFromNative: index = " + n2);
        if (this.mCallback != null) {
            this.mCallback.a(this.mTotalVideoNums > 0 ? (float)(n2 + 1) / (float)this.mTotalVideoNums : 0.0f);
        }
    }

    public static interface a {
        public void a(float var1);
    }
}

