/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoediter.ffmpeg.jni;

import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.videoediter.ffmpeg.jni.FFDecodedFrame;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class TXFFAudioDecoderJNI {
    private static final String TAG = "TXFFAudioDecoderJNI";
    private long handle = this.init();
    private AtomicBoolean isInitSuccess = new AtomicBoolean(false);

    private native long init();

    private native int configureInput(long var1, int var3, byte[] var4, int var5, int var6);

    private native FFDecodedFrame decode(long var1, byte[] var3, long var4, int var6);

    private native void release(long var1);

    private native void configureOutput(long var1, int var3, int var4);

    public synchronized int configureInput(int n2, ByteBuffer byteBuffer, int n3, int n4, int n5) {
        int n6 = this.configureInput(this.handle, n2, this.getBuffer(byteBuffer, n3), n4, n5);
        if (n6 == 0) {
            TXCLog.i(TAG, "init native decoder success!");
            this.isInitSuccess.set(true);
        } else {
            TXCLog.e(TAG, "init native decoder error!");
            this.isInitSuccess.set(true);
        }
        return n6;
    }

    public synchronized void configureOutput(int n2, int n3) {
        this.configureOutput(this.handle, n2, n3);
    }

    public synchronized FFDecodedFrame decode(byte[] byArray, long l2, int n2) {
        if (this.isInitSuccess.get()) {
            return this.decode(this.handle, byArray, l2, n2);
        }
        TXCLog.e(TAG, "decoder not init yet!");
        return null;
    }

    public synchronized void release() {
        if (this.isInitSuccess.get()) {
            TXCLog.i(TAG, "release decoder!");
            this.release(this.handle);
            this.isInitSuccess.set(false);
        } else {
            TXCLog.e(TAG, "decoder not init yet!");
        }
    }

    private byte[] getBuffer(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer == null) {
            return null;
        }
        byte[] byArray = new byte[n2];
        byteBuffer.position(0);
        byteBuffer.get(byArray);
        return byArray;
    }
}

