/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoediter.audio;

import com.tencent.liteav.basic.log.TXCLog;

public class TXJNIAudioResampler {
    private static final String TAG = "TXJNIAudioResampler";
    private volatile boolean isInitSuccess;
    private long handle = this.init();

    private native long init();

    private native void uninit(long var1);

    private native void setSpeed(long var1, float var3);

    private native void setSampleRate(long var1, int var3, int var4);

    private native void setChannelCount(long var1, int var3);

    private native short[] resample(long var1, short[] var3);

    private native short[] flushBuffer(long var1);

    public TXJNIAudioResampler() {
        if (this.handle != -1L) {
            this.isInitSuccess = true;
        }
    }

    public synchronized void destroy() {
        if (this.isInitSuccess) {
            this.isInitSuccess = false;
            this.uninit(this.handle);
            this.handle = -1L;
        }
    }

    public synchronized void setSpeed(float f2) {
        if (this.isInitSuccess) {
            this.setSpeed(this.handle, f2);
        } else {
            TXCLog.e(TAG, "you must init first!!!");
        }
    }

    public synchronized void setSampleRate(int n2, int n3) {
        if (this.isInitSuccess) {
            this.setSampleRate(this.handle, n2, n3);
        } else {
            TXCLog.e(TAG, "you must init first!!!");
        }
    }

    public synchronized void setChannelCount(int n2) {
        if (this.isInitSuccess) {
            this.setChannelCount(this.handle, n2);
        } else {
            TXCLog.e(TAG, "you must init first!!!");
        }
    }

    public synchronized short[] resample(short[] sArray) {
        if (this.isInitSuccess) {
            return this.resample(this.handle, sArray);
        }
        TXCLog.e(TAG, "you must init first!!!");
        return sArray;
    }

    public synchronized short[] flushBuffer() {
        if (this.isInitSuccess) {
            return this.flushBuffer(this.handle);
        }
        TXCLog.e(TAG, "you must init first!!!");
        return null;
    }
}

