/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.txcvodplayer;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.tencent.ijk.media.player.IMediaPlayer;
import com.tencent.ijk.media.player.ISurfaceTextureHolder;
import com.tencent.ijk.media.player.ISurfaceTextureHost;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.txcvodplayer.a;
import com.tencent.liteav.txcvodplayer.c;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@TargetApi(value=14)
public class TextureRenderView
extends TextureView
implements com.tencent.liteav.txcvodplayer.a {
    private static final String TAG = "TextureRenderView";
    private c mMeasureHelper;
    private b mSurfaceCallback;

    public TextureRenderView(Context context) {
        super(context);
        this.initView(context);
    }

    public TextureRenderView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initView(context);
    }

    public TextureRenderView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initView(context);
    }

    @TargetApi(value=21)
    public TextureRenderView(Context context, AttributeSet attributeSet, int n2, int n3) {
        super(context, attributeSet, n2, n3);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mMeasureHelper = new c((View)this);
        this.mSurfaceCallback = new b(this);
        this.setSurfaceTextureListener(this.mSurfaceCallback);
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public boolean shouldWaitForResize() {
        return false;
    }

    protected void onDetachedFromWindow() {
        try {
            this.mSurfaceCallback.a();
            super.onDetachedFromWindow();
            this.mSurfaceCallback.b();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mSurfaceCallback.c();
    }

    @Override
    public void setVideoSize(int n2, int n3) {
        if (n2 > 0 && n3 > 0) {
            this.mMeasureHelper.a(n2, n3);
            this.requestLayout();
        }
    }

    @Override
    public void setVideoSampleAspectRatio(int n2, int n3) {
        if (n2 > 0 && n3 > 0) {
            this.mMeasureHelper.b(n2, n3);
            this.requestLayout();
        }
    }

    @Override
    public void setVideoRotation(int n2) {
        this.mMeasureHelper.a(n2);
        this.setRotation(n2);
    }

    @Override
    public void setAspectRatio(int n2) {
        this.mMeasureHelper.b(n2);
        this.requestLayout();
    }

    protected void onMeasure(int n2, int n3) {
        this.mMeasureHelper.c(n2, n3);
        this.setMeasuredDimension(this.mMeasureHelper.a(), this.mMeasureHelper.b());
    }

    public a.b getSurfaceHolder() {
        return new a(this, this.mSurfaceCallback.a, this.mSurfaceCallback);
    }

    @Override
    public void addRenderCallback(a.a a2) {
        this.mSurfaceCallback.a(a2);
    }

    @Override
    public void removeRenderCallback(a.a a2) {
        this.mSurfaceCallback.b(a2);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName((CharSequence)TextureRenderView.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName((CharSequence)TextureRenderView.class.getName());
    }

    private static final class b
    implements TextureView.SurfaceTextureListener,
    ISurfaceTextureHost {
        private SurfaceTexture a;
        private boolean b;
        private int c;
        private int d;
        private boolean e = true;
        private boolean f = false;
        private boolean g = false;
        private WeakReference<TextureRenderView> h;
        private Map<a.a, Object> i = new ConcurrentHashMap<a.a, Object>();

        public b(@NonNull TextureRenderView textureRenderView) {
            this.h = new WeakReference<TextureRenderView>(textureRenderView);
        }

        public void a(boolean bl) {
            this.e = bl;
        }

        public void a(SurfaceTexture surfaceTexture) {
            this.a = surfaceTexture;
        }

        public void a(@NonNull a.a a2) {
            this.i.put(a2, a2);
            a a3 = null;
            if (this.a != null) {
                if (a3 == null) {
                    a3 = new a((TextureRenderView)this.h.get(), this.a, this);
                }
                a2.a(a3, this.c, this.d);
            }
            if (this.b) {
                if (a3 == null) {
                    a3 = new a((TextureRenderView)this.h.get(), this.a, this);
                }
                a2.a(a3, 0, this.c, this.d);
            }
        }

        public void b(@NonNull a.a a2) {
            this.i.remove(a2);
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
            this.a = surfaceTexture;
            this.b = false;
            this.c = 0;
            this.d = 0;
            a a2 = new a((TextureRenderView)this.h.get(), surfaceTexture, this);
            for (a.a a3 : this.i.keySet()) {
                a3.a(a2, 0, 0);
            }
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
            this.a = surfaceTexture;
            this.b = true;
            this.c = n2;
            this.d = n3;
            a a2 = new a((TextureRenderView)this.h.get(), surfaceTexture, this);
            for (a.a a3 : this.i.keySet()) {
                a3.a(a2, 0, n2, n3);
            }
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            this.a = surfaceTexture;
            this.b = false;
            this.c = 0;
            this.d = 0;
            a a2 = new a((TextureRenderView)this.h.get(), surfaceTexture, this);
            for (a.a a3 : this.i.keySet()) {
                a3.a(a2);
            }
            TXCLog.i(TextureRenderView.TAG, "onSurfaceTextureDestroyed: destroy: " + this.e);
            return this.e;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }

        @Override
        public void releaseSurfaceTexture(SurfaceTexture surfaceTexture) {
            if (surfaceTexture == null) {
                TXCLog.i(TextureRenderView.TAG, "releaseSurfaceTexture: null");
            } else if (this.g) {
                if (surfaceTexture != this.a) {
                    TXCLog.i(TextureRenderView.TAG, "releaseSurfaceTexture: didDetachFromWindow(): release different SurfaceTexture");
                    surfaceTexture.release();
                } else if (!this.e) {
                    TXCLog.i(TextureRenderView.TAG, "releaseSurfaceTexture: didDetachFromWindow(): release detached SurfaceTexture");
                    surfaceTexture.release();
                } else {
                    TXCLog.i(TextureRenderView.TAG, "releaseSurfaceTexture: didDetachFromWindow(): already released by TextureView");
                }
            } else if (this.f) {
                if (surfaceTexture != this.a) {
                    TXCLog.i(TextureRenderView.TAG, "releaseSurfaceTexture: willDetachFromWindow(): release different SurfaceTexture");
                    surfaceTexture.release();
                } else if (!this.e) {
                    TXCLog.i(TextureRenderView.TAG, "releaseSurfaceTexture: willDetachFromWindow(): re-attach SurfaceTexture to TextureView");
                    this.a(true);
                } else {
                    TXCLog.i(TextureRenderView.TAG, "releaseSurfaceTexture: willDetachFromWindow(): will released by TextureView");
                }
            } else if (surfaceTexture != this.a) {
                TXCLog.i(TextureRenderView.TAG, "releaseSurfaceTexture: alive: release different SurfaceTexture");
                surfaceTexture.release();
            } else if (!this.e) {
                TXCLog.i(TextureRenderView.TAG, "releaseSurfaceTexture: alive: re-attach SurfaceTexture to TextureView");
                this.a(true);
            } else {
                TXCLog.i(TextureRenderView.TAG, "releaseSurfaceTexture: alive: will released by TextureView");
            }
        }

        public void a() {
            TXCLog.i(TextureRenderView.TAG, "willDetachFromWindow()");
            this.f = true;
        }

        public void b() {
            TXCLog.i(TextureRenderView.TAG, "didDetachFromWindow()");
            this.g = true;
        }

        public void c() {
            TXCLog.i(TextureRenderView.TAG, "onAttachFromWindow()");
            this.f = false;
            this.g = false;
        }
    }

    private static final class a
    implements a.b {
        private TextureRenderView a;
        private SurfaceTexture b;
        private ISurfaceTextureHost c;
        private Surface d;

        public a(@NonNull TextureRenderView textureRenderView, @Nullable SurfaceTexture surfaceTexture, @NonNull ISurfaceTextureHost iSurfaceTextureHost) {
            this.a = textureRenderView;
            this.b = surfaceTexture;
            this.c = iSurfaceTextureHost;
        }

        @Override
        @TargetApi(value=16)
        public void a(IMediaPlayer iMediaPlayer) {
            if (iMediaPlayer == null) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 16 && iMediaPlayer instanceof ISurfaceTextureHolder) {
                ISurfaceTextureHolder iSurfaceTextureHolder = (ISurfaceTextureHolder)((Object)iMediaPlayer);
                this.a.mSurfaceCallback.a(false);
                if (this.a.getSurfaceTexture() != null) {
                    this.b = this.a.getSurfaceTexture();
                }
                try {
                    SurfaceTexture surfaceTexture = iSurfaceTextureHolder.getSurfaceTexture();
                    if (surfaceTexture != null) {
                        iSurfaceTextureHolder.setSurfaceTextureHost(this.a.mSurfaceCallback);
                        this.a.setSurfaceTexture(surfaceTexture);
                        this.a.mSurfaceCallback.a(surfaceTexture);
                    } else {
                        if (this.d != null) {
                            iMediaPlayer.setSurface(this.d);
                        }
                        iSurfaceTextureHolder.setSurfaceTexture(this.b);
                        iSurfaceTextureHolder.setSurfaceTextureHost(this.a.mSurfaceCallback);
                    }
                    this.d = iMediaPlayer.getSurface();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.d = this.b();
                iMediaPlayer.setSurface(this.d);
            }
        }

        @Override
        @NonNull
        public com.tencent.liteav.txcvodplayer.a a() {
            return this.a;
        }

        @Nullable
        public Surface b() {
            if (this.b == null) {
                return null;
            }
            if (this.d == null) {
                this.d = new Surface(this.b);
            }
            return this.d;
        }
    }
}

