/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtc.impl;

import android.annotation.SuppressLint;
import android.opengl.EGLContext;
import android.opengl.GLES20;
import com.tencent.liteav.basic.a.a;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.opengl.TXCOpenGlUtils;
import com.tencent.liteav.basic.opengl.e;
import com.tencent.liteav.basic.util.e;
import com.tencent.liteav.beauty.b.p;
import com.tencent.liteav.beauty.b.w;
import com.tencent.liteav.r;
import com.tencent.trtc.TRTCCloudDef;
import com.tencent.trtc.TRTCCloudListener;
import java.nio.ByteBuffer;

public class TRTCVideoPreprocessListenerAdapter
implements r {
    private static final String TAG = "TRTCVideoPreprocessListenerAdapter";
    private final e mLastFrameSize = new e(0, 0);
    private final TRTCCloudDef.TRTCVideoFrame mYUVInputFrame = new TRTCCloudDef.TRTCVideoFrame();
    private final TRTCCloudDef.TRTCVideoFrame mYUVOutputFrame = new TRTCCloudDef.TRTCVideoFrame();
    private final TRTCCloudDef.TRTCVideoFrame mShadowInputFrame = new TRTCCloudDef.TRTCVideoFrame();
    private final TRTCCloudDef.TRTCVideoFrame mShadowOutputFrame = new TRTCCloudDef.TRTCVideoFrame();
    private final a mDelayQueue = new a();
    private int mPixelFormat;
    private int mBufferType;
    private TRTCCloudListener.TRTCVideoFrameListener mListener;
    private boolean mHasNotifiedGLContextCreated = false;
    private w mRGBAToYUVFilter;
    private p mYUVToRGBAFilter;
    private int mFrameBufferId = -1;

    public void setListener(final int n2, final int n3, final TRTCCloudListener.TRTCVideoFrameListener tRTCVideoFrameListener) {
        this.mDelayQueue.a(new Runnable(){

            @Override
            public void run() {
                TRTCVideoPreprocessListenerAdapter.this.setListenerInternal(n2, n3, tRTCVideoFrameListener);
            }
        });
    }

    private void setListenerInternal(int n2, int n3, TRTCCloudListener.TRTCVideoFrameListener tRTCVideoFrameListener) {
        this.notifyGLContextDestroy();
        this.mPixelFormat = n2;
        this.mBufferType = n3;
        this.mListener = tRTCVideoFrameListener;
        this.notifyGLContextCreated();
    }

    @Override
    public void onGLContextCreated() {
        this.mDelayQueue.a();
        this.notifyGLContextCreated();
    }

    @SuppressLint(value={"NewApi"})
    private static void initVideoFrame(TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame, int n2, int n3, int n4, int n5) {
        tRTCVideoFrame.width = n2;
        tRTCVideoFrame.height = n3;
        tRTCVideoFrame.pixelFormat = n4;
        tRTCVideoFrame.bufferType = n5;
        if (n4 == 2 && tRTCVideoFrame.texture == null) {
            tRTCVideoFrame.texture = new TRTCCloudDef.TRTCTexture();
            Object object = TXCOpenGlUtils.e();
            if (object instanceof EGLContext) {
                tRTCVideoFrame.texture.eglContext14 = (EGLContext)object;
            } else {
                tRTCVideoFrame.texture.eglContext10 = (javax.microedition.khronos.egl.EGLContext)object;
            }
        } else if (n4 == 1 || n4 == 4) {
            if (n5 == 2 && tRTCVideoFrame.data == null) {
                tRTCVideoFrame.data = new byte[n2 * n3 * 3 / 2];
            } else if (n5 == 1 && tRTCVideoFrame.buffer == null) {
                tRTCVideoFrame.buffer = ByteBuffer.allocateDirect(n2 * n3 * 3 / 2);
            }
        }
    }

    private void shadowCopyVideoFrame(TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame, TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame2) {
        tRTCVideoFrame2.width = tRTCVideoFrame.width;
        tRTCVideoFrame2.height = tRTCVideoFrame.height;
        tRTCVideoFrame2.pixelFormat = tRTCVideoFrame.pixelFormat;
        tRTCVideoFrame2.bufferType = tRTCVideoFrame.bufferType;
        tRTCVideoFrame2.texture = tRTCVideoFrame.texture;
        tRTCVideoFrame2.data = tRTCVideoFrame.data;
        tRTCVideoFrame2.buffer = tRTCVideoFrame.buffer;
    }

    @Override
    public int onProcessVideoFrame(int n2, int n3, int n4, int n5) {
        this.mDelayQueue.a();
        if (this.mListener == null) {
            return n2;
        }
        if (this.mLastFrameSize.a != n3 || this.mLastFrameSize.b != n4) {
            this.releaseOpenGLResources();
            this.mYUVInputFrame.data = null;
            this.mYUVInputFrame.buffer = null;
            this.mYUVOutputFrame.data = null;
            this.mYUVOutputFrame.buffer = null;
            this.mLastFrameSize.a = n3;
            this.mLastFrameSize.b = n4;
        }
        TRTCVideoPreprocessListenerAdapter.initVideoFrame(this.mYUVInputFrame, n3, n4, this.mPixelFormat, this.mBufferType);
        TRTCVideoPreprocessListenerAdapter.initVideoFrame(this.mYUVOutputFrame, n3, n4, this.mPixelFormat, this.mBufferType);
        if (this.mPixelFormat == 2) {
            this.mYUVInputFrame.texture.textureId = n2;
            this.mYUVOutputFrame.texture.textureId = n5;
            this.mListener.onProcessVideoFrame(this.mYUVInputFrame, this.mYUVOutputFrame);
            return this.mYUVOutputFrame.texture.textureId;
        }
        if (this.mFrameBufferId == -1) {
            this.mFrameBufferId = TXCOpenGlUtils.d();
        }
        this.convertTextureToYUV(n2, this.mYUVInputFrame);
        this.shadowCopyVideoFrame(this.mYUVInputFrame, this.mShadowInputFrame);
        this.shadowCopyVideoFrame(this.mYUVOutputFrame, this.mShadowOutputFrame);
        this.mListener.onProcessVideoFrame(this.mShadowInputFrame, this.mShadowOutputFrame);
        this.convertYUVToTexture(this.mShadowOutputFrame, n5);
        return n5;
    }

    private void convertYUVToTexture(TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame, int n2) {
        if (tRTCVideoFrame.data == null && tRTCVideoFrame.buffer == null) {
            return;
        }
        int n3 = tRTCVideoFrame.width;
        int n4 = tRTCVideoFrame.height;
        p p2 = this.getYUVToRGBAFilter(tRTCVideoFrame.pixelFormat, n3, n4);
        TXCOpenGlUtils.a(n2, this.mFrameBufferId);
        GLES20.glViewport((int)0, (int)0, (int)n3, (int)n4);
        if (tRTCVideoFrame.bufferType == 2) {
            p2.a(tRTCVideoFrame.data);
        } else if (tRTCVideoFrame.bufferType == 1) {
            p2.a(tRTCVideoFrame.buffer);
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferId);
        p2.a(-1, this.mFrameBufferId, n2);
        TXCOpenGlUtils.d(this.mFrameBufferId);
    }

    private void convertTextureToYUV(int n2, TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame) {
        int n3 = tRTCVideoFrame.width;
        int n4 = tRTCVideoFrame.height;
        w w2 = this.getRGBAToYUVFilter(tRTCVideoFrame.pixelFormat, n3, n4);
        GLES20.glViewport((int)0, (int)0, (int)n3, (int)n4);
        w2.a(n3, n4);
        int n5 = w2.a(n2);
        TXCOpenGlUtils.a(n5, this.mFrameBufferId);
        e.a a2 = e.a.a;
        if (tRTCVideoFrame.pixelFormat == 1) {
            a2 = e.a.b;
        } else if (tRTCVideoFrame.pixelFormat == 4) {
            a2 = e.a.c;
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferId);
        if (tRTCVideoFrame.bufferType == 1) {
            TXCOpenGlUtils.a(a2, n3, n4, tRTCVideoFrame.buffer);
        } else {
            TXCOpenGlUtils.a(a2, n3, n4, tRTCVideoFrame.data);
        }
        TXCOpenGlUtils.d(this.mFrameBufferId);
    }

    private w getRGBAToYUVFilter(int n2, int n3, int n4) {
        if (this.mRGBAToYUVFilter == null) {
            int n5 = n2 == 1 ? 1 : 3;
            this.mRGBAToYUVFilter = new w(n5);
            this.mRGBAToYUVFilter.a(true);
            if (!this.mRGBAToYUVFilter.c()) {
                TXCLog.e(TAG, "init RGBA to YUV filter failed.");
            }
            this.mRGBAToYUVFilter.a(n3, n4);
        }
        return this.mRGBAToYUVFilter;
    }

    private p getYUVToRGBAFilter(int n2, int n3, int n4) {
        if (this.mYUVToRGBAFilter == null) {
            int n5 = n2 == 1 ? 1 : 3;
            this.mYUVToRGBAFilter = new p(n5);
            if (!this.mYUVToRGBAFilter.c()) {
                TXCLog.e(TAG, "init YUV to RGBA failed.");
            }
            this.mYUVToRGBAFilter.a(n3, n4);
        }
        return this.mYUVToRGBAFilter;
    }

    public void onDetectFacePoints(float[] fArray) {
    }

    @Override
    public void onGLContextReadyToDestory() {
        this.mDelayQueue.a();
        this.notifyGLContextDestroy();
        this.releaseOpenGLResources();
    }

    private void notifyGLContextCreated() {
        if (this.mListener != null && !this.mHasNotifiedGLContextCreated) {
            this.mListener.onGLContextCreated();
            this.mHasNotifiedGLContextCreated = true;
        }
    }

    private void notifyGLContextDestroy() {
        if (this.mListener != null && this.mHasNotifiedGLContextCreated) {
            this.mListener.onGLContextDestory();
            this.mHasNotifiedGLContextCreated = false;
        }
    }

    private void releaseOpenGLResources() {
        if (this.mRGBAToYUVFilter != null) {
            this.mRGBAToYUVFilter.e();
            this.mRGBAToYUVFilter = null;
        }
        if (this.mYUVToRGBAFilter != null) {
            this.mYUVToRGBAFilter.e();
            this.mYUVToRGBAFilter = null;
        }
        TXCOpenGlUtils.b(this.mFrameBufferId);
        this.mFrameBufferId = -1;
    }
}

